/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.NonAppliedDistribution;
import org.kuali.kfs.module.ar.businessobject.NonInvoicedDistribution;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class NonAppliedHolding
extends PersistableBusinessObjectBase {
    private String referenceFinancialDocumentNumber;
    private KualiDecimal financialDocumentLineAmount = KualiDecimal.ZERO;
    private String customerNumber;
    private Customer customer;
    private KualiDecimal availableUnappliedAmount = KualiDecimal.ZERO;
    private KualiDecimal appliedUnappliedAmount = KualiDecimal.ZERO;
    private Collection<NonInvoicedDistribution> nonInvoicedDistributions;
    private Collection<NonAppliedDistribution> nonAppliedDistributions = new ArrayList<NonAppliedDistribution>();
    private FinancialSystemDocumentHeader documentHeader;

    public String getReferenceFinancialDocumentNumber() {
        return this.referenceFinancialDocumentNumber;
    }

    public void setReferenceFinancialDocumentNumber(String referenceFinancialDocumentNumber) {
        this.referenceFinancialDocumentNumber = referenceFinancialDocumentNumber;
    }

    public KualiDecimal getFinancialDocumentLineAmount() {
        return this.financialDocumentLineAmount;
    }

    public void setFinancialDocumentLineAmount(KualiDecimal financialDocumentLineAmount) {
        this.financialDocumentLineAmount = financialDocumentLineAmount;
    }

    public String getCustomerNumber() {
        return this.customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Collection<NonInvoicedDistribution> getNonInvoicedDistributions() {
        return this.nonInvoicedDistributions;
    }

    public void setNonInvoicedDistributions(Collection<NonInvoicedDistribution> nonInvoicedDistributions) {
        this.nonInvoicedDistributions = nonInvoicedDistributions;
    }

    public Collection<NonAppliedDistribution> getNonAppliedDistributions() {
        return this.nonAppliedDistributions;
    }

    public void setNonAppliedDistributions(List<NonAppliedDistribution> nonAppliedDistributions) {
        this.nonAppliedDistributions = nonAppliedDistributions;
    }

    public KualiDecimal getAvailableUnappliedAmount() {
        KualiDecimal amount = this.financialDocumentLineAmount;
        for (NonInvoicedDistribution nonInvoicedDistribution : this.nonInvoicedDistributions) {
            amount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)nonInvoicedDistribution.getFinancialDocumentLineAmount());
        }
        for (NonAppliedDistribution nonAppliedDistribution : this.nonAppliedDistributions) {
            amount = (KualiDecimal)amount.subtract((AbstractKualiDecimal)nonAppliedDistribution.getFinancialDocumentLineAmount());
        }
        return amount;
    }

    public KualiDecimal getAppliedUnappliedAmount() {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (NonInvoicedDistribution nonInvoicedDistribution : this.nonInvoicedDistributions) {
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)nonInvoicedDistribution.getFinancialDocumentLineAmount());
        }
        for (NonAppliedDistribution nonAppliedDistribution : this.nonAppliedDistributions) {
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)nonAppliedDistribution.getFinancialDocumentLineAmount());
        }
        return amount;
    }

    public FinancialSystemDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void setDocumentHeader(FinancialSystemDocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }
}

