/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.datadictionary.Action;
import org.kuali.kfs.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.kuali.kfs.sys.businessobject.actions.BusinessObjectActionsProvider;
import org.kuali.rice.kim.api.identity.Person;

public class CustomerActionsProvider
extends BusinessObjectActionsProvider {
    public List<Action> getActionLinks(BusinessObjectBase businessObject, Person user) {
        List actions = super.getActionLinks(businessObject, user);
        BusinessObjectAdminService businessObjectAdminService = this.businessObjectDictionaryService.getBusinessObjectAdminService(businessObject.getClass());
        if (businessObjectAdminService instanceof CustomerAdminService && ((CustomerAdminService)businessObjectAdminService).allowsReport(user)) {
            String reportUrl = CustomerActionsProvider.generateReportUrl((Customer)businessObject);
            Action action = new Action("Report", "GET", reportUrl);
            actions.add(action);
        }
        return actions;
    }

    private static String generateReportUrl(Customer customer) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessObjectClassName", CustomerOpenItemReportDetail.class.getName());
        params.put("returnLocation", "");
        params.put("lookupableImplServiceName", "arCustomerOpenItemReportLookupable");
        params.put("methodToCall", "search");
        params.put("customerNumber", customer.getCustomerNumber());
        params.put("reportName", "Customer History Report");
        params.put("customerName", customer.getCustomerName());
        params.put("docFormKey", "88888888");
        return UrlFactory.parameterizeUrl((String)"arCustomerOpenItemReportLookup.do", params);
    }
}

