/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.kim.impl.identity.PersonImpl;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceReport;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsSuspendedInvoiceDetailReport;
import org.kuali.kfs.module.ar.businessobject.InvoiceSuspensionCategory;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsSuspendedInvoiceReportLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsSuspendedInvoiceDetailReportLookupableHelperServiceImpl
extends ContractsGrantsSuspendedInvoiceReportLookupableHelperServiceImplBase {
    protected PersonService personService;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ArrayList<ContractsGrantsSuspendedInvoiceDetailReport> displayList = new ArrayList<ContractsGrantsSuspendedInvoiceDetailReport>();
        HashMap<String, String> invoiceDocumentCriteria = new HashMap<String, String>();
        String suspensionCategoryCode = (String)lookupFormFields.get("suspensionCategoryCode");
        if (StringUtils.isNotBlank((CharSequence)suspensionCategoryCode)) {
            invoiceDocumentCriteria.put("invoiceSuspensionCategories.suspensionCategoryCode", suspensionCategoryCode);
        }
        String documentNumber = (String)lookupFormFields.get("documentNumber");
        List<? extends ContractsAndGrantsAward> matchingAwards = this.lookupMatchingAwards(lookupFormFields);
        if (matchingAwards != null) {
            if (matchingAwards.isEmpty()) {
                return displayList;
            }
            String proposalNumbers = this.harvestIdsFromAwards(matchingAwards);
            if (!StringUtils.isBlank((CharSequence)proposalNumbers)) {
                invoiceDocumentCriteria.put("invoiceGeneralDetail.proposalNumber", proposalNumbers);
            }
        }
        String processingDocumentStatuses = this.buildProcessingDocumentStatusesForLookup();
        invoiceDocumentCriteria.put("documentHeader.workflowDocumentStatusCode", processingDocumentStatuses);
        Collection cgInvoiceDocuments = this.getLookupService().findCollectionBySearchHelper(ContractsGrantsInvoiceDocument.class, invoiceDocumentCriteria, true);
        for (ContractsGrantsInvoiceDocument cgInvoiceDoc : cgInvoiceDocuments) {
            if (ObjectUtils.isNull(cgInvoiceDoc.getInvoiceSuspensionCategories()) || cgInvoiceDoc.getInvoiceSuspensionCategories().isEmpty() || !StringUtils.isBlank((CharSequence)documentNumber) && !StringUtils.equals((CharSequence)documentNumber, (CharSequence)cgInvoiceDoc.getDocumentNumber())) continue;
            for (InvoiceSuspensionCategory invoiceSuspensionCategory : cgInvoiceDoc.getInvoiceSuspensionCategories()) {
                ContractsAndGrantsBillingAward award;
                Pattern suspensionCategoryCodePattern = null;
                if (!StringUtils.isBlank((CharSequence)suspensionCategoryCode)) {
                    suspensionCategoryCodePattern = Pattern.compile(suspensionCategoryCode.replace("*", ".*"), 2);
                }
                if (!StringUtils.isBlank((CharSequence)suspensionCategoryCode) && (suspensionCategoryCodePattern == null || !suspensionCategoryCodePattern.matcher(invoiceSuspensionCategory.getSuspensionCategoryCode()).matches())) continue;
                ContractsGrantsSuspendedInvoiceDetailReport cgSuspendedInvoiceDetailReport = new ContractsGrantsSuspendedInvoiceDetailReport();
                cgSuspendedInvoiceDetailReport.setSuspensionCategoryCode(invoiceSuspensionCategory.getSuspensionCategoryCode());
                cgSuspendedInvoiceDetailReport.setDocumentNumber(cgInvoiceDoc.getDocumentNumber());
                cgSuspendedInvoiceDetailReport.setLetterOfCreditFundGroupCode(null);
                if (ObjectUtils.isNotNull((Object)cgInvoiceDoc.getInvoiceGeneralDetail().getAward()) && ObjectUtils.isNotNull((Object)cgInvoiceDoc.getInvoiceGeneralDetail().getAward().getLetterOfCreditFund())) {
                    cgSuspendedInvoiceDetailReport.setLetterOfCreditFundGroupCode(cgInvoiceDoc.getInvoiceGeneralDetail().getAward().getLetterOfCreditFund().getLetterOfCreditFundGroupCode());
                }
                if ((award = cgInvoiceDoc.getInvoiceGeneralDetail().getAward()) != null) {
                    Person fundManager = award.getAwardPrimaryFundManager().getFundManager();
                    String fundManagerPrincipalName = fundManager.getPrincipalName();
                    PersonImpl projectDirector = award.getAwardPrimaryProjectDirector().getProjectDirector();
                    String projectDirectorPrincipalName = projectDirector.getPrincipalName();
                    cgSuspendedInvoiceDetailReport.setAwardFundManager(fundManager);
                    cgSuspendedInvoiceDetailReport.setAwardProjectDirector((Person)projectDirector);
                    cgSuspendedInvoiceDetailReport.setProjectDirectorPrincipalName(projectDirectorPrincipalName);
                    cgSuspendedInvoiceDetailReport.setFundManagerPrincipalName(fundManagerPrincipalName);
                    cgSuspendedInvoiceDetailReport.setAwardTotal(award.getAwardTotalAmount());
                }
                if (displayList.contains((Object)cgSuspendedInvoiceDetailReport)) continue;
                displayList.add(cgSuspendedInvoiceDetailReport);
            }
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    protected List<? extends ContractsAndGrantsAward> lookupMatchingAwards(Map lookupFields) {
        String awardTotal;
        HashMap<String, String> awardLookupFields = new HashMap<String, String>();
        ArrayList filteredAwards = new ArrayList();
        String letterOfCreditFundGroupCode = (String)lookupFields.get("letterOfCreditFundGroupCode");
        if (!StringUtils.isBlank((CharSequence)letterOfCreditFundGroupCode)) {
            awardLookupFields.put("letterOfCreditFund.letterOfCreditFundGroupCode", letterOfCreditFundGroupCode);
        }
        if (!StringUtils.isBlank((CharSequence)(awardTotal = (String)lookupFields.get("awardTotal")))) {
            awardLookupFields.put("awardTotal", awardTotal);
        }
        String fundManagerPrincipalName = (String)lookupFields.get("awardFundManager.principalName");
        Set<String> fundManagerPrincipalIds = this.getContractsGrantsReportHelperService().lookupPrincipalIds(fundManagerPrincipalName);
        if (StringUtils.isNotBlank((CharSequence)fundManagerPrincipalName)) {
            if (fundManagerPrincipalIds.isEmpty()) {
                return filteredAwards;
            }
            String joinedFundManagerPrincipalIds = StringUtils.join(fundManagerPrincipalIds, (String)SearchOperator.OR.op());
            awardLookupFields.put("awardFundManagers.principalId", joinedFundManagerPrincipalIds);
        }
        String projectDirectorPrincipalName = (String)lookupFields.get("awardProjectDirector.principalName");
        Set<String> projectDirectorPrincipalIds = this.getContractsGrantsReportHelperService().lookupPrincipalIds(projectDirectorPrincipalName);
        if (StringUtils.isNotBlank((CharSequence)projectDirectorPrincipalName)) {
            if (projectDirectorPrincipalIds.isEmpty()) {
                return filteredAwards;
            }
            String joinedProjectDirectorPrincipalIds = StringUtils.join(projectDirectorPrincipalIds, (String)SearchOperator.OR.op());
            awardLookupFields.put("awardProjectDirectors.principalId", joinedProjectDirectorPrincipalIds);
        }
        if (awardLookupFields.isEmpty()) {
            return null;
        }
        awardLookupFields.put("active", "Y");
        return this.getContractsAndGrantsModuleBillingService().lookupAwards(awardLookupFields, true);
    }

    protected String harvestIdsFromAwards(List<? extends ContractsAndGrantsAward> awards) {
        if (awards.isEmpty()) {
            return "";
        }
        HashSet<String> proposalIdsSet = new HashSet<String>();
        for (ContractsAndGrantsAward contractsAndGrantsAward : awards) {
            proposalIdsSet.add(contractsAndGrantsAward.getProposalNumber());
        }
        return StringUtils.join(proposalIdsSet, (String)SearchOperator.OR.op());
    }

    @Override
    protected void buildResultTable(LookupForm lookupForm, Collection displayList, Collection resultTable) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasReturnableRow = false;
        for (Object entry : displayList) {
            BusinessObject element = (BusinessObject)entry;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            List columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (!col.getPropertyName().equals("documentNumber")) continue;
                String url = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                HashMap<String, String> fieldList = new HashMap<String, String>();
                fieldList.put("documentNumber", propValue);
                HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(url, "");
                a.setTitle(HtmlData.getTitleText((String)this.getContractsGrantsReportHelperService().createTitleText(ContractsGrantsInvoiceReport.class), ContractsGrantsInvoiceReport.class, fieldList));
                col.setColumnAnchor((HtmlData)a);
            }
            ResultRow row = new ResultRow(columns, "", "&nbsp;");
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            boolean isRowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(isRowReturnable);
            if (isRowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }
}

