/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.ReceivableCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.SalesTaxCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.WriteoffCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.WriteoffTaxCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableTaxService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.TaxDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.GeneralLedgerPostingDocumentBase;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.TaxService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class CustomerInvoiceWriteoffDocument
extends GeneralLedgerPostingDocumentBase
implements GeneralLedgerPendingEntrySource,
AmountTotaling {
    protected static final String REQUIRES_APPROVAL_NODE = "RequiresApproval";
    protected String chartOfAccountsCode;
    protected String accountNumber;
    protected String subAccountNumber;
    protected String financialObjectCode;
    protected String financialSubObjectCode;
    protected String projectCode;
    protected String organizationReferenceIdentifier;
    protected String financialDocumentReferenceInvoiceNumber;
    protected String statusCode;
    protected String customerNote;
    protected Account account;
    protected Chart chartOfAccounts;
    protected SubAccount subAccount;
    protected ObjectCode financialObject;
    protected SubObjectCode financialSubObject;
    protected ProjectCode project;
    protected CustomerInvoiceDocument customerInvoiceDocument;
    protected AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;
    protected KualiDecimal invoiceWriteoffAmount;

    public AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return this.accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrganizationReferenceIdentifier() {
        return this.organizationReferenceIdentifier;
    }

    public void setOrganizationReferenceIdentifier(String organizationReferenceIdentifier) {
        this.organizationReferenceIdentifier = organizationReferenceIdentifier;
    }

    public String getFinancialDocumentReferenceInvoiceNumber() {
        return this.financialDocumentReferenceInvoiceNumber;
    }

    public void setFinancialDocumentReferenceInvoiceNumber(String financialDocumentReferenceInvoiceNumber) {
        this.financialDocumentReferenceInvoiceNumber = financialDocumentReferenceInvoiceNumber;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public ObjectCode getFinancialObject() {
        return this.financialObject;
    }

    public void setFinancialObject(ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public SubObjectCode getFinancialSubObject() {
        return this.financialSubObject;
    }

    public void setFinancialSubObject(SubObjectCode financialSubObject) {
        this.financialSubObject = financialSubObject;
    }

    public ProjectCode getProject() {
        return this.project;
    }

    public void setProject(ProjectCode project) {
        this.project = project;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        if (ObjectUtils.isNull((Object)this.customerInvoiceDocument) && StringUtils.isNotEmpty((CharSequence)this.financialDocumentReferenceInvoiceNumber)) {
            this.refreshReferenceObject("customerInvoiceDocument");
        }
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public List<CustomerInvoiceDetail> getCustomerInvoiceDetailsForWriteoff() {
        ArrayList<CustomerInvoiceDetail> customerInvoiceDetailsForWriteoff = new ArrayList<CustomerInvoiceDetail>();
        for (CustomerInvoiceDetail customerInvoiceDetail : this.getCustomerInvoiceDocument().getCustomerInvoiceDetailsWithoutDiscounts()) {
            customerInvoiceDetail.setCustomerInvoiceWriteoffDocumentNumber(this.documentNumber);
            customerInvoiceDetailsForWriteoff.add(customerInvoiceDetail);
        }
        return customerInvoiceDetailsForWriteoff;
    }

    public KualiDecimal getInvoiceWriteoffAmount() {
        if (!"A".equals(this.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode())) {
            this.invoiceWriteoffAmount = this.customerInvoiceDocument.getOpenAmount();
        }
        return this.invoiceWriteoffAmount;
    }

    public void setInvoiceWriteoffAmount(KualiDecimal invoiceWriteoffAmount) {
        this.invoiceWriteoffAmount = invoiceWriteoffAmount;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void initiateDocument() {
        this.setStatusCode("INIT");
    }

    public void clearInitFields() {
        this.setFinancialDocumentReferenceInvoiceNumber(null);
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        if (StringUtils.isNotBlank((CharSequence)this.getFinancialDocumentReferenceInvoiceNumber())) {
            ArrayList<String> documentIds = new ArrayList<String>();
            documentIds.add(this.getFinancialDocumentReferenceInvoiceNumber());
            return documentIds;
        }
        return null;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            CustomerInvoiceWriteoffDocumentService writeoffService = (CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class);
            writeoffService.completeWriteoffProcess(this);
        }
    }

    public void prepareForSave(KualiDocumentEvent event) {
        if (!((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this)) {
            this.logErrors();
            throw new ValidationException("general ledger GLPE generation failed");
        }
        super.prepareForSave(event);
    }

    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)glpeSourceDetail;
        if (!customerInvoiceDetail.getAmountOpen().isPositive()) {
            return true;
        }
        if (((AccountsReceivableTaxService)SpringContext.getBean(AccountsReceivableTaxService.class)).isCustomerInvoiceDetailTaxable(this.getCustomerInvoiceDocument(), customerInvoiceDetail)) {
            KualiDecimal amount = customerInvoiceDetail.getInvoiceItemPreTaxAmount();
            this.addReceivableGLPEs(sequenceHelper, glpeSourceDetail, true, amount);
            sequenceHelper.increment();
            this.addWriteoffGLPEs(sequenceHelper, glpeSourceDetail, true, amount);
            this.addSalesTaxGLPEs(sequenceHelper, glpeSourceDetail, true, amount);
        } else {
            KualiDecimal amount = customerInvoiceDetail.getAmountOpen();
            this.addReceivableGLPEs(sequenceHelper, glpeSourceDetail, true, amount);
            sequenceHelper.increment();
            this.addWriteoffGLPEs(sequenceHelper, glpeSourceDetail, true, amount);
        }
        return true;
    }

    protected void addReceivableGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, boolean hasClaimOnCashOffset, KualiDecimal amount) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)glpeSourceDetail;
        ReceivableCustomerInvoiceDetail receivableCustomerInvoiceDetail = new ReceivableCustomerInvoiceDetail(customerInvoiceDetail, this.getCustomerInvoiceDocument());
        boolean isDebit = false;
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        service.createAndAddGenericInvoiceRelatedGLPEs(this, (GeneralLedgerPendingEntrySourceDetail)receivableCustomerInvoiceDetail, sequenceHelper, isDebit, hasClaimOnCashOffset, amount);
    }

    protected void addWriteoffGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, boolean hasClaimOnCashOffset, KualiDecimal amount) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)glpeSourceDetail;
        WriteoffCustomerInvoiceDetail writeoffCustomerInvoiceDetail = new WriteoffCustomerInvoiceDetail(customerInvoiceDetail, this);
        boolean isDebit = true;
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        service.createAndAddGenericInvoiceRelatedGLPEs(this, (GeneralLedgerPendingEntrySourceDetail)writeoffCustomerInvoiceDetail, sequenceHelper, isDebit, hasClaimOnCashOffset, amount);
    }

    protected void addSalesTaxGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, boolean hasWriteoffTaxClaimOnCashOffset, KualiDecimal amount) {
        List invGlpes = this.getCustomerInvoiceDocument().getGeneralLedgerPendingEntries();
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)glpeSourceDetail;
        boolean isDebit = true;
        String postalCode = ((AccountsReceivableTaxService)SpringContext.getBean(AccountsReceivableTaxService.class)).getPostalCodeForTaxation(this.getCustomerInvoiceDocument());
        Date dateOfTransaction = this.getCustomerInvoiceDocument().getBillingDate();
        List salesTaxDetails = ((TaxService)SpringContext.getBean(TaxService.class)).getSalesTaxDetails(dateOfTransaction, postalCode, amount);
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        for (TaxDetail salesTaxDetail : salesTaxDetails) {
            SalesTaxCustomerInvoiceDetail salesTaxCustomerInvoiceDetail = new SalesTaxCustomerInvoiceDetail(salesTaxDetail, customerInvoiceDetail);
            ReceivableCustomerInvoiceDetail receivableCustomerInvoiceDetail = new ReceivableCustomerInvoiceDetail(salesTaxCustomerInvoiceDetail, this.getCustomerInvoiceDocument());
            WriteoffTaxCustomerInvoiceDetail writeoffTaxCustomerInvoiceDetail = new WriteoffTaxCustomerInvoiceDetail(salesTaxCustomerInvoiceDetail, this);
            CustomerInvoiceDetail customerInvDetail = hasWriteoffTaxClaimOnCashOffset ? writeoffTaxCustomerInvoiceDetail : salesTaxCustomerInvoiceDetail;
            List<WriteOffGlpes> newGlpes = this.findGeneralLedgerPendingEntryForDetail(invGlpes, (GeneralLedgerPendingEntrySourceDetail)receivableCustomerInvoiceDetail, (GeneralLedgerPendingEntrySourceDetail)salesTaxCustomerInvoiceDetail);
            for (WriteOffGlpes writeOffGlpe : newGlpes) {
                sequenceHelper.increment();
                if (writeOffGlpe.isWriteOffDetail) {
                    service.createAndAddGenericInvoiceRelatedGLPEs(this, (GeneralLedgerPendingEntrySourceDetail)customerInvDetail, sequenceHelper, isDebit, hasWriteoffTaxClaimOnCashOffset, writeOffGlpe.glpe.getTransactionLedgerEntryAmount());
                } else {
                    service.createAndAddGenericInvoiceRelatedGLPEs(this, (GeneralLedgerPendingEntrySourceDetail)receivableCustomerInvoiceDetail, sequenceHelper, !isDebit, hasWriteoffTaxClaimOnCashOffset, writeOffGlpe.glpe.getTransactionLedgerEntryAmount());
                }
                invGlpes.remove(writeOffGlpe.glpe);
            }
        }
    }

    protected List<WriteOffGlpes> findGeneralLedgerPendingEntryForDetail(List<GeneralLedgerPendingEntry> glpes, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySourceDetail glpeWriteOffDetail) {
        ArrayList<WriteOffGlpes> arrGlpeMatches = new ArrayList<WriteOffGlpes>();
        for (GeneralLedgerPendingEntry glpe : glpes) {
            if (glpeSourceDetail.getAccountNumber().matches(glpe.getAccountNumber()) && glpeSourceDetail.getChartOfAccountsCode().matches(glpe.getChartOfAccountsCode()) && glpeSourceDetail.getObjectCode().getFinancialObjectCode().matches(glpe.getFinancialObjectCode())) {
                arrGlpeMatches.add(new WriteOffGlpes(glpe, false));
                continue;
            }
            if (!glpeWriteOffDetail.getAccountNumber().matches(glpe.getAccountNumber()) || !glpeWriteOffDetail.getChartOfAccountsCode().matches(glpe.getChartOfAccountsCode()) || !glpeWriteOffDetail.getObjectCode().getFinancialObjectCode().matches(glpe.getFinancialObjectCode())) continue;
            arrGlpeMatches.add(new WriteOffGlpes(glpe, true));
        }
        return arrGlpeMatches;
    }

    public KualiDecimal getGeneralLedgerPendingEntryAmountForDetail(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        return null;
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        return new ArrayList<CustomerInvoiceDetail>(this.getCustomerInvoiceDocument().getCustomerInvoiceDetailsWithoutDiscounts());
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return false;
    }

    public KualiDecimal getTotalDollarAmount() {
        return this.getInvoiceWriteoffAmount();
    }

    public String getCustomerNote() {
        return this.customerNote;
    }

    public void setCustomerNote(String customerNote) {
        this.customerNote = customerNote;
    }

    public void populateCustomerNote() {
        this.customerNote = "";
        CustomerService customerService = (CustomerService)SpringContext.getBean(CustomerService.class);
        List<Note> boNotes = customerService.getCustomerNotes(this.getCustomerInvoiceDocument().getCustomer().getCustomerNumber());
        StringBuffer customerNotes = new StringBuffer();
        if (boNotes.size() > 0) {
            for (Note note : boNotes) {
                customerNotes.append(note.getNoteText().trim()).append(" ");
            }
            this.customerNote = customerNotes.toString().trim();
        }
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (REQUIRES_APPROVAL_NODE.equals(nodeName)) {
            ParameterService paramService = (ParameterService)SpringContext.getBean(ParameterService.class);
            KualiDecimal approvalThreshold = new KualiDecimal(paramService.getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "APPROVAL_THRESHOLD"));
            return approvalThreshold.isLessThan((AbstractKualiDecimal)this.getInvoiceWriteoffAmount());
        }
        throw new UnsupportedOperationException("answerSplitNode('" + nodeName + "') called but no handler for this nodeName present.");
    }

    protected class WriteOffGlpes {
        GeneralLedgerPendingEntry glpe;
        boolean isWriteOffDetail;

        public WriteOffGlpes(GeneralLedgerPendingEntry pe, boolean writeOff) {
            this.glpe = pe;
            this.isWriteOffDetail = writeOff;
        }
    }
}

