/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.sys.KFSConstants;

public class CustomerServiceImpl
implements CustomerService {
    protected SequenceAccessorService sequenceAccessorService;
    protected BusinessObjectService businessObjectService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected NoteService noteService;
    protected static final String CUSTOMER_NUMBER_SEQUENCE = "CUST_NBR_SEQ";

    @Override
    public Customer getByPrimaryKey(String customerNumber) {
        return (Customer)this.businessObjectService.findBySinglePrimaryKey(Customer.class, (Object)customerNumber);
    }

    @Override
    public Customer getByTaxNumber(String taxNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerTaxNbr", taxNumber);
        Collection customers = this.getBusinessObjectService().findMatching(Customer.class, fieldValues);
        Customer customer = null;
        Iterator iterator = customers.iterator();
        while (iterator.hasNext()) {
            Customer c;
            customer = c = (Customer)((Object)iterator.next());
        }
        return customer;
    }

    @Override
    public String getNextCustomerNumber(Customer newCustomer) {
        try {
            Long customerNumberSuffix = this.sequenceAccessorService.getNextAvailableSequenceNumber(CUSTOMER_NUMBER_SEQUENCE, Customer.class);
            String customerNumberPrefix = newCustomer.getCustomerName().substring(0, 3);
            return customerNumberPrefix + customerNumberSuffix;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            throw new StringIndexOutOfBoundsException("Customer name is less than three characters in length.");
        }
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    @Override
    public Customer getCustomerByName(String customerName) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerName", customerName);
        Collection customers = this.getBusinessObjectService().findMatching(Customer.class, fieldValues);
        Customer customer = null;
        Iterator iterator = customers.iterator();
        while (iterator.hasNext()) {
            Customer c;
            customer = c = (Customer)((Object)iterator.next());
        }
        return customer;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getInvoicesForCustomer(Customer customer) {
        Collection<CustomerInvoiceDocument> invoices = null;
        if (null != customer) {
            invoices = this.getInvoicesForCustomer(customer.getCustomerNumber());
        }
        return invoices;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getInvoicesForCustomer(String customerNumber) {
        return this.customerInvoiceDocumentService.getCustomerInvoiceDocumentsByCustomerNumber(customerNumber);
    }

    @Override
    public void createCustomerNote(String customerNumber, String customerNote) {
        Customer customer = this.getByPrimaryKey(customerNumber);
        if (StringUtils.isNotBlank((CharSequence)customerNote)) {
            Note newBONote = new Note();
            newBONote.setNoteText(customerNote);
            newBONote.setNotePostedTimestampToCurrent();
            newBONote.setNoteTypeCode(KFSConstants.NoteTypeEnum.BUSINESS_OBJECT_NOTE_TYPE.getCode());
            Note note = this.noteService.createNote(newBONote, (PersistableBusinessObject)customer, GlobalVariables.getUserSession().getPrincipalId());
            this.noteService.save(note);
        }
    }

    @Override
    public List<Note> getCustomerNotes(String customerNumber) {
        Customer customer = this.getByPrimaryKey(customerNumber);
        List<Object> notes = new ArrayList<Note>();
        if (ObjectUtils.isNotNull((Object)((Object)customer))) {
            notes = this.noteService.getByRemoteObjectId(customer.getObjectId());
        }
        return notes;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }
}

