/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.AppliedPayment;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.InvoicePaidAppliedService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InvoicePaidAppliedServiceImpl
implements InvoicePaidAppliedService<AppliedPayment> {
    private BusinessObjectService businessObjectService;
    private UniversityDateService universityDateService;

    @Override
    public void clearDocumentPaidAppliedsFromDatabase(String documentNumber) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("documentNumber", documentNumber);
        this.businessObjectService.deleteMatching(InvoicePaidApplied.class, fields);
    }

    @Override
    public Integer getNumberOfInvoicePaidAppliedsForInvoiceDetail(String financialDocumentReferenceInvoiceNumber, Integer invoiceItemNumber) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("financialDocumentReferenceInvoiceNumber", financialDocumentReferenceInvoiceNumber);
        criteria.put("invoiceItemNumber", invoiceItemNumber);
        return this.businessObjectService.countMatching(InvoicePaidApplied.class, criteria);
    }

    public Collection<InvoicePaidApplied> getInvoicePaidAppliedsFromSpecificDocument(String documentNumber, String referenceCustomerInvoiceDocumentNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("financialDocumentReferenceInvoiceNumber", referenceCustomerInvoiceDocumentNumber);
        criteria.put("documentNumber", documentNumber);
        return this.businessObjectService.findMatching(InvoicePaidApplied.class, criteria);
    }

    @Override
    public boolean doesInvoiceHaveAppliedAmounts(CustomerInvoiceDocument document) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("financialDocumentReferenceInvoiceNumber", document.getDocumentNumber());
        Collection results = this.businessObjectService.findMatching(InvoicePaidApplied.class, criteria);
        for (InvoicePaidApplied invoicePaidApplied : results) {
            if (invoicePaidApplied.getDocumentNumber().equals(document.getDocumentNumber())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<InvoicePaidApplied> getInvoicePaidAppliedsForInvoice(String documentNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("financialDocumentReferenceInvoiceNumber", documentNumber);
        return this.businessObjectService.findMatching(InvoicePaidApplied.class, criteria);
    }

    @Override
    public Collection<InvoicePaidApplied> getInvoicePaidAppliedsForInvoice(CustomerInvoiceDocument invoice) {
        return this.getInvoicePaidAppliedsForInvoice(invoice.getDocumentNumber());
    }

    @Override
    public List<InvoicePaidApplied> getActiveInvoicePaidAppliedsForInvoice(CustomerInvoiceDocument invoice) {
        return this.filterInvoicePaidAppliedsToOnlyActive((List)this.getInvoicePaidAppliedsForInvoice(invoice));
    }

    @Override
    public List<InvoicePaidApplied> filterInvoicePaidAppliedsToOnlyActive(List<InvoicePaidApplied> invoicePaidApplieds) {
        return invoicePaidApplieds.stream().filter(invoicePaidApplied -> !invoicePaidApplied.isAdjusted()).collect(Collectors.toList());
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }
}

