/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.PaymentMedium;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.authorization.CashControlDocumentPresentationController;
import org.kuali.kfs.module.ar.document.validation.AddCashControlDetailRule;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;

public class CashControlDocumentRule
extends TransactionalDocumentRuleBase
implements AddCashControlDetailRule<CashControlDocument> {
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        boolean isValid = super.processCustomSaveDocumentBusinessRules(document);
        CashControlDocument ccDocument = (CashControlDocument)document;
        ccDocument.refreshReferenceObject("customerPaymentMedium");
        ccDocument.refreshReferenceObject("generalLedgerPendingEntries");
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (errorMap.hasErrors()) {
            isValid &= this.checkRefDocNumber(ccDocument);
            isValid &= this.validateCashControlDetails(ccDocument);
        }
        return isValid;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean isValid = super.processCustomRouteDocumentBusinessRules(document);
        CashControlDocument cashControlDocument = (CashControlDocument)document;
        if (isValid) {
            isValid = this.checkPaymentMedium(cashControlDocument);
            isValid &= this.checkRefDocNumber(cashControlDocument);
            isValid &= this.validateBankCode(cashControlDocument);
            isValid &= this.validateCashControlDetails(cashControlDocument);
            isValid &= this.checkCashControlDocumentHasDetails(cashControlDocument);
        }
        return isValid;
    }

    protected boolean processCustomApproveDocumentBusinessRules(ApproveDocumentEvent approveEvent) {
        boolean isValid = super.processCustomApproveDocumentBusinessRules(approveEvent);
        CashControlDocument cashControlDocument = (CashControlDocument)approveEvent.getDocument();
        cashControlDocument.refreshReferenceObject("customerPaymentMedium");
        cashControlDocument.refreshReferenceObject("generalLedgerPendingEntries");
        isValid &= this.checkAllAppDocsApprovedOrCanceled(cashControlDocument);
        return isValid &= this.checkGLPEsCreated(cashControlDocument);
    }

    protected boolean checkLineAmount(CashControlDocument document, CashControlDetail detail) {
        boolean isValid = true;
        PaymentApplicationDocument paymentApplicationDocument = detail.getReferenceFinancialDocument();
        if (detail.getFinancialDocumentLineAmount().isZero() && (paymentApplicationDocument == null || !paymentApplicationDocument.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled() && !paymentApplicationDocument.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved())) {
            GlobalVariables.getMessageMap().putError("financialDocumentLineAmount", "error.ar.LineAmountCannotBeZero", new String[0]);
            isValid = false;
        }
        if (detail.getFinancialDocumentLineAmount().isNegative()) {
            GlobalVariables.getMessageMap().putError("financialDocumentLineAmount", "error.ar.LineAmountCannotBeNegative", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    protected boolean checkCashControlDocumentHasDetails(CashControlDocument cashControlDocument) {
        boolean isValid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (cashControlDocument.getCashControlDetails().isEmpty()) {
            GlobalVariables.getMessageMap().putError("cashControlDetails", "error.ar.NoLinesToProcess", new String[0]);
            isValid = false;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return isValid;
    }

    protected boolean checkPaymentMedium(CashControlDocument document) {
        boolean isValid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        String paymentMediumCode = document.getCustomerPaymentMediumCode();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("customerPaymentMediumCode", paymentMediumCode);
        PaymentMedium paymentMedium = (PaymentMedium)this.getBusinessObjectService().findByPrimaryKey(PaymentMedium.class, criteria);
        if (paymentMedium == null) {
            GlobalVariables.getMessageMap().putError("customerPaymentMediumCode", "error.ar.CustomerPaymentMediumIsNotValid", new String[0]);
            isValid = false;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return isValid;
    }

    protected boolean checkRefDocNumber(CashControlDocument document) {
        boolean isValid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        String paymentMedium = document.getCustomerPaymentMediumCode();
        if ("CA".equalsIgnoreCase(paymentMedium)) {
            String refDocNumber = document.getReferenceFinancialDocumentNumber();
            try {
                Long.parseLong(refDocNumber);
                if (StringUtils.isBlank((CharSequence)refDocNumber)) {
                    GlobalVariables.getMessageMap().putError("referenceFinancialDocumentNumber", "error.ar.ReferenceDocNumberCannotBeNullforPaymentMediumCash", new String[0]);
                    isValid = false;
                } else {
                    boolean docExists = this.getDocumentService().documentExists(refDocNumber);
                    if (!docExists) {
                        GlobalVariables.getMessageMap().putError("referenceFinancialDocumentNumber", "error.ar.ReferenceDocNumberMustBeValidforPaymentMediumCash", new String[0]);
                        isValid = false;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                GlobalVariables.getMessageMap().putError("referenceFinancialDocumentNumber", "error.ar.ReferenceDocNumberMustBeValidforPaymentMediumCash", new String[0]);
                isValid = false;
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return isValid;
    }

    protected boolean checkGLPEsCreated(CashControlDocument cashControlDocument) {
        boolean isValid = true;
        List<GeneralLedgerPendingEntry> glpes = cashControlDocument.getGeneralLedgerPendingEntries();
        Integer totalGLRecordsCreated = 0;
        if (glpes == null || glpes.isEmpty()) {
            totalGLRecordsCreated = cashControlDocument.getGeneralLedgerEntriesPostedCount();
        }
        if (!"CA".equalsIgnoreCase(cashControlDocument.getCustomerPaymentMediumCode()) && (glpes == null || glpes.isEmpty()) && totalGLRecordsCreated == 0) {
            GlobalVariables.getMessageMap().putError("document.generalLedgerPendingEntr*", "error.ar.GLPEsNotCreated", new String[0]);
            isValid = false;
        }
        return isValid;
    }

    @Override
    public boolean processAddCashControlDetailBusinessRules(CashControlDocument transactionalDocument, CashControlDetail cashControlDetail) {
        boolean success = this.checkGLPEsNotGenerated(transactionalDocument);
        if (success) {
            GlobalVariables.getMessageMap().removeFromErrorPath("newCashControlDetail");
            success = this.validateBankCode(transactionalDocument);
            GlobalVariables.getMessageMap().addToErrorPath("newCashControlDetail");
            success &= this.validateCashControlDetail(transactionalDocument, cashControlDetail);
        }
        return success;
    }

    protected boolean validateCashControlDetail(CashControlDocument document, CashControlDetail cashControlDetail) {
        boolean isValid;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int originalErrorCount = errorMap.getErrorCount();
        this.getDictionaryValidationService().validateBusinessObject((BusinessObject)cashControlDetail);
        boolean bl = isValid = errorMap.getErrorCount() == originalErrorCount;
        if (isValid) {
            String customerNumber = cashControlDetail.getCustomerNumber();
            if (customerNumber != null && !"".equals(customerNumber)) {
                isValid = this.checkCustomerNumber(customerNumber);
            }
            isValid &= this.checkLineAmount(document, cashControlDetail);
        }
        return isValid;
    }

    protected boolean validateCashControlDetails(CashControlDocument cashControlDocument) {
        GlobalVariables.getMessageMap().addToErrorPath("document");
        boolean isValid = true;
        for (int i = 0; i < cashControlDocument.getCashControlDetails().size(); ++i) {
            CashControlDetail cashControlDetail = cashControlDocument.getCashControlDetail(i);
            String propertyName = "cashControlDetail[" + i + "]";
            GlobalVariables.getMessageMap().addToErrorPath(propertyName);
            isValid &= this.validateCashControlDetail(cashControlDocument, cashControlDetail);
            GlobalVariables.getMessageMap().removeFromErrorPath(propertyName);
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return isValid;
    }

    protected boolean checkCustomerNumber(String customerNumber) {
        boolean isValid = true;
        if (customerNumber != null && !"".equals(customerNumber)) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("customerNumber", customerNumber);
            Customer customer = (Customer)this.getBusinessObjectService().findByPrimaryKey(Customer.class, criteria);
            if (customer == null) {
                GlobalVariables.getMessageMap().putError("customerNumber", "error.ar.CustomerNumberIsNotValid", new String[0]);
                isValid = false;
            }
        }
        return isValid;
    }

    protected boolean checkGLPEsNotGenerated(CashControlDocument cashControlDocument) {
        boolean success = true;
        List<GeneralLedgerPendingEntry> glpes = cashControlDocument.getGeneralLedgerPendingEntries();
        if (glpes != null && !glpes.isEmpty()) {
            success = false;
            GlobalVariables.getMessageMap().putError("document.generalLedgerPendingEntr*", "error.ar.AddApplicationDocNotAllowedAfterGLPEsGenerated", new String[0]);
        }
        return success;
    }

    protected boolean checkAllAppDocsApprovedOrCanceled(CashControlDocument cashControlDocument) {
        boolean allAppDocsApproved = true;
        for (int i = 0; i < cashControlDocument.getCashControlDetails().size(); ++i) {
            CashControlDetail cashControlDetail = cashControlDocument.getCashControlDetail(i);
            PaymentApplicationDocument applicationDocument = cashControlDetail.getReferenceFinancialDocument();
            WorkflowDocument workflowDocument = applicationDocument.getDocumentHeader().getWorkflowDocument();
            if (workflowDocument.isApproved() || workflowDocument.isCanceled() || workflowDocument.isDisapproved()) continue;
            allAppDocsApproved = false;
            String propertyName = "cashControlDetail[" + i + "]";
            GlobalVariables.getMessageMap().addToErrorPath("document");
            GlobalVariables.getMessageMap().addToErrorPath(propertyName);
            GlobalVariables.getMessageMap().putError("status", "error.ar.AllApplicationDocumentsMustBeApprovedCanceledOrDisapproved", new String[0]);
            GlobalVariables.getMessageMap().removeFromErrorPath(propertyName);
            GlobalVariables.getMessageMap().removeFromErrorPath("document");
            break;
        }
        return allAppDocsApproved;
    }

    protected boolean validateBankCode(CashControlDocument document) {
        boolean isValid = true;
        CashControlDocumentPresentationController ccPC = (CashControlDocumentPresentationController)((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentPresentationController((Document)document);
        if (!ccPC.getEditModes((Document)document).contains("editBankCode")) {
            return true;
        }
        String bankCode = document.getBankCode();
        if (StringUtils.isNotBlank((CharSequence)bankCode)) {
            Bank bank = ((BankService)SpringContext.getBean(BankService.class)).getByPrimaryId(bankCode);
            if (ObjectUtils.isNull((Object)bank)) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("document.bankCode", "error.ar.invalidBankCode", new String[0]);
            } else if (!bank.isBankDepositIndicator()) {
                isValid = false;
                GlobalVariables.getMessageMap().putError("document.bankCode", "error.ar.bankNotEligibleForDepositActivity", new String[0]);
            }
        } else if (((BankService)SpringContext.getBean(BankService.class)).isBankSpecificationEnabled()) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("document.bankCode", "error.ar.bankCodeRequired", new String[0]);
        }
        return isValid;
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

