/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.coa.businessobject.ProjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.kfs.kim.impl.group.GroupBo;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rest.responses.AdHocRoutePersonResponse;
import org.kuali.kfs.krad.rest.responses.AdHocRouteWorkgroupResponse;
import org.kuali.kfs.krad.rest.responses.GlpeResponse;
import org.kuali.kfs.krad.rest.responses.NoteResponse;
import org.kuali.kfs.krad.rest.responses.PendingActionResponse;
import org.kuali.kfs.krad.rest.responses.RouteLogResponse;
import org.kuali.kfs.krad.rest.responses.TakenActionResponse;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationAdjustmentNonAppliedHolding;
import org.kuali.kfs.module.ar.rest.resource.responses.PaymentApplicationAdjustmentInvoiceResponse;
import org.kuali.kfs.sys.FileUtil;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.OriginationCode;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.businessobject.service.DetailsUrlService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentFormBase;
import org.kuali.kfs.sys.rest.presentation.Button;
import org.kuali.kfs.sys.rest.presentation.ButtonGroup;
import org.kuali.kfs.sys.rest.presentation.StandardButtonManager;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class PaymentApplicationAdjustmentForm
extends FinancialSystemTransactionalDocumentFormBase {
    private static final Logger LOG = LogManager.getLogger();
    private static final String ADJUST_BUTTON_EXTRA_BUTTON_PROPERTY = "adjust";
    private static final String EMPTY_JSON = "{}";
    private BusinessObjectService businessObjectService;
    private PersonService personService;
    private String headerFieldsJson;
    private List<PaymentApplicationAdjustmentNonAppliedHolding> nonAppliedHoldings = new ArrayList<PaymentApplicationAdjustmentNonAppliedHolding>();
    private List<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();

    public void populate(HttpServletRequest request) {
        this.registerEditableProperty("methodToCall");
        super.populate(request);
    }

    public void reset(ActionMapping mapping, ServletRequest request) {
        super.reset(mapping, request);
    }

    protected String getDefaultDocumentTypeName() {
        return "APPA";
    }

    PaymentApplicationAdjustmentDocument getApplicationAdjustmentDocument() {
        return (PaymentApplicationAdjustmentDocument)this.getDocument();
    }

    protected List<HeaderField> getStandardHeaderFields(WorkflowDocument workflowDocument) {
        List standardHeaderFields = super.getStandardHeaderFields(workflowDocument);
        HeaderField initiatorInquiryHeaderField = standardHeaderFields.stream().filter(field -> field.getId().equals("documentInitiator")).findFirst().orElse(null);
        if (initiatorInquiryHeaderField != null) {
            String initiatorUrl = this.getPersonInquiryUrl(this.getInitiator());
            initiatorInquiryHeaderField.setNonLookupValue(initiatorUrl);
        }
        HeaderField adjustee = this.getAdjusteeHeaderField();
        standardHeaderFields.add(adjustee);
        this.getAdjustmentHeaderField().ifPresent(standardHeaderFields::add);
        return standardHeaderFields;
    }

    private HeaderField getAdjusteeHeaderField() {
        String ddAttributeEntryName = "DataDictionary.PaymentApplicationAdjustmentDocument.attributes.adjusteeDocumentNumber";
        String displayValue = this.getPaymentApplicationAdjustmentDocument().getAdjusteeDocumentNumber();
        String nonLookupValue = this.getDocumentHandlerUrl(displayValue);
        return new HeaderField("documentAdjustee", "DataDictionary.PaymentApplicationAdjustmentDocument.attributes.adjusteeDocumentNumber", displayValue, nonLookupValue);
    }

    private Optional<HeaderField> getAdjustmentHeaderField() {
        String adjustmentDocumentNumber = this.getPaymentApplicationAdjustmentDocument().getAdjustmentDocumentNumber();
        return Optional.ofNullable(adjustmentDocumentNumber).map(displayValue -> {
            String ddAttributeEntryName = "DataDictionary.PaymentApplicationAdjustmentDocument.attributes.adjustmentDocumentNumber";
            String nonLookupValue = this.getDocumentHandlerUrl((String)displayValue);
            return new HeaderField("documentAdjuster", "DataDictionary.PaymentApplicationAdjustmentDocument.attributes.adjustmentDocumentNumber", displayValue, nonLookupValue);
        });
    }

    PaymentApplicationAdjustmentDocument getPaymentApplicationAdjustmentDocument() {
        return (PaymentApplicationAdjustmentDocument)this.getDocument();
    }

    private String urlForCustomer(Customer customer) {
        DetailsUrlService detailsUrlService = (DetailsUrlService)SpringContext.getBean(DetailsUrlService.class);
        return detailsUrlService.getDetailsUrl((BusinessObjectBase)customer, "customerNumber");
    }

    private String urlForGroup(GroupBo group) {
        DetailsUrlService detailsUrlService = (DetailsUrlService)SpringContext.getBean(DetailsUrlService.class);
        return detailsUrlService.getDetailsUrl((BusinessObjectBase)group, "name");
    }

    private String urlForPerson(Person person) {
        return this.getPersonInquiryUrl(person);
    }

    private void setupNonAppliedHoldingsWrapper() {
        this.nonAppliedHoldings.clear();
        List<NonAppliedHolding> documentNonAppliedHoldings = this.getPaymentApplicationAdjustmentDocument().getNonAppliedHoldings();
        if (documentNonAppliedHoldings != null) {
            this.nonAppliedHoldings = documentNonAppliedHoldings.stream().map(holding -> this.addNonAppliedHoldingWithCustomer(holding.getCustomer(), holding.getFinancialDocumentLineAmount())).collect(Collectors.toList());
        }
    }

    public PaymentApplicationAdjustmentNonAppliedHolding addNonAppliedHoldingWithCustomer(Customer customer, KualiDecimal amount) {
        PaymentApplicationAdjustmentNonAppliedHolding nonAppliedHolding = new PaymentApplicationAdjustmentNonAppliedHolding(customer.getCustomerName(), customer.getCustomerNumber(), this.urlForCustomer(customer), amount);
        this.nonAppliedHoldings.add(nonAppliedHolding);
        return nonAppliedHolding;
    }

    public AdHocRouteWorkgroupResponse createAdHocRouteWorkgroupResponse(GroupBo group, String action) {
        return new AdHocRouteWorkgroupResponse(group.getId(), group.getName(), group.getNamespaceCode(), action, this.urlForGroup(group));
    }

    public NoteResponse createNoteResponse(Note note) {
        Attachment attachment = note.getAttachment();
        return new NoteResponse(note.getObjectId(), note.getNoteText(), note.getAuthorUniversal().getName(), this.getPersonInquiryUrl(note.getAuthorUniversal()), attachment != null ? attachment.getAttachmentFileName() : null, attachment != null ? attachment.getAttachmentFileSizeWithUnits() : null, note.getAttachmentLink(), note.getNotePostedTimestamp());
    }

    public GlpeResponse createGlpeResponse(GeneralLedgerPendingEntry glpe) {
        String universityFiscalYearInquiryUrl = this.getInquiryUrl(SystemOptions.class, "universityFiscalYear=" + glpe.getUniversityFiscalYear().toString());
        String chartCodeInquiryUrl = this.getInquiryUrl(Chart.class, "chartOfAccountsCode=" + glpe.getChartOfAccountsCode());
        String accountNumberInquiryUrl = this.getInquiryUrl(Account.class, "chartOfAccountsCode=" + glpe.getChartOfAccountsCode() + "&accountNumber=" + glpe.getAccountNumber());
        String subAccountNumberInquiryUrl = this.getInquiryUrl(SubAccount.class, "chartOfAccountsCode=" + glpe.getChartOfAccountsCode() + "&accountNumber=" + glpe.getAccountNumber() + "&subAccountNumber=" + glpe.getSubAccountNumber());
        String objectInquiryUrl = this.getInquiryUrl(ObjectCode.class, "financialObjectCode=" + glpe.getFinancialObjectCode() + "&universityFiscalYear=" + glpe.getUniversityFiscalYear().toString() + "&chartOfAccountsCode=" + glpe.getChartOfAccountsCode());
        String subObjectInquiryUrl = this.getInquiryUrl(SubObjectCode.class, "financialSubObjectCode=" + glpe.getFinancialSubObjectCode() + "&financialObjectCode=" + glpe.getFinancialObjectCode() + "&universityFiscalYear=" + glpe.getUniversityFiscalYear().toString() + "&chartOfAccountsCode=" + glpe.getChartOfAccountsCode());
        String projectCodeInquiryUrl = this.getInquiryUrl(ProjectCode.class, "code=" + glpe.getProjectCode());
        String documentTypeCodeInquiryUrl = this.getInquiryUrl(DocumentTypeEBO.class, "documentTypeId=" + glpe.getFinancialSystemDocumentTypeCode().getDocumentTypeId());
        String balanceTypeInquiryUrl = this.getInquiryUrl(BalanceType.class, "code=" + glpe.getFinancialBalanceTypeCode());
        String objectTypeInquiryUrl = this.getInquiryUrl(ObjectType.class, "code=" + glpe.getFinancialObjectTypeCode());
        String fiscalPeriodCodeInquiryUrl = this.getInquiryUrl(AccountingPeriod.class, "universityFiscalPeriodCode=" + glpe.getUniversityFiscalPeriodCode() + "&universityFiscalYear=" + glpe.getUniversityFiscalYear().toString());
        String originCodeInquiryUrl = this.getInquiryUrl(OriginationCode.class, "financialSystemOriginationCode=" + glpe.getFinancialSystemOriginationCode());
        String documentNumberUrl = this.getDocumentUrl(glpe.getDocumentNumber());
        return new GlpeResponse(glpe.getUniversityFiscalYear().toString(), universityFiscalYearInquiryUrl, glpe.getChartOfAccountsCode(), chartCodeInquiryUrl, glpe.getAccountNumber(), accountNumberInquiryUrl, glpe.getSubAccountNumber(), subAccountNumberInquiryUrl, glpe.getFinancialObjectCode(), objectInquiryUrl, glpe.getFinancialSubObjectCode(), subObjectInquiryUrl, glpe.getProjectCode(), projectCodeInquiryUrl, glpe.getFinancialDocumentTypeCode(), documentTypeCodeInquiryUrl, glpe.getFinancialBalanceTypeCode(), balanceTypeInquiryUrl, glpe.getFinancialObjectTypeCode(), objectTypeInquiryUrl, glpe.getTransactionLedgerEntryAmount(), glpe.getTransactionDebitCreditCode(), glpe.getUniversityFiscalPeriodCode(), fiscalPeriodCodeInquiryUrl, glpe.getFinancialSystemOriginationCode(), originCodeInquiryUrl, glpe.getDocumentNumber(), documentNumberUrl, glpe.getTransactionLedgerEntryDescription(), glpe.getTransactionDate(), glpe.getOrganizationDocumentNumber(), glpe.getOrganizationReferenceId(), glpe.getReferenceFinancialDocumentTypeCode(), glpe.getReferenceFinancialSystemOriginationCode(), glpe.getReferenceFinancialDocumentNumber());
    }

    private String getInquiryUrl(Class boClass, String keyValues) {
        String basePath = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("application.url");
        return basePath + "/kr/inquiry.do?methodToCall=start&businessObjectClassName=" + boClass.getName() + "&" + keyValues;
    }

    private String getDocumentUrl(String docNumber) {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("kew.url") + "/DocHandler.do?docId=" + docNumber + "&command=displayDocSearchView";
    }

    public AdHocRoutePersonResponse createAdHocRoutePersonResponse(Person person, String action) {
        return new AdHocRoutePersonResponse(person.getPrincipalName(), String.format("%s %s", person.getFirstName(), person.getLastName()), action, this.urlForPerson(person));
    }

    public TakenActionResponse createTakenActionResponse(ActionTakenValue actionTaken) {
        Person target = this.getPersonService().getPerson(actionTaken.getPrincipalId());
        Person delegator = this.getPersonService().getPerson(actionTaken.getDelegatorPrincipalId());
        return new TakenActionResponse(actionTaken.getActionTakenLabel(), target, this.getPersonInquiryUrl(target), delegator, this.getPersonInquiryUrl(delegator), (Date)actionTaken.getActionDate(), actionTaken.getAnnotation());
    }

    public PendingActionResponse createPendingActionResponse(ActionRequestValue actionRequest) {
        String targetName = "";
        String targetUrl = "";
        if (actionRequest.isGroupRequest()) {
            GroupBo targetGroup = (GroupBo)this.getBusinessObjectService().findBySinglePrimaryKey(GroupBo.class, (Object)actionRequest.getGroupId());
            if (targetGroup != null) {
                targetName = targetGroup.getName();
                targetUrl = this.urlForGroup(targetGroup);
            }
        } else {
            Person targetPerson = this.getPersonService().getPerson(actionRequest.getPrincipalId());
            targetName = String.format("%s, %s", targetPerson.getLastName(), targetPerson.getFirstName());
            targetUrl = this.getPersonInquiryUrl(targetPerson);
        }
        return new PendingActionResponse(actionRequest.getActionRequestId(), actionRequest.getActionRequestedLabel(), actionRequest.isActive(), targetName, targetUrl, (Date)actionRequest.getCreateDate(), actionRequest.getAnnotation());
    }

    public RouteLogResponse createRouteLogResponse() {
        String documentId = (String)StringUtils.defaultIfBlank((CharSequence)this.getDocumentId(), (CharSequence)this.getDocId());
        if (StringUtils.isBlank((CharSequence)documentId)) {
            LOG.warn("No document id to create route log response");
            return null;
        }
        DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        List takenActionsResponses = routeHeaderValue.getActionsTaken().stream().map(this::createTakenActionResponse).collect(Collectors.toList());
        List pendingActionsResponses = KEWServiceLocator.getActionRequestService().getRootRequests((Collection)routeHeaderValue.getActionRequests()).stream().filter(ActionRequestValue::isPending).map(this::createPendingActionResponse).collect(Collectors.toList());
        Person initiator = this.getPersonService().getPerson(routeHeaderValue.getInitiatorPrincipalId());
        String workflowUrl = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("kew.url");
        DocumentType documentType = routeHeaderValue.getDocumentType();
        String documentTypeUrl = String.format("%s/DocumentConfigurationView.do?methodToCall=start&documentTypeName=%s", workflowUrl, documentType.getName());
        return new RouteLogResponse(documentId, documentType, documentTypeUrl, initiator, this.getPersonInquiryUrl(initiator), routeHeaderValue.getDocRouteStatusLabel(), routeHeaderValue.getCurrentNodeNames(), (Date)routeHeaderValue.getCreateDate(), routeHeaderValue.getDateLastModified().toDate(), (Date)routeHeaderValue.getApprovedDate(), (Date)routeHeaderValue.getFinalizedDate(), takenActionsResponses, pendingActionsResponses);
    }

    public String getDocumentActionsJson() {
        return this.serializeToJsonSafely(this.documentActions).orElse(EMPTY_JSON);
    }

    public String getButtonGroupJson() throws JsonProcessingException {
        List<Button> extraButtons = this.convertExtraButtons();
        Map documentActions = this.getDocumentActions();
        List standardButtons = StandardButtonManager.getStandardButtons((Map)documentActions);
        List buttons = ListUtils.union(extraButtons, (List)standardButtons);
        ButtonGroup buttonGroup = new ButtonGroup(buttons);
        String buttonGroupJson = MAPPER.writeValueAsString((Object)buttonGroup);
        LOG.debug("getButtonGroupJson() - Returning : buttonGroupJson={}", (Object)buttonGroupJson);
        return buttonGroupJson;
    }

    private List<Button> convertExtraButtons() {
        List<Button> buttons = this.getExtraButtons().stream().map(Button::from).collect(Collectors.toList());
        LOG.debug("convertExtraButtons() - Returning : buttons={}", buttons);
        return buttons;
    }

    public List<ExtraButton> getExtraButtons() {
        super.getExtraButtons();
        if (this.canAdjust()) {
            Map<String, ExtraButton> buttonsMap = PaymentApplicationAdjustmentForm.createButtonsMap();
            this.extraButtons.add(buttonsMap.get(ADJUST_BUTTON_EXTRA_BUTTON_PROPERTY));
        }
        return this.extraButtons;
    }

    private static Map<String, ExtraButton> createButtonsMap() {
        ExtraButton adjustButton = new ExtraButton();
        adjustButton.setExtraButtonProperty(ADJUST_BUTTON_EXTRA_BUTTON_PROPERTY);
        String extraButtonSource = "${externalizable.images.url}buttonsmall_adjust.gif";
        adjustButton.setExtraButtonSource("${externalizable.images.url}buttonsmall_adjust.gif");
        adjustButton.setExtraButtonAltText("Adjust");
        return Map.of(ADJUST_BUTTON_EXTRA_BUTTON_PROPERTY, adjustButton);
    }

    private boolean canAdjust() {
        if (this.userCannotInitiateAnAdjustment()) {
            LOG.debug("canAdjust() - Exit; User does not have permission");
            return false;
        }
        boolean canAdjust = this.noPreviousOrPendingAdjustments() && this.isFinalOrProcessed();
        LOG.debug("canAdjust() - Exit : canAdjust={}", (Object)canAdjust);
        return canAdjust;
    }

    private boolean noPreviousOrPendingAdjustments() {
        return this.getPaymentApplicationAdjustmentDocument().getAdjustmentDocumentNumber() == null;
    }

    private boolean isFinalOrProcessed() {
        PaymentApplicationAdjustmentDocument adjustmentDocument = this.getPaymentApplicationAdjustmentDocument();
        WorkflowDocument workflowDocument = PaymentApplicationAdjustmentForm.extractWorkFlowDocument((Document)adjustmentDocument);
        return workflowDocument.isFinal() || workflowDocument.isProcessed();
    }

    private static WorkflowDocument extractWorkFlowDocument(Document document) {
        DocumentHeader documentHeader = document.getDocumentHeader();
        return documentHeader.getWorkflowDocument();
    }

    private boolean userCannotInitiateAnAdjustment() {
        Person person;
        Document document = this.getDocument();
        DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer(document);
        return !documentAuthorizer.canInitiate("APPA", person = GlobalVariables.getUserSession().getPerson());
    }

    public String getDocumentDescription() {
        return this.getPaymentApplicationAdjustmentDocument().getDocumentHeader().getDocumentDescription();
    }

    public String getDocumentExplanation() {
        return this.getPaymentApplicationAdjustmentDocument().getDocumentHeader().getExplanation();
    }

    public String getOrganizationDocumentNumber() {
        return this.getPaymentApplicationAdjustmentDocument().getDocumentHeader().getOrganizationDocumentNumber();
    }

    public String getRouteLogResponseJson() {
        return this.serializeToJsonSafely(this.createRouteLogResponse()).orElse(EMPTY_JSON);
    }

    public long getAttachmentMaxFileSize() {
        String attachmentSize = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString("KR-NS", "Document", "MAX_FILE_SIZE_ATTACHMENT");
        return FileUtil.getBytes((String)attachmentSize);
    }

    public String getNonAppliedHoldingsJson() {
        this.setupNonAppliedHoldingsWrapper();
        return (String)this.serializeToJsonSafely(this.nonAppliedHoldings).get();
    }

    public String getAdHocRouteWorkgroupJson() {
        try {
            ArrayList workgroupResponses = new ArrayList();
            this.getAdHocRouteWorkgroups().forEach(workgroup -> {
                GroupBo group = (GroupBo)this.getBusinessObjectService().findBySinglePrimaryKey(GroupBo.class, (Object)workgroup.getId());
                if (group != null) {
                    workgroupResponses.add(this.createAdHocRouteWorkgroupResponse(group, workgroup.getActionRequested()));
                }
            });
            return MAPPER.writeValueAsString(workgroupResponses);
        }
        catch (JsonProcessingException jpe) {
            LOG.error("Unable to serialize ad hoc route workgroups. Error {}", (Object)jpe.getMessage());
            return null;
        }
    }

    public String getAdHocRoutePersonJson() {
        try {
            List personResponses = this.getAdHocRoutePersons().stream().map(recipient -> {
                Person person = this.getPersonService().getPersonByPrincipalName(recipient.getId());
                return this.createAdHocRoutePersonResponse(person, recipient.getActionRequested());
            }).collect(Collectors.toList());
            return MAPPER.writeValueAsString(personResponses);
        }
        catch (JsonProcessingException jpe) {
            LOG.error("Unable to serialize ad hoc route persons. Error {}", (Object)jpe.getMessage());
            return null;
        }
    }

    public String getAdHocActionRequestCodesJson() {
        try {
            return MAPPER.writeValueAsString((Object)this.getAdHocActionRequestCodes());
        }
        catch (JsonProcessingException jpe) {
            LOG.error("Unable to serialize ad hoc request codes. Error {}", (Object)jpe.getMessage());
            return null;
        }
    }

    public String getNotesAndAttachmentsJson() {
        try {
            List notes = this.getDocument().getNotes();
            List noteResponses = notes.stream().map(this::createNoteResponse).collect(Collectors.toList());
            return MAPPER.writeValueAsString(noteResponses);
        }
        catch (JsonProcessingException jpe) {
            LOG.error("Unable to serialize notes. Error {}", (Object)jpe.getMessage());
            return null;
        }
    }

    public String getGeneralLedgerPendingEntriesJson() {
        List glpes = this.getPaymentApplicationAdjustmentDocument().getGeneralLedgerPendingEntries();
        this.getPaymentApplicationAdjustmentDocument().fillInFiscalPeriodYear(glpes);
        List glpeResponses = glpes.stream().map(this::createGlpeResponse).collect(Collectors.toList());
        return this.serializeToJsonSafely(glpeResponses).orElse(EMPTY_JSON);
    }

    public PaymentApplicationAdjustmentInvoiceResponse createInvoiceResponse(CustomerInvoiceDocument invoice) {
        List<InvoicePaidApplied> paidAppliedsForInvoice = this.getApplicationAdjustmentDocument().getInvoicePaidApplieds().stream().filter(invoicePaidApplied -> invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber().equals(invoice.getDocumentNumber())).collect(Collectors.toList());
        return new PaymentApplicationAdjustmentInvoiceResponse(this.getDocId(), invoice, paidAppliedsForInvoice, this.getDocumentHandlerUrl(invoice.getDocumentNumber()), this.urlForCustomer(invoice.getCustomer()));
    }

    public List<PaymentApplicationAdjustmentInvoiceResponse> getInvoiceResponses() {
        return this.invoices.stream().map(this::createInvoiceResponse).collect(Collectors.toList());
    }

    public String getInvoiceResponsesJson() {
        return (String)this.serializeToJsonSafely(this.getInvoiceResponses()).get();
    }

    List<CustomerInvoiceDocument> getInvoices() {
        return this.invoices;
    }

    void setInvoices(List<CustomerInvoiceDocument> invoices) {
        this.invoices = invoices;
    }

    public String getHeaderFieldsJson() {
        return this.headerFieldsJson;
    }

    void setHeaderFieldsJson(String headerFieldsJson) {
        this.headerFieldsJson = headerFieldsJson;
    }

    private BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    private PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }
}

