/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceDetailApply;
import org.kuali.kfs.sys.rest.presentation.Link;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PaymentApplicationInvoiceApply
implements Serializable {
    private CustomerInvoiceDocument invoice;
    private List<PaymentApplicationInvoiceDetailApply> detailApplications;
    private String payAppDocNumber;
    private boolean quickApply;
    private boolean quickApplyOldValue;
    private String documentUrl;
    private String customerUrl;

    public PaymentApplicationInvoiceApply(String payAppDocNumber, CustomerInvoiceDocument invoice) {
        this.invoice = invoice;
        this.detailApplications = new ArrayList<PaymentApplicationInvoiceDetailApply>();
        for (CustomerInvoiceDetail invoiceDetail : invoice.getCustomerInvoiceDetailsWithoutDiscounts()) {
            this.detailApplications.add(new PaymentApplicationInvoiceDetailApply(payAppDocNumber, invoiceDetail));
        }
        this.quickApply = false;
        this.quickApplyOldValue = false;
        this.payAppDocNumber = payAppDocNumber;
    }

    public KualiDecimal getAmountToApply() {
        KualiDecimal applyAmount = KualiDecimal.ZERO;
        for (PaymentApplicationInvoiceDetailApply detailApplication : this.detailApplications) {
            applyAmount = (KualiDecimal)applyAmount.add((AbstractKualiDecimal)detailApplication.getAmountApplied());
        }
        return applyAmount;
    }

    @JsonIgnore
    public boolean isAnyAppliedAmounts() {
        for (PaymentApplicationInvoiceDetailApply detailApplication : this.detailApplications) {
            if (!detailApplication.getAmountApplied().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    public List<PaymentApplicationInvoiceDetailApply> getDetailApplications() {
        return this.detailApplications;
    }

    public String getDocumentNumber() {
        return this.invoice.getDocumentNumber();
    }

    public KualiDecimal getTotalAmount() {
        return this.invoice.getTotalDollarAmount();
    }

    public KualiDecimal getOpenAmount() {
        return this.invoice.getOpenAmount();
    }

    public Date getInvoiceBillingDate() {
        return this.invoice.getBillingDate();
    }

    public String getCustomerName() {
        return this.invoice.getCustomer().getCustomerName();
    }

    public String getCustomerNumber() {
        return this.invoice.getCustomer().getCustomerNumber();
    }

    public String getHeaderText() {
        return this.invoice.getInvoiceHeaderText();
    }

    @JsonIgnore
    public boolean isQuickApply() {
        return this.quickApply;
    }

    public void setQuickApply(boolean quickApply) {
        this.quickApplyOldValue = this.quickApply;
        this.quickApply = quickApply;
        for (PaymentApplicationInvoiceDetailApply detailApplication : this.detailApplications) {
            detailApplication.setInvoiceQuickApplied(quickApply);
        }
    }

    @JsonIgnore
    public boolean isQuickApplyChanged() {
        return this.quickApply != this.quickApplyOldValue;
    }

    @JsonIgnore
    public CustomerInvoiceDocument getInvoice() {
        return this.invoice;
    }

    public String getDocumentUrl() {
        return this.documentUrl;
    }

    public void setDocumentUrl(String documentUrl) {
        this.documentUrl = documentUrl;
    }

    public String getCustomerUrl() {
        return this.customerUrl;
    }

    public void setCustomerUrl(String customerUrl) {
        this.customerUrl = customerUrl;
    }

    public Link getCustomerLink() {
        return new Link(this.getCustomerNumber(), this.getCustomerUrl());
    }

    public Link getDocumentLink() {
        return new Link(this.getDocumentNumber(), this.getDocumentUrl());
    }
}

