/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutingRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.DocumentRequest;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentApplicationAdjustmentRequest
extends DocumentRequest {
    private final List<InvoiceApplication> invoiceApplications;
    private final List<NonAppliedHolding> nonAppliedHoldings;

    @JsonCreator
    public PaymentApplicationAdjustmentRequest(@JsonProperty(value="description") String description, @JsonProperty(value="explanation") String explanation, @JsonProperty(value="orgDocNumber") String orgDocNumber, @JsonProperty(value="adHocRouting") AdHocRoutingRequest adHocRoutingRequest, @JsonProperty(value="invoiceApplications") List<InvoiceApplication> invoiceApplications, @JsonProperty(value="nonAppliedHoldings") List<NonAppliedHolding> nonAppliedHoldings) {
        super(description, explanation, orgDocNumber, adHocRoutingRequest);
        Validate.isTrue((invoiceApplications != null ? 1 : 0) != 0, (String)"invoiceApplications must be supplied", (Object[])new Object[0]);
        Validate.isTrue((nonAppliedHoldings != null ? 1 : 0) != 0, (String)"nonAppliedHoldings must be supplied", (Object[])new Object[0]);
        this.invoiceApplications = invoiceApplications;
        this.nonAppliedHoldings = nonAppliedHoldings;
    }

    public List<NonAppliedHolding> getNonAppliedHoldings() {
        return this.nonAppliedHoldings;
    }

    public List<InvoiceApplication> getInvoiceApplications() {
        return this.invoiceApplications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentApplicationAdjustmentRequest that = (PaymentApplicationAdjustmentRequest)o;
        return this.invoiceApplications.equals(that.invoiceApplications) && this.nonAppliedHoldings.equals(that.nonAppliedHoldings);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceApplications, this.nonAppliedHoldings);
    }

    public String toString() {
        return new StringJoiner(", ", PaymentApplicationAdjustmentRequest.class.getSimpleName() + "[", "]").add("invoiceApplications=" + this.invoiceApplications).add("nonAppliedHoldings=" + this.nonAppliedHoldings).toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NonAppliedHolding {
        private final KualiDecimal amount;
        private final String customerNumber;

        @JsonCreator
        public NonAppliedHolding(@JsonProperty(value="amount") KualiDecimal amount, @JsonProperty(value="customerNumber") String customerNumber) {
            Validate.isTrue((amount != null ? 1 : 0) != 0, (String)"amount must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerNumber), (String)"customerNumber must be supplied", (Object[])new Object[0]);
            this.amount = amount;
            this.customerNumber = customerNumber;
        }

        public KualiDecimal getAmount() {
            return this.amount;
        }

        public String getCustomerNumber() {
            return this.customerNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonAppliedHolding that = (NonAppliedHolding)o;
            return this.amount.equals((Object)that.amount) && this.customerNumber.equals(that.customerNumber);
        }

        public int hashCode() {
            return Objects.hash(this.amount, this.customerNumber);
        }

        public String toString() {
            return new StringJoiner(", ", NonAppliedHolding.class.getSimpleName() + "[", "]").add("amount=" + this.amount).add("customerNumber='" + this.customerNumber + "'").toString();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InvoiceApplicationDetail {
        private final KualiDecimal amountApplied;
        private final Integer sequenceNumber;

        @JsonCreator
        public InvoiceApplicationDetail(@JsonProperty(value="amountApplied") KualiDecimal amountApplied, @JsonProperty(value="sequenceNumber") Integer sequenceNumber) {
            Validate.isTrue((amountApplied != null ? 1 : 0) != 0, (String)"amountApplied must be supplied", (Object[])new Object[0]);
            Validate.isTrue((sequenceNumber != null ? 1 : 0) != 0, (String)"sequenceNumber must be supplied", (Object[])new Object[0]);
            Validate.isTrue((sequenceNumber >= 0 ? 1 : 0) != 0, (String)"sequenceNumber must not be negative", (Object[])new Object[0]);
            this.amountApplied = amountApplied;
            this.sequenceNumber = sequenceNumber;
        }

        public KualiDecimal getAmountApplied() {
            return this.amountApplied;
        }

        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvoiceApplicationDetail that = (InvoiceApplicationDetail)o;
            return this.amountApplied.equals((Object)that.amountApplied) && this.sequenceNumber.equals(that.sequenceNumber);
        }

        public int hashCode() {
            return Objects.hash(this.amountApplied, this.sequenceNumber);
        }

        public String toString() {
            return new StringJoiner(", ", InvoiceApplicationDetail.class.getSimpleName() + "[", "]").add("amountApplied=" + this.amountApplied).add("sequenceNumber=" + this.sequenceNumber).toString();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InvoiceApplication {
        private final String customerNumber;
        private final String documentNumber;
        private final List<InvoiceApplicationDetail> detailApplications;

        @JsonCreator
        public InvoiceApplication(@JsonProperty(value="customerNumber") String customerNumber, @JsonProperty(value="documentNumber") String documentNumber, @JsonProperty(value="detailApplications") List<InvoiceApplicationDetail> detailApplications) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerNumber), (String)"customerNumber must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)documentNumber), (String)"documentNumber must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(detailApplications), (String)"detailApplications must be supplied", (Object[])new Object[0]);
            this.customerNumber = customerNumber;
            this.documentNumber = documentNumber;
            this.detailApplications = detailApplications;
        }

        public String getCustomerNumber() {
            return this.customerNumber;
        }

        public String getDocumentNumber() {
            return this.documentNumber;
        }

        public List<InvoiceApplicationDetail> getDetailApplications() {
            return this.detailApplications;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvoiceApplication that = (InvoiceApplication)o;
            return this.customerNumber.equals(that.customerNumber) && this.documentNumber.equals(that.documentNumber) && this.detailApplications.equals(that.detailApplications);
        }

        public int hashCode() {
            return Objects.hash(this.customerNumber, this.documentNumber, this.detailApplications);
        }

        public String toString() {
            return new StringJoiner(", ", InvoiceApplication.class.getSimpleName() + "[", "]").add("customerNumber='" + this.customerNumber + "'").add("detailApplications=" + this.detailApplications).add("documentNumber='" + this.documentNumber + "'").toString();
        }
    }
}

