/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.Lookupable;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.lookup.CustomerAgingReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.web.struts.CustomerAgingReportForm;

public class CustomerAgingReportAction
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger();
    private static final String TOTALS_TABLE_KEY = "totalsTable";

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerAgingReportForm lookupForm = (CustomerAgingReportForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (lookupable == null) {
            LOG.error("Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        ArrayList resultTable = new ArrayList();
        try {
            Collection displayList = lookupable.performLookup((LookupForm)lookupForm, resultTable, true);
            Long totalSize = ((CollectionIncomplete)displayList).getActualSizeIfTruncated();
            request.setAttribute("reqSearchResultsSize", (Object)totalSize);
            request.setAttribute("reqSearchResults", resultTable);
            String resultsKey = request.getParameter("searchResultKey");
            if (resultsKey != null) {
                GlobalVariables.getUserSession().removeObject(resultsKey);
                GlobalVariables.getUserSession().removeObject(resultsKey + ".form");
            }
            resultsKey = GlobalVariables.getUserSession().addObjectWithGeneratedKey(resultTable);
            GlobalVariables.getUserSession().addObject(resultsKey + ".form", (Object)form);
            request.setAttribute("searchResultKey", (Object)resultsKey);
        }
        catch (NumberFormatException e) {
            GlobalVariables.getMessageMap().putError("universityFiscalYear", "error.custom", new String[]{"Fiscal Year must be a four-digit number"});
        }
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (ObjectUtils.isNull((Object)lookupable)) {
            LOG.error("Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map values = lookupForm.getFields();
        for (Row row : lookupable.getRows()) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName() != null && !field.getPropertyName().equals("")) {
                    if (request.getParameter(field.getPropertyName()) != null) {
                        field.setPropertyValue(request.getParameter(field.getPropertyName()));
                    } else if (values.get(field.getPropertyName()) != null) {
                        field.setPropertyValue(values.get(field.getPropertyName()));
                    }
                }
                fieldValues.put(field.getPropertyName(), field.getPropertyValue());
            }
        }
        fieldValues.put("docFormKey", lookupForm.getFormKey());
        fieldValues.put("backLocation", lookupForm.getBackLocation());
        if (lookupable.checkForAdditionalFields(fieldValues)) {
            for (Row row : lookupable.getRows()) {
                for (Field field : row.getFields()) {
                    if (field.getPropertyName() == null || field.getPropertyName().equals("")) continue;
                    if (request.getParameter(field.getPropertyName()) != null) {
                        field.setPropertyValue(request.getParameter(field.getPropertyName()));
                        fieldValues.put(field.getPropertyName(), request.getParameter(field.getPropertyName()));
                        continue;
                    }
                    if (values.get(field.getPropertyName()) == null) continue;
                    field.setPropertyValue(values.get(field.getPropertyName()));
                }
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("cancel");
    }

    public ActionForward clearValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LookupForm lookupForm = (LookupForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (ObjectUtils.isNull((Object)lookupable)) {
            LOG.error("Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        for (Row row : lookupable.getRows()) {
            for (Field field : row.getFields()) {
                if (field.getFieldType().equals("radio")) continue;
                field.setPropertyValue(field.getDefaultValue());
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CustomerAgingReportForm customerAgeForm = (CustomerAgingReportForm)form;
        String resultKey = request.getParameter("searchResultKey");
        request.setAttribute("searchResultKey", (Object)resultKey);
        request.setAttribute("reqSearchResults", GlobalVariables.getUserSession().retrieveObject(resultKey));
        CustomerAgingReportForm prevForm = (CustomerAgingReportForm)((Object)GlobalVariables.getUserSession().retrieveObject(resultKey + ".form"));
        customerAgeForm.setTotal0to30(prevForm.getTotal0to30());
        customerAgeForm.setTotal31to60(prevForm.getTotal31to60());
        customerAgeForm.setTotal61to90(prevForm.getTotal61to90());
        customerAgeForm.setTotal91toSYSPR(prevForm.getTotal91toSYSPR());
        customerAgeForm.setTotalSYSPRplus1orMore(prevForm.getTotalSYSPRplus1orMore());
        request.setAttribute("reqSearchResultsSize", (Object)request.getParameter("reqSearchResultsSize"));
        if (customerAgeForm.getLookupable().getLookupableHelperService() instanceof CustomerAgingReportLookupableHelperServiceImpl) {
            Object totalsTable = GlobalVariables.getUserSession().retrieveObject(TOTALS_TABLE_KEY);
            request.setAttribute(TOTALS_TABLE_KEY, totalsTable);
        }
        return mapping.findForward("basic");
    }
}

