/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar;

import com.lowagie.text.Font;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.ar.Billable;

public final class ArConstants {
    public static final String AR_NAMESPACE_CODE = "KFS-AR";
    public static final String INVOICE_DOC_TYPE = "Invoice";
    public static final String CREDIT_MEMO_DOC_TYPE = "Credit Memo";
    public static final String PAYMENT_DOC_TYPE = "Payment";
    public static final String WRITEOFF_DOC_TYPE = "Writeoff";
    public static final String SORT_INDEX_SESSION_KEY = "sortIndex";
    public static final String NUM_SORT_INDEX_CLICK_SESSION_KEY = "numberOfSortClicked";
    public static final String TOTALS_TABLE_KEY = "totalsTable";
    public static final String COLLECTION_ACTIVITY_REPORT_LOOKUP = "collectionActivityReportLookup";
    public static final String INCLUDE_ZERO_BALANCE_CUSTOMERS = "INCLUDE_ZERO_BALANCE_CUSTOMERS";
    public static final String BASIS_OF_ACCOUNTING_CASH = "1";
    public static final String BASIS_OF_ACCOUNTING_ACCRUAL = "2";
    public static final String DUNNING_LETTER_TEMPLATE_UPLOAD = "template.dunningLetterTemplateUpload";
    public static final String DUNNING_LETTER_TEMPLATE_TYPE = "Dunning Letter";
    public static final String DUNNING_LETTER_TEMPLATE_NEW_FILE_NAME_PREFIX = "Dunning_Letter_Template_";
    public static final String INVOICE_TEMPLATE_UPLOAD = "document.invoiceTemplateUpload";
    public static final String INVOICE_TEMPLATE_TYPE = "Invoice";
    public static final String INVOICE_TEMPLATE_NEW_FILE_NAME_PREFIX = "Invoice_Template_";
    public static final String CONTRACTS_GRANTS_INVOICE_COMPONENT = "ContractsGrantsInvoice";
    public static final String NEW_CASH_CONTROL_DETAIL_ERROR_PATH_PREFIX = "newCashControlDetail";
    public static final String CUSTOMER_INVOICE_DETAIL_UOM_DEFAULT = "EA";
    public static final String GLPE_WRITEOFF_GENERATION_METHOD_CHART = "1";
    public static final String GLPE_WRITEOFF_GENERATION_METHOD_ORG_ACCT_DEFAULT = "2";
    public static final String ALLOW_SALES_TAX_LIABILITY_ADJUSTMENT_IND_NO = "N";
    public static final String COPY_CUSTOMER_INVOICE_DOCUMENT_WITH_DISCOUNTS_QUESTION = "ConfirmationForCopyingInvoiceWithDiscounts";
    public static final String SUSPENSION_CATEGORIES_PRESENT_QUESTION = "ConfirmationForSuspensionCategoriesPresent";
    public static final String CUST_ADDR_ID_SEQ = "CUST_ADDR_ID_SEQ";
    public static int ITEM_QUANTITY_SCALE = 10;
    public static final String AWARD_LOOKUP_IMPL = "awardLookupable";
    public static final String AWARD_ACCOUNT_LOOKUP_IMPL = "awardAccountLookupable";
    public static final String CUSTOMER_OPEN_ITEM_REPORT_LOOKUPABLE_IMPL = "arCustomerOpenItemReportLookupable";
    public static final String INV_DOCUMENT_DESCRIPTION = "Customer Invoice";
    public static final String CUSTOMER_COMPONENT = "Customer";
    public static final String CLEAR_INIT_TAB_METHOD = "clearInitTab";
    public static final String CONTINUE_LOC_REVIEW_METHOD = "continueLOCReview";
    public static final String DOWNLOAD_METHOD = "download";
    public static final String EXPORT_METHOD = "export";
    public static final String PRINT_METHOD = "print";
    public static final String PRINT_CREDIT_MEMO_PDF_METHOD = "printCreditMemoPDF";
    public static final String PRINT_INVOICE_PDF_METHOD = "printInvoicePDF";
    public static final String UPLOAD_METHOD = "upload";
    public static final String CLEAR_BUTTON_FILE_NAME = "buttonsmall_clear.gif";
    public static final String CLEAR_BUTTON_ALT_TEXT = "Clear";
    public static final String CONTINUE_BUTTON_FILE_NAME = "buttonsmall_continue.gif";
    public static final String CONTINUE_BUTTON_ALT_TEXT = "Continue";
    public static final String EXPORT_BUTTON_FILE_NAME = "buttonsmall_export.gif";
    public static final String EXPORT_BUTTON_ALT_TEXT = "Export";
    public static final String EXPORT_BUTTON_ONCLICK_TEXT = "excludeSubmitRestriction=true";
    public static final String PRINT_BUTTON_FILE_NAME = "buttonsmall_genprintfile.gif";
    public static final String PRINT_BUTTON_ALT_TEXT = "Print";
    public static final String PRORATE_BUTTON_METHOD = "methodToCall.prorateBill";
    public static final String PRORATE_BUTTON_FILE_NAME = "buttonsmall_prorate.gif";
    public static final String PRORATE_BUTTON_ALT_TEXT = "Prorate Bill";
    public static final String TRANSMIT_GENERATE_BUTTON_FILE_NAME = "buttonsmall_transmitgenerate.gif";
    public static final String TRANSMIT_GENERATE_BUTTON_ALT_TEXT = "Transmit/Generate Print File";
    public static final String AGENCY_PRIMARY_ADDRESSES_TYPE_CODE = "P";
    public static final String AGENCY_ALTERNATE_ADDRESSES_TYPE_CODE = "A";
    public static final String DISCOUNT_PREFIX = "DISCOUNT - ";
    public static final String CUSTOMER_INVOICE_WRITEOFF_SUMMARY_ACTION = "viewSummary";
    public static final String CUSTOMER_INVOICE_WRITEOFF_DOCUMENT_DESCRIPTION = "Writeoff for ";
    public static final String LOCKBOX_DOCUMENT_DESCRIPTION = "Created by Lockbox ";
    public static final String LOCKBOX_REMITTANCE_FOR_INVALID_INVOICE_NUMBER = "Lockbox: Remittance for INVALID invoice number ";
    public static final String LOCKBOX_REMITTANCE_FOR_CLOSED_INVOICE_NUMBER = "Lockbox: Remittance for CLOSED invoice number ";
    public static final String LOCKBOX_REMITTANCE_FOR_INVOICE_NUMBER = "Lockbox: Remittance for invoice number ";
    public static final String STATEMENT_FORMAT_SUMMARY = "Summary";
    public static final String STATEMENT_FORMAT_DETAIL = "Detail";
    public static final String INCLUDE_ZERO_BALANCE_YES = "Yes";
    public static final String INCLUDE_ZERO_BALANCE_NO = "No";
    public static final String LOC_BY_LOC_FUND = "LOC By Letter of Credit Fund";
    public static final String LOC_BY_LOC_FUND_GRP = "LOC By Letter of Credit Fund Group";
    public static final String AWARD_TOTAL = "awardTotal";
    public static final String AWARD_FUND_MANAGER = "awardFundManager";
    public static final String AWARD_FUND_MANAGERS = "awardFundManagers";
    public static final String AWARD_PROJECT_DIRECTORS = "awardProjectDirectors";
    public static final String AWARD_PROJECT_DIRECTOR = "awardProjectDirector";
    public static final String INVOICE_REPORT_OPTION = "dummyBusinessObject.invoiceReportOption";
    public static final String CGINV_DOC_ERR_LOG_REPORT = "Contracts & Grants Invoice Document Error Log Report";
    public static final String OUTSTANDING_INVOICE_REPORT = "Outstanding Invoice Report";
    public static final String OUTSTANDING_INVOICES = "Outstanding Invoices";
    public static final String PAST_DUE_INVOICES = "Past Due Invoices";
    public static final String CONTRACTS_GRANTS_SUSPENDED_INVOICE_SUMMARY_REPORT = "ContractsGrantsSuspendedInvoiceSummaryReport";
    public static final String CONTRACTS_GRANTS_SUSPENDED_INVOICE_DETAIL_REPORT = "ContractsGrantsSuspendedInvoiceDetailReport";
    public static final String CONTRACTS_GRANTS_PAYMENT_HISTORY_REPORT = "ContractsGrantsPaymentHistoryReport";
    public static final String CONTRACTS_GRANTS_LOC_REPORT = "ContractsGrantsLOCReport";
    public static final String CONTRACTS_GRANTS_MILESTONE_REPORT = "ContractsGrantsMilestoneReport";
    public static final String COLLECTION_ACTIVITY_REPORT_SORT_FIELD = "CollectionActivityReport";
    public static final String CONTRACTS_GRANTS_INVOICE_REPORT_SORT_FIELD = "ContractsGrantsInvoiceReport";
    public static final String CONTRACTS_GRANTS_INVOICE_ERROR_LOG_REPORT_SORT_FIELD = "ContractsGrantsInvoiceDocumentErrorLog";
    public static final String TICKLERS_REPORT_SORT_FIELD = "TicklersReport";
    public static final String COLLECTION_ACTIVITY_REPORT_TITLE = "Collection Activity Report";
    public static final String QUARTER1 = "q1";
    public static final String QUARTER2 = "q2";
    public static final String QUARTER3 = "q3";
    public static final String QUARTER4 = "q4";
    public static final String SEMI_ANNUAL = "Sa";
    public static final String ANNUAL = "An";
    public static final String FINAL = "F";
    public static final String CONTRACTS_GRANTS_INVOICE_DOCUMENT_DESCRIPTION = "Contracts & Grants Invoice";
    public static final String ACCOUNT = "Account";
    public static final String CONTRACT_CONTROL_ACCOUNT = "Contract Control Account";
    public static final String BILL_SECTION = "Bills";
    public static final String MILESTONES_SECTION = "Milestones";
    public static final String INCOME_ACCOUNT = "Income";
    public static final String INV_AWARD = "1";
    public static final String INV_ACCOUNT = "2";
    public static final String INV_CONTRACT_CONTROL_ACCOUNT = "3";
    public static final String INV_SCHEDULE = "4";
    public static final String INVOICE_AMOUNT_LABEL = "Invoice Amount";
    public static final String PRINT_INVOICES_FROM_LABEL = "Print Invoices From";
    public static final String PRINT_INVOICES_TO_LABEL = "Print Invoices To";
    public static final String LETTER_OF_CREDIT_REVIEW_DOCUMENT = "Letter Of Credit Review Document.";
    public static final String CHAPTER7_CODE = "C7";
    public static final String CHAPTER11_CODE = "C11";
    public static final String CHAPTER13_CODE = "C13";
    public static final String JUDGMENT_OBTAINED_CODE = "JO";
    public static final String CHAPTER7 = "Chapter 7";
    public static final String CHAPTER11 = "Chapter 11";
    public static final String CHAPTER13 = "Chapter 13";
    public static final String JUDGMENT_OBTAINED = "Judgment Obtained";
    public static final String INVOICES_FILE_PREFIX = "Invoices-";
    public static final String INVOICE_ENVELOPES_FILE_PREFIX = "InvoiceEnvelopes-";
    public static final String INVOICE_ZIP_FILE_PREFIX = "Invoice-report";
    public static final String FF_425_TEMPLATE_NM = "/org/kuali/kfs/module/ar/document/FEDERAL_FINANCIAL_FORM_425.pdf";
    public static final String FF_425A_TEMPLATE_NM = "/org/kuali/kfs/module/ar/document/FEDERAL_FINANCIAL_FORM_425A.pdf";
    public static final String FEDERAL_FORM_425 = "425";
    public static final String FEDERAL_FORM_425A = "425A";
    public static final String FEDERAL_FUND_425_REPORT_ABBREVIATION = "FF425";
    public static final String FEDERAL_FUND_425A_REPORT_ABBREVIATION = "FF425A";
    public static final String FROM_SUFFIX = " From";
    public static final String TO_SUFFIX = " To";
    public static final String LETTER_OF_CREDIT_REVIEW_INIT_SECTION = "letterOfCreditReviewInitSection";

    private ArConstants() {
    }

    public static class Federal425APdf {
        public static final int NUMBER_OF_SUMMARIES_PER_PAGE = 30;
    }

    public static class InvoiceEnvelopePdf {
        public static final float LENGTH = 650.0f;
        public static final float WIDTH = 320.0f;
        public static final float INDENTATION_LEFT = 20.0f;
    }

    public static class LOCReviewPdf {
        public static final float LENGTH = 1350.0f;
        public static final float WIDTH = 595.0f;
        public static final float RESULTS_TABLE_WIDTH = 1300.0f;
        public static final float RESULTS_TABLE_CELL_PADDING = 20.0f;
        public static final int RESULTS_TABLE_COLSPAN = 11;
        public static final int INNER_TABLE_COLUMNS = 8;
        public static final float INNER_TABLE_WIDTH = 1000.0f;
    }

    public static class PdfReportFonts {
        public static final Font LOC_REVIEW_TITLE_FONT = new Font(2, 18.0f, 1);
        public static final Font LOC_REVIEW_HEADER_FONT = new Font(2, 16.0f, 1);
        public static final Font LOC_REVIEW_SMALL_BOLD = new Font(2, 14.0f, 1);
        public static final Font ENVELOPE_TITLE_FONT = new Font(2, 12.0f, 1);
        public static final Font ENVELOPE_SMALL_FONT = new Font(2, 9.0f, 0);
    }

    public static class BillingQuarterLastDays {
        public static MonthDay FIRST_QUARTER = new MonthDay(2, 31);
        public static MonthDay SECOND_QUARTER = new MonthDay(5, 30);
        public static MonthDay THIRD_QUARTER = new MonthDay(8, 30);
        public static MonthDay FOURTH_QUARTER = new MonthDay(11, 31);
    }

    public static class MonthDay {
        private int month;
        private int day;

        public MonthDay(int month, int day) {
            this.month = month;
            this.day = day;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public Date getDateForYear(int year) {
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(2, this.getMonth());
            c.set(5, this.getDay());
            c.set(1, year);
            return c.getTime();
        }
    }

    public static enum ContractsAndGrantsInvoiceDocumentCreationProcessType {
        BATCH("B", "Batch"),
        LOC("L", "LOC"),
        MANUAL("M", "Manual");

        private String code;
        private String name;

        private ContractsAndGrantsInvoiceDocumentCreationProcessType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public static String getName(String code) {
            for (ContractsAndGrantsInvoiceDocumentCreationProcessType type : ContractsAndGrantsInvoiceDocumentCreationProcessType.values()) {
                if (!type.getCode().equals(code)) continue;
                return type.getName();
            }
            return null;
        }
    }

    public static class CostCategoryMaintenanceSections {
        public static final String EDIT_OBJECT_CODES = "EditObjectCodes";
        public static final String EDIT_OBJECT_LEVELS = "EditObjectLevels";
        public static final String EDIT_OBJECT_CONSOLIDATIONS = "EditObjectConsolidations";
    }

    public static class UrlActions {
        public static final String CUSTOMER_OPEN_ITEM_REPORT_LOOKUP = "arCustomerOpenItemReportLookup.do";
        public static final String CASH_CONTROL_DOCUMENT = "arCashControl.do";
        public static final String FEDERAL_FINANCIAL_REPORT = "arFederalFinancialReport.do";
    }

    public static class MultipleValueReturnActions {
        public static final String CONTRACTS_GRANTS_COLLECTION_ACTIVITY_INVOICES = "arContractsGrantsCollectionActivity.do";
        public static final String CONTRACTS_GRANTS_INVOICES = "arContractsGrantsInvoiceSummary.do";
        public static final String GENERATE_DUNNING_LETTERS_SUMMARY = "arGenerateDunningLettersSummary.do";
    }

    public static class Actions {
        public static final String ACCOUNTS_RECEIVABLE_INVOICE_TEMPLATE_UPLOAD = "arAccountsReceivableInvoiceTemplateUpload";
        public static final String ACCOUNTS_RECEIVABLE_DUNNING_LETTER_TEMPLATE_UPLOAD = "arAccountsReceivableDunningLetterTemplateUpload";
        public static final String TRANSMIT_CONTRACTS_AND_GRANTS_INVOICES = "arTransmitContractsAndGrantsInvoices";
        public static final String CONTRACTS_GRANTS_LOC_REPORT = "contractsGrantsLOCReport";
        public static final String AR_TICKLER_REPORT = "arTicklersReport";
    }

    public static class ReportBuilderDataServiceBeanNames {
        public static final String CONTRACTS_GRANTS_SUSPENDED_INVOICE_SUMMARY = "contractsGrantsSuspendedInvoiceSummaryReportBuilderService";
        public static final String CONTRACTS_GRANTS_AGING = "contractsGrantsAgingReportBuilderService";
        public static final String CONTRACTS_GRANTS_INVOICE = "contractsGrantsInvoiceReportBuilderService";
        public static final String CONTRACTS_GRANTS_INVOICE_ERROR_LOG = "contractsGrantsInvoiceDocumentErrorLogReportBuilderService";
        public static final String COLLECTION_ACTIVITY = "collectionActivityReportBuilderService";
        public static final String CONTRACTS_GRANTS_LOC = "contractsGrantsLOCReportBuilderService";
        public static final String CONTRACTS_GRANTS_MILESTONE = "contractsGrantsMilestoneReportBuilderService";
        public static final String CONTRACTS_GRANTS_PAYMENT_HISTORY = "contractsGrantsPaymentHistoryReportBuilderService";
        public static final String TICKLERS = "ticklersReportBuilderService";
        public static final String CONTRACTS_GRANTS_SUSPENDED_INVOICE_DETAIL = "contractsGrantsSuspendedInvoiceDetailReportBuilderService";
    }

    public static enum BillingFrequencyValues {
        PREDETERMINED_BILLING("PDBS"),
        MILESTONE("MILE"),
        MONTHLY("MNTH"),
        QUARTERLY("QUAR"),
        SEMI_ANNUALLY("SEMI"),
        ANNUALLY("ANNU"),
        LETTER_OF_CREDIT("LOCB"),
        MANUAL("MANL");

        private String code;

        private BillingFrequencyValues(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static BillingFrequencyValues fromCode(String code) {
            if (code == null || code.isEmpty()) {
                return null;
            }
            for (BillingFrequencyValues billingFrequency : BillingFrequencyValues.values()) {
                if (!code.equals(billingFrequency.code)) continue;
                return billingFrequency;
            }
            return null;
        }

        public static boolean isPredeterminedBilling(Billable billable) {
            return StringUtils.equals((CharSequence)billable.getBillingFrequencyCode(), (CharSequence)BillingFrequencyValues.PREDETERMINED_BILLING.code);
        }

        public static boolean isMilestone(Billable billable) {
            return StringUtils.equals((CharSequence)billable.getBillingFrequencyCode(), (CharSequence)BillingFrequencyValues.MILESTONE.code);
        }

        public static boolean isLetterOfCredit(Billable billable) {
            return StringUtils.equals((CharSequence)billable.getBillingFrequencyCode(), (CharSequence)BillingFrequencyValues.LETTER_OF_CREDIT.code);
        }

        public static boolean isTimeBased(Billable billable) {
            return StringUtils.equals((CharSequence)BillingFrequencyValues.MONTHLY.code, (CharSequence)billable.getBillingFrequencyCode()) || StringUtils.equals((CharSequence)BillingFrequencyValues.QUARTERLY.code, (CharSequence)billable.getBillingFrequencyCode()) || StringUtils.equals((CharSequence)BillingFrequencyValues.SEMI_ANNUALLY.code, (CharSequence)billable.getBillingFrequencyCode()) || StringUtils.equals((CharSequence)BillingFrequencyValues.ANNUALLY.code, (CharSequence)billable.getBillingFrequencyCode()) || StringUtils.equals((CharSequence)BillingFrequencyValues.MANUAL.code, (CharSequence)billable.getBillingFrequencyCode());
        }
    }

    public static class ArDocumentTypeCodes {
        public static final String CASH_CONTROL = "CTRL";
        public static final String COLLECTION_EVENT = "CVNT";
        public static final String CONTRACTS_GRANTS_COLLECTION_ACTIVTY = "CCA";
        public static final String CONTRACTS_GRANTS_INVOICE = "CINV";
        public static final String CUSTOMER_CREDIT_MEMO_DOCUMENT_TYPE_CODE = "CRM";
        public static final String FINAL_BILLED_INDICATOR_DOCUMENT_TYPE_CODE = "FBI";
        public static final String INV_DOCUMENT_TYPE = "INV";
        public static final String INVOICE_WRITEOFF_DOCUMENT_TYPE_CODE = "INVW";
        public static final String LETTER_OF_CREDIT_REVIEW = "LCR";
        public static final String MILESTONE_SCHEDULE = "MILE";
        public static final String PAYMENT_APPLICATION_ADJUSTMENT_DOCUMENT_TYPE_CODE = "APPA";
        public static final String PAYMENT_APPLICATION_DOCUMENT_TYPE_CODE = "APP";
        public static final String PREDETERMINED_BILLING_SCHEDULE = "PDBS";
    }

    public static class ContractsGrantsAgingReportFields {
        public static final String OPEN_INVOCE_REPORT_NAME = "Contracts & Grants Open Invoices Report";
        public static final String AGENCY_SHORT_NAME = "Agency Short Name";
        public static final String TOTAL_WRITEOFF = "Total Write-Off";
        public static final String TOTAL_CREDITS = "Total Credits";
    }

    public static class DunningLetters {
        public static final String DYS_PST_DUE_CURRENT = "Current";
        public static final String DYS_PST_DUE_31_60 = "31-60";
        public static final String DYS_PST_DUE_61_90 = "61-90";
        public static final String DYS_PST_DUE_91_120 = "91-120";
        public static final String DYS_PST_DUE_121 = "121+";
        public static final String DYS_PST_DUE_FINAL = "FINAL";
        public static final String DYS_PST_DUE_STATE_AGENCY_FINAL = "State Agency FINAL";
        public static final String DUNNING_LETTER_SENT_TXT = "Dunning Letter has been sent to sponsor.";
    }

    public static class InvoiceTransmissionMethod {
        public static final String MAIL = "MAIL";
        public static final String EMAIL = "EMAIL";
    }

    public static class ReportsConstants {
        public static final List<String> awardBalancesReportSubtotalFieldsList = new ArrayList<String>();
        public static final List<String> reportSearchCriteriaExceptionList;
        public static final List<String> cgInvoiceReportSubtotalFieldsList;
        public static final List<String> cgPaymentHistoryReportSubtotalFieldsList;
        public static final List<String> cgLOCReportSubtotalFieldsList;
        public static final List<String> cgSuspendedInvoiceDetailReportSubtotalFieldsList;
        public static final String INVOICE_INDICATOR_OPEN = "Open";
        public static final String INVOICE_INDICATOR_CLOSE = "Close";

        static {
            awardBalancesReportSubtotalFieldsList.add("agency.fullName");
            awardBalancesReportSubtotalFieldsList.add("awardStatusCode");
            awardBalancesReportSubtotalFieldsList.add("awardPrimaryProjectDirector.projectDirector.name");
            awardBalancesReportSubtotalFieldsList.add("awardPrimaryFundManager.fundManager.name");
            reportSearchCriteriaExceptionList = new ArrayList<String>();
            reportSearchCriteriaExceptionList.add("backLocation");
            reportSearchCriteriaExceptionList.add("docFormKey");
            reportSearchCriteriaExceptionList.add(ArConstants.INVOICE_REPORT_OPTION);
            cgInvoiceReportSubtotalFieldsList = new ArrayList<String>();
            cgInvoiceReportSubtotalFieldsList.add("proposalNumber");
            cgPaymentHistoryReportSubtotalFieldsList = new ArrayList<String>();
            cgPaymentHistoryReportSubtotalFieldsList.add("awardNumber");
            cgPaymentHistoryReportSubtotalFieldsList.add("customerName");
            cgPaymentHistoryReportSubtotalFieldsList.add("paymentNumber");
            cgPaymentHistoryReportSubtotalFieldsList.add("paymentDate");
            cgLOCReportSubtotalFieldsList = new ArrayList<String>();
            cgSuspendedInvoiceDetailReportSubtotalFieldsList = new ArrayList<String>();
        }
    }

    public static class BatchFileSystem {
        public static final String EXTENSION = ".txt";
        public static final String CGINVOICE_BATCH_VALIDATION_ERROR_OUTPUT_FILE = "cgin_batch_validation_err";
        public static final String CGINVOICE_BATCH_CREATION_ERROR_OUTPUT_FILE = "cgin_batch_create_doc_err";
        public static final String LOC_CREATION_BY_LOCF_ERROR_OUTPUT_FILE = "cgin_loc_by_loc_fund_create_doc_err";
    }

    public static class OrganizationOptionsSections {
        public static final String EDIT_ORGANIZATION_REMIT_TO_ADDRESS = "Edit Organization Remit To Address";
    }

    public static class PrintInvoiceOptions {
        public static final String PRINT_BY_PROCESSING_ORG = "Q";
        public static final String PRINT_BY_USER = "U";
        public static final String PRINT_BY_BILLING_ORG = "B";
    }

    public static final class PredeterminedBillingScheduleImport {
        public static final String FILE_TYPE_IDENTIFIER = "PredeterminedBillingScheduleCsvInputFileType";
    }

    public static final class MilestoneScheduleImport {
        public static final String FILE_TYPE_IDENTIFIER = "MilestoneScheduleCsvInputFileType";
    }

    public static final class Lockbox {
        public static final String LOCKBOX_REPORT_SUBFOLDER = "ar";
        public static final String BATCH_REPORT_BASENAME = "lockbox_batch";
    }

    public static final class CustomerInvoiceWriteoff {
        public static final String CUSTOMER_INVOICE_WRITEOFF_FILE_TYPE_IDENTIFIER = "customerInvoiceWriteoffInputFileType";
        public static final String CUSTOMER_INVOICE_WRITEOFF_REPORT_SUBFOLDER = "ar";
        public static final String BATCH_REPORT_BASENAME = "customer_invoice_writeoff";
    }

    public static final class CustomerLoad {
        public static final String CUSTOMER_LOAD_FILE_TYPE_IDENTIFIER = "customerLoadInputFileType";
        public static final String CUSTOMER_CSV_LOAD_FILE_TYPE_IDENTIFIER = "customerLoadCSVInputFileType";
        public static final String CUSTOMER_LOAD_REPORT_SUBFOLDER = "ar";
        public static final String BATCH_REPORT_BASENAME = "ar_customer_load";
    }

    public static class CustomerCreditMemoConstants {
        public static final String CUSTOMER_CREDIT_MEMO_ITEM_QUANTITY = "qty";
        public static final String CUSTOMER_CREDIT_MEMO_ITEM_TOTAL_AMOUNT = "itemAmount";
        public static final String BOTH_QUANTITY_AND_ITEM_TOTAL_AMOUNT_ENTERED = "both";
        public static final String GENERATE_CUSTOMER_CREDIT_MEMO_DOCUMENT_QUESTION_ID = "GenerateCustomerCreditMemoDocumentQuestionID";
    }

    public static class CustomerInvoiceWriteoffStatuses {
        public static final String INITIATE = "INIT";
        public static final String IN_PROCESS = "INPR";
    }

    public static class CustomerCreditMemoStatuses {
        public static final String INITIATE = "INIT";
        public static final String IN_PROCESS = "INPR";
    }

    public static class CustomerAgingReportFields {
        public static final String ACCT = "Account";
        public static final String TOTAL_0_TO_30 = "total0to30";
        public static final String TOTAL_31_TO_60 = "total31to60";
        public static final String TOTAL_61_TO_90 = "total61to90";
        public static final String TOTAL_91_TO_SYSPR = "total90toSYSPR";
        public static final String TOTAL_AMOUNT_DUE = "totalAmountDue";
    }

    public static class LOCReportTypeFieldValues {
        public static final String DRAW_DETAILS = "Details Report";
        public static final String AMOUNTS_NOT_DRAWN = "Amounts Not Drawn Report";
    }

    public static class ReportOptionFieldValues {
        public static final String PROCESSING_ORG = "Processing Organization";
        public static final String BILLING_ORG = "Billing Organization";
    }

    public static class PaymentMediumCode {
        public static final String CASH = "CA";
        public static final String CHECK = "CK";
        public static final String WIRE_TRANSFER = "WT";
        public static final String CREDIT_CARD = "CR";
    }

    public static class TemplateUploadSystem {
        public static final String EXTENSION = ".pdf";
        public static final String TEMPLATE_MIME_TYPE = "application/pdf";
    }

    public static class PermissionNames {
        public static final String REPORT = "Report";
    }
}

