/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.report;

import org.apache.commons.lang3.StringUtils;

public class CustomerLoadBatchError {
    private String customerName;
    private String propertyName;
    private Class<?> propertyClass;
    private String value;
    private String description;

    public CustomerLoadBatchError() {
        this.customerName = "";
        this.propertyName = "";
        this.propertyClass = null;
        this.value = "";
        this.description = "";
    }

    public CustomerLoadBatchError(String customerName) {
        this.customerName = customerName;
    }

    public CustomerLoadBatchError(String customerName, String propertyName, Class<?> propertyClass, String value, String description) {
        this.customerName = customerName;
        this.propertyName = propertyName;
        this.propertyClass = propertyClass;
        this.value = value;
        this.description = description;
    }

    public String toString() {
        return "[" + this.customerName + "] " + (String)("class java.lang.Object".equals(this.propertyClass.toString()) || this.propertyClass == null ? "" : "(" + this.propertyClass.toString() + ") ") + (String)(StringUtils.isBlank((CharSequence)this.propertyName) ? "" : this.getPropertyNameLastElement() + ": ") + (String)(StringUtils.isBlank((CharSequence)this.value) || "N/A".equalsIgnoreCase(this.value) ? "" : "'" + this.value + "' - ") + this.description;
    }

    public String getPropertyNameLastElement() {
        if (StringUtils.isBlank((CharSequence)this.propertyName)) {
            return this.propertyName;
        }
        String[] propertyNameElements = this.propertyName.split("\\.");
        if (propertyNameElements.length <= 0) {
            return this.propertyName;
        }
        return propertyNameElements[propertyNameElements.length - 1];
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public void setPropertyClass(Class<?> propertyClass) {
        this.propertyClass = propertyClass;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

