/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.batch.LockboxLoadStep;
import org.kuali.kfs.module.ar.batch.service.LockboxLoadService;
import org.kuali.kfs.module.ar.businessobject.Lockbox;
import org.kuali.kfs.module.ar.businessobject.LockboxDetail;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.FlatFileInformation;
import org.kuali.kfs.sys.batch.FlatFileTransactionInformation;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.mail.BodyMailMessage;
import org.kuali.kfs.sys.mail.MailMessage;
import org.kuali.kfs.sys.service.EmailService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LockboxLoadServiceImpl
implements LockboxLoadService {
    private static final Logger LOG = LogManager.getLogger();
    private BatchInputFileType batchInputFileType;
    private String reportsDirectory;
    private BatchInputFileService batchInputFileService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private EmailService emailService;
    private ParameterService parameterService;

    @Override
    public boolean loadFile() {
        LOG.debug("loadFile() started");
        boolean result = true;
        ArrayList<FlatFileInformation> flatFileInformationList = new ArrayList<FlatFileInformation>();
        List<String> fileNamesToLoad = this.getListOfFilesToProcess();
        LOG.info("loadFile() Found " + fileNamesToLoad.size() + " file(s) to process.");
        ArrayList<String> processedFiles = new ArrayList<String>();
        for (String inputFileName : fileNamesToLoad) {
            LOG.info("loadFile() Beginning processing of filename: " + inputFileName + ".");
            FlatFileInformation flatFileInformation = new FlatFileInformation(inputFileName);
            flatFileInformationList.add(flatFileInformation);
            if (this.loadFile(inputFileName, flatFileInformation)) {
                processedFiles.add(inputFileName);
                flatFileInformation.addFileInfoMessage("File successfully completed processing.");
                continue;
            }
            flatFileInformation.addFileErrorMessage("File failed to process successfully.");
        }
        this.removeDoneFiles(processedFiles);
        this.sendLoadSummaryEmail(flatFileInformationList);
        return result;
    }

    protected boolean loadFile(String fileName, FlatFileInformation flatFileInformation) {
        boolean valid = true;
        byte[] fileByteContent = this.safelyLoadFileBytes(fileName);
        LOG.info("loadFile() Attempting to parse the file");
        Object parsedObject = null;
        try {
            parsedObject = this.batchInputFileService.parse(this.batchInputFileType, fileByteContent);
        }
        catch (ParseException e) {
            LOG.error("loadFile() Error parsing batch file: " + e.getMessage());
            flatFileInformation.addFileErrorMessage("Error parsing batch file: " + e.getMessage());
            valid = false;
        }
        if (parsedObject != null) {
            valid = this.validate(parsedObject);
            this.copyAllMessage(parsedObject, flatFileInformation);
            if (valid) {
                this.loadLockbox(parsedObject);
            }
        }
        return valid;
    }

    public boolean validate(Object parsedFileContents) {
        LOG.debug("validate() started");
        boolean valid = true;
        List lockboxList = (List)parsedFileContents;
        for (Lockbox lockbox : lockboxList) {
            if (this.compareDetailsWithHeader(lockbox)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public void process(String fileName, Object parsedFileContents) {
    }

    protected boolean compareDetailsWithHeader(Lockbox lockbox) {
        String message;
        boolean isHeaderMatchedDetails = true;
        KualiDecimal headerTransBatchTotal = lockbox.getHeaderTransactionBatchTotal();
        Integer headerTransBatchCount = lockbox.getHeaderTransactionBatchCount();
        KualiDecimal detailInvPaidTotal = new KualiDecimal(0);
        Integer totalDetailRecords = 0;
        for (LockboxDetail detail : lockbox.getLockboxDetails()) {
            detailInvPaidTotal = (KualiDecimal)detailInvPaidTotal.add((AbstractKualiDecimal)detail.getInvoicePaidOrAppliedAmount());
            Integer n = totalDetailRecords;
            Integer n2 = totalDetailRecords = Integer.valueOf(totalDetailRecords + 1);
        }
        if (headerTransBatchTotal.compareTo((AbstractKualiDecimal)detailInvPaidTotal) == 0 && headerTransBatchCount.compareTo(totalDetailRecords) == 0) {
            message = "Good Transfer for lockbox number " + lockbox.getLockboxNumber() + ". Transaction count : " + lockbox.getHeaderTransactionBatchCount() + " Transaction total amount : $ " + lockbox.getHeaderTransactionBatchTotal();
            lockbox.getFlatFileTransactionInformation().addInfoMessage(message);
            GlobalVariables.getMessageMap().putInfo("GLOBAL_ERRORS", "error.custom", new String[]{message});
        }
        if (headerTransBatchTotal.compareTo((AbstractKualiDecimal)detailInvPaidTotal) != 0) {
            message = "Bad Transmission for lock box number " + lockbox.getLockboxNumber() + ". Detail does not match header control values  Header total : $ " + lockbox.getHeaderTransactionBatchTotal() + " Detail total : $ " + detailInvPaidTotal;
            lockbox.getFlatFileTransactionInformation().addErrorMessage(message);
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.custom", new String[]{message});
            isHeaderMatchedDetails = false;
        }
        if (headerTransBatchCount.compareTo(totalDetailRecords) != 0) {
            message = "Bad Transmission for lock box number " + lockbox.getLockboxNumber() + ". Detail does not match header control values  Header Count : " + lockbox.getHeaderTransactionBatchCount() + " Detail total : " + totalDetailRecords;
            lockbox.getFlatFileTransactionInformation().addErrorMessage(message);
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.custom", new String[]{message});
            isHeaderMatchedDetails = false;
        }
        return isHeaderMatchedDetails;
    }

    public void sendLoadSummaryEmail(List<FlatFileInformation> flatFileInformationList) {
        for (FlatFileInformation information : flatFileInformationList) {
            this.sendEmail(information);
        }
    }

    public void sendEmail(FlatFileInformation flatFileInformation) {
        LOG.debug("sendEmail() starting");
        BodyMailMessage message = new BodyMailMessage();
        message.setFromAddress(this.emailService.getDefaultFromAddress());
        String subject = this.parameterService.getParameterValueAsString(LockboxLoadStep.class, "SUMMARY_AND_ERROR_NOTIFICATION_EMAIL_SUBJECT");
        String fileName = StringUtils.substringAfterLast((String)flatFileInformation.getFileName(), (String)"\\");
        message.setSubject(subject + "[ " + fileName + " ]");
        ArrayList toAddressList = new ArrayList(this.parameterService.getParameterValuesAsString(LockboxLoadStep.class, "SUMMARY_AND_ERROR_NOTIFICATION_TO_EMAIL_ADDRESSES"));
        message.getToAddresses().addAll(toAddressList);
        String body = this.composeLockboxLoadBody(flatFileInformation);
        message.setMessage(body);
        this.emailService.sendMessage((MailMessage)message, false);
    }

    protected String composeLockboxLoadBody(FlatFileInformation flatFileInformation) {
        String contactText = this.parameterService.getParameterValueAsString(LockboxLoadStep.class, "CONTACTS_TEXT");
        StringBuffer body = new StringBuffer();
        body.append(contactText);
        body.append("\n");
        for (Object object : flatFileInformation.getFlatFileIdentifierToTransactionInfomationMap().values()) {
            for (String[] message : ((FlatFileTransactionInformation)object).getMessages()) {
                body.append(message[1]);
                body.append("\n");
            }
        }
        for (String[] resultMessage : flatFileInformation.getMessages()) {
            body.append(resultMessage[1]);
            body.append("\n");
        }
        return body.toString();
    }

    protected List<String> getListOfFilesToProcess() {
        List fileNamesToLoad = this.batchInputFileService.listInputFileNamesWithDoneFile(this.batchInputFileType);
        if (fileNamesToLoad == null) {
            LOG.error("getListOfFilesToProcess() BatchInputFileService.listInputFileNamesWithDoneFile(" + this.batchInputFileType.getFileTypeIdentifier() + ") returned NULL which should never happen.");
            throw new RuntimeException("BatchInputFileService.listInputFileNamesWithDoneFile(" + this.batchInputFileType.getFileTypeIdentifier() + ") returned NULL which should never happen.");
        }
        for (String inputFileName : fileNamesToLoad) {
            if (!StringUtils.isBlank((CharSequence)inputFileName)) continue;
            LOG.error("getListOfFilesToProcess() One of the file names returned as ready to process [" + inputFileName + "] was blank.  This should not happen, so throwing an error to investigate.");
            throw new RuntimeException("One of the file names returned as ready to process [" + inputFileName + "] was blank.  This should not happen, so throwing an error to investigate.");
        }
        return fileNamesToLoad;
    }

    protected byte[] safelyLoadFileBytes(String fileName) {
        byte[] fileByteContent;
        try (FileInputStream fileContents = new FileInputStream(fileName);){
            fileByteContent = IOUtils.toByteArray((InputStream)fileContents);
        }
        catch (FileNotFoundException e1) {
            LOG.error("safelyLoadFileBytes() Batch file not found [" + fileName + "]. " + e1.getMessage());
            throw new RuntimeException("Batch File not found [" + fileName + "]. " + e1.getMessage());
        }
        catch (IOException e1) {
            LOG.error("safelyLoadFileBytes() IO Exception loading: [" + fileName + "]. " + e1.getMessage());
            throw new RuntimeException("IO Exception loading: [" + fileName + "]. " + e1.getMessage());
        }
        return fileByteContent;
    }

    protected void loadLockbox(Object parsedObject) {
        ArrayList loadLockboxList = new ArrayList();
        List lockboxList = (List)parsedObject;
        int batchSequenceNumber = 1;
        for (Lockbox lockbox : lockboxList) {
            this.setLockboxToLoad(loadLockboxList, lockbox, batchSequenceNumber);
            ++batchSequenceNumber;
        }
        this.businessObjectService.save(loadLockboxList);
    }

    protected void removeDoneFiles(List<String> dataFileNames) {
        for (String dataFileName : dataFileNames) {
            File doneFile = new File(StringUtils.substringBeforeLast((String)dataFileName, (String)".") + ".done");
            if (!doneFile.exists()) continue;
            doneFile.delete();
        }
    }

    protected void setLockboxToLoad(List loadLockboxList, Lockbox lockbox, int batchSequenceNumber) {
        for (LockboxDetail detail : lockbox.getLockboxDetails()) {
            Lockbox lockboxToLoad = new Lockbox();
            lockboxToLoad.setLockboxNumber(lockbox.getLockboxNumber());
            lockboxToLoad.setScannedInvoiceDate(lockbox.getScannedInvoiceDate());
            lockboxToLoad.setCustomerNumber(detail.getCustomerNumber());
            lockboxToLoad.setBatchSequenceNumber(batchSequenceNumber);
            lockboxToLoad.setProcessedInvoiceDate(this.dateTimeService.getCurrentSqlDate());
            lockboxToLoad.setFinancialDocumentReferenceInvoiceNumber(detail.getFinancialDocumentReferenceInvoiceNumber());
            lockboxToLoad.setBillingDate(detail.getBillingDate());
            lockboxToLoad.setInvoiceTotalAmount(detail.getInvoiceTotalAmount());
            lockboxToLoad.setInvoicePaidOrAppliedAmount(detail.getInvoicePaidOrAppliedAmount());
            lockboxToLoad.setCustomerPaymentMediumCode(detail.getCustomerPaymentMediumCode());
            loadLockboxList.add(lockboxToLoad);
        }
    }

    protected void copyAllMessage(Object parsedObject, FlatFileInformation flatFileInformation) {
        List lockboxList = (List)parsedObject;
        for (Lockbox lockbox : lockboxList) {
            FlatFileTransactionInformation information = lockbox.getFlatFileTransactionInformation();
            flatFileInformation.getOrAddFlatFileData(lockbox.getLockboxNumber(), information);
        }
    }

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        return null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setBatchInputFileType(BatchInputFileType batchInputFileType) {
        this.batchInputFileType = batchInputFileType;
    }

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

