/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.LetterOfCreditBillingPeriod;
import org.kuali.kfs.module.ar.businessobject.TimeBasedBillingPeriod;

public abstract class BillingPeriod {
    protected java.sql.Date startDate;
    protected java.sql.Date endDate;
    protected boolean billable;
    protected final AccountingPeriodService accountingPeriodService;
    protected final ArConstants.BillingFrequencyValues billingFrequency;
    protected final java.sql.Date awardStartDate;
    protected final java.sql.Date currentDate;
    protected final java.sql.Date lastBilledDate;

    protected BillingPeriod(ArConstants.BillingFrequencyValues billingFrequency, java.sql.Date awardStartDate, java.sql.Date currentDate, java.sql.Date lastBilledDate, AccountingPeriodService accountingPeriodService) {
        this.awardStartDate = awardStartDate;
        this.lastBilledDate = lastBilledDate;
        this.accountingPeriodService = accountingPeriodService;
        this.billingFrequency = billingFrequency;
        this.currentDate = currentDate;
    }

    public java.sql.Date getStartDate() {
        return this.startDate;
    }

    public java.sql.Date getEndDate() {
        return this.endDate;
    }

    public static BillingPeriod determineBillingPeriodPriorTo(java.sql.Date awardStartDate, java.sql.Date currentDate, java.sql.Date lastBilledDate, ArConstants.BillingFrequencyValues billingFrequency, AccountingPeriodService accountingPeriodService) {
        BillingPeriod billingPeriod = ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.equals((Object)billingFrequency) ? new LetterOfCreditBillingPeriod(billingFrequency, awardStartDate, currentDate, lastBilledDate, accountingPeriodService) : new TimeBasedBillingPeriod(billingFrequency, awardStartDate, currentDate, lastBilledDate, accountingPeriodService);
        billingPeriod.billable = billingPeriod.canThisBeBilled();
        if (billingPeriod.billable) {
            billingPeriod.startDate = billingPeriod.determineStartDate();
            billingPeriod.endDate = billingPeriod.determineEndDateByFrequency();
        }
        return billingPeriod;
    }

    protected abstract java.sql.Date determineEndDateByFrequency();

    protected AccountingPeriod findAccountingPeriodBy(java.sql.Date date) {
        return this.accountingPeriodService.getByDate(date);
    }

    protected boolean canThisBeBilled() {
        if (this.lastBilledDate == null) {
            return true;
        }
        return this.canThisBeBilledByBillingFrequency();
    }

    protected abstract boolean canThisBeBilledByBillingFrequency();

    protected java.sql.Date determineStartDate() {
        if (this.lastBilledDate == null) {
            return this.awardStartDate;
        }
        return this.determineStartDateByFrequency();
    }

    protected abstract java.sql.Date determineStartDateByFrequency();

    protected java.sql.Date calculatePreviousDate(java.sql.Date date) {
        return new java.sql.Date(DateUtils.addDays((Date)date, (int)-1).getTime());
    }

    protected java.sql.Date calculateNextDay(java.sql.Date date) {
        return new java.sql.Date(DateUtils.addDays((Date)date, (int)1).getTime());
    }

    public boolean isBillable() {
        return this.billable;
    }
}

