/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.sys.businessobject.TaxDetail;
import org.kuali.kfs.sys.context.SpringContext;

public class SalesTaxCustomerInvoiceDetail
extends CustomerInvoiceDetail {
    private TaxDetail taxDetail;
    private CustomerInvoiceDetail customerInvoiceDetail;

    public SalesTaxCustomerInvoiceDetail(TaxDetail taxDetail, CustomerInvoiceDetail customerInvoiceDetail) {
        this.taxDetail = taxDetail;
        this.customerInvoiceDetail = customerInvoiceDetail;
    }

    public Account getAccount() {
        return ((AccountService)SpringContext.getBean(AccountService.class)).getByPrimaryId(this.taxDetail.getChartOfAccountsCode(), this.taxDetail.getAccountNumber());
    }

    public String getAccountNumber() {
        return this.taxDetail.getAccountNumber();
    }

    public KualiDecimal getAmount() {
        return this.taxDetail.getTaxAmount();
    }

    public String getChartOfAccountsCode() {
        return this.taxDetail.getChartOfAccountsCode();
    }

    public String getFinancialObjectCode() {
        return this.taxDetail.getFinancialObjectCode();
    }

    public ObjectCode getObjectCode() {
        return ((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class)).getByPrimaryIdForCurrentYear(this.taxDetail.getChartOfAccountsCode(), this.taxDetail.getFinancialObjectCode());
    }

    @Override
    public ObjectCode getAccountsReceivableObject() {
        return this.customerInvoiceDetail.getAccountsReceivableObject();
    }

    @Override
    public String getAccountsReceivableObjectCode() {
        return this.customerInvoiceDetail.getAccountsReceivableObjectCode();
    }

    public String getFinancialSubObjectCode() {
        return null;
    }

    public String getOrganizationReferenceId() {
        return null;
    }

    public String getProjectCode() {
        return null;
    }

    public String getSubAccountNumber() {
        return null;
    }
}

