/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.impl.AccountingDocumentRuleBaseConstants;

public class WriteoffCustomerInvoiceDetail
extends CustomerInvoiceDetail {
    private CustomerInvoiceDetail postable;
    private CustomerInvoiceWriteoffDocument poster;
    private boolean isUsingOrgAcctDefaultWriteoffFAU;
    private boolean isUsingChartForWriteoff;

    public WriteoffCustomerInvoiceDetail(CustomerInvoiceDetail postable, CustomerInvoiceWriteoffDocument poster) {
        this.postable = postable;
        this.poster = poster;
        String writeoffGenerationOption = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_GENERATION_METHOD");
        this.isUsingOrgAcctDefaultWriteoffFAU = "2".equals(writeoffGenerationOption);
        this.isUsingChartForWriteoff = "1".equals(writeoffGenerationOption);
        if (this.isUsingOrgAcctDefaultWriteoffFAU) {
            this.poster.refreshReferenceObject("account");
            this.poster.refreshReferenceObject("chartOfAccounts");
            this.poster.refreshReferenceObject("subAccount");
            this.poster.refreshReferenceObject("financialObject");
            this.poster.refreshReferenceObject("financialSubObject");
            this.poster.refreshReferenceObject("project");
        } else {
            this.postable.refreshNonUpdateableReferences();
        }
    }

    public Account getAccount() {
        if (this.isUsingOrgAcctDefaultWriteoffFAU) {
            return this.poster.getAccount();
        }
        return this.postable.getAccount();
    }

    public String getAccountNumber() {
        if (this.isUsingOrgAcctDefaultWriteoffFAU) {
            return this.poster.getAccountNumber();
        }
        return this.postable.getAccountNumber();
    }

    public KualiDecimal getAmount() {
        return this.postable.getAmountOpen();
    }

    public String getChartOfAccountsCode() {
        if (this.isUsingOrgAcctDefaultWriteoffFAU) {
            return this.poster.getChartOfAccountsCode();
        }
        return this.postable.getChartOfAccountsCode();
    }

    public String getDocumentNumber() {
        return this.postable.getDocumentNumber();
    }

    public String getFinancialDocumentLineDescription() {
        return this.postable.getFinancialDocumentLineDescription();
    }

    public String getFinancialObjectCode() {
        CustomerInvoiceWriteoffDocumentService customerInvoiceWriteoffDocumentService = (CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class);
        return customerInvoiceWriteoffDocumentService.getFinancialObjectCode(this.postable, this.poster, this.isUsingOrgAcctDefaultWriteoffFAU, this.isUsingChartForWriteoff, this.getChartOfAccountsCode());
    }

    public ObjectCode getObjectCode() {
        CustomerInvoiceWriteoffDocumentService customerInvoiceWriteoffDocumentService = (CustomerInvoiceWriteoffDocumentService)SpringContext.getBean(CustomerInvoiceWriteoffDocumentService.class);
        return customerInvoiceWriteoffDocumentService.getObjectCode(this.postable, this.poster, this.isUsingOrgAcctDefaultWriteoffFAU, this.isUsingChartForWriteoff, this.getChartOfAccountsCode());
    }

    public String getFinancialSubObjectCode() {
        return AccountingDocumentRuleBaseConstants.GENERAL_LEDGER_PENDING_ENTRY_CODE.getBlankFinancialSubObjectCode();
    }

    public String getOrganizationReferenceId() {
        if (this.isUsingOrgAcctDefaultWriteoffFAU) {
            return this.poster.getOrganizationReferenceIdentifier();
        }
        return this.postable.getOrganizationReferenceId();
    }

    public String getProjectCode() {
        if (this.isUsingOrgAcctDefaultWriteoffFAU) {
            return this.poster.getProjectCode();
        }
        return this.postable.getProjectCode();
    }

    public String getSubAccountNumber() {
        if (this.isUsingOrgAcctDefaultWriteoffFAU) {
            return this.poster.getSubAccountNumber();
        }
        return this.postable.getSubAccountNumber();
    }
}

