/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.sys.businessobject.admin.DefaultBoAdminService;

public class InvoiceTemplateAdminService
extends DefaultBoAdminService {
    protected final Map<String, String> buildRoleQualifications(Object businessObject, String principalId) {
        Map roleQualifications = super.buildRoleQualifications(businessObject, principalId);
        roleQualifications.putAll(KRADUtils.getNamespaceAndComponentSimpleName(businessObject.getClass()));
        InvoiceTemplate invoiceTemplate = (InvoiceTemplate)((Object)businessObject);
        roleQualifications.put("chartOfAccountsCode", invoiceTemplate.getBillByChartOfAccountCode());
        roleQualifications.put("organizationCode", invoiceTemplate.getBilledByOrganizationCode());
        return roleQualifications;
    }

    public boolean allowsCopy(BusinessObjectBase businessObject, Person person) {
        if (businessObject == null || !this.maintDocSupportsCopy(businessObject)) {
            return false;
        }
        String principalId = person.getPrincipalId();
        HashMap<String, String> roleQualifiers = new HashMap<String, String>(this.buildRoleQualifications(businessObject, principalId));
        HashMap<String, String> permissionDetails = new HashMap<String, String>(this.buildPermissionDetails(businessObject));
        permissionDetails.put("documentTypeName", this.documentDictionaryService.getMaintenanceDocumentTypeName(businessObject.getClass()));
        permissionDetails.put("maintenanceAction", "New");
        return this.permissionService.isAuthorizedByTemplate(person.getPrincipalId(), "KFS-SYS", "Create / Maintain Record(s)", permissionDetails, roleQualifiers);
    }
}

