/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.search.SearchOperator;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLOCReport;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsReportLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsLetterOfCreditReviewDocument;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;

public class ContractsGrantsLOCReportLookupableHelperServiceImpl
extends ContractsGrantsReportLookupableHelperServiceImplBase {
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected DateTimeService dateTimeService;

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        this.validateSearchParametersForOperatorAndValue(fieldValues, "amountAvailableToDraw");
        this.validateSearchParametersForOperatorAndValue(fieldValues, "claimOnCashBalance");
        this.validateSearchParametersForOperatorAndValue(fieldValues, "amountToDraw");
        this.validateSearchParametersForOperatorAndValue(fieldValues, "fundsNotDrawn");
        String lowerBoundLetterOfCreditReviewCreateDate = fieldValues.get("rangeLowerBoundKeyPrefix_letterOfCreditReviewCreateDate");
        this.validateTimestampField(lowerBoundLetterOfCreditReviewCreateDate, "rangeLowerBoundKeyPrefix_letterOfCreditReviewCreateDate", this.getDateTimeService());
        String upperBoundLetterOfCreditReviewCreateDate = fieldValues.get("letterOfCreditReviewCreateDate");
        this.validateTimestampField(upperBoundLetterOfCreditReviewCreateDate, "letterOfCreditReviewCreateDate", this.getDateTimeService());
    }

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        String reportType = (String)lookupFormFields.get("reportType");
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ContractsGrantsReportLookupableHelperServiceImplBase.OperatorAndValue amountAvailableToDrawOperator = this.buildOperatorAndValueFromField(lookupFormFields, "amountAvailableToDraw");
        ContractsGrantsReportLookupableHelperServiceImplBase.OperatorAndValue claimOnCashBalanceOperator = this.buildOperatorAndValueFromField(lookupFormFields, "claimOnCashBalance");
        ContractsGrantsReportLookupableHelperServiceImplBase.OperatorAndValue amountToDrawOperator = this.buildOperatorAndValueFromField(lookupFormFields, "amountToDraw");
        ContractsGrantsReportLookupableHelperServiceImplBase.OperatorAndValue fundsNotDrawnOperator = this.buildOperatorAndValueFromField(lookupFormFields, "fundsNotDrawn");
        ArrayList<ContractsGrantsLOCReport> displayList = new ArrayList<ContractsGrantsLOCReport>();
        Map<String, String> locLookupFields = this.buildCriteriaForLetterOfCreditLookup(lookupFormFields);
        locLookupFields.put("documentHeader.workflowDocumentStatusCode", StringUtils.join((Iterable)this.getFinancialSystemDocumentService().getSuccessfulDocumentStatuses(), (String)SearchOperator.OR.op()));
        Collection cgLOCReviewDocs = this.getLookupService().findCollectionBySearchHelper(ContractsGrantsLetterOfCreditReviewDocument.class, locLookupFields, true);
        for (ContractsGrantsLetterOfCreditReviewDocument cgLOCReviewDoc : cgLOCReviewDocs) {
            List<ContractsGrantsLetterOfCreditReviewDetail> headerReviewDetails = cgLOCReviewDoc.getHeaderReviewDetails();
            List<ContractsGrantsLetterOfCreditReviewDetail> accountReviewDetails = cgLOCReviewDoc.getAccountReviewDetails();
            if (accountReviewDetails.size() <= 0) continue;
            KualiDecimal totalAmountAvailableToDraw = KualiDecimal.ZERO;
            KualiDecimal totalClaimOnCashBalance = KualiDecimal.ZERO;
            KualiDecimal totalAmountToDraw = KualiDecimal.ZERO;
            KualiDecimal totalFundsNotDrawn = KualiDecimal.ZERO;
            ContractsGrantsLOCReport cgLOCReport = new ContractsGrantsLOCReport();
            for (ContractsGrantsLetterOfCreditReviewDetail accountReviewDetailEntry : accountReviewDetails) {
                KualiDecimal claimOnCashBalance = ObjectUtils.isNull((Object)accountReviewDetailEntry.getClaimOnCashBalance()) ? KualiDecimal.ZERO : accountReviewDetailEntry.getClaimOnCashBalance();
                KualiDecimal previousDraw = ObjectUtils.isNull((Object)accountReviewDetailEntry.getAmountToDraw()) ? KualiDecimal.ZERO : accountReviewDetailEntry.getAmountToDraw();
                KualiDecimal fundsNotDrawn = ObjectUtils.isNull((Object)accountReviewDetailEntry.getFundsNotDrawn()) ? KualiDecimal.ZERO : accountReviewDetailEntry.getFundsNotDrawn();
                totalClaimOnCashBalance = (KualiDecimal)totalClaimOnCashBalance.add((AbstractKualiDecimal)claimOnCashBalance);
                totalAmountToDraw = (KualiDecimal)totalAmountToDraw.add((AbstractKualiDecimal)previousDraw);
                totalFundsNotDrawn = (KualiDecimal)totalFundsNotDrawn.add((AbstractKualiDecimal)fundsNotDrawn);
            }
            for (ContractsGrantsLetterOfCreditReviewDetail accountReviewDetailEntry : headerReviewDetails) {
                KualiDecimal amountAvailableToDraw = ObjectUtils.isNull((Object)accountReviewDetailEntry.getAmountAvailableToDraw()) ? KualiDecimal.ZERO : accountReviewDetailEntry.getAmountAvailableToDraw();
                totalAmountAvailableToDraw = (KualiDecimal)totalAmountAvailableToDraw.add((AbstractKualiDecimal)amountAvailableToDraw);
            }
            if (amountAvailableToDrawOperator != null && !amountAvailableToDrawOperator.applyComparison((Number)totalAmountAvailableToDraw) || claimOnCashBalanceOperator != null && !claimOnCashBalanceOperator.applyComparison((Number)totalClaimOnCashBalance) || amountToDrawOperator != null && !amountToDrawOperator.applyComparison((Number)totalAmountToDraw) || fundsNotDrawnOperator != null && !fundsNotDrawnOperator.applyComparison((Number)totalFundsNotDrawn)) continue;
            cgLOCReport.setDocumentNumber(cgLOCReviewDoc.getDocumentNumber());
            cgLOCReport.setLetterOfCreditFundCode(cgLOCReviewDoc.getLetterOfCreditFundCode());
            cgLOCReport.setLetterOfCreditFundGroupCode(cgLOCReviewDoc.getLetterOfCreditFundGroupCode());
            Timestamp dateCreated = cgLOCReviewDoc.getFinancialSystemDocumentHeader().getWorkflowCreateDate();
            if (ObjectUtils.isNotNull((Object)dateCreated)) {
                cgLOCReport.setLetterOfCreditReviewCreateDate(new Date(dateCreated.getTime()));
            }
            cgLOCReport.setAmountAvailableToDraw(totalAmountAvailableToDraw);
            cgLOCReport.setClaimOnCashBalance(totalClaimOnCashBalance);
            cgLOCReport.setAmountToDraw(totalAmountToDraw);
            cgLOCReport.setFundsNotDrawn(totalFundsNotDrawn);
            if (reportType.equals("Amounts Not Drawn Report")) {
                if (!totalFundsNotDrawn.isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
                displayList.add(cgLOCReport);
                continue;
            }
            displayList.add(cgLOCReport);
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    protected Map<String, String> buildCriteriaForLetterOfCreditLookup(Map lookupFormFields) {
        String letterOfCreditFundGroupCode;
        String letterOfCreditFundCode;
        HashMap<String, String> lookupFields = new HashMap<String, String>();
        String documentNumber = (String)lookupFormFields.get("documentNumber");
        if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
            lookupFields.put("documentNumber", documentNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(letterOfCreditFundCode = (String)lookupFormFields.get("letterOfCreditFundCode")))) {
            lookupFields.put("letterOfCreditFundCode", letterOfCreditFundCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(letterOfCreditFundGroupCode = (String)lookupFormFields.get("letterOfCreditFundGroupCode")))) {
            lookupFields.put("letterOfCreditFundGroupCode", letterOfCreditFundGroupCode);
        }
        String lowerBoundLetterOfCreditReviewCreateDate = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_letterOfCreditReviewCreateDate");
        String upperBoundLetterOfCreditReviewCreateDate = (String)lookupFormFields.get("letterOfCreditReviewCreateDate");
        String letterOfCreditReviewCreateDateCriteria = this.getContractsGrantsReportHelperService().fixDateCriteria(lowerBoundLetterOfCreditReviewCreateDate, upperBoundLetterOfCreditReviewCreateDate, true);
        if (StringUtils.isNotBlank((CharSequence)letterOfCreditReviewCreateDateCriteria)) {
            lookupFields.put("documentHeader.workflowCreateDate", letterOfCreditReviewCreateDateCriteria);
        }
        return lookupFields;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

