/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsPaymentHistoryReport;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsReportLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustableDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class ContractsGrantsPaymentHistoryReportLookupableHelperServiceImpl
extends ContractsGrantsReportLookupableHelperServiceImplBase {
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected FinancialSystemDocumentService financialSystemDocumentService;

    public void validateSearchParameters(Map<String, String> fieldValues) {
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get("paymentDate"))) {
            this.validateDateField(fieldValues.get("paymentDate"), "paymentDate", this.getDateTimeService());
        }
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get("rangeLowerBoundKeyPrefix_paymentDate"))) {
            this.validateDateField(fieldValues.get("rangeLowerBoundKeyPrefix_paymentDate"), "rangeLowerBoundKeyPrefix_paymentDate", this.getDateTimeService());
        }
        this.validateSearchParametersForOperatorAndValue(fieldValues, "invoiceAmount");
        super.validateSearchParameters(fieldValues);
    }

    public Collection<ContractsGrantsPaymentHistoryReport> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ArrayList<ContractsGrantsPaymentHistoryReport> displayList = new ArrayList<ContractsGrantsPaymentHistoryReport>();
        HashMap<String, String> invoiceAppliedLookupFields = new HashMap<String, String>();
        if (lookupFormFields.containsKey("invoiceType")) {
            invoiceAppliedLookupFields.put("customerInvoiceDocument.documentHeader.workflowDocumentTypeName", (String)lookupFormFields.get("invoiceType"));
        }
        if (lookupFormFields.containsKey("paymentNumber")) {
            invoiceAppliedLookupFields.put("documentNumber", (String)lookupFormFields.get("paymentNumber"));
        }
        if (lookupFormFields.containsKey("customerNumber")) {
            invoiceAppliedLookupFields.put("customerInvoiceDocument.accountsReceivableDocumentHeader.customerNumber", (String)lookupFormFields.get("customerNumber"));
        }
        if (lookupFormFields.containsKey("paymentAmount")) {
            invoiceAppliedLookupFields.put("invoiceItemAppliedAmount", (String)lookupFormFields.get("paymentAmount"));
        }
        if (lookupFormFields.containsKey("invoiceNumber")) {
            invoiceAppliedLookupFields.put("financialDocumentReferenceInvoiceNumber", (String)lookupFormFields.get("invoiceNumber"));
        }
        Collection invoicePaidApplieds = this.getLookupService().findCollectionBySearchHelper(InvoicePaidApplied.class, invoiceAppliedLookupFields, true);
        try {
            for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
                boolean useInvoicePaidApplied = true;
                Document doc = this.getDocumentService().getByDocumentHeaderId(invoicePaidApplied.getDocumentNumber());
                if (!(doc instanceof PaymentApplicationAdjustableDocument)) continue;
                PaymentApplicationAdjustableDocument paymentApp = (PaymentApplicationAdjustableDocument)doc;
                if (this.getFinancialSystemDocumentService().getUnsuccessfulDocumentStatuses().contains(paymentApp.getFinancialSystemDocumentHeader().getWorkflowDocumentStatusCode())) {
                    useInvoicePaidApplied = false;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)lookupFormFields.get("appliedIndicator")))) {
                    String appliedIndicator = (String)lookupFormFields.get("appliedIndicator");
                    if ("Y".equals(appliedIndicator) && !this.getFinancialSystemDocumentService().getSuccessfulDocumentStatuses().contains(paymentApp.getFinancialSystemDocumentHeader().getWorkflowDocumentStatusCode())) {
                        useInvoicePaidApplied = false;
                    } else if ("N".equals(appliedIndicator) && !this.getFinancialSystemDocumentService().getPendingDocumentStatuses().contains(paymentApp.getFinancialSystemDocumentHeader().getWorkflowDocumentStatusCode())) {
                        useInvoicePaidApplied = false;
                    }
                }
                DateTime dateFinalized = paymentApp.getDocumentHeader().getWorkflowDocument().getDateFinalized();
                java.util.Date paymentAppFinalDate = null;
                if (dateFinalized != null) {
                    paymentAppFinalDate = dateFinalized.toDate();
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)lookupFormFields.get("paymentDate")))) {
                    java.util.Date toPaymentDate = this.getDateTimeService().convertToDate((String)lookupFormFields.get("paymentDate"));
                    if (paymentAppFinalDate == null || !KfsDateUtils.isSameDay((java.util.Date)paymentAppFinalDate, (java.util.Date)toPaymentDate) && toPaymentDate.before(paymentAppFinalDate)) {
                        useInvoicePaidApplied = false;
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)lookupFormFields.get("rangeLowerBoundKeyPrefix_paymentDate")))) {
                    java.util.Date fromPaymentDate = this.getDateTimeService().convertToDate((String)lookupFormFields.get("rangeLowerBoundKeyPrefix_paymentDate"));
                    if (paymentAppFinalDate == null || !KfsDateUtils.isSameDay((java.util.Date)paymentAppFinalDate, (java.util.Date)fromPaymentDate) && fromPaymentDate.after(paymentAppFinalDate)) {
                        useInvoicePaidApplied = false;
                    }
                }
                ContractsGrantsInvoiceDocument cgInvoiceDocument = (ContractsGrantsInvoiceDocument)this.getBusinessObjectService().findBySinglePrimaryKey(ContractsGrantsInvoiceDocument.class, (Object)invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber());
                ContractsGrantsReportLookupableHelperServiceImplBase.OperatorAndValue invoiceAmountOperator = this.buildOperatorAndValueFromField(lookupFormFields, "invoiceAmount");
                if (invoiceAmountOperator != null && !invoiceAmountOperator.applyComparison((Number)cgInvoiceDocument.getTotalDollarAmount())) {
                    useInvoicePaidApplied = false;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)lookupFormFields.get("awardNumber"))) && !StringUtils.equals((CharSequence)cgInvoiceDocument.getInvoiceGeneralDetail().getAward().getProposalNumber(), (CharSequence)((CharSequence)lookupFormFields.get("awardNumber")))) {
                    useInvoicePaidApplied = false;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)lookupFormFields.get("reversedIndicator")))) {
                    String reversedIndicator = (String)lookupFormFields.get("reversedIndicator");
                    if ("Y".equals(reversedIndicator) && !cgInvoiceDocument.isInvoiceReversal()) {
                        useInvoicePaidApplied = false;
                    } else if ("N".equals(reversedIndicator) & cgInvoiceDocument.isInvoiceReversal()) {
                        useInvoicePaidApplied = false;
                    }
                }
                if (!useInvoicePaidApplied) continue;
                ContractsGrantsPaymentHistoryReport cgPaymentHistoryReport = new ContractsGrantsPaymentHistoryReport();
                cgPaymentHistoryReport.setPaymentNumber(invoicePaidApplied.getDocumentNumber());
                cgPaymentHistoryReport.setPaymentDocumentType(paymentApp.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
                FinancialSystemDocumentHeader documentHeader = (FinancialSystemDocumentHeader)cgInvoiceDocument.getDocumentHeader();
                cgPaymentHistoryReport.setInvoiceType(documentHeader.getWorkflowDocumentTypeName());
                cgPaymentHistoryReport.setPaymentAmount(invoicePaidApplied.getInvoiceItemAppliedAmount());
                cgPaymentHistoryReport.setInvoiceNumber(invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber());
                if (dateFinalized != null) {
                    cgPaymentHistoryReport.setPaymentDate(new Date(dateFinalized.getMillis()));
                }
                cgPaymentHistoryReport.setAppliedIndicator(this.getFinancialSystemDocumentService().getSuccessfulDocumentStatuses().contains(paymentApp.getFinancialSystemDocumentHeader().getWorkflowDocumentStatusCode()));
                if (ObjectUtils.isNotNull((Object)((Object)cgInvoiceDocument.getInvoiceGeneralDetail()))) {
                    cgPaymentHistoryReport.setAwardNumber(cgInvoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
                }
                cgPaymentHistoryReport.setReversedIndicator(cgInvoiceDocument.isInvoiceReversal());
                cgPaymentHistoryReport.setCustomerNumber(cgInvoiceDocument.getCustomerNumber());
                cgPaymentHistoryReport.setCustomerName(cgInvoiceDocument.getCustomer().getCustomerName());
                cgPaymentHistoryReport.setInvoiceAmount(cgInvoiceDocument.getTotalDollarAmount());
                displayList.add(cgPaymentHistoryReport);
            }
            this.buildResultTable(lookupForm, displayList, resultTable);
        }
        catch (ParseException pe) {
            throw new RuntimeException("I tried to validate the date and amount fields related to search, I really did.  But...I guess I didn't try hard enough", pe);
        }
        return displayList;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }
}

