/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.web.format.Formatter;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.DunningCampaign;
import org.kuali.kfs.module.ar.businessobject.DunningLetterDistribution;
import org.kuali.kfs.module.ar.businessobject.DunningLetterTemplate;
import org.kuali.kfs.module.ar.businessobject.GenerateDunningLettersLookupResult;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.lookup.AccountsReceivableLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.DunningLetterService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.web.ui.ContractsGrantsLookupResultRow;

public class GenerateDunningLettersLookupableHelperServiceImpl
extends AccountsReceivableLookupableHelperServiceImplBase {
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected AccountService accountService;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected DunningLetterService dunningLetterService;
    protected PersonService personService;

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        List<? extends BusinessObject> displayList = this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        List returnKeys = this.getReturnKeys();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (GenerateDunningLettersLookupResult generateDunningLettersLookupResult : displayList) {
            List<String> invoiceAttributesForDisplay = generateDunningLettersLookupResult.getInvoiceAttributesForDisplay();
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)generateDunningLettersLookupResult, user);
            ArrayList<ResultRow> subResultRows = new ArrayList<ResultRow>();
            for (ContractsGrantsInvoiceDocument invoice : generateDunningLettersLookupResult.getInvoices()) {
                ArrayList<Column> subResultColumns = new ArrayList<Column>();
                InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
                if (CollectionUtils.isNotEmpty(invoice.getAccountDetails())) {
                    invoiceAccountDetail = invoice.getAccountDetails().get(0);
                }
                for (String propertyName : invoiceAttributesForDisplay) {
                    if (propertyName.equalsIgnoreCase("accountNumber")) {
                        Account account = this.getAccountService().getByPrimaryId(invoiceAccountDetail.getChartOfAccountsCode(), invoiceAccountDetail.getAccountNumber());
                        subResultColumns.add(this.setupResultsColumn((BusinessObject)account, propertyName, businessObjectRestrictions));
                        continue;
                    }
                    if ("dunningLetterTemplateSentDate".equalsIgnoreCase(propertyName)) {
                        InvoiceGeneralDetail invoiceGeneralDetail = invoice.getInvoiceGeneralDetail();
                        subResultColumns.add(this.setupResultsColumn((BusinessObject)invoiceGeneralDetail, propertyName, businessObjectRestrictions));
                        continue;
                    }
                    subResultColumns.add(this.setupResultsColumn((BusinessObject)invoice, propertyName, businessObjectRestrictions));
                }
                ResultRow subResultRow = new ResultRow(subResultColumns, "", "");
                subResultRow.setObjectId(invoice.getObjectId());
                subResultRows.add(subResultRow);
            }
            Collection<Column> columns = this.getColumns((BusinessObject)generateDunningLettersLookupResult, businessObjectRestrictions);
            HtmlData returnUrl = this.getReturnUrl((BusinessObject)generateDunningLettersLookupResult, lookupForm, returnKeys, businessObjectRestrictions);
            ContractsGrantsLookupResultRow row = new ContractsGrantsLookupResultRow((List)columns, subResultRows, returnUrl.constructCompleteHtmlTag(), this.getActionUrls((BusinessObject)generateDunningLettersLookupResult, pkNames, businessObjectRestrictions));
            resultTable.add(row);
        }
        return displayList;
    }

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        Collection<GenerateDunningLettersLookupResult> searchResultsCollection = this.getInvoiceDocumentsForDunningLetterLookup(fieldValues);
        return this.buildSearchResultList(searchResultsCollection, Long.valueOf(searchResultsCollection.size()));
    }

    protected Collection<GenerateDunningLettersLookupResult> getInvoiceDocumentsForDunningLetterLookup(Map<String, String> fieldValues) {
        String proposalNumber = fieldValues.get("proposalNumber");
        String customerNumber = fieldValues.get("customerNumber");
        String invoiceDocumentNumber = fieldValues.get("invoiceDocumentNumber");
        String awardTotal = fieldValues.get("awardTotal");
        String accountNumber = fieldValues.get("accountNumber");
        String reportOption = fieldValues.get("reportOption");
        String chartCode = fieldValues.get("chartOfAccountsCode");
        String orgCode = fieldValues.get("organizationCode");
        HashMap<String, String> fieldValuesForInvoice = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)proposalNumber)) {
            fieldValuesForInvoice.put("invoiceGeneralDetail.proposalNumber", proposalNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)customerNumber)) {
            fieldValuesForInvoice.put("accountsReceivableDocumentHeader.customerNumber", customerNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceDocumentNumber)) {
            fieldValuesForInvoice.put("documentNumber", invoiceDocumentNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)awardTotal)) {
            fieldValuesForInvoice.put("invoiceGeneralDetail.awardTotal", awardTotal);
        }
        if (StringUtils.isNotBlank((CharSequence)accountNumber)) {
            fieldValuesForInvoice.put("accountDetails.accountNumber", accountNumber);
        }
        fieldValuesForInvoice.put("openInvoiceIndicator", "true");
        fieldValuesForInvoice.put("documentHeader.financialDocumentStatusCode", "A");
        if (StringUtils.equalsIgnoreCase((CharSequence)reportOption, (CharSequence)"Processing Organization")) {
            if (StringUtils.isNotBlank((CharSequence)chartCode) && StringUtils.isNotBlank((CharSequence)orgCode)) {
                fieldValuesForInvoice.put("accountsReceivableDocumentHeader.processingOrganizationCode", orgCode);
                fieldValuesForInvoice.put("accountsReceivableDocumentHeader.processingChartOfAccountCode", chartCode);
            }
        } else if (StringUtils.isNotBlank((CharSequence)chartCode) && StringUtils.isNotBlank((CharSequence)orgCode)) {
            fieldValuesForInvoice.put("billedByOrganizationCode", orgCode);
            fieldValuesForInvoice.put("billByChartOfAccountCode", chartCode);
        }
        Collection<ContractsGrantsInvoiceDocument> cgInvoiceDocuments = this.contractsGrantsInvoiceDocumentService.retrieveAllCGInvoicesByCriteria(fieldValuesForInvoice);
        Collection<ContractsGrantsInvoiceDocument> eligibleInvoiceDocuments = this.validateInvoicesForDunningLetters(fieldValues, cgInvoiceDocuments);
        return this.getDunningLetterService().getPopulatedGenerateDunningLettersLookupResults(eligibleInvoiceDocuments);
    }

    protected Collection<ContractsGrantsInvoiceDocument> validateInvoicesForDunningLetters(Map<String, String> fieldValues, Collection<ContractsGrantsInvoiceDocument> cgInvoiceDocuments) {
        Integer agingBucketStartValue = null;
        Integer agingBucketEndValue = null;
        String stateAgencyFinalCutOffDate = this.parameterService.getParameterValueAsString(DunningCampaign.class, "DUNNING_LETTERS_STATE_AGENCY_FINAL_DAYS_PAST_DUE", "0");
        String finalCutOffDate = this.parameterService.getParameterValueAsString(DunningCampaign.class, "DUNNING_LETTERS_FINAL_DAYS_PAST_DUE", "0");
        Integer cutoffdateFinal = new Integer(finalCutOffDate);
        String agencyNumber = fieldValues.get("agencyNumber");
        String campaignID = fieldValues.get("campaignID");
        String collector = fieldValues.get("principalId");
        String agingBucket = fieldValues.get("agingBucket");
        String collectorPrincName = fieldValues.get("collector.principalName");
        Integer[] agingBucketStartAndEnd = this.getAgingBucketStartAndEnd(agingBucket, cutoffdateFinal);
        if (!ObjectUtils.isNull((Object)agingBucketStartAndEnd)) {
            agingBucketStartValue = agingBucketStartAndEnd[0];
            agingBucketEndValue = agingBucketStartAndEnd[1];
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        ArrayList<ContractsGrantsInvoiceDocument> eligibleInvoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        for (ContractsGrantsInvoiceDocument invoice : cgInvoiceDocuments) {
            String foundDunningLetterTemplate;
            if (!this.isInvoiceGenerallyEligibleForDunningLetter(invoice) || !this.doesInvoiceMatchCollectorCriteria(invoice, collector, collectorPrincName) || !this.contractsGrantsInvoiceDocumentService.canViewInvoice(invoice, user.getPrincipalId()) || !this.doesInvoiceMatchAwardCriteria(invoice, agencyNumber, campaignID) || !this.doesInvoiceFitWithinAgingBucket(invoice, agingBucket, agingBucketStartValue, agingBucketEndValue, stateAgencyFinalCutOffDate) || !StringUtils.isNotBlank((CharSequence)(foundDunningLetterTemplate = this.findMatchingDunningLetterTemplate(invoice, cutoffdateFinal, stateAgencyFinalCutOffDate)))) continue;
            invoice.getInvoiceGeneralDetail().setDunningLetterTemplateAssigned(foundDunningLetterTemplate);
            this.businessObjectService.save((PersistableBusinessObject)invoice.getInvoiceGeneralDetail());
            eligibleInvoices.add(invoice);
        }
        return eligibleInvoices;
    }

    protected Integer[] getAgingBucketStartAndEnd(String agingBucket, Integer cutoffDateFinal) {
        if (StringUtils.isNotBlank((CharSequence)agingBucket)) {
            Integer agingBucketEndValue;
            Integer agingBucketStartValue;
            if (agingBucket.equalsIgnoreCase("Current")) {
                agingBucketStartValue = 0;
                agingBucketEndValue = 30;
            } else if (agingBucket.equalsIgnoreCase("FINAL") || agingBucket.equalsIgnoreCase("State Agency FINAL")) {
                agingBucketStartValue = cutoffDateFinal + 1;
                agingBucketEndValue = 0;
            } else if (agingBucket.equalsIgnoreCase("121+")) {
                agingBucketStartValue = 121;
                agingBucketEndValue = cutoffDateFinal;
            } else {
                agingBucketStartValue = new Integer(agingBucket.split("-")[0]);
                agingBucketEndValue = new Integer(agingBucket.split("-")[1]);
            }
            if (agingBucketStartValue != null && agingBucketEndValue != null) {
                Integer[] returnContainer = new Integer[]{agingBucketStartValue, agingBucketEndValue};
                return returnContainer;
            }
        }
        return null;
    }

    protected boolean isInvoiceGenerallyEligibleForDunningLetter(ContractsGrantsInvoiceDocument invoice) {
        if (ObjectUtils.isNull((Object)invoice.getAge())) {
            return false;
        }
        if (ObjectUtils.isNull((Object)((Object)invoice.getInvoiceGeneralDetail())) || ObjectUtils.isNull((Object)invoice.getInvoiceGeneralDetail().getAward()) || ObjectUtils.isNull((Object)invoice.getInvoiceGeneralDetail().getAward().getDunningCampaign())) {
            return false;
        }
        String dunningCampaignCode = invoice.getInvoiceGeneralDetail().getAward().getDunningCampaign();
        DunningCampaign dunningCampaign = (DunningCampaign)this.businessObjectService.findBySinglePrimaryKey(DunningCampaign.class, (Object)dunningCampaignCode);
        return !ObjectUtils.isNull((Object)((Object)dunningCampaign)) && dunningCampaign.isActive();
    }

    protected boolean doesInvoiceMatchCollectorCriteria(ContractsGrantsInvoiceDocument invoice, String collectorPrincipalIdParameter, String collectorPrincipalNameParameter) {
        String collectorPrincipalId = collectorPrincipalIdParameter;
        boolean checkCollector = StringUtils.isNotBlank((CharSequence)collectorPrincipalId);
        boolean isCollector = true;
        if (StringUtils.isNotBlank((CharSequence)collectorPrincipalNameParameter)) {
            checkCollector = true;
            Person collectorObj = this.personService.getPersonByPrincipalName(collectorPrincipalNameParameter);
            if (collectorObj != null) {
                collectorPrincipalId = collectorObj.getPrincipalId();
            } else {
                isCollector = false;
            }
        }
        return !checkCollector || isCollector && this.contractsGrantsInvoiceDocumentService.canViewInvoice(invoice, collectorPrincipalId);
    }

    protected boolean doesInvoiceMatchAwardCriteria(ContractsGrantsInvoiceDocument invoice, String agencyNumberParameter, String campaignIdParameter) {
        if (StringUtils.isNotBlank((CharSequence)agencyNumberParameter) && !StringUtils.equals((CharSequence)invoice.getInvoiceGeneralDetail().getAward().getAgencyNumber(), (CharSequence)agencyNumberParameter)) {
            return false;
        }
        return StringUtils.isBlank((CharSequence)campaignIdParameter) || StringUtils.equals((CharSequence)invoice.getInvoiceGeneralDetail().getAward().getDunningCampaign(), (CharSequence)campaignIdParameter);
    }

    protected boolean doesInvoiceFitWithinAgingBucket(ContractsGrantsInvoiceDocument invoice, String agingBucket, Integer agingBucketStart, Integer agingBucketEnd, String stateAgencyFinalCutOffDate) {
        if (agingBucketStart == null || agingBucketEnd == null) {
            return true;
        }
        if (invoice.getInvoiceGeneralDetail().getAward().getAgency().isStateAgencyIndicator()) {
            if (agingBucket.equalsIgnoreCase("State Agency FINAL")) {
                agingBucketStart = new Integer(stateAgencyFinalCutOffDate) + 1;
                agingBucketEnd = 0;
            } else if (agingBucket.equalsIgnoreCase("121+")) {
                agingBucketStart = 121;
                agingBucketEnd = new Integer(stateAgencyFinalCutOffDate);
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)agingBucket, (CharSequence)"FINAL")) {
            return !invoice.getInvoiceGeneralDetail().getAward().getAgency().isStateAgencyIndicator() && invoice.getAge() >= agingBucketStart;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)agingBucket, (CharSequence)"State Agency FINAL")) {
            return invoice.getInvoiceGeneralDetail().getAward().getAgency().isStateAgencyIndicator() && invoice.getAge() >= agingBucketStart;
        }
        return invoice.getAge() >= agingBucketStart && invoice.getAge() <= agingBucketEnd;
    }

    protected String findMatchingDunningLetterTemplate(ContractsGrantsInvoiceDocument invoice, Integer cutoffDateFinal, String stateAgencyFinalCutOffDate) {
        ContractsAndGrantsBillingAgency agency = invoice.getInvoiceGeneralDetail().getAward().getAgency();
        String dunningCampaignCode = invoice.getInvoiceGeneralDetail().getAward().getDunningCampaign();
        DunningCampaign dunningCampaign = (DunningCampaign)this.businessObjectService.findBySinglePrimaryKey(DunningCampaign.class, (Object)dunningCampaignCode);
        List<DunningLetterDistribution> dunningLetterDistributions = dunningCampaign.getDunningLetterDistributions();
        if (CollectionUtils.isEmpty(dunningLetterDistributions)) {
            return null;
        }
        for (DunningLetterDistribution dunningLetterDistribution : dunningLetterDistributions) {
            DunningLetterTemplate dunningLetterTemplate = (DunningLetterTemplate)this.getBusinessObjectService().findBySinglePrimaryKey(DunningLetterTemplate.class, (Object)dunningLetterDistribution.getDunningLetterTemplate());
            if (StringUtils.equalsIgnoreCase((CharSequence)dunningLetterDistribution.getDaysPastDue(), (CharSequence)"Current")) {
                if (invoice.getAge() < 0 || invoice.getAge() > 30 || !dunningLetterDistribution.isActiveIndicator() || !dunningLetterDistribution.isSendDunningLetterIndicator() || !dunningLetterTemplate.isActive() || !ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) continue;
                return dunningLetterDistribution.getDunningLetterTemplate();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)dunningLetterDistribution.getDaysPastDue(), (CharSequence)"31-60")) {
                if (invoice.getAge() <= 30 || invoice.getAge() > 60 || !dunningLetterDistribution.isActiveIndicator() || !dunningLetterDistribution.isSendDunningLetterIndicator() || !dunningLetterTemplate.isActive() || !ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) continue;
                return dunningLetterDistribution.getDunningLetterTemplate();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)dunningLetterDistribution.getDaysPastDue(), (CharSequence)"61-90")) {
                if (invoice.getAge() <= 60 || invoice.getAge() > 90 || !dunningLetterDistribution.isActiveIndicator() || !dunningLetterDistribution.isSendDunningLetterIndicator() || !dunningLetterTemplate.isActive() || !ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) continue;
                return dunningLetterDistribution.getDunningLetterTemplate();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)dunningLetterDistribution.getDaysPastDue(), (CharSequence)"91-120")) {
                if (invoice.getAge() <= 90 || invoice.getAge() > 120 || !dunningLetterDistribution.isActiveIndicator() || !dunningLetterDistribution.isSendDunningLetterIndicator() || !dunningLetterTemplate.isActive() || !ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) continue;
                return dunningLetterDistribution.getDunningLetterTemplate();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)dunningLetterDistribution.getDaysPastDue(), (CharSequence)"121+")) {
                int cutoffDate = cutoffDateFinal;
                if (agency.isStateAgencyIndicator()) {
                    cutoffDate = Integer.parseInt(stateAgencyFinalCutOffDate);
                }
                if (invoice.getAge() <= 120 || invoice.getAge() > cutoffDate || !dunningLetterDistribution.isActiveIndicator() || !dunningLetterDistribution.isSendDunningLetterIndicator() || !dunningLetterTemplate.isActive() || !ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) continue;
                return dunningLetterDistribution.getDunningLetterTemplate();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)dunningLetterDistribution.getDaysPastDue(), (CharSequence)"FINAL")) {
                if (agency.isStateAgencyIndicator() || invoice.getAge() <= cutoffDateFinal || !dunningLetterDistribution.isActiveIndicator() || !dunningLetterDistribution.isSendDunningLetterIndicator() || !dunningLetterTemplate.isActive() || !ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) continue;
                return dunningLetterDistribution.getDunningLetterTemplate();
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)dunningLetterDistribution.getDaysPastDue(), (CharSequence)"State Agency FINAL") || !agency.isStateAgencyIndicator()) continue;
            cutoffDateFinal = Integer.parseInt(stateAgencyFinalCutOffDate);
            if (invoice.getAge() <= cutoffDateFinal || !dunningLetterDistribution.isActiveIndicator() || !dunningLetterDistribution.isSendDunningLetterIndicator() || !dunningLetterTemplate.isActive() || !ObjectUtils.isNotNull((Object)dunningLetterTemplate.getFilename())) continue;
            return dunningLetterDistribution.getDunningLetterTemplate();
        }
        return null;
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            results.sort((Comparator)new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    protected List<? extends BusinessObject> getSearchResultsHelper(Map<String, String> fieldValues, boolean unbounded) {
        return this.getContractsAndGrantsModuleBillingService().lookupAwards(fieldValues, unbounded);
    }

    protected Column setupResultsColumn(BusinessObject element, String attributeName, BusinessObjectRestrictions businessObjectRestrictions) {
        Column col = new Column();
        col.setPropertyName(attributeName);
        String columnTitle = this.getDataDictionaryService().getAttributeLabel(element.getClass(), attributeName);
        if (StringUtils.isBlank((CharSequence)columnTitle)) {
            columnTitle = this.getDataDictionaryService().getCollectionLabel(element.getClass(), attributeName);
        }
        col.setColumnTitle(columnTitle);
        col.setMaxLength(this.getDataDictionaryService().getAttributeMaxLength(element.getClass(), attributeName).intValue());
        try {
            Class formatterClass = this.getDataDictionaryService().getAttributeFormatter(element.getClass(), attributeName);
            Formatter formatter = null;
            if (ObjectUtils.isNotNull((Object)formatterClass)) {
                formatter = (Formatter)formatterClass.newInstance();
                col.setFormatter(formatter);
            }
            String propValue = "";
            Object prop = ObjectUtils.getPropertyValue((Object)element, (String)attributeName);
            Class<?> propClass = null;
            PropertyDescriptor propDescriptor = PropertyUtils.getPropertyDescriptor((Object)element, (String)col.getPropertyName());
            if (ObjectUtils.isNotNull((Object)propDescriptor)) {
                propClass = propDescriptor.getPropertyType();
            }
            if (ObjectUtils.isNotNull((Object)prop)) {
                propValue = this.getContractsGrantsReportHelperService().formatByType(prop, formatter);
            }
            col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass(propClass));
            col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass(propClass));
            propValue = super.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
            col.setPropertyValue(propValue);
            if (StringUtils.isNotBlank((CharSequence)propValue)) {
                col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
            }
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Unable to get new instance of formatter class for property " + col.getPropertyName(), ie);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException("Cannot access PropertyType for property '" + col.getPropertyName() + "'  on an instance of '" + element.getClass().getName() + "'.", ex);
        }
        return col;
    }

    protected Collection<Column> getColumns(BusinessObject bo, BusinessObjectRestrictions businessObjectRestrictions) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String attributeName : this.getBusinessObjectDictionaryService().getLookupResultFieldNames(bo.getClass())) {
            columns.add(this.setupResultsColumn(bo, attributeName, businessObjectRestrictions));
        }
        return columns;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public DunningLetterService getDunningLetterService() {
        return this.dunningLetterService;
    }

    public void setDunningLetterService(DunningLetterService dunningLetterService) {
        this.dunningLetterService = dunningLetterService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

