/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddressEmail;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoice;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoiceRecurrenceDetails;
import org.kuali.kfs.integration.ar.AccountsReceivableDocumentHeader;
import org.kuali.kfs.kew.api.action.WorkflowAction;
import org.kuali.kfs.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Copyable;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceRecurrenceDetails;
import org.kuali.kfs.module.ar.businessobject.CustomerProcessingType;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.businessobject.PrintInvoiceOptions;
import org.kuali.kfs.module.ar.businessobject.ReceivableCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.SalesTaxCustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableTaxService;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.TaxDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentBase;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.Correctable;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.dataaccess.FinancialSystemDocumentHeaderDao;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.TaxService;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class CustomerInvoiceDocument
extends AccountingDocumentBase
implements AmountTotaling,
Copyable,
Correctable,
Comparable<CustomerInvoiceDocument>,
AccountsReceivableCustomerInvoice {
    protected static final String HAS_RECCURENCE_NODE = "HasReccurence";
    protected static final String BATCH_GENERATED_NODE = "BatchGenerated";
    protected String invoiceHeaderText;
    protected String invoiceAttentionLineText;
    protected Date invoiceDueDate;
    protected Date billingDate;
    protected Date closedDate;
    protected Date billingDateForDisplay;
    protected String invoiceTermsText;
    protected String organizationInvoiceNumber;
    protected String customerPurchaseOrderNumber;
    protected String printInvoiceIndicator;
    protected Date customerPurchaseOrderDate;
    protected String billByChartOfAccountCode;
    protected String billedByOrganizationCode;
    protected Integer customerShipToAddressIdentifier;
    protected Integer customerBillToAddressIdentifier;
    protected String customerSpecialProcessingCode;
    protected boolean customerRecordAttachmentIndicator;
    protected boolean openInvoiceIndicator;
    protected Date printDate;
    protected Integer age;
    protected String customerName;
    protected String billingAddressName;
    protected String billingCityName;
    protected String billingStateCode;
    protected String billingZipCode;
    protected String billingCountryCode;
    protected String billingAddressInternationalProvinceName;
    protected String billingInternationalMailCode;
    protected String billingEmailAddress;
    protected String billingAddressTypeCode;
    protected String billingLine1StreetAddress;
    protected String billingLine2StreetAddress;
    protected String shippingLine1StreetAddress;
    protected String shippingLine2StreetAddress;
    protected String shippingAddressName;
    protected String shippingCityName;
    protected String shippingStateCode;
    protected String shippingZipCode;
    protected String shippingCountryCode;
    protected String shippingAddressInternationalProvinceName;
    protected String shippingInternationalMailCode;
    protected String shippingEmailAddress;
    protected String shippingAddressTypeCode;
    protected boolean recurredInvoiceIndicator;
    protected Date reportedDate;
    protected org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader accountsReceivableDocumentHeader;
    protected Chart billByChartOfAccount;
    protected Organization billedByOrganization;
    protected CustomerProcessingType customerSpecialProcessing;
    protected PrintInvoiceOptions printInvoiceOption;
    protected CustomerAddress customerShipToAddress;
    protected CustomerAddress customerBillToAddress;
    protected CustomerInvoiceRecurrenceDetails customerInvoiceRecurrenceDetails;
    private Timestamp agingReportSentTime;

    public KualiDecimal getOpenAmount() {
        return ((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).getOpenAmountForCustomerInvoiceDocument(this);
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getInvoiceHeaderText() {
        return this.invoiceHeaderText;
    }

    public void setInvoiceHeaderText(String invoiceHeaderText) {
        this.invoiceHeaderText = invoiceHeaderText;
    }

    public String getInvoiceAttentionLineText() {
        return this.invoiceAttentionLineText;
    }

    public void setInvoiceAttentionLineText(String invoiceAttentionLineText) {
        this.invoiceAttentionLineText = invoiceAttentionLineText;
    }

    public Date getInvoiceDueDate() {
        return this.invoiceDueDate;
    }

    public void setInvoiceDueDate(Date invoiceDueDate) {
        this.invoiceDueDate = invoiceDueDate;
    }

    public Date getBillingDate() {
        return this.billingDate;
    }

    public Integer getAge() {
        if (ObjectUtils.isNotNull((Object)this.billingDate)) {
            return (int)KfsDateUtils.getDifferenceInDays((Timestamp)new Timestamp(this.billingDate.getTime()), (Timestamp)((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
        }
        return null;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public void setBillingDate(Date billingDate) {
        this.billingDate = billingDate;
    }

    public String getInvoiceTermsText() {
        return this.invoiceTermsText;
    }

    public void setInvoiceTermsText(String invoiceTermsText) {
        this.invoiceTermsText = invoiceTermsText;
    }

    public String getOrganizationInvoiceNumber() {
        return this.organizationInvoiceNumber;
    }

    public void setOrganizationInvoiceNumber(String organizationInvoiceNumber) {
        this.organizationInvoiceNumber = organizationInvoiceNumber;
    }

    public String getCustomerPurchaseOrderNumber() {
        return this.customerPurchaseOrderNumber;
    }

    public void setCustomerPurchaseOrderNumber(String customerPurchaseOrderNumber) {
        this.customerPurchaseOrderNumber = customerPurchaseOrderNumber;
    }

    public String getPrintInvoiceIndicator() {
        return this.printInvoiceIndicator;
    }

    public void setPrintInvoiceIndicator(String printInvoiceIndicator) {
        this.printInvoiceIndicator = printInvoiceIndicator;
    }

    public Date getCustomerPurchaseOrderDate() {
        return this.customerPurchaseOrderDate;
    }

    public void setCustomerPurchaseOrderDate(Date customerPurchaseOrderDate) {
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    public String getBillByChartOfAccountCode() {
        return this.billByChartOfAccountCode;
    }

    public void setBillByChartOfAccountCode(String billByChartOfAccountCode) {
        this.billByChartOfAccountCode = billByChartOfAccountCode;
    }

    public String getBilledByOrganizationCode() {
        return this.billedByOrganizationCode;
    }

    public void setBilledByOrganizationCode(String billedByOrganizationCode) {
        this.billedByOrganizationCode = billedByOrganizationCode;
    }

    public Integer getCustomerShipToAddressIdentifier() {
        return this.customerShipToAddressIdentifier;
    }

    public void setCustomerShipToAddressIdentifier(Integer customerShipToAddressIdentifier) {
        this.customerShipToAddressIdentifier = customerShipToAddressIdentifier;
    }

    public Integer getCustomerBillToAddressIdentifier() {
        return this.customerBillToAddressIdentifier;
    }

    public void setCustomerBillToAddressIdentifier(Integer customerBillToAddressIdentifier) {
        this.customerBillToAddressIdentifier = customerBillToAddressIdentifier;
    }

    public String getCustomerSpecialProcessingCode() {
        return this.customerSpecialProcessingCode;
    }

    public void setCustomerSpecialProcessingCode(String customerSpecialProcessingCode) {
        this.customerSpecialProcessingCode = customerSpecialProcessingCode;
    }

    public boolean isCustomerRecordAttachmentIndicator() {
        return this.customerRecordAttachmentIndicator;
    }

    public void setCustomerRecordAttachmentIndicator(boolean customerRecordAttachmentIndicator) {
        this.customerRecordAttachmentIndicator = customerRecordAttachmentIndicator;
    }

    public boolean isOpenInvoiceIndicator() {
        return this.openInvoiceIndicator;
    }

    public void setOpenInvoiceIndicator(boolean openInvoiceIndicator) {
        this.openInvoiceIndicator = openInvoiceIndicator;
    }

    public Date getPrintDate() {
        return this.printDate;
    }

    public void setPrintDate(Date printDate) {
        this.printDate = printDate;
    }

    public org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader getAccountsReceivableDocumentHeader() {
        return this.accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = accountsReceivableDocumentHeader;
    }

    public void setAccountsReceivableDocumentHeader(AccountsReceivableDocumentHeader accountsReceivableDocumentHeader) {
        this.accountsReceivableDocumentHeader = (org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader)accountsReceivableDocumentHeader;
    }

    public String getParentInvoiceNumber() {
        return this.getAccountsReceivableDocumentHeader().getDocumentHeader().getDocumentTemplateNumber();
    }

    public Chart getBillByChartOfAccount() {
        return this.billByChartOfAccount;
    }

    @Deprecated
    public void setBillByChartOfAccount(Chart billByChartOfAccount) {
        this.billByChartOfAccount = billByChartOfAccount;
    }

    public Organization getBilledByOrganization() {
        return this.billedByOrganization;
    }

    @Deprecated
    public void setBilledByOrganization(Organization billedByOrganization) {
        this.billedByOrganization = billedByOrganization;
    }

    public CustomerProcessingType getCustomerSpecialProcessing() {
        return this.customerSpecialProcessing;
    }

    @Deprecated
    public void setCustomerSpecialProcessing(CustomerProcessingType customerSpecialProcessing) {
        this.customerSpecialProcessing = customerSpecialProcessing;
    }

    public Date getBillingDateForDisplay() {
        if (ObjectUtils.isNotNull((Object)this.getBillingDate())) {
            return this.getBillingDate();
        }
        return ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
    }

    public void setBillingDateForDisplay(Date date) {
    }

    public Date getClosedDate() {
        return this.closedDate;
    }

    public void setClosedDate(Date closedDate) {
        this.closedDate = closedDate;
    }

    public boolean hasInvoiceBeenCorrected() {
        DocumentHeader documentHeader = ((FinancialSystemDocumentHeaderDao)SpringContext.getBean(FinancialSystemDocumentHeaderDao.class)).getCorrectingDocumentHeader(this.documentNumber);
        return ObjectUtils.isNotNull((Object)documentHeader) && StringUtils.isNotBlank((CharSequence)documentHeader.getDocumentNumber());
    }

    public boolean isInvoiceReversal() {
        return ObjectUtils.isNotNull((Object)this.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber());
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return ((CustomerInvoiceDetail)postable).isDebit();
    }

    public Class<CustomerInvoiceDetail> getSourceAccountingLineClass() {
        return CustomerInvoiceDetail.class;
    }

    public void updateAccountReceivableObjectCodes() {
        for (Object accountingLine : this.getSourceAccountingLines()) {
            ((CustomerInvoiceDetailService)SpringContext.getBean(CustomerInvoiceDetailService.class)).updateAccountsReceivableObjectCode((CustomerInvoiceDetail)accountingLine);
        }
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        this.addReceivableGLPEs(sequenceHelper, glpeSourceDetail);
        sequenceHelper.increment();
        this.addIncomeGLPEs(sequenceHelper, glpeSourceDetail);
        if (((AccountsReceivableTaxService)SpringContext.getBean(AccountsReceivableTaxService.class)).isCustomerInvoiceDetailTaxable(this, (CustomerInvoiceDetail)glpeSourceDetail)) {
            this.addSalesTaxGLPEs(sequenceHelper, glpeSourceDetail);
        }
        return true;
    }

    protected void addReceivableGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)glpeSourceDetail;
        ReceivableCustomerInvoiceDetail receivableCustomerInvoiceDetail = new ReceivableCustomerInvoiceDetail(customerInvoiceDetail, this);
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        service.createAndAddGenericInvoiceRelatedGLPEs((GeneralLedgerPendingEntrySource)this, (GeneralLedgerPendingEntrySourceDetail)receivableCustomerInvoiceDetail, sequenceHelper, this.isInvoiceDetailReceivableDebit(customerInvoiceDetail), false, customerInvoiceDetail.getInvoiceItemPreTaxAmount());
    }

    protected boolean isInvoiceDetailReceivableDebit(CustomerInvoiceDetail customerInvoiceDetail) {
        return !this.isInvoiceReversal() && !customerInvoiceDetail.isDiscountLine() || this.isInvoiceReversal() && customerInvoiceDetail.isDiscountLine();
    }

    protected void addIncomeGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)glpeSourceDetail;
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        service.createAndAddGenericInvoiceRelatedGLPEs((GeneralLedgerPendingEntrySource)this, (GeneralLedgerPendingEntrySourceDetail)customerInvoiceDetail, sequenceHelper, this.isInvoiceDetailIncomeDebit(customerInvoiceDetail), false, customerInvoiceDetail.getInvoiceItemPreTaxAmount());
    }

    protected boolean isInvoiceDetailIncomeDebit(CustomerInvoiceDetail customerInvoiceDetail) {
        return !this.isInvoiceReversal() && customerInvoiceDetail.isDiscountLine() || this.isInvoiceReversal() && !customerInvoiceDetail.isDiscountLine();
    }

    protected void addSalesTaxGLPEs(GeneralLedgerPendingEntrySequenceHelper sequenceHelper, GeneralLedgerPendingEntrySourceDetail glpeSourceDetail) {
        CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)glpeSourceDetail;
        boolean isDebit = !this.isInvoiceReversal() && customerInvoiceDetail.isDiscountLine() || this.isInvoiceReversal() && !customerInvoiceDetail.isDiscountLine();
        String postalCode = ((AccountsReceivableTaxService)SpringContext.getBean(AccountsReceivableTaxService.class)).getPostalCodeForTaxation(this);
        Date dateOfTransaction = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        List salesTaxDetails = ((TaxService)SpringContext.getBean(TaxService.class)).getSalesTaxDetails(dateOfTransaction, postalCode, customerInvoiceDetail.getInvoiceItemPreTaxAmount());
        AccountsReceivablePendingEntryService service = (AccountsReceivablePendingEntryService)SpringContext.getBean(AccountsReceivablePendingEntryService.class);
        for (TaxDetail salesTaxDetail : salesTaxDetails) {
            SalesTaxCustomerInvoiceDetail salesTaxCustomerInvoiceDetail = new SalesTaxCustomerInvoiceDetail(salesTaxDetail, customerInvoiceDetail);
            ReceivableCustomerInvoiceDetail receivableCustomerInvoiceDetail = new ReceivableCustomerInvoiceDetail(salesTaxCustomerInvoiceDetail, this);
            sequenceHelper.increment();
            service.createAndAddGenericInvoiceRelatedGLPEs((GeneralLedgerPendingEntrySource)this, (GeneralLedgerPendingEntrySourceDetail)receivableCustomerInvoiceDetail, sequenceHelper, !isDebit, false, salesTaxDetail.getTaxAmount());
            sequenceHelper.increment();
            service.createAndAddGenericInvoiceRelatedGLPEs((GeneralLedgerPendingEntrySource)this, (GeneralLedgerPendingEntrySourceDetail)salesTaxCustomerInvoiceDetail, sequenceHelper, isDebit, false, salesTaxDetail.getTaxAmount());
        }
    }

    public GeneralLedgerPendingEntryService getGeneralLedgerPendingEntryService() {
        return (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class);
    }

    public List<String> getWorkflowEngineDocumentIdsToLock() {
        if (this.isInvoiceReversal() && StringUtils.isNotBlank((CharSequence)this.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber())) {
            ArrayList<String> documentIds = new ArrayList<String>();
            documentIds.add(this.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber());
            return documentIds;
        }
        return null;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (!this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            return;
        }
        if (ObjectUtils.isNull((Object)this.getBillingDate())) {
            this.setBillingDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDateMidnight());
        }
        CustomerInvoiceDocumentService invoiceService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
        invoiceService.convertDiscountsToPaidApplieds(this);
        if (this.isInvoiceReversal()) {
            CustomerInvoiceDocument correctedCustomerInvoiceDocument = (CustomerInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(this.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber());
            ((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).closeCustomerInvoiceDocument(correctedCustomerInvoiceDocument);
            ((CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class)).closeCustomerInvoiceDocument(this);
        }
        if (!(ObjectUtils.isNull((Object)((Object)this.getCustomerInvoiceRecurrenceDetails())) || ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate()) && ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate()) && ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceIntervalCode()) && ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber()) && ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentInitiatorUserIdentifier()))) {
            UserSession currentSession = GlobalVariables.getUserSession();
            GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
            InvoiceRecurrence newInvoiceRecurrence = new InvoiceRecurrence();
            newInvoiceRecurrence.setInvoiceNumber(this.getCustomerInvoiceRecurrenceDetails().getInvoiceNumber());
            newInvoiceRecurrence.setCustomerNumber(this.getCustomerInvoiceRecurrenceDetails().getCustomerNumber());
            newInvoiceRecurrence.setDocumentRecurrenceBeginDate(this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate());
            newInvoiceRecurrence.setDocumentRecurrenceEndDate(this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate());
            newInvoiceRecurrence.setDocumentRecurrenceIntervalCode(this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceIntervalCode());
            newInvoiceRecurrence.setDocumentTotalRecurrenceNumber(this.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber());
            newInvoiceRecurrence.setDocumentInitiatorUserIdentifier(this.getCustomerInvoiceRecurrenceDetails().getDocumentInitiatorUserIdentifier());
            newInvoiceRecurrence.setActive(this.getCustomerInvoiceRecurrenceDetails().isActive());
            MaintenanceDocument invoiceRecurrenceMaintDoc = (MaintenanceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument(this.getInvoiceRecurrenceMaintenanceDocumentTypeName());
            invoiceRecurrenceMaintDoc.getDocumentHeader().setDocumentDescription("Automatically created from Invoice");
            invoiceRecurrenceMaintDoc.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)newInvoiceRecurrence);
            ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)invoiceRecurrenceMaintDoc);
            invoiceRecurrenceMaintDoc.getDocumentHeader().getWorkflowDocument().route("Automatically created and routed by CustomerInvoiceDocument #" + this.getDocumentNumber() + ".");
            GlobalVariables.setUserSession((UserSession)currentSession);
        }
    }

    protected String getInvoiceRecurrenceMaintenanceDocumentTypeName() {
        return "INVR";
    }

    public void prepareForSave() {
        if (this.isInvoiceReversal()) {
            this.setOpenInvoiceIndicator(false);
        }
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(this.getTotalDollarAmount());
        this.captureWorkflowHeaderInformation();
        if (ObjectUtils.isNotNull((Object)((Object)this.getCustomerInvoiceRecurrenceDetails())) && this.getProcessRecurrenceFlag()) {
            Calendar beginCalendar;
            if (ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getCustomerNumber())) {
                this.getCustomerInvoiceRecurrenceDetails().setCustomerNumber(this.getAccountsReceivableDocumentHeader().getCustomerNumber());
            }
            this.customerInvoiceRecurrenceDetails.setInvoiceNumber(this.getDocumentNumber());
            if (ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber()) && ObjectUtils.isNotNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate())) {
                beginCalendar = Calendar.getInstance();
                beginCalendar.setTime(this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate());
                Date beginDate = this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate();
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.setTime(this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate());
                Date endDate = this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate();
                Calendar nextCalendar = Calendar.getInstance();
                int totalRecurrences = 0;
                int addCounter = 0;
                String intervalCode = this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceIntervalCode();
                if ("M".equals(intervalCode)) {
                    addCounter = 1;
                }
                if ("Q".equals(intervalCode)) {
                    addCounter = 3;
                }
                while (!beginDate.after(endDate)) {
                    beginCalendar.setTime(beginDate);
                    beginCalendar.add(2, addCounter);
                    beginDate = KfsDateUtils.convertToSqlDate((java.util.Date)beginCalendar.getTime());
                    ++totalRecurrences;
                    Date nextDate = beginDate;
                    nextCalendar.setTime(nextDate);
                    nextCalendar.add(2, addCounter);
                    nextDate = KfsDateUtils.convertToSqlDate((java.util.Date)nextCalendar.getTime());
                    if (!endDate.after(beginDate) || !endDate.before(nextDate)) continue;
                    ++totalRecurrences;
                    break;
                }
                if (totalRecurrences > 0) {
                    this.getCustomerInvoiceRecurrenceDetails().setDocumentTotalRecurrenceNumber(totalRecurrences);
                }
            }
            if (ObjectUtils.isNotNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber()) && ObjectUtils.isNull((Object)this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate())) {
                beginCalendar = Calendar.getInstance();
                beginCalendar.setTime(new Timestamp(this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate().getTime()));
                Calendar endCalendar = beginCalendar;
                int addCounter = 0;
                Integer documentTotalRecurrenceNumber = this.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber();
                String intervalCode = this.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceIntervalCode();
                if ("M".equals(intervalCode)) {
                    addCounter = -1;
                    addCounter += documentTotalRecurrenceNumber.intValue();
                }
                if ("Q".equals(intervalCode)) {
                    addCounter = -3;
                    addCounter += documentTotalRecurrenceNumber * 3;
                }
                endCalendar.add(2, addCounter);
                this.getCustomerInvoiceRecurrenceDetails().setDocumentRecurrenceEndDate(KfsDateUtils.convertToSqlDate((java.util.Date)endCalendar.getTime()));
            }
        }
        this.setBilledByOrganizationCode(StringUtils.upperCase((String)this.billedByOrganizationCode));
        this.accountsReceivableDocumentHeader.setProcessingOrganizationCode(StringUtils.upperCase((String)this.accountsReceivableDocumentHeader.getProcessingOrganizationCode()));
        this.accountsReceivableDocumentHeader.setCustomerNumber(StringUtils.upperCase((String)this.accountsReceivableDocumentHeader.getCustomerNumber()));
        if (ObjectUtils.isNull((Object)this.getCustomerShipToAddressIdentifier())) {
            this.setCustomerShipToAddress(null);
            this.setCustomerShipToAddressOnInvoice(null);
        }
    }

    public boolean getProcessRecurrenceFlag() {
        CustomerInvoiceRecurrenceDetails rec = this.getCustomerInvoiceRecurrenceDetails();
        boolean processRecurrenceFlag = null != rec.getDocumentRecurrenceIntervalCode();
        processRecurrenceFlag &= null != rec.getDocumentRecurrenceBeginDate();
        processRecurrenceFlag &= null != rec.getDocumentRecurrenceEndDate() || null != rec.getDocumentTotalRecurrenceNumber();
        processRecurrenceFlag &= rec.isActive();
        return processRecurrenceFlag &= null != rec.getDocumentInitiatorUserIdentifier();
    }

    public boolean getNoRecurrenceDataFlag() {
        CustomerInvoiceRecurrenceDetails rec = this.getCustomerInvoiceRecurrenceDetails();
        boolean noRecurrenceDataFlag = ObjectUtils.isNull((Object)rec.getDocumentRecurrenceIntervalCode());
        noRecurrenceDataFlag &= ObjectUtils.isNull((Object)rec.getDocumentRecurrenceBeginDate());
        noRecurrenceDataFlag &= ObjectUtils.isNull((Object)rec.getDocumentRecurrenceEndDate());
        noRecurrenceDataFlag &= !rec.isActive();
        noRecurrenceDataFlag &= ObjectUtils.isNull((Object)rec.getDocumentTotalRecurrenceNumber());
        return noRecurrenceDataFlag &= ObjectUtils.isNull((Object)rec.getDocumentInitiatorUserIdentifier());
    }

    public void toCopy() {
        super.toCopy();
        CustomerInvoiceDocumentService customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
        customerInvoiceDocumentService.setupDefaultValuesForCopiedCustomerInvoiceDocument(this);
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(this.getTotalDollarAmount());
    }

    public void toErrorCorrection() {
        super.toErrorCorrection();
        this.negateCustomerInvoiceDetailUnitPrices();
        this.setOpenInvoiceIndicator(false);
        this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(this.getTotalDollarAmount());
        if (ObjectUtils.isNotNull((Object)((Object)this.customerInvoiceRecurrenceDetails))) {
            this.customerInvoiceRecurrenceDetails.setInvoiceNumber(this.documentNumber);
        }
    }

    public void negateCustomerInvoiceDetailUnitPrices() {
        for (Object accountingLine : this.getSourceAccountingLines()) {
            CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)accountingLine;
            customerInvoiceDetail.setInvoiceItemUnitPrice(customerInvoiceDetail.getInvoiceItemUnitPrice().negate());
            customerInvoiceDetail.setCustomerInvoiceDocument(null);
        }
    }

    public boolean hasAtLeastOneDiscount() {
        for (Object accountingLine : this.getSourceAccountingLines()) {
            CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)accountingLine;
            if (!customerInvoiceDetail.isDiscountLineParent()) continue;
            return true;
        }
        return false;
    }

    public boolean isDiscountLineBasedOnSequenceNumber(Integer sequenceNumber) {
        if (ObjectUtils.isNull((Object)sequenceNumber)) {
            return false;
        }
        for (Object accountingLine : this.getSourceAccountingLines()) {
            CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)accountingLine;
            Integer discLineNum = customerInvoiceDetail.getInvoiceItemDiscountLineNumber();
            if (!ObjectUtils.isNotNull((Object)discLineNum) || !sequenceNumber.equals(customerInvoiceDetail.getInvoiceItemDiscountLineNumber())) continue;
            return true;
        }
        return false;
    }

    public CustomerInvoiceDetail getParentLineBasedOnDiscountSequenceNumber(Integer discountSequenceNumber) {
        if (ObjectUtils.isNull((Object)discountSequenceNumber)) {
            return null;
        }
        for (Object accountingLine : this.getSourceAccountingLines()) {
            CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)accountingLine;
            Integer discLineNum = customerInvoiceDetail.getInvoiceItemDiscountLineNumber();
            if (!ObjectUtils.isNotNull((Object)discLineNum) || !discountSequenceNumber.equals(customerInvoiceDetail.getInvoiceItemDiscountLineNumber())) continue;
            return customerInvoiceDetail;
        }
        return null;
    }

    public void updateDiscountAndParentLineReferences() {
        for (Object accountingLine : this.getSourceAccountingLines()) {
            CustomerInvoiceDetail discount = (CustomerInvoiceDetail)accountingLine;
            CustomerInvoiceDetail parent = this.getParentLineBasedOnDiscountSequenceNumber(discount.getSequenceNumber());
            if (ObjectUtils.isNotNull((Object)parent)) {
                discount.setParentDiscountCustomerInvoiceDetail(parent);
                parent.setDiscountCustomerInvoiceDetail(discount);
                continue;
            }
            discount.setParentDiscountCustomerInvoiceDetail(null);
        }
    }

    public void removeDiscountLineBasedOnParentLineIndex(int parentLineIndex) {
        CustomerInvoiceDetail parentLine = (CustomerInvoiceDetail)this.getSourceAccountingLines().get(parentLineIndex);
        int discountLineIndex = -1;
        for (int i = 0; i < this.getSourceAccountingLines().size(); ++i) {
            if (!parentLine.getInvoiceItemDiscountLineNumber().equals(((CustomerInvoiceDetail)this.getSourceAccountingLines().get(i)).getSequenceNumber())) continue;
            discountLineIndex = i;
        }
        this.getSourceAccountingLines().remove(discountLineIndex);
    }

    public CustomerInvoiceRecurrenceDetails getCustomerInvoiceRecurrenceDetails() {
        return this.customerInvoiceRecurrenceDetails;
    }

    public void setCustomerInvoiceRecurrenceDetails(CustomerInvoiceRecurrenceDetails customerInvoiceRecurrenceDetails) {
        this.customerInvoiceRecurrenceDetails = customerInvoiceRecurrenceDetails;
    }

    public void setCustomerInvoiceRecurrenceDetails(AccountsReceivableCustomerInvoiceRecurrenceDetails customerInvoiceRecurrenceDetails) {
        this.customerInvoiceRecurrenceDetails = (CustomerInvoiceRecurrenceDetails)customerInvoiceRecurrenceDetails;
    }

    public CustomerAddress getCustomerShipToAddress() {
        return this.customerShipToAddress;
    }

    public void setCustomerShipToAddress(CustomerAddress customerShipToAddress) {
        this.customerShipToAddress = customerShipToAddress;
    }

    public CustomerAddress getCustomerBillToAddress() {
        return this.customerBillToAddress;
    }

    public void setCustomerBillToAddress(CustomerAddress customerBillToAddress) {
        this.customerBillToAddress = customerBillToAddress;
    }

    public void setCustomerBillToAddress(AccountsReceivableCustomerAddress customerBillToAddress) {
        this.customerBillToAddress = (CustomerAddress)customerBillToAddress;
    }

    public PrintInvoiceOptions getPrintInvoiceOption() {
        if (ObjectUtils.isNull((Object)((Object)this.printInvoiceOption)) && StringUtils.isNotEmpty((CharSequence)this.printInvoiceIndicator)) {
            this.refreshReferenceObject("printInvoiceOption");
        }
        return this.printInvoiceOption;
    }

    public void setPrintInvoiceOption(PrintInvoiceOptions printInvoiceOption) {
        this.printInvoiceOption = printInvoiceOption;
    }

    public KualiDecimal getInvoiceItemPreTaxAmountTotal() {
        KualiDecimal invoiceItemPreTaxAmountTotal = new KualiDecimal(0);
        for (Object accountingLine : this.getSourceAccountingLines()) {
            invoiceItemPreTaxAmountTotal = (KualiDecimal)invoiceItemPreTaxAmountTotal.add((AbstractKualiDecimal)((CustomerInvoiceDetail)accountingLine).getInvoiceItemPreTaxAmount());
        }
        return invoiceItemPreTaxAmountTotal;
    }

    public KualiDecimal getInvoiceItemTaxAmountTotal() {
        KualiDecimal invoiceItemTaxAmountTotal = new KualiDecimal(0);
        for (Object accountingLine : this.getSourceAccountingLines()) {
            invoiceItemTaxAmountTotal = (KualiDecimal)invoiceItemTaxAmountTotal.add((AbstractKualiDecimal)((CustomerInvoiceDetail)accountingLine).getInvoiceItemTaxAmount());
        }
        return invoiceItemTaxAmountTotal;
    }

    public CustomerAddress getPrimaryAddressForCustomerNumber() {
        if (ObjectUtils.isNotNull((Object)((Object)this.accountsReceivableDocumentHeader)) && StringUtils.isNotEmpty((CharSequence)this.accountsReceivableDocumentHeader.getCustomerNumber())) {
            return ((CustomerAddressService)SpringContext.getBean(CustomerAddressService.class)).getPrimaryAddress(this.accountsReceivableDocumentHeader.getCustomerNumber());
        }
        return null;
    }

    public Customer getCustomer() {
        if (ObjectUtils.isNotNull((Object)((Object)this.accountsReceivableDocumentHeader))) {
            return this.accountsReceivableDocumentHeader.getCustomer();
        }
        return null;
    }

    public List<CustomerInvoiceDetail> getCustomerInvoiceDetailsWithoutDiscounts() {
        ArrayList<CustomerInvoiceDetail> customerInvoiceDetailsWithoutDiscounts = new ArrayList<CustomerInvoiceDetail>();
        this.updateDiscountAndParentLineReferences();
        List customerInvoiceDetailsWithDiscounts = this.getSourceAccountingLines();
        for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceDetailsWithDiscounts) {
            if (customerInvoiceDetail.isDiscountLine()) continue;
            customerInvoiceDetail.setDocumentNumber(this.getDocumentNumber());
            customerInvoiceDetailsWithoutDiscounts.add(customerInvoiceDetail);
        }
        return customerInvoiceDetailsWithoutDiscounts;
    }

    public List<CustomerInvoiceDetail> getDiscounts() {
        ArrayList<CustomerInvoiceDetail> discounts = new ArrayList<CustomerInvoiceDetail>();
        this.updateDiscountAndParentLineReferences();
        List customerInvoiceDetailsWithDiscounts = this.getSourceAccountingLines();
        for (CustomerInvoiceDetail customerInvoiceDetail : customerInvoiceDetailsWithDiscounts) {
            if (!customerInvoiceDetail.isDiscountLine()) continue;
            customerInvoiceDetail.setDocumentNumber(this.getDocumentNumber());
            discounts.add(customerInvoiceDetail);
        }
        return discounts;
    }

    @Override
    public int compareTo(CustomerInvoiceDocument customerInvoiceDocument) {
        if (this.getBillByChartOfAccountCode().equals(customerInvoiceDocument.getBillByChartOfAccountCode()) && this.getBilledByOrganizationCode().equals(customerInvoiceDocument.getBilledByOrganizationCode())) {
            return 0;
        }
        return -1;
    }

    public boolean wouldPayOff(KualiDecimal additionalAmountToApply) {
        KualiDecimal openAmount = this.getOpenAmount();
        return KualiDecimal.ZERO.isGreaterEqual(openAmount.subtract((AbstractKualiDecimal)additionalAmountToApply));
    }

    public KualiDecimal getTotalDollarAmount() {
        return this.getSourceTotal();
    }

    public String getBillingAddressInternationalProvinceName() {
        return this.billingAddressInternationalProvinceName;
    }

    public void setBillingAddressInternationalProvinceName(String billingAddressInternationalProvinceName) {
        this.billingAddressInternationalProvinceName = billingAddressInternationalProvinceName;
    }

    public String getBillingAddressName() {
        return this.billingAddressName;
    }

    public void setBillingAddressName(String billingAddressName) {
        this.billingAddressName = billingAddressName;
    }

    public String getBillingAddressTypeCode() {
        return this.billingAddressTypeCode;
    }

    public void setBillingAddressTypeCode(String billingAddressTypeCode) {
        this.billingAddressTypeCode = billingAddressTypeCode;
    }

    public String getBillingCityName() {
        return this.billingCityName;
    }

    public void setBillingCityName(String billingCityName) {
        this.billingCityName = billingCityName;
    }

    public String getBillingCountryCode() {
        return this.billingCountryCode;
    }

    public void setBillingCountryCode(String billingCountryCode) {
        this.billingCountryCode = billingCountryCode;
    }

    public String getBillingEmailAddress() {
        return this.billingEmailAddress;
    }

    public void setBillingEmailAddress(String billingEmailAddress) {
        this.billingEmailAddress = billingEmailAddress;
    }

    public String getBillingInternationalMailCode() {
        return this.billingInternationalMailCode;
    }

    public void setBillingInternationalMailCode(String billingInternationalMailCode) {
        this.billingInternationalMailCode = billingInternationalMailCode;
    }

    public String getBillingStateCode() {
        return this.billingStateCode;
    }

    public void setBillingStateCode(String billingStateCode) {
        this.billingStateCode = billingStateCode;
    }

    public String getBillingZipCode() {
        return this.billingZipCode;
    }

    public void setBillingZipCode(String billingZipCode) {
        this.billingZipCode = billingZipCode;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getShippingAddressInternationalProvinceName() {
        return this.shippingAddressInternationalProvinceName;
    }

    public void setShippingAddressInternationalProvinceName(String shippingAddressInternationalProvinceName) {
        this.shippingAddressInternationalProvinceName = shippingAddressInternationalProvinceName;
    }

    public String getShippingAddressName() {
        return this.shippingAddressName;
    }

    public void setShippingAddressName(String shippingAddressName) {
        this.shippingAddressName = shippingAddressName;
    }

    public String getShippingAddressTypeCode() {
        return this.shippingAddressTypeCode;
    }

    public void setShippingAddressTypeCode(String shippingAddressTypeCode) {
        this.shippingAddressTypeCode = shippingAddressTypeCode;
    }

    public String getShippingCityName() {
        return this.shippingCityName;
    }

    public void setShippingCityName(String shippingCityName) {
        this.shippingCityName = shippingCityName;
    }

    public String getShippingCountryCode() {
        return this.shippingCountryCode;
    }

    public void setShippingCountryCode(String shippingCountryCode) {
        this.shippingCountryCode = shippingCountryCode;
    }

    public String getShippingEmailAddress() {
        return this.shippingEmailAddress;
    }

    public void setShippingEmailAddress(String shippingEmailAddress) {
        this.shippingEmailAddress = shippingEmailAddress;
    }

    public String getShippingInternationalMailCode() {
        return this.shippingInternationalMailCode;
    }

    public void setShippingInternationalMailCode(String shippingInternationalMailCode) {
        this.shippingInternationalMailCode = shippingInternationalMailCode;
    }

    public String getShippingStateCode() {
        return this.shippingStateCode;
    }

    public void setShippingStateCode(String shippingStateCode) {
        this.shippingStateCode = shippingStateCode;
    }

    public String getShippingZipCode() {
        return this.shippingZipCode;
    }

    public void setShippingZipCode(String shippingZipCode) {
        this.shippingZipCode = shippingZipCode;
    }

    public String getBillingLine1StreetAddress() {
        return this.billingLine1StreetAddress;
    }

    public void setBillingLine1StreetAddress(String billingLine1StreetAddress) {
        this.billingLine1StreetAddress = billingLine1StreetAddress;
    }

    public String getBillingLine2StreetAddress() {
        return this.billingLine2StreetAddress;
    }

    public void setBillingLine2StreetAddress(String billingLine2StreetAddress) {
        this.billingLine2StreetAddress = billingLine2StreetAddress;
    }

    public String getShippingLine1StreetAddress() {
        return this.shippingLine1StreetAddress;
    }

    public void setShippingLine1StreetAddress(String shippingLine1StreetAddress) {
        this.shippingLine1StreetAddress = shippingLine1StreetAddress;
    }

    public String getShippingLine2StreetAddress() {
        return this.shippingLine2StreetAddress;
    }

    public void setShippingLine2StreetAddress(String shippingLine2StreetAddress) {
        this.shippingLine2StreetAddress = shippingLine2StreetAddress;
    }

    public boolean getRecurredInvoiceIndicator() {
        return this.recurredInvoiceIndicator;
    }

    public void setRecurredInvoiceIndicator(boolean recurredInvoiceIndicator) {
        this.recurredInvoiceIndicator = recurredInvoiceIndicator;
    }

    public Date getReportedDate() {
        return this.reportedDate;
    }

    public void setReportedDate(Date reportedDate) {
        this.reportedDate = reportedDate;
    }

    public String getBilledByChartOfAccCodeAndOrgCode() {
        return this.getBillByChartOfAccountCode() + "/" + this.getBilledByOrganizationCode();
    }

    public void setCustomerBillToAddressOnInvoice(CustomerAddress customerBillToAddress) {
        this.accountsReceivableDocumentHeader.refreshReferenceObject("customer");
        if (ObjectUtils.isNotNull((Object)((Object)this.accountsReceivableDocumentHeader.getCustomer()))) {
            this.setCustomerName(this.accountsReceivableDocumentHeader.getCustomer().getCustomerName());
        }
        if (ObjectUtils.isNotNull((Object)customerBillToAddress)) {
            this.setBillingAddressTypeCode(customerBillToAddress.getCustomerAddressTypeCode());
            this.setBillingAddressName(customerBillToAddress.getCustomerAddressName());
            this.setBillingLine1StreetAddress(customerBillToAddress.getCustomerLine1StreetAddress());
            this.setBillingLine2StreetAddress(customerBillToAddress.getCustomerLine2StreetAddress());
            this.setBillingCityName(customerBillToAddress.getCustomerCityName());
            this.setBillingStateCode(customerBillToAddress.getCustomerStateCode());
            this.setBillingZipCode(customerBillToAddress.getCustomerZipCode());
            this.setBillingCountryCode(customerBillToAddress.getCustomerCountryCode());
            this.setBillingAddressInternationalProvinceName(customerBillToAddress.getCustomerAddressInternationalProvinceName());
            this.setBillingInternationalMailCode(customerBillToAddress.getCustomerInternationalMailCode());
            List<AccountsReceivableCustomerAddressEmail> customerBillToAddressEmails = customerBillToAddress.getCustomerAddressEmails();
            if (customerBillToAddressEmails.size() > 0) {
                this.setBillingEmailAddress(customerBillToAddressEmails.get(0).getCustomerEmailAddress());
            }
        }
    }

    public void setCustomerShipToAddressOnInvoice(CustomerAddress customerShipToAddress) {
        this.accountsReceivableDocumentHeader.refreshReferenceObject("customer");
        Customer customer = this.accountsReceivableDocumentHeader.getCustomer();
        if (ObjectUtils.isNotNull((Object)((Object)customer))) {
            this.setCustomerName(customer.getCustomerName());
        }
        if (ObjectUtils.isNotNull((Object)customerShipToAddress)) {
            this.setShippingAddressTypeCode(customerShipToAddress.getCustomerAddressTypeCode());
            this.setShippingAddressName(customerShipToAddress.getCustomerAddressName());
            this.setShippingLine1StreetAddress(customerShipToAddress.getCustomerLine1StreetAddress());
            this.setShippingLine2StreetAddress(customerShipToAddress.getCustomerLine2StreetAddress());
            this.setShippingCityName(customerShipToAddress.getCustomerCityName());
            this.setShippingStateCode(customerShipToAddress.getCustomerStateCode());
            this.setShippingZipCode(customerShipToAddress.getCustomerZipCode());
            this.setShippingCountryCode(customerShipToAddress.getCustomerCountryCode());
            this.setShippingAddressInternationalProvinceName(customerShipToAddress.getCustomerAddressInternationalProvinceName());
            this.setShippingInternationalMailCode(customerShipToAddress.getCustomerInternationalMailCode());
            List<AccountsReceivableCustomerAddressEmail> customerShipToAddressEmails = customerShipToAddress.getCustomerAddressEmails();
            if (customerShipToAddressEmails.size() > 0) {
                this.setShippingEmailAddress(customerShipToAddressEmails.get(0).getCustomerEmailAddress());
            }
        } else {
            this.setShippingAddressTypeCode(null);
            this.setShippingAddressName(null);
            this.setShippingLine1StreetAddress(null);
            this.setShippingLine2StreetAddress(null);
            this.setShippingCityName(null);
            this.setShippingStateCode(null);
            this.setShippingZipCode(null);
            this.setShippingCountryCode(null);
            this.setShippingAddressInternationalProvinceName(null);
            this.setShippingInternationalMailCode(null);
            this.setShippingEmailAddress(null);
        }
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (HAS_RECCURENCE_NODE.equals(nodeName)) {
            return this.hasRecurrence();
        }
        if (BATCH_GENERATED_NODE.equals(nodeName)) {
            return this.isBatchGenerated();
        }
        throw new UnsupportedOperationException("answerSplitNode('" + nodeName + "') was called but no handler for nodeName specified.");
    }

    protected boolean isBatchGenerated() {
        return this.recurredInvoiceIndicator;
    }

    protected boolean hasRecurrence() {
        return ObjectUtils.isNotNull((Object)((Object)this.getCustomerInvoiceRecurrenceDetails())) && this.getCustomerInvoiceRecurrenceDetails().isActive();
    }

    public void setBillingAddressTypeCodeAsPrimary() {
        this.setBillingAddressTypeCode("P");
    }

    public Timestamp getAgingReportSentTime() {
        return this.agingReportSentTime;
    }

    public void setAgingReportSentTime(Timestamp agingReportSentTime) {
        this.agingReportSentTime = agingReportSentTime;
    }

    public void doActionTaken(ActionTakenEvent event) {
        super.doActionTaken(event);
        if (event.getActionTaken().getActionTaken().equals(WorkflowAction.CANCEL)) {
            this.setOpenInvoiceIndicator(false);
            for (Object accountingLine : this.getSourceAccountingLines()) {
                CustomerInvoiceDetail customerInvoiceDetail = (CustomerInvoiceDetail)accountingLine;
                customerInvoiceDetail.setAmount(KualiDecimal.ZERO);
            }
        }
    }
}

