/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.fp.document.authorization.FinancialProcessingAccountingLineAuthorizer;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.web.AccountingLineRenderingContext;
import org.kuali.kfs.sys.document.web.AccountingLineViewAction;

public class CustomerInvoiceDocumentSourceLinesAuthorizer
extends FinancialProcessingAccountingLineAuthorizer {
    private static final String RECALCULATE_METHOD_NAME = "recalculateSourceLine";
    private static final String RECALCULATE_LABEL = "Recalculate Source Accounting Line";
    private static final String RECALCULATE_BUTTON_LABEL = "Recalculate";
    private static final String DISCOUNT_METHOD_NAME = "discountSourceLine";
    private static final String DISCOUNT_LABEL = "Discount a Source Accounting Line";
    private static final String DISCOUNT_BUTTON_LABEL = "Discount";
    private static final String REFRESH_METHOD_NAME = "refreshNewSourceLine";
    private static final String REFRESH_LABEL = "Refresh New Source Line";
    private static final String REFRESH_BUTTON_LABEL = "Refresh";
    private static final String REFRESH_BUTTON_ICON = "fa fa-refresh";
    private static final String DEFAULT_BUTTON_STYLE = "btn btn-default";
    private static final String ICON_BUTTON_STYLE = "btn clean";

    protected Map<String, AccountingLineViewAction> getActionMap(AccountingLineRenderingContext accountingLineRenderingContext, String accountingLinePropertyName, Integer accountingLineIndex, String groupTitle) {
        Map actionMap = super.getActionMap(accountingLineRenderingContext, accountingLinePropertyName, accountingLineIndex, groupTitle);
        CustomerInvoiceDetail invoiceLine = (CustomerInvoiceDetail)accountingLineRenderingContext.getAccountingLine();
        if (this.isNewLine(accountingLineIndex)) {
            actionMap.put(REFRESH_METHOD_NAME, new AccountingLineViewAction(REFRESH_METHOD_NAME, REFRESH_LABEL, ICON_BUTTON_STYLE, REFRESH_BUTTON_LABEL, REFRESH_BUTTON_ICON));
        } else {
            String methodName = this.getMethodName(accountingLineRenderingContext.getAccountingLine(), accountingLinePropertyName, accountingLineIndex, RECALCULATE_METHOD_NAME);
            actionMap.put(methodName, new AccountingLineViewAction(methodName, RECALCULATE_LABEL, DEFAULT_BUTTON_STYLE, RECALCULATE_BUTTON_LABEL));
            if (this.showDiscountButton(invoiceLine)) {
                methodName = this.getMethodName(accountingLineRenderingContext.getAccountingLine(), accountingLinePropertyName, accountingLineIndex, DISCOUNT_METHOD_NAME);
                actionMap.put(methodName, new AccountingLineViewAction(methodName, DISCOUNT_LABEL, DEFAULT_BUTTON_STYLE, DISCOUNT_BUTTON_LABEL));
            }
        }
        return actionMap;
    }

    private boolean showDiscountButton(CustomerInvoiceDetail invoiceLine) {
        return !invoiceLine.isDiscountLine() && !invoiceLine.isDiscountLineParent();
    }

    private String getMethodName(AccountingLine line, String accountingLineProperty, Integer accountingLineIndex, String methodName) {
        String infix = super.getActionInfixForExtantAccountingLine(line, accountingLineProperty);
        return methodName + ".line" + accountingLineIndex.toString() + ".anchoraccounting" + infix + "Anchor";
    }

    private boolean isNewLine(Integer accountingLineIndex) {
        return accountingLineIndex == null || accountingLineIndex < 0;
    }

    public Set<String> getUnviewableBlocks(AccountingDocument accountingDocument, AccountingLine accountingLine, boolean newLine, Person currentUser) {
        Set blocks = super.getUnviewableBlocks(accountingDocument, accountingLine, newLine, currentUser);
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        boolean enableTax = parameterService.getParameterValueAsBoolean("KFS-AR", "Document", "ENABLE_SALES_TAX_IND");
        if (!enableTax) {
            blocks.add("invoiceItemTaxAmount");
            blocks.add("taxableIndicator");
        }
        return blocks;
    }

    public boolean determineEditPermissionOnField(AccountingDocument accountingDocument, AccountingLine accountingLine, String accountingLineCollectionProperty, String fieldName, boolean editablePage) {
        boolean discountLineFlag;
        boolean canModify = super.determineEditPermissionOnField(accountingDocument, accountingLine, accountingLineCollectionProperty, fieldName, editablePage);
        if (canModify && (discountLineFlag = ((CustomerInvoiceDetail)accountingLine).isDiscountLine()) && (StringUtils.equals((CharSequence)fieldName, (CharSequence)this.getChartPropertyName()) || StringUtils.equals((CharSequence)fieldName, (CharSequence)this.getAccountNumberPropertyName()))) {
            canModify = false;
        }
        return canModify;
    }

    protected String getChartPropertyName() {
        return "chartOfAccountsCode";
    }

    protected String getAccountNumberPropertyName() {
        return "accountNumber";
    }

    protected String getItemDescriptionPropertyName() {
        return "invoiceItemDescription";
    }

    protected String getAmountPropertyName() {
        return "amount";
    }
}

