/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.KewApiServiceLocator;
import org.kuali.kfs.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.kfs.kew.doctype.bo.DocumentType;
import org.kuali.kfs.kew.doctype.service.DocumentTypeService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.ElectronicPaymentClaim;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.GeneralLedgerPostingDocument;
import org.kuali.kfs.sys.document.service.AccountingDocumentRuleHelperService;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;

public class CashControlDocumentServiceImpl
implements CashControlDocumentService {
    private AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private GeneralLedgerPendingEntryService glpeService;
    private OptionsService optionsService;
    private SystemInformationService systemInformationService;
    private DataDictionaryService dataDictionaryService;
    private ChartService chartService;
    private UniversityDateService universityDateService;
    private BankService bankService;
    private AccountingDocumentRuleHelperService accountingDocumentRuleHelperService;
    private DocumentTypeService documentTypeService;

    @Override
    public PaymentApplicationDocument createAndSavePaymentApplicationDocument(String description, CashControlDocument cashControlDocument, CashControlDetail cashControlDetail) {
        PaymentApplicationDocument doc = (PaymentApplicationDocument)this.documentService.getNewDocument(PaymentApplicationDocument.class);
        doc.getDocumentHeader().setDocumentDescription(description);
        doc.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(cashControlDetail.getFinancialDocumentLineAmount());
        String processingChartCode = cashControlDocument.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode();
        String processingOrgCode = cashControlDocument.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode();
        AccountsReceivableDocumentHeader arDocHeader = new AccountsReceivableDocumentHeader();
        arDocHeader.setProcessingChartOfAccountCode(processingChartCode);
        arDocHeader.setProcessingOrganizationCode(processingOrgCode);
        arDocHeader.setDocumentNumber(doc.getDocumentNumber());
        arDocHeader.setCustomerNumber(cashControlDetail.getCustomerNumber());
        doc.setAccountsReceivableDocumentHeader(arDocHeader);
        doc.getDocumentHeader().setOrganizationDocumentNumber(cashControlDocument.getDocumentNumber());
        doc.refreshNonUpdateableReferences();
        doc.setCashControlDetail(cashControlDetail);
        doc.setNonAppliedHolding(null);
        this.documentService.saveDocument((Document)doc);
        DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        queue.indexDocument(doc.getDocumentNumber());
        return doc;
    }

    @Override
    public void addNewCashControlDetail(String description, CashControlDocument cashControlDocument, CashControlDetail cashControlDetail) {
        cashControlDocument.addCashControlDetail(cashControlDetail);
        PaymentApplicationDocument paymentApplicationDocument = this.createAndSavePaymentApplicationDocument(description, cashControlDocument, cashControlDetail);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocument);
        cashControlDetail.setReferenceFinancialDocumentNumber(paymentApplicationDocument.getDocumentNumber());
        paymentApplicationDocument.populateDocumentForRouting();
        paymentApplicationDocument.prepareForSave();
        this.documentService.prepareWorkflowDocument((Document)paymentApplicationDocument);
        this.documentService.saveDocument((Document)cashControlDocument);
        DocumentType cashDocumentType = this.documentTypeService.getDocumentTypeByName(cashControlDocument.getFinancialDocumentTypeCode());
        DocumentAttributeIndexingQueue cashQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        cashQueue.indexDocument(cashControlDocument.getDocumentNumber());
        DocumentType payDocumentType = this.documentTypeService.getDocumentTypeByName(paymentApplicationDocument.getFinancialDocumentTypeCode());
        DocumentAttributeIndexingQueue payQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
        payQueue.indexDocument(paymentApplicationDocument.getDocumentNumber());
    }

    @Override
    public void saveGLPEs(CashControlDocument cashControlDocument) {
        this.businessObjectService.save(cashControlDocument.getGeneralLedgerPendingEntries());
    }

    @Override
    public boolean createCashReceiptGLPEs(CashControlDocument cashControlDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        if (cashControlDocument.getCashControlTotalAmount().isZero()) {
            return true;
        }
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = cashControlDocument.getAccountsReceivableDocumentHeader();
        String processingChartOfAccountCode = accountsReceivableDocumentHeader.getProcessingChartOfAccountCode();
        String processingOrganizationCode = accountsReceivableDocumentHeader.getProcessingOrganizationCode();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentFiscalYear);
        criteria.put("processingChartOfAccountCode", processingChartOfAccountCode);
        criteria.put("processingOrganizationCode", processingOrganizationCode);
        SystemInformation systemInformation = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        if (ObjectUtils.isNull((Object)((Object)systemInformation))) {
            return false;
        }
        SystemOptions options = this.optionsService.getCurrentYearOptions();
        AccountingLine accountingLine = this.buildAccountingLine(systemInformation.getUniversityClearingAccountNumber(), systemInformation.getUniversityClearingSubAccountNumber(), systemInformation.getUniversityClearingObjectCode(), null, systemInformation.getUniversityClearingChartOfAccountsCode(), "C", cashControlDocument.getCashControlTotalAmount());
        String financialSystemDocumentTypeCode = this.getDataDictionaryService().getDocumentTypeNameByClass(((Object)((Object)cashControlDocument)).getClass());
        GeneralLedgerPendingEntry explicitEntry = this.createAndAddNewExplicitEntry(cashControlDocument, sequenceHelper, accountingLine, options, financialSystemDocumentTypeCode);
        return this.createAndAddTheOffsetEntry(cashControlDocument, explicitEntry, accountingLine, sequenceHelper);
    }

    @Override
    public boolean createBankOffsetGLPEs(CashControlDocument cashControlDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        boolean isSuccess = true;
        if (this.bankService.isBankSpecificationEnabled()) {
            Bank bank = this.bankService.getByPrimaryId(cashControlDocument.getBankCode());
            GeneralLedgerPendingEntry bankOffsetEntry = new GeneralLedgerPendingEntry();
            KualiDecimal totalAmount = (KualiDecimal)this.glpeService.getOffsetToCashAmount((GeneralLedgerPostingDocument)cashControlDocument).negated();
            if (totalAmount.isZero()) {
                isSuccess = true;
            } else if (this.glpeService.populateBankOffsetGeneralLedgerPendingEntry(bank, totalAmount, (GeneralLedgerPostingDocument)cashControlDocument, cashControlDocument.getPostingYear(), sequenceHelper, bankOffsetEntry, "document.bankCode")) {
                bankOffsetEntry.setTransactionLedgerEntryDescription(this.accountingDocumentRuleHelperService.formatProperty("description.glpe.bankOffset", new Object[0]));
                cashControlDocument.addPendingEntry(bankOffsetEntry);
                sequenceHelper.increment();
                GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(bankOffsetEntry);
                isSuccess = this.glpeService.populateOffsetGeneralLedgerPendingEntry(cashControlDocument.getPostingYear(), bankOffsetEntry, sequenceHelper, offsetEntry);
                cashControlDocument.addPendingEntry(offsetEntry);
                sequenceHelper.increment();
            } else {
                isSuccess = false;
            }
        }
        return isSuccess;
    }

    @Override
    public boolean createDistributionOfIncomeAndExpenseGLPEs(CashControlDocument cashControlDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = cashControlDocument.getAccountsReceivableDocumentHeader();
        String processingChartOfAccountCode = accountsReceivableDocumentHeader.getProcessingChartOfAccountCode();
        String processingOrganizationCode = accountsReceivableDocumentHeader.getProcessingOrganizationCode();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentFiscalYear);
        criteria.put("processingChartOfAccountCode", processingChartOfAccountCode);
        criteria.put("processingOrganizationCode", processingOrganizationCode);
        SystemInformation systemInformation = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        if (ObjectUtils.isNull((Object)((Object)systemInformation))) {
            return false;
        }
        SystemOptions options = this.optionsService.getCurrentYearOptions();
        AccountingLine accountingLine = this.buildAccountingLine(systemInformation.getUniversityClearingAccountNumber(), systemInformation.getUniversityClearingSubAccountNumber(), systemInformation.getUniversityClearingObjectCode(), null, systemInformation.getUniversityClearingChartOfAccountsCode(), "C", cashControlDocument.getCashControlTotalAmount());
        String financialSystemDocumentTypeCode = this.getDataDictionaryService().getDocumentTypeNameByClass(((Object)((Object)cashControlDocument)).getClass());
        GeneralLedgerPendingEntry explicitEntry = this.createAndAddNewExplicitEntry(cashControlDocument, sequenceHelper, accountingLine, options, financialSystemDocumentTypeCode);
        boolean isSuccess = this.createAndAddTheOffsetEntry(cashControlDocument, explicitEntry, accountingLine, sequenceHelper);
        HashMap<String, String> criteria2 = new HashMap<String, String>();
        criteria2.put("referenceFinancialDocumentNumber", cashControlDocument.getDocumentNumber());
        Collection electronicPaymentClaims = this.businessObjectService.findMatching(ElectronicPaymentClaim.class, criteria2);
        if (ObjectUtils.isNull((Object)electronicPaymentClaims)) {
            return false;
        }
        for (ElectronicPaymentClaim electronicPaymentClaim : electronicPaymentClaims) {
            HashMap<String, Object> criteria3 = new HashMap<String, Object>();
            criteria3.put("documentNumber", electronicPaymentClaim.getDocumentNumber());
            criteria3.put("sequenceNumber", electronicPaymentClaim.getFinancialDocumentLineNumber());
            criteria3.put("financialDocumentLineTypeCode", "F");
            SourceAccountingLine advanceDepositAccountingLine = (SourceAccountingLine)this.businessObjectService.findByPrimaryKey(SourceAccountingLine.class, criteria3);
            accountingLine = this.buildAccountingLine(advanceDepositAccountingLine.getAccountNumber(), advanceDepositAccountingLine.getSubAccountNumber(), advanceDepositAccountingLine.getFinancialObjectCode(), advanceDepositAccountingLine.getFinancialSubObjectCode(), advanceDepositAccountingLine.getChartOfAccountsCode(), "D", advanceDepositAccountingLine.getAmount());
            explicitEntry = this.createAndAddNewExplicitEntry(cashControlDocument, sequenceHelper, accountingLine, options, financialSystemDocumentTypeCode);
            isSuccess &= this.createAndAddTheOffsetEntry(cashControlDocument, explicitEntry, accountingLine, sequenceHelper);
        }
        return isSuccess;
    }

    @Override
    public boolean createGeneralErrorCorrectionGLPEs(CashControlDocument cashControlDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = cashControlDocument.getAccountsReceivableDocumentHeader();
        String processingChartOfAccountCode = accountsReceivableDocumentHeader.getProcessingChartOfAccountCode();
        String processingOrganizationCode = accountsReceivableDocumentHeader.getProcessingOrganizationCode();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentFiscalYear);
        criteria.put("processingChartOfAccountCode", processingChartOfAccountCode);
        criteria.put("processingOrganizationCode", processingOrganizationCode);
        SystemInformation systemInformation = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        if (ObjectUtils.isNull((Object)((Object)systemInformation))) {
            return false;
        }
        SystemOptions options = this.optionsService.getCurrentYearOptions();
        AccountingLine accountingLine = this.buildAccountingLine(systemInformation.getUniversityClearingAccountNumber(), systemInformation.getUniversityClearingSubAccountNumber(), systemInformation.getCreditCardObjectCode(), null, systemInformation.getUniversityClearingChartOfAccountsCode(), "D", cashControlDocument.getCashControlTotalAmount());
        String financialSystemDocumentTypeCode = this.getDataDictionaryService().getDocumentTypeNameByClass(((Object)((Object)cashControlDocument)).getClass());
        this.createAndAddNewExplicitEntry(cashControlDocument, sequenceHelper, accountingLine, options, financialSystemDocumentTypeCode);
        accountingLine = this.buildAccountingLine(systemInformation.getUniversityClearingAccountNumber(), systemInformation.getUniversityClearingSubAccountNumber(), systemInformation.getUniversityClearingObjectCode(), null, systemInformation.getUniversityClearingChartOfAccountsCode(), "C", cashControlDocument.getCashControlTotalAmount());
        this.createAndAddNewExplicitEntry(cashControlDocument, sequenceHelper, accountingLine, options, financialSystemDocumentTypeCode);
        return true;
    }

    @Override
    public String getLockboxNumber(CashControlDocument cashControlDocument) {
        Integer currentFiscalYear = this.universityDateService.getCurrentFiscalYear();
        String chartOfAccountsCode = cashControlDocument.getAccountsReceivableDocumentHeader().getProcessingChartOfAccountCode();
        String processingOrgCode = cashControlDocument.getAccountsReceivableDocumentHeader().getProcessingOrganizationCode();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", currentFiscalYear);
        criteria.put("processingChartOfAccountCode", chartOfAccountsCode);
        criteria.put("processingOrganizationCode", processingOrgCode);
        SystemInformation systemInformation = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        return systemInformation == null ? null : systemInformation.getLockboxNumber();
    }

    protected AccountingLine buildAccountingLine(String accountNumber, String subAccountNumber, String objectCode, String subObjectCode, String chartOfAccountsCode, String debitOrCredit, KualiDecimal amount) {
        AccountingLine accountingLine;
        try {
            accountingLine = (AccountingLine)SourceAccountingLine.class.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InfrastructureException("unable to access sourceAccountingLineClass", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new InfrastructureException("unable to instantiate sourceAccountingLineClass", (Exception)e);
        }
        accountingLine.setAccountNumber(accountNumber);
        accountingLine.setFinancialObjectCode(objectCode);
        accountingLine.setSubAccountNumber(subAccountNumber);
        accountingLine.setChartOfAccountsCode(chartOfAccountsCode);
        accountingLine.setFinancialSubObjectCode(subObjectCode);
        accountingLine.setDebitCreditCode(debitOrCredit);
        accountingLine.setAmount(amount);
        return accountingLine;
    }

    protected GeneralLedgerPendingEntry createAndAddNewExplicitEntry(CashControlDocument cashControlDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, AccountingLine accountingLine, SystemOptions options, String documentType) {
        GeneralLedgerPendingEntry explicitEntry = new GeneralLedgerPendingEntry();
        this.glpeService.populateExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySource)cashControlDocument, (GeneralLedgerPendingEntrySourceDetail)accountingLine, sequenceHelper, explicitEntry);
        explicitEntry.setFinancialDocumentTypeCode(documentType);
        explicitEntry.setDocumentNumber(cashControlDocument.getDocumentNumber());
        cashControlDocument.addPendingEntry(explicitEntry);
        cashControlDocument.customizeExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySourceDetail)accountingLine, explicitEntry);
        sequenceHelper.increment();
        return explicitEntry;
    }

    protected boolean createAndAddTheOffsetEntry(CashControlDocument cashControlDocument, GeneralLedgerPendingEntry explicitEntry, AccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        GeneralLedgerPendingEntry offsetEntry = new GeneralLedgerPendingEntry(explicitEntry);
        boolean isSuccess = this.glpeService.populateOffsetGeneralLedgerPendingEntry(cashControlDocument.getPostingYear(), explicitEntry, sequenceHelper, offsetEntry);
        cashControlDocument.customizeOffsetGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySourceDetail)accountingLine, explicitEntry, offsetEntry);
        cashControlDocument.addPendingEntry(offsetEntry);
        sequenceHelper.increment();
        return isSuccess;
    }

    public SystemInformationService getSystemInformationService() {
        return this.systemInformationService;
    }

    public void setSystemInformationService(SystemInformationService systemInformationService) {
        this.systemInformationService = systemInformationService;
    }

    public ChartService getChartService() {
        return this.chartService;
    }

    public void setChartService(ChartService chartService) {
        this.chartService = chartService;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public GeneralLedgerPendingEntryService getGlpeService() {
        return this.glpeService;
    }

    public void setGlpeService(GeneralLedgerPendingEntryService glpeService) {
        this.glpeService = glpeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public AccountsReceivableDocumentHeaderService getAccountsReceivableDocumentHeaderService() {
        return this.accountsReceivableDocumentHeaderService;
    }

    public void setAccountsReceivableDocumentHeaderService(AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService) {
        this.accountsReceivableDocumentHeaderService = accountsReceivableDocumentHeaderService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setBankService(BankService bankService) {
        this.bankService = bankService;
    }

    public AccountingDocumentRuleHelperService getAccountingDocumentRuleHelperService() {
        return this.accountingDocumentRuleHelperService;
    }

    public void setAccountingDocumentRuleHelperService(AccountingDocumentRuleHelperService accountingDocumentRuleService) {
        this.accountingDocumentRuleHelperService = accountingDocumentRuleService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }
}

