/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableTaxService;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.InvoicePaidAppliedService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerCreditMemoDocumentServiceImpl
implements CustomerCreditMemoDocumentService {
    private DocumentService documentService;
    private InvoicePaidAppliedService<CustomerInvoiceDetail> paidAppliedService;
    private UniversityDateService universityDateService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    private AccountsReceivableTaxService accountsReceivableTaxService;

    @Override
    public void completeCustomerCreditMemo(CustomerCreditMemoDocument creditMemo) {
        String invoiceNumber = creditMemo.getFinancialDocumentReferenceInvoiceNumber();
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceNumber);
        if (!invoice.isOpenInvoiceIndicator()) {
            throw new UnsupportedOperationException("The CreditMemo Document #" + creditMemo.getDocumentNumber() + " attempted to credit an Invoice [#" + invoiceNumber + "] that was already closed.  This is not supported.");
        }
        KualiDecimal openAmount = invoice.getOpenAmount();
        Integer paidAppliedItemNumber = 0;
        List<CustomerCreditMemoDetail> details = creditMemo.getCreditMemoDetails();
        for (CustomerCreditMemoDetail detail : details) {
            CustomerInvoiceDetail invoiceDetail = detail.getCustomerInvoiceDetail();
            if (detail.getCreditMemoLineTotalAmount().isZero()) continue;
            if (((KualiDecimal)detail.getCreditMemoLineTotalAmount().abs()).isGreaterThan((AbstractKualiDecimal)invoiceDetail.getAmountOpen())) {
                throw new UnsupportedOperationException("The credit detail for CreditMemo Document #" + creditMemo.getDocumentNumber() + " attempted to credit more than the Open Amount on the Invoice Detail.  This is not supported.");
            }
            if (paidAppliedItemNumber == 0) {
                paidAppliedItemNumber = this.paidAppliedService.getNumberOfInvoicePaidAppliedsForInvoiceDetail(invoiceNumber, invoiceDetail.getInvoiceItemNumber());
            }
            InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied();
            invoicePaidApplied.setDocumentNumber(creditMemo.getDocumentNumber());
            Integer n = paidAppliedItemNumber;
            Integer n2 = paidAppliedItemNumber = Integer.valueOf(paidAppliedItemNumber + 1);
            invoicePaidApplied.setPaidAppliedItemNumber(n);
            invoicePaidApplied.setFinancialDocumentReferenceInvoiceNumber(invoiceNumber);
            invoicePaidApplied.setInvoiceItemNumber(invoiceDetail.getInvoiceItemNumber());
            invoicePaidApplied.setUniversityFiscalYear(this.universityDateService.getCurrentFiscalYear());
            invoicePaidApplied.setUniversityFiscalPeriodCode(this.universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
            invoicePaidApplied.setInvoiceItemAppliedAmount((KualiDecimal)detail.getCreditMemoLineTotalAmount().abs());
            openAmount = (KualiDecimal)openAmount.subtract((AbstractKualiDecimal)((KualiDecimal)detail.getCreditMemoLineTotalAmount().abs()));
            this.businessObjectService.save((PersistableBusinessObject)invoicePaidApplied);
        }
        if (invoice.isOpenInvoiceIndicator() && KualiDecimal.ZERO.equals((Object)openAmount)) {
            this.customerInvoiceDocumentService.addCloseNote(invoice, creditMemo.getDocumentHeader().getWorkflowDocument());
            invoice.setOpenInvoiceIndicator(false);
            invoice.setClosedDate(this.dateTimeService.getCurrentSqlDate());
            this.documentService.updateDocument((Document)invoice);
        }
    }

    @Override
    public void recalculateCustomerCreditMemoDocument(CustomerCreditMemoDocument customerCreditMemoDocument, boolean blanketApproveDocumentEventFlag) {
        List<CustomerCreditMemoDetail> customerCreditMemoDetails = customerCreditMemoDocument.getCreditMemoDetails();
        if (!blanketApproveDocumentEventFlag) {
            customerCreditMemoDocument.resetTotals();
        }
        for (CustomerCreditMemoDetail customerCreditMemoDetail : customerCreditMemoDetails) {
            BigDecimal itemQuantity = customerCreditMemoDetail.getCreditMemoItemQuantity();
            KualiDecimal customerCreditMemoDetailItemAmount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
            if (ObjectUtils.isNull((Object)itemQuantity) && ObjectUtils.isNull((Object)customerCreditMemoDetailItemAmount)) {
                if (blanketApproveDocumentEventFlag) continue;
                customerCreditMemoDetail.setDuplicateCreditMemoItemTotalAmount(null);
                continue;
            }
            if (ObjectUtils.isNotNull((Object)customerCreditMemoDetailItemAmount)) {
                customerCreditMemoDetail.recalculateBasedOnEnteredItemAmount(customerCreditMemoDocument);
            } else {
                customerCreditMemoDetail.recalculateBasedOnEnteredItemQty(customerCreditMemoDocument);
                if (!blanketApproveDocumentEventFlag) {
                    customerCreditMemoDetailItemAmount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
                }
            }
            if (blanketApproveDocumentEventFlag) continue;
            customerCreditMemoDetail.setDuplicateCreditMemoItemTotalAmount(customerCreditMemoDetailItemAmount);
            boolean isCustomerInvoiceDetailTaxable = this.accountsReceivableTaxService.isCustomerInvoiceDetailTaxable(customerCreditMemoDocument.getInvoice(), customerCreditMemoDetail.getCustomerInvoiceDetail());
            customerCreditMemoDocument.recalculateTotals(customerCreditMemoDetailItemAmount, isCustomerInvoiceDetailTaxable);
        }
        customerCreditMemoDocument.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(customerCreditMemoDocument.getCrmTotalAmount());
    }

    @Override
    public Collection<CustomerCreditMemoDocument> getCustomerCreditMemoDocumentByInvoiceDocument(String invoiceNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("financialDocumentReferenceInvoiceNumber", invoiceNumber);
        return this.businessObjectService.findMatching(CustomerCreditMemoDocument.class, fieldValues);
    }

    @Override
    public boolean isThereNoDataToSubmit(CustomerCreditMemoDocument customerCreditMemoDocument) {
        boolean isSuccess = true;
        List<CustomerCreditMemoDetail> customerCreditMemoDetails = customerCreditMemoDocument.getCreditMemoDetails();
        for (CustomerCreditMemoDetail customerCreditMemoDetail : customerCreditMemoDetails) {
            BigDecimal itemQuantity = customerCreditMemoDetail.getCreditMemoItemQuantity();
            KualiDecimal customerCreditMemoDetailItemAmount = customerCreditMemoDetail.getCreditMemoItemTotalAmount();
            if (!ObjectUtils.isNotNull((Object)itemQuantity) && !ObjectUtils.isNotNull((Object)customerCreditMemoDetailItemAmount)) continue;
            isSuccess = false;
            break;
        }
        return isSuccess;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setPaidAppliedService(InvoicePaidAppliedService<CustomerInvoiceDetail> paidAppliedService) {
        this.paidAppliedService = paidAppliedService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public AccountsReceivableTaxService getAccountsReceivableTaxService() {
        return this.accountsReceivableTaxService;
    }

    public void setAccountsReceivableTaxService(AccountsReceivableTaxService accountsReceivableTaxService) {
        this.accountsReceivableTaxService = accountsReceivableTaxService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }
}

