/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.WorkflowDocumentFactory;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustableDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.dataaccess.AccountsReceivableDocumentHeaderDao;
import org.kuali.kfs.module.ar.document.dataaccess.CustomerInvoiceDetailDao;
import org.kuali.kfs.module.ar.document.dataaccess.NonAppliedHoldingDao;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerOpenItemReportService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerOpenItemReportServiceImpl
implements CustomerOpenItemReportService {
    private static final Logger LOG = LogManager.getLogger();
    protected AccountsReceivableDocumentHeaderDao accountsReceivableDocumentHeaderDao;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected DocumentService documentService;
    protected DateTimeService dateTimeService;
    protected CustomerInvoiceDetailDao customerInvoiceDetailDao;
    protected NonAppliedHoldingDao nonAppliedHoldingDao;
    protected BusinessObjectService businessObjectService;

    @Override
    public List getPopulatedReportDetails(String customerNumber) {
        WorkflowDocument workflowDocument;
        ArrayList<CustomerOpenItemReportDetail> results = new ArrayList<CustomerOpenItemReportDetail>();
        Collection<String> documentNumbers = this.accountsReceivableDocumentHeaderDao.getARDocumentNumbersIncludingHiddenApplicationByCustomerNumber(customerNumber);
        if (documentNumbers.size() == 0) {
            return results;
        }
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        ArrayList<String> finSysDocHeaderIds = new ArrayList<String>();
        ArrayList<String> invoiceIds = new ArrayList<String>();
        ArrayList<String> paymentApplicationIds = new ArrayList<String>();
        ArrayList<String> paymentApplicationAdjustmentIds = new ArrayList<String>();
        HashMap<String, CustomerOpenItemReportDetail> details = new HashMap<String, CustomerOpenItemReportDetail>();
        for (String docNumber : documentNumbers) {
            CustomerOpenItemReportDetail detail = new CustomerOpenItemReportDetail();
            workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)docNumber);
            if (ObjectUtils.isNull((Object)workflowDocument.getDateApproved())) continue;
            java.util.Date approvedDate = this.getSqlDate(workflowDocument.getDateApproved().toCalendar(Locale.getDefault()));
            String documentType = workflowDocument.getDocumentTypeName();
            detail.setDocumentType(documentType);
            detail.setDocumentNumber(docNumber);
            if (documentType.equals("INV") || documentType.equals("CINV")) {
                invoiceIds.add(docNumber);
            } else {
                detail.setDueApprovedDate(approvedDate);
                if (documentType.equals("APP")) {
                    paymentApplicationIds.add(docNumber);
                } else if (documentType.equals("APPA")) {
                    paymentApplicationAdjustmentIds.add(docNumber);
                } else {
                    finSysDocHeaderIds.add(docNumber);
                }
            }
            details.put(docNumber, detail);
        }
        Collection<NonAppliedHolding> arNonAppliedHoldings = this.nonAppliedHoldingDao.getNonAppliedHoldingsForCustomer(customerNumber);
        ArrayList<String> payAppUnappliedHoldingIds = new ArrayList<String>();
        ArrayList<String> appaUnappliedHoldingIds = new ArrayList<String>();
        for (NonAppliedHolding nonAppliedHolding : arNonAppliedHoldings) {
            workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)nonAppliedHolding.getReferenceFinancialDocumentNumber());
            String documentNumber = nonAppliedHolding.getReferenceFinancialDocumentNumber();
            String documentType = nonAppliedHolding.getDocumentHeader().getWorkflowDocumentTypeName();
            CustomerOpenItemReportDetail detail = new CustomerOpenItemReportDetail();
            detail.setDocumentType(documentType);
            detail.setDocumentNumber(documentNumber);
            if (ObjectUtils.isNull((Object)workflowDocument.getDateApproved())) continue;
            java.util.Date documentApprovedDate = this.getSqlDate(workflowDocument.getDateApproved().toCalendar(Locale.getDefault()));
            detail.setDueApprovedDate(documentApprovedDate);
            details.put(nonAppliedHolding.getReferenceFinancialDocumentNumber(), detail);
            if (paymentApplicationIds.contains(documentNumber) || paymentApplicationAdjustmentIds.contains(documentNumber)) continue;
            if (documentType.equals("APP")) {
                payAppUnappliedHoldingIds.add(nonAppliedHolding.getReferenceFinancialDocumentNumber());
                continue;
            }
            if (!documentType.equals("APPA")) continue;
            appaUnappliedHoldingIds.add(nonAppliedHolding.getReferenceFinancialDocumentNumber());
        }
        this.populateReportDetailsForInvoices(invoiceIds, results, details);
        this.populateReportDetailsForPaymentApplications(paymentApplicationIds, customerNumber, results, details);
        this.populateReportDetailsForPaymentApplicationAdjustments(paymentApplicationAdjustmentIds, customerNumber, results, details);
        this.populateReportDetailsForPaymentApplications(payAppUnappliedHoldingIds, customerNumber, results, details);
        this.populateReportDetailsForPaymentApplicationAdjustments(appaUnappliedHoldingIds, customerNumber, results, details);
        this.populateReportDetails(finSysDocHeaderIds, results, details);
        return results;
    }

    @Override
    public List getPopulatedReportDetails(Map urlParameters) {
        Collection<CustomerInvoiceDocument> invoices;
        ArrayList results = new ArrayList();
        Collection arDocumentHeaders = this.getARDocumentHeaders(urlParameters);
        if (arDocumentHeaders.size() == 0) {
            return results;
        }
        ArrayList<String> arDocumentHeaderIds = new ArrayList<String>();
        for (AccountsReceivableDocumentHeader arDocHeader : arDocumentHeaders) {
            arDocumentHeaderIds.add(arDocHeader.getDocumentNumber());
        }
        String reportOption = ((String[])urlParameters.get("reportOption"))[0];
        Collection details = null;
        if (StringUtils.equals((CharSequence)reportOption, (CharSequence)"Account")) {
            String accountNumber = ((String[])urlParameters.get("accountNumber"))[0];
            details = this.customerInvoiceDetailDao.getCustomerInvoiceDetailsByAccountNumberByInvoiceDocumentNumbers(accountNumber, arDocumentHeaderIds);
            invoices = this.getInvoicesByAccountNumberByDocumentIds(accountNumber, arDocumentHeaderIds, details);
        } else {
            invoices = this.getDocuments(CustomerInvoiceDocument.class, arDocumentHeaderIds);
        }
        if (ObjectUtils.isNull((Object)invoices) | invoices.size() == 0) {
            return results;
        }
        ArrayList<CustomerInvoiceDocument> selectedInvoices = new ArrayList<CustomerInvoiceDocument>();
        String columnTitle = ((String[])urlParameters.get("columnTitle"))[0];
        java.util.Date reportRunDate = null;
        java.util.Date beginDate = null;
        java.util.Date endDate = null;
        try {
            reportRunDate = this.dateTimeService.convertToDate(((String[])urlParameters.get("reportRunDate"))[0]);
            if (!StringUtils.equals((CharSequence)columnTitle, (CharSequence)"All days")) {
                endDate = this.dateTimeService.convertToDate(((String[])urlParameters.get("endDate"))[0]);
                String strBeginDate = ((String[])urlParameters.get("startDate"))[0];
                if (StringUtils.isNotEmpty((CharSequence)strBeginDate)) {
                    beginDate = this.dateTimeService.convertToDate(strBeginDate);
                }
            }
        }
        catch (ParseException e) {
            LOG.error("problem during CustomerOpenItemReportServiceImpl.getPopulatedReportDetails()", (Throwable)e);
        }
        if (StringUtils.equals((CharSequence)reportOption, (CharSequence)"Billing Organization")) {
            String chartCode = ((String[])urlParameters.get("processingOrBillingChartCode"))[0];
            String orgCode = ((String[])urlParameters.get("orgCode"))[0];
            if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)"All days")) {
                for (CustomerInvoiceDocument invoice : invoices) {
                    if (!ObjectUtils.isNull((Object)invoice.getClosedDate()) || !ObjectUtils.isNotNull((Object)invoice.getBillingDate()) || reportRunDate.before(invoice.getBillingDate()) || !StringUtils.equals((CharSequence)chartCode, (CharSequence)invoice.getBillByChartOfAccountCode()) || !StringUtils.equals((CharSequence)orgCode, (CharSequence)invoice.getBilledByOrganizationCode())) continue;
                    selectedInvoices.add(invoice);
                }
            } else {
                for (CustomerInvoiceDocument invoice : invoices) {
                    if (!ObjectUtils.isNull((Object)invoice.getClosedDate()) || !ObjectUtils.isNotNull((Object)invoice.getBillingDate()) || !StringUtils.equals((CharSequence)chartCode, (CharSequence)invoice.getBillByChartOfAccountCode()) || !StringUtils.equals((CharSequence)orgCode, (CharSequence)invoice.getBilledByOrganizationCode()) || (!ObjectUtils.isNotNull((Object)beginDate) || beginDate.after(invoice.getBillingDate()) || endDate.before(invoice.getBillingDate())) && (!ObjectUtils.isNull((Object)beginDate) || endDate.before(invoice.getBillingDate()))) continue;
                    selectedInvoices.add(invoice);
                }
            }
        } else if (StringUtils.equals((CharSequence)columnTitle, (CharSequence)"All days")) {
            for (CustomerInvoiceDocument invoice : invoices) {
                if (!ObjectUtils.isNull((Object)invoice.getClosedDate()) || !ObjectUtils.isNotNull((Object)invoice.getBillingDate()) || reportRunDate.before(invoice.getBillingDate())) continue;
                selectedInvoices.add(invoice);
            }
        } else {
            for (CustomerInvoiceDocument invoice : invoices) {
                if ((!ObjectUtils.isNull((Object)invoice.getClosedDate()) || !ObjectUtils.isNotNull((Object)invoice.getBillingDate()) || !ObjectUtils.isNotNull(beginDate) || beginDate.after(invoice.getBillingDate()) || endDate.before(invoice.getBillingDate())) && (!ObjectUtils.isNull(beginDate) || endDate.before(invoice.getBillingDate()))) continue;
                selectedInvoices.add(invoice);
            }
        }
        if (selectedInvoices.size() == 0) {
            return results;
        }
        if (StringUtils.equals((CharSequence)reportOption, (CharSequence)"Account")) {
            this.populateReporDetails(selectedInvoices, results, details);
        } else {
            this.populateReportDetails(selectedInvoices, results);
        }
        return results;
    }

    protected void populateReportDetailsForInvoices(List<String> invoiceIds, List<CustomerOpenItemReportDetail> results, HashMap<String, CustomerOpenItemReportDetail> details) {
        if (invoiceIds.isEmpty()) {
            return;
        }
        List invoices = (List)this.getDocuments(CustomerInvoiceDocument.class, invoiceIds);
        for (CustomerInvoiceDocument invoice : invoices) {
            String documentNumber = invoice.getDocumentNumber();
            CustomerOpenItemReportDetail detail = details.get(documentNumber);
            String documentDescription = invoice.getDocumentHeader().getDocumentDescription();
            detail.setDocumentDescription((String)StringUtils.defaultIfEmpty((CharSequence)documentDescription, (CharSequence)""));
            detail.setBillingDate(invoice.getBillingDate());
            detail.setDueApprovedDate(invoice.getInvoiceDueDate());
            detail.setDocumentPaymentAmount(invoice.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount());
            detail.setUnpaidUnappliedAmount(this.customerInvoiceDocumentService.getOpenAmountForCustomerInvoiceDocument(invoice));
            results.add(detail);
        }
    }

    protected void populateReportDetailsForPaymentApplicationAdjustments(List<String> paymentApplicationAdjustmentIds, String customerNumber, List results, HashMap<String, CustomerOpenItemReportDetail> details) {
        if (paymentApplicationAdjustmentIds.isEmpty()) {
            return;
        }
        List appaDocuments = (List)this.getDocuments(PaymentApplicationAdjustmentDocument.class, paymentApplicationAdjustmentIds);
        appaDocuments.forEach(appaDoc -> {
            CustomerOpenItemReportDetail detail = (CustomerOpenItemReportDetail)((Object)((Object)details.get(appaDoc.getDocumentNumber())));
            String documentDescription = appaDoc.getDocumentHeader().getDocumentDescription();
            detail.setDocumentDescription((String)StringUtils.defaultIfEmpty((CharSequence)documentDescription, (CharSequence)""));
            KualiDecimal nonAppliedAmountForCustomer = appaDoc.getNonAppliedHoldings().stream().filter(nonAppliedHolding -> nonAppliedHolding.getCustomerNumber().equals(customerNumber)).map(NonAppliedHolding::getAvailableUnappliedAmount).reduce(KualiDecimal.ZERO, AbstractKualiDecimal::add);
            detail.setUnpaidUnappliedAmount(nonAppliedAmountForCustomer);
            KualiDecimal documentPaymentAmount = appaDoc.getInvoicePaidApplieds().stream().filter(invoicePaidApplied -> invoicePaidApplied.getCustomerInvoiceDocument().getCustomer().getCustomerNumber().equals(customerNumber)).map(InvoicePaidApplied::getInvoiceItemAppliedAmount).reduce(nonAppliedAmountForCustomer, AbstractKualiDecimal::add);
            detail.setDocumentPaymentAmount(documentPaymentAmount);
            results.add(detail);
        });
    }

    protected void populateReportDetailsForPaymentApplications(List<String> paymentApplicationIds, String customerNumber, List<CustomerOpenItemReportDetail> results, HashMap<String, CustomerOpenItemReportDetail> details) {
        if (paymentApplicationIds.isEmpty()) {
            return;
        }
        List paymentApplications = (List)this.getDocuments(PaymentApplicationDocument.class, paymentApplicationIds);
        for (PaymentApplicationDocument paymentApplication : paymentApplications) {
            String documentNumber = paymentApplication.getDocumentNumber();
            CustomerOpenItemReportDetail detail = details.get(documentNumber);
            String documentDescription = paymentApplication.getDocumentHeader().getDocumentDescription();
            detail.setDocumentDescription((String)StringUtils.defaultIfEmpty((CharSequence)documentDescription, (CharSequence)""));
            detail.setDocumentPaymentAmount(paymentApplication.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount());
            KualiDecimal unAppliedAmount = KualiDecimal.ZERO;
            if (ObjectUtils.isNotNull((Object)((Object)paymentApplication.getNonAppliedHolding())) && paymentApplication.getNonAppliedHolding().getCustomerNumber().equals(customerNumber)) {
                unAppliedAmount = paymentApplication.getNonAppliedHolding().getAvailableUnappliedAmount();
            }
            detail.setUnpaidUnappliedAmount(unAppliedAmount);
            results.add(detail);
        }
    }

    public void populateReportDetails(List<String> finSysDocHeaderIds, List results, HashMap details) {
        if (finSysDocHeaderIds.isEmpty()) {
            return;
        }
        ArrayList<FinancialSystemDocumentHeader> financialSystemDocHeaders = new ArrayList<FinancialSystemDocumentHeader>();
        for (String documentNumber : finSysDocHeaderIds) {
            FinancialSystemDocumentHeader header = (FinancialSystemDocumentHeader)this.businessObjectService.findBySinglePrimaryKey(FinancialSystemDocumentHeader.class, (Object)documentNumber);
            if (header == null) continue;
            financialSystemDocHeaders.add(header);
        }
        for (FinancialSystemDocumentHeader fsDocumentHeader : financialSystemDocHeaders) {
            CustomerOpenItemReportDetail detail = (CustomerOpenItemReportDetail)((Object)details.get(fsDocumentHeader.getDocumentNumber()));
            detail.setDocumentDescription(StringUtils.trimToEmpty((String)fsDocumentHeader.getDocumentDescription()));
            detail.setDocumentPaymentAmount(fsDocumentHeader.getFinancialDocumentTotalAmount());
            detail.setUnpaidUnappliedAmount(KualiDecimal.ZERO);
            results.add(detail);
        }
    }

    protected void populateReportDetails(List<CustomerInvoiceDocument> invoices, List results) {
        for (CustomerInvoiceDocument invoice : invoices) {
            CustomerOpenItemReportDetail detail = new CustomerOpenItemReportDetail();
            detail.setDocumentType(invoice.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            detail.setDocumentNumber(invoice.getDocumentNumber());
            String documentDescription = invoice.getDocumentHeader().getDocumentDescription();
            if (ObjectUtils.isNotNull((Object)documentDescription)) {
                detail.setDocumentDescription(documentDescription);
            } else {
                detail.setDocumentDescription("");
            }
            detail.setBillingDate(invoice.getBillingDate());
            detail.setDueApprovedDate(invoice.getInvoiceDueDate());
            detail.setDocumentPaymentAmount(invoice.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount());
            detail.setUnpaidUnappliedAmount(this.customerInvoiceDocumentService.getOpenAmountForCustomerInvoiceDocument(invoice));
            results.add(detail);
        }
    }

    private Document getDocumentWithId(String docId) {
        return this.documentService.getByDocumentHeaderId(docId);
    }

    public Collection getDocuments(Class classToSearchFrom, List documentNumbers) {
        return this.documentService.getDocumentsByListOfDocumentHeaderIds(classToSearchFrom, documentNumbers);
    }

    protected java.util.Date getSqlDate(Calendar cal) {
        Date sqlDueDate = null;
        if (ObjectUtils.isNull((Object)cal)) {
            return null;
        }
        try {
            sqlDueDate = this.dateTimeService.convertToSqlDate(new Timestamp(cal.getTime().getTime()));
        }
        catch (ParseException e) {
            LOG.error("Error in converting given calendar to sql date");
        }
        return sqlDueDate;
    }

    protected Collection getARDocumentHeaders(Map urlParameters) {
        Collection arDocumentHeaders;
        String reportOption = ((String[])urlParameters.get("reportOption"))[0];
        String customerNumber = ((String[])urlParameters.get("customerNumber"))[0];
        if (StringUtils.equals((CharSequence)reportOption, (CharSequence)"Processing Organization")) {
            String processingChartCode = ((String[])urlParameters.get("processingOrBillingChartCode"))[0];
            String processingOrganizationCode = ((String[])urlParameters.get("orgCode"))[0];
            arDocumentHeaders = this.accountsReceivableDocumentHeaderDao.getARDocumentHeadersByCustomerNumberByProcessingOrgCodeAndChartCode(customerNumber, processingChartCode, processingOrganizationCode);
        } else {
            arDocumentHeaders = this.accountsReceivableDocumentHeaderDao.getARDocumentHeadersIncludingHiddenApplicationByCustomerNumber(customerNumber);
        }
        return arDocumentHeaders;
    }

    protected Collection<CustomerInvoiceDocument> getInvoicesByAccountNumberByDocumentIds(String accountNumber, List arDocumentHeaderIds, Collection<CustomerInvoiceDetail> details) {
        Collection invoices = null;
        if (ObjectUtils.isNull(details) | details.size() == 0) {
            return invoices;
        }
        ArrayList<String> documentIds = new ArrayList<String>();
        for (CustomerInvoiceDetail detail : details) {
            String documentNumber = detail.getDocumentNumber();
            if (documentIds.contains(documentNumber)) continue;
            documentIds.add(documentNumber);
        }
        if (documentIds.size() != 0) {
            invoices = this.getDocuments(CustomerInvoiceDocument.class, documentIds);
        }
        return invoices;
    }

    protected void populateReporDetails(List<CustomerInvoiceDocument> selectedInvoices, List results, Collection<CustomerInvoiceDetail> invoiceDetails) {
        for (CustomerInvoiceDocument invoice : selectedInvoices) {
            String documentNumber = invoice.getDocumentNumber();
            KualiDecimal amount = KualiDecimal.ZERO;
            KualiDecimal taxAmount = KualiDecimal.ZERO;
            KualiDecimal openAmount = KualiDecimal.ZERO;
            boolean foundFlag = false;
            for (CustomerInvoiceDetail invoiceDetail : invoiceDetails) {
                KualiDecimal openItemAmount;
                KualiDecimal itemTaxAmount;
                String tempDocumentNumber = invoiceDetail.getDocumentNumber();
                if (!StringUtils.equals((CharSequence)documentNumber, (CharSequence)tempDocumentNumber)) continue;
                foundFlag = true;
                KualiDecimal itemAmount = invoiceDetail.getAmount();
                if (ObjectUtils.isNotNull((Object)itemAmount)) {
                    amount = (KualiDecimal)amount.add((AbstractKualiDecimal)itemAmount);
                }
                if (ObjectUtils.isNotNull((Object)(itemTaxAmount = invoiceDetail.getInvoiceItemTaxAmount()))) {
                    taxAmount = (KualiDecimal)taxAmount.add((AbstractKualiDecimal)itemTaxAmount);
                }
                if (!ObjectUtils.isNotNull((Object)(openItemAmount = invoiceDetail.getAmountOpen()))) continue;
                openAmount = (KualiDecimal)openAmount.add((AbstractKualiDecimal)openItemAmount);
            }
            if (!foundFlag) continue;
            CustomerOpenItemReportDetail detail = new CustomerOpenItemReportDetail();
            detail.setDocumentType(invoice.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            detail.setDocumentNumber(documentNumber);
            String documentDescription = invoice.getDocumentHeader().getDocumentDescription();
            if (ObjectUtils.isNotNull((Object)documentDescription)) {
                detail.setDocumentDescription(documentDescription);
            } else {
                detail.setDocumentDescription("");
            }
            detail.setBillingDate(invoice.getBillingDate());
            detail.setDueApprovedDate(invoice.getInvoiceDueDate());
            detail.setDocumentPaymentAmount((KualiDecimal)amount.add((AbstractKualiDecimal)taxAmount));
            detail.setUnpaidUnappliedAmount(openAmount);
            results.add(detail);
        }
    }

    @Override
    public Collection<String> getDocumentNumbersOfReferenceReports(String customerNumber) {
        ArrayList<String> documentNumbers = new ArrayList<String>();
        Collection<AccountsReceivableDocumentHeader> arDocumentHeaders = this.accountsReceivableDocumentHeaderDao.getARDocumentHeadersIncludingHiddenApplicationByCustomerNumber(customerNumber);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        ArrayList<String> paymentApplicationAdjustableIds = new ArrayList<String>();
        ArrayList<String> creditMemoIds = new ArrayList<String>();
        ArrayList<String> writeOffIds = new ArrayList<String>();
        for (AccountsReceivableDocumentHeader documentHeader : arDocumentHeaders) {
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)documentHeader.getDocumentNumber());
            if (ObjectUtils.isNull((Object)workflowDocument.getDateApproved())) continue;
            String documentType = workflowDocument.getDocumentTypeName();
            String documentNumber = documentHeader.getDocumentNumber();
            switch (documentType) {
                case "APP": 
                case "APPA": {
                    paymentApplicationAdjustableIds.add(documentNumber);
                    break;
                }
                case "CRM": {
                    creditMemoIds.add(documentNumber);
                    break;
                }
                case "INVW": {
                    writeOffIds.add(documentNumber);
                    break;
                }
            }
        }
        paymentApplicationAdjustableIds.stream().map(this::getDocumentWithId).filter(PaymentApplicationAdjustableDocument.class::isInstance).map(PaymentApplicationAdjustableDocument.class::cast).map(PaymentApplicationAdjustableDocument::getInvoicePaidApplieds).flatMap(Collection::stream).map(InvoicePaidApplied::getFinancialDocumentReferenceInvoiceNumber).forEach(documentNumbers::add);
        if (creditMemoIds.size() > 0) {
            Collection creditMemoDetailDocs = this.getDocuments(CustomerCreditMemoDocument.class, creditMemoIds);
            for (CustomerCreditMemoDocument creditMemo : creditMemoDetailDocs) {
                documentNumbers.add(creditMemo.getFinancialDocumentReferenceInvoiceNumber());
            }
        }
        if (writeOffIds.size() > 0) {
            Collection customerInvoiceWriteoffDocs = this.getDocuments(CustomerInvoiceWriteoffDocument.class, writeOffIds);
            for (CustomerInvoiceWriteoffDocument invoiceWriteoffDocument : customerInvoiceWriteoffDocs) {
                documentNumbers.add(invoiceWriteoffDocument.getFinancialDocumentReferenceInvoiceNumber());
            }
        }
        return documentNumbers;
    }

    @Override
    public List getPopulatedUnpaidUnappliedAmountReportDetails(String customerNumber, String refDocumentNumber) {
        ArrayList results = new ArrayList();
        Collection<AccountsReceivableDocumentHeader> arDocumentHeaders = this.accountsReceivableDocumentHeaderDao.getARDocumentHeadersIncludingHiddenApplicationByCustomerNumber(customerNumber);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        HashMap<String, CustomerOpenItemReportDetail> details = new HashMap<String, CustomerOpenItemReportDetail>();
        ArrayList<String> paymentApplicationIds = new ArrayList<String>();
        ArrayList<String> creditMemoIds = new ArrayList<String>();
        ArrayList<String> writeOffIds = new ArrayList<String>();
        for (AccountsReceivableDocumentHeader documentHeader : arDocumentHeaders) {
            CustomerOpenItemReportDetail detail = new CustomerOpenItemReportDetail();
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)userId, (String)documentHeader.getDocumentNumber());
            if (ObjectUtils.isNull((Object)workflowDocument.getDateApproved())) continue;
            java.util.Date approvedDate = this.getSqlDate(workflowDocument.getDateApproved().toCalendar(Locale.getDefault()));
            String documentType = workflowDocument.getDocumentTypeName();
            detail.setDocumentType(documentType);
            String documentNumber = documentHeader.getDocumentNumber();
            detail.setDocumentNumber(documentNumber);
            detail.setDueApprovedDate(approvedDate);
            switch (documentType) {
                case "APP": 
                case "APPA": {
                    paymentApplicationIds.add(documentNumber);
                    break;
                }
                case "CRM": {
                    creditMemoIds.add(documentNumber);
                    break;
                }
                case "INVW": {
                    writeOffIds.add(documentNumber);
                    break;
                }
            }
            details.put(documentNumber, detail);
        }
        this.populateReportDetailsForUnpaidUnappliedPaymentApplications(paymentApplicationIds, results, details, customerNumber);
        if (creditMemoIds.size() > 0) {
            this.populateReportDetailsForCreditMemo(creditMemoIds, results, details, refDocumentNumber);
        }
        if (writeOffIds.size() > 0) {
            this.populateReportDetailsForWriteOff(writeOffIds, results, details, refDocumentNumber);
        }
        return results;
    }

    protected void populateReportDetailsForUnpaidUnappliedPaymentApplications(List<String> paymentApplicationIds, List results, HashMap details, String customerNumber) {
        paymentApplicationIds.stream().map(this::getDocumentWithId).filter(document -> document instanceof PaymentApplicationAdjustableDocument).map(PaymentApplicationAdjustableDocument.class::cast).forEach(paymentApplicationAdjustableDocument -> {
            CustomerOpenItemReportDetail detail = (CustomerOpenItemReportDetail)((Object)((Object)details.get(paymentApplicationAdjustableDocument.getDocumentNumber())));
            String documentDescription = paymentApplicationAdjustableDocument.getDocumentHeader().getDocumentDescription();
            detail.setDocumentDescription((String)StringUtils.defaultIfEmpty((CharSequence)documentDescription, (CharSequence)""));
            detail.setDocumentPaymentAmount(paymentApplicationAdjustableDocument.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount());
            Optional<NonAppliedHolding> nonAppliedHoldingForCustomer = paymentApplicationAdjustableDocument.getNonAppliedHoldings().stream().filter(nonAppliedHolding -> nonAppliedHolding.getCustomerNumber().equals(customerNumber)).findAny();
            KualiDecimal unappliedAmount = KualiDecimal.ZERO;
            if (nonAppliedHoldingForCustomer.isPresent()) {
                unappliedAmount = nonAppliedHoldingForCustomer.get().getFinancialDocumentLineAmount();
            }
            detail.setUnpaidUnappliedAmount(unappliedAmount);
            results.add(detail);
        });
    }

    protected void populateReportDetailsForCreditMemo(List creditMemoIds, List results, HashMap details, String refDocumentNumber) {
        Collection creditMemoDetailDocs = this.getDocuments(CustomerCreditMemoDocument.class, creditMemoIds);
        for (CustomerCreditMemoDocument creditMemo : creditMemoDetailDocs) {
            if (!creditMemo.getFinancialDocumentReferenceInvoiceNumber().equals(refDocumentNumber)) continue;
            String documentNumber = creditMemo.getDocumentNumber();
            CustomerOpenItemReportDetail detail = (CustomerOpenItemReportDetail)((Object)details.get(documentNumber));
            String documentDescription = creditMemo.getDocumentHeader().getDocumentDescription();
            if (ObjectUtils.isNotNull((Object)documentDescription)) {
                detail.setDocumentDescription(documentDescription);
            } else {
                detail.setDocumentDescription("");
            }
            detail.setDocumentPaymentAmount(creditMemo.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount());
            detail.setUnpaidUnappliedAmount(KualiDecimal.ZERO);
            results.add(detail);
        }
    }

    protected void populateReportDetailsForWriteOff(List writeOffIds, List results, HashMap details, String refDocumentNumber) {
        Collection customerInvoiceWriteoffDocs = this.getDocuments(CustomerInvoiceWriteoffDocument.class, writeOffIds);
        for (CustomerInvoiceWriteoffDocument invoiceWriteoffDocument : customerInvoiceWriteoffDocs) {
            if (!invoiceWriteoffDocument.getFinancialDocumentReferenceInvoiceNumber().equals(refDocumentNumber)) continue;
            String documentNumber = invoiceWriteoffDocument.getDocumentNumber();
            CustomerOpenItemReportDetail detail = (CustomerOpenItemReportDetail)((Object)details.get(documentNumber));
            String documentDescription = invoiceWriteoffDocument.getDocumentHeader().getDocumentDescription();
            if (ObjectUtils.isNotNull((Object)documentDescription)) {
                detail.setDocumentDescription(documentDescription);
            } else {
                detail.setDocumentDescription("");
            }
            detail.setDocumentPaymentAmount(invoiceWriteoffDocument.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount());
            detail.setUnpaidUnappliedAmount(KualiDecimal.ZERO);
            results.add(detail);
        }
    }

    public void setAccountsReceivableDocumentHeaderDao(AccountsReceivableDocumentHeaderDao accountsReceivableDocumentHeaderDao) {
        this.accountsReceivableDocumentHeaderDao = accountsReceivableDocumentHeaderDao;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setCustomerInvoiceDetailDao(CustomerInvoiceDetailDao customerInvoiceDetailDao) {
        this.customerInvoiceDetailDao = customerInvoiceDetailDao;
    }

    public void setNonAppliedHoldingDao(NonAppliedHoldingDao nonAppliedHoldingDao) {
        this.nonAppliedHoldingDao = nonAppliedHoldingDao;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

