/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceRecurrenceInitiatorValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private DocumentHelperService documentHelperService;
    private PersonService personService;

    public boolean validate(AttributedDocumentEvent event) {
        if (ObjectUtils.isNull((Object)((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails()))) {
            return true;
        }
        if (this.customerInvoiceDocument.getNoRecurrenceDataFlag()) {
            return true;
        }
        String initiatorUserIdentifier = this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentInitiatorUserIdentifier();
        if (ObjectUtils.isNull((Object)initiatorUserIdentifier)) {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceRecurrenceDetails.documentInitiatorUser.principalName", "error.document.invoiceRecurrenceMaintenance.initiatorIsRequired", new String[0]);
            return false;
        }
        DocumentAuthorizer documentAuthorizer = this.documentHelperService.getDocumentAuthorizer("INVR");
        Person person = this.personService.getPerson(initiatorUserIdentifier);
        if (person == null) {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceRecurrenceDetails.documentInitiatorUser.principalName", "error.document.invoiceRecurrenceMaintenance.initiatorDoesNotExist", new String[0]);
            return false;
        }
        if (!documentAuthorizer.canInitiate("INVR", person)) {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceRecurrenceDetails.documentInitiatorUser.principalName", "error.document.invoiceRecurrenceMainitenance.initiatorIsNotAuthorized", new String[0]);
            return false;
        }
        return true;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

