/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.web.format.CurrencyFormatter;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;

public class ContractsGrantsBillingUtilityServiceImpl
implements ContractsGrantsBillingUtilityService {
    protected BusinessObjectService businessObjectService;

    @Override
    public String formatForCurrency(KualiDecimal amount) {
        if (!ObjectUtils.isNull((Object)amount)) {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.put("showCurrencySymbol", "true");
            CurrencyFormatter currencyFormatter = new CurrencyFormatter();
            currencyFormatter.setSettings(settings);
            return (String)currencyFormatter.format((Object)amount);
        }
        return "";
    }

    @Override
    public String buildFullAddress(CustomerAddress address) {
        Object fullAddress = "";
        if (ObjectUtils.isNotNull((Object)address)) {
            Object billCityStateZip;
            String customerCountryCode;
            if (StringUtils.isNotEmpty((CharSequence)address.getCustomerLine1StreetAddress())) {
                fullAddress = (String)fullAddress + address.getCustomerLine1StreetAddress() + "\n";
            }
            if (StringUtils.isNotEmpty((CharSequence)address.getCustomerLine2StreetAddress())) {
                fullAddress = (String)fullAddress + address.getCustomerLine2StreetAddress() + "\n";
            }
            if (StringUtils.equals((CharSequence)(customerCountryCode = (String)StringUtils.defaultIfBlank((CharSequence)address.getCustomerCountryCode(), (CharSequence)"US")), (CharSequence)"US")) {
                billCityStateZip = this.generateCityStateZipLine(address.getCustomerCityName(), address.getCustomerStateCode(), address.getCustomerZipCode());
            } else {
                billCityStateZip = this.generateCityStateZipLine(address.getCustomerCityName(), address.getCustomerAddressInternationalProvinceName(), address.getCustomerInternationalMailCode());
                billCityStateZip = (String)billCityStateZip + ", " + address.getCustomerCountry().getName();
            }
            fullAddress = (String)fullAddress + (String)billCityStateZip;
        }
        return fullAddress;
    }

    protected String generateCityStateZipLine(String city, String state, String zipCode) {
        StringBuffer cityStateZip = new StringBuffer(city);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            cityStateZip.append(", ").append(state);
        }
        if (StringUtils.isNotBlank((CharSequence)zipCode)) {
            cityStateZip.append(" ").append(zipCode);
        }
        return cityStateZip.toString();
    }

    @Override
    public void putValueOrEmptyString(Map<String, String> map, String key, String value) {
        map.put(key, ObjectUtils.isNull((Object)value) ? "" : value);
    }

    @Override
    public List<Bill> getActiveBillsForAwardAccount(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", proposalNumber);
        map.put("chartOfAccountsCode", chartOfAccountsCode);
        map.put("accountNumber", accountNumber);
        map.put("active", true);
        return (List)this.businessObjectService.findMatching(Bill.class, map);
    }

    @Override
    public List<Milestone> getActiveMilestonesForProposalNumber(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        if (proposalNumber == null) {
            throw new IllegalArgumentException("proposalNumber may not be null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", proposalNumber);
        map.put("chartOfAccountsCode", chartOfAccountsCode);
        map.put("accountNumber", accountNumber);
        map.put("active", true);
        return (List)this.businessObjectService.findMatching(Milestone.class, map);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

