/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import com.opencsv.CSVReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.vo.PredeterminedBillingScheduleCsvHeaders;
import org.kuali.kfs.sys.batch.CsvBatchInputFileTypeBase;
import org.springframework.util.AutoPopulatingList;

public abstract class ScheduleCsvInputFileType
extends CsvBatchInputFileTypeBase<PredeterminedBillingScheduleCsvHeaders> {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    protected DocumentService documentService;
    protected DateTimeService dateTimeService;
    MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    private AccountService accountService;
    private ConfigurationService configurationService;

    protected void validateCSVFileInput(List<String> expectedHeaderList, InputStream fileContents) throws IOException {
        CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(fileContents, StandardCharsets.UTF_8));
        List<String> inputHeaderList = Arrays.asList(csvReader.readNext());
        fileContents.reset();
        if (!this.accountService.accountsCanCrossCharts() && !inputHeaderList.contains("chartOfAccountsCode")) {
            expectedHeaderList.remove("chartOfAccountsCode");
        }
        super.validateCSVFileInput(expectedHeaderList, fileContents);
    }

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        StringBuilder fileName = new StringBuilder("_");
        fileName.append("_").append(principalName);
        if (StringUtils.isNotBlank((CharSequence)fileUserIdentifier)) {
            fileName.append("_").append(fileUserIdentifier);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US);
        dateFormat.format(Timestamp.valueOf(LocalDateTime.now()));
        fileName.append("_").append(dateFormat.format(Timestamp.valueOf(LocalDateTime.now())));
        return fileName.toString();
    }

    protected String flattenErrorMessages(AutoPopulatingList<ErrorMessage> errorMessages) {
        StringBuilder flattenedErrorMessage = new StringBuilder();
        errorMessages.forEach(errorMessage -> flattenedErrorMessage.append(MessageFormat.format(this.configurationService.getPropertyValueAsString(errorMessage.getErrorKey()), errorMessage.getMessageParameters())).append("<br/>"));
        return flattenedErrorMessage.toString();
    }

    void removeFiles(String filename) {
        String doneFileName = StringUtils.substringBeforeLast((String)filename, (String)".") + ".done";
        this.removeFile(doneFileName);
        this.removeFile(filename);
    }

    private void removeFile(String qualifiedFilePath) {
        File fileToDelete = new File(qualifiedFilePath);
        if (fileToDelete.exists() && !fileToDelete.delete()) {
            LOG.warn(fileToDelete.getName() + " could not be successfully deleted.");
        }
    }

    public boolean validate(Object parsedFileContents) {
        return true;
    }

    String deriveChartOfAccountsCodeFromAccount(String accountNumber) {
        Account account;
        if (!this.accountService.accountsCanCrossCharts() && ObjectUtils.isNotNull((Object)(account = this.accountService.getUniqueAccountForAccountNumber(accountNumber)))) {
            return account.getChartOfAccountsCode();
        }
        return null;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

