/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneBase;
import org.kuali.kfs.sys.context.SpringContext;

public class Milestone
extends MilestoneBase
implements MutableInactivatable {
    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private Date milestoneExpectedCompletionDate;
    private boolean billed = false;
    private boolean active;
    private List<InvoiceMilestone> invoiceMilestones;
    private ContractsAndGrantsBillingAward award;
    private transient ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;

    public Milestone() {
    }

    private Milestone(String proposalNumber, String chartOfAccountsCode, String accountNumber, Date milestoneExpectedCompletionDate, boolean billed, boolean active, String milestoneNumber, String milestoneDescription, KualiDecimal milestoneAmount, Date milestoneActualCompletionDate) {
        this.proposalNumber = proposalNumber;
        this.chartOfAccountsCode = chartOfAccountsCode;
        this.accountNumber = accountNumber;
        this.milestoneExpectedCompletionDate = milestoneExpectedCompletionDate;
        this.billed = billed;
        this.active = active;
        this.milestoneNumber = milestoneNumber;
        this.milestoneDescription = milestoneDescription;
        this.milestoneAmount = milestoneAmount;
        this.milestoneActualCompletionDate = milestoneActualCompletionDate;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public Date getMilestoneExpectedCompletionDate() {
        return this.milestoneExpectedCompletionDate;
    }

    public void setMilestoneExpectedCompletionDate(Date milestoneExpectedCompletionDate) {
        this.milestoneExpectedCompletionDate = milestoneExpectedCompletionDate;
    }

    public boolean isBilled() {
        return this.billed;
    }

    public void setBilled(boolean billed) {
        this.billed = billed;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<InvoiceMilestone> getInvoiceMilestones() {
        return this.invoiceMilestones;
    }

    public void setInvoiceMilestones(List<InvoiceMilestone> invoiceMilestones) {
        this.invoiceMilestones = invoiceMilestones;
    }

    public ContractsAndGrantsBillingAward getAward() {
        ContractsAndGrantsBillingAward updatedAward = this.getContractsAndGrantsModuleBillingService().updateAwardIfNecessary(this.proposalNumber, this.award);
        if (ObjectUtils.isNull((Object)updatedAward)) {
            return this.award;
        }
        return updatedAward;
    }

    public void setAward(ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Milestone)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Milestone milestone = (Milestone)((Object)o);
        return this.billed == milestone.billed && this.active == milestone.active && Objects.equals(this.proposalNumber, milestone.proposalNumber) && Objects.equals(this.chartOfAccountsCode, milestone.chartOfAccountsCode) && Objects.equals(this.accountNumber, milestone.accountNumber) && Objects.equals(this.milestoneExpectedCompletionDate, milestone.milestoneExpectedCompletionDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.proposalNumber, this.chartOfAccountsCode, this.accountNumber, this.milestoneExpectedCompletionDate, this.billed, this.active);
    }

    protected ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        if (this.contractsAndGrantsModuleBillingService == null) {
            this.contractsAndGrantsModuleBillingService = (ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class);
        }
        return this.contractsAndGrantsModuleBillingService;
    }

    protected void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public static class MilestoneBuilder {
        private String proposalNumber;
        private String chartOfAccountsCode;
        private String accountNumber;
        private Date milestoneExpectedCompletionDate;
        private boolean billed;
        private boolean active;
        private String milestoneNumber;
        private String milestoneDescription;
        private KualiDecimal milestoneAmount;
        private Date milestoneActualCompletionDate;

        public MilestoneBuilder setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
            return this;
        }

        public MilestoneBuilder setChartOfAccountsCode(String chartOfAccountsCode) {
            this.chartOfAccountsCode = chartOfAccountsCode;
            return this;
        }

        public MilestoneBuilder setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public MilestoneBuilder setMilestoneExpectedCompletionDate(Date milestoneExpectedCompletionDate) {
            this.milestoneExpectedCompletionDate = milestoneExpectedCompletionDate;
            return this;
        }

        public MilestoneBuilder setBilled(boolean billed) {
            this.billed = billed;
            return this;
        }

        public MilestoneBuilder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public MilestoneBuilder setMilestoneNumber(String milestoneNumber) {
            this.milestoneNumber = milestoneNumber;
            return this;
        }

        public MilestoneBuilder setMilestoneDescription(String milestoneDescription) {
            this.milestoneDescription = milestoneDescription;
            return this;
        }

        public MilestoneBuilder setMilestoneAmount(KualiDecimal milestoneAmount) {
            this.milestoneAmount = milestoneAmount;
            return this;
        }

        public MilestoneBuilder setMilestoneActualCompletionDate(Date milestoneActualCompletionDate) {
            this.milestoneActualCompletionDate = milestoneActualCompletionDate;
            return this;
        }

        public Milestone build() throws IllegalStateException {
            this.validate();
            return new Milestone(this.proposalNumber, this.chartOfAccountsCode, this.accountNumber, this.milestoneExpectedCompletionDate, this.billed, this.active, this.milestoneNumber, this.milestoneDescription, this.milestoneAmount, this.milestoneActualCompletionDate);
        }

        private void validate() {
            if (StringUtils.isBlank((CharSequence)this.proposalNumber)) {
                throw new IllegalStateException("Proposal Number is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.chartOfAccountsCode)) {
                throw new IllegalStateException("Chart of Accounts Code is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.accountNumber)) {
                throw new IllegalStateException("Account Number is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.milestoneNumber)) {
                throw new IllegalStateException("Milestone Number is required.");
            }
            if (this.milestoneExpectedCompletionDate == null) {
                throw new IllegalStateException("Milestone Expected Completion Date is required.");
            }
        }
    }
}

