/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.search.SearchOperator;
import org.kuali.kfs.core.web.format.Formatter;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.lookup.AccountsReceivableLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;

public abstract class ContractsGrantsReportLookupableHelperServiceImplBase
extends AccountsReceivableLookupableHelperServiceImplBase {
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected Pattern numericPattern = Pattern.compile("[-+]?\\d+\\.?\\d*");

    protected void buildResultTable(LookupForm lookupForm, Collection displayList, Collection resultTable) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasReturnableRow = false;
        for (Object entry : displayList) {
            BusinessObject element = (BusinessObject)entry;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            List columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
                if (!col.getPropertyName().equals("documentNumber") && !col.getPropertyName().equals("paymentNumber")) continue;
                String url = this.contractsGrantsReportHelperService.getDocSearchUrl(propValue);
                HashMap<String, String> fieldList = new HashMap<String, String>();
                fieldList.put("documentNumber", propValue);
                HtmlData.AnchorHtmlData a = new HtmlData.AnchorHtmlData(url, "");
                a.setTitle(HtmlData.getTitleText((String)this.getContractsGrantsReportHelperService().createTitleText(this.getBusinessObjectClass()), (Class)this.getBusinessObjectClass(), fieldList));
                col.setColumnAnchor((HtmlData)a);
            }
            ResultRow row = new ResultRow(columns, "", "&nbsp;");
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            boolean isRowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(isRowReturnable);
            if (isRowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
    }

    protected boolean validateOperatorAndValue(String propertyName, String operatorAndValue) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)operatorAndValue)) {
            return true;
        }
        String numericValue = operatorAndValue;
        if (operatorAndValue.charAt(0) == '>' || operatorAndValue.charAt(0) == '<') {
            numericValue = operatorAndValue.charAt(1) == '=' ? operatorAndValue.substring(2) : operatorAndValue.substring(1);
        }
        if (!(matcher = this.numericPattern.matcher(numericValue)).matches()) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.report.invalid.calculated.pattern", new String[]{operatorAndValue});
            return false;
        }
        return true;
    }

    protected void validateSearchParametersForOperatorAndValue(Map<String, String> fieldValues, String propertyName) {
        if (StringUtils.isNotBlank((CharSequence)fieldValues.get(propertyName)) && !this.validateOperatorAndValue(propertyName, fieldValues.get(propertyName))) {
            throw new ValidationException("Error in criteria for " + propertyName);
        }
    }

    protected OperatorAndValue parseOperatorAndValue(String operatorAndValue) {
        if (StringUtils.isBlank((CharSequence)operatorAndValue)) {
            return null;
        }
        if (operatorAndValue.startsWith(SearchOperator.LESS_THAN_EQUAL.op())) {
            String valueOnly = operatorAndValue.substring(2);
            return new OperatorAndValue(SearchOperator.LESS_THAN_EQUAL, valueOnly);
        }
        if (operatorAndValue.startsWith(SearchOperator.GREATER_THAN_EQUAL.toString())) {
            String valueOnly = operatorAndValue.substring(2);
            return new OperatorAndValue(SearchOperator.GREATER_THAN_EQUAL, valueOnly);
        }
        if (operatorAndValue.startsWith(SearchOperator.LESS_THAN.op())) {
            String valueOnly = operatorAndValue.substring(1);
            return new OperatorAndValue(SearchOperator.LESS_THAN, valueOnly);
        }
        if (operatorAndValue.startsWith(SearchOperator.GREATER_THAN.op())) {
            String valueOnly = operatorAndValue.substring(1);
            return new OperatorAndValue(SearchOperator.GREATER_THAN, valueOnly);
        }
        return new OperatorAndValue(SearchOperator.EQUAL, operatorAndValue);
    }

    protected OperatorAndValue buildOperatorAndValueFromField(Map lookupFields, String propertyName) {
        OperatorAndValue operator = null;
        String fieldFromLookup = (String)lookupFields.get(propertyName);
        if (StringUtils.isNotBlank((CharSequence)fieldFromLookup)) {
            operator = this.parseOperatorAndValue(fieldFromLookup);
        }
        return operator;
    }

    protected void validateDateField(String dateFieldValue, String dateFieldPropertyName, DateTimeService dateTimeService) {
        if (StringUtils.isNotBlank((CharSequence)dateFieldValue)) {
            try {
                dateTimeService.convertToDate(dateFieldValue);
            }
            catch (ParseException pe) {
                this.addDateTimeError(dateFieldPropertyName);
            }
        }
    }

    protected void validateTimestampField(String dateFieldValue, String dateFieldPropertyName, DateTimeService dateTimeService) {
        if (StringUtils.isNotBlank((CharSequence)dateFieldValue)) {
            try {
                dateTimeService.convertToSqlTimestamp(dateFieldValue);
            }
            catch (ParseException pe) {
                this.addDateTimeError(dateFieldPropertyName);
            }
        }
    }

    protected void addDateTimeError(String dateFieldPropertyName) {
        String attributeProperty = dateFieldPropertyName.startsWith("rangeLowerBoundKeyPrefix_") ? dateFieldPropertyName.substring("rangeLowerBoundKeyPrefix_".length()) : dateFieldPropertyName;
        String label = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), attributeProperty);
        GlobalVariables.getMessageMap().putError(dateFieldPropertyName, "error.invalidDateTime", new String[]{label});
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    protected final class OperatorAndValue {
        protected SearchOperator operator;
        protected Double value;

        private OperatorAndValue(SearchOperator operator, String valueAsString) {
            this.operator = operator;
            this.value = new Double(valueAsString);
        }

        protected boolean applyComparison(Number otherValue) {
            if (this.value == null) {
                return otherValue == null;
            }
            if (otherValue == null) {
                return false;
            }
            Double otherValueDouble = otherValue.doubleValue();
            int compareResult = otherValueDouble.compareTo(this.value);
            switch (this.operator) {
                case EQUAL: {
                    return compareResult == 0;
                }
                case LESS_THAN: {
                    return compareResult < 0;
                }
                case GREATER_THAN: {
                    return compareResult > 0;
                }
                case LESS_THAN_EQUAL: {
                    return compareResult <= 0;
                }
                case GREATER_THAN_EQUAL: {
                    return compareResult >= 0;
                }
            }
            throw new IllegalStateException("The operator did not catch ");
        }
    }
}

