/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.ar.AccountsReceivableSchedule;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.LookupUtils;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.GlobalVariables;

public class ScheduleLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final String AWARD_ENDING_DATE_KEY = "award.awardEndingDate";
    private static final String AWARD_ENDING_DATE_FROM_KEY = "rangeLowerBoundKeyPrefix_award.awardEndingDate";
    private static final List<String> AWARD_KEYS = Arrays.asList("agencyNumber", "award.awardEndingDate");
    private DateTimeService dateTimeService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return this.truncateResultsListIfNecessary(this.getSearchResultsUnbounded(fieldValues));
    }

    public List<? extends BusinessObject> getSearchResultsUnbounded(Map<String, String> fieldValues) {
        Map<String, String> awardFieldValues = fieldValues.entrySet().stream().filter(map -> AWARD_KEYS.contains(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        fieldValues.entrySet().removeAll(awardFieldValues.entrySet());
        List<? extends BusinessObject> schedules = this.getSearchResultsHelper(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), fieldValues), true);
        schedules = this.filterOutSchedulesWithoutMatchingAgencies(awardFieldValues, schedules);
        schedules = this.filterOutSchedulesWithoutMatchingAwardEndDate(awardFieldValues, schedules);
        return schedules;
    }

    private List<? extends BusinessObject> filterOutSchedulesWithoutMatchingAgencies(Map<String, String> awardFieldValues, List<? extends BusinessObject> schedules) {
        String agencyNumber = awardFieldValues.get("agencyNumber");
        if (StringUtils.isNotBlank((CharSequence)agencyNumber)) {
            String updatedAgencyNumber = agencyNumber.replace("*", ".*").replace("%", ".*").replace("?", ".?");
            schedules = schedules.stream().filter(schedule -> ((AccountsReceivableSchedule)schedule).getAward().getAgencyNumber().matches(updatedAgencyNumber)).collect(Collectors.toList());
        }
        return schedules;
    }

    private List<? extends BusinessObject> filterOutSchedulesWithoutMatchingAwardEndDate(Map<String, String> awardFieldValues, List<? extends BusinessObject> schedules) {
        String awardEndingDateSearchString = awardFieldValues.get(AWARD_ENDING_DATE_KEY);
        String awardEndingDateLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), AWARD_ENDING_DATE_KEY);
        if (StringUtils.isNotBlank((CharSequence)awardEndingDateSearchString)) {
            if (awardEndingDateSearchString.startsWith("<=")) {
                Date awardEndingDateEnd = this.parseDate(awardEndingDateSearchString.substring(2), AWARD_ENDING_DATE_KEY, awardEndingDateLabel + " To");
                schedules = schedules.stream().filter(schedule -> {
                    java.sql.Date awardEndingDate = ((AccountsReceivableSchedule)schedule).getAward().getAwardEndingDate();
                    return awardEndingDate.before(awardEndingDateEnd) || awardEndingDate.equals(awardEndingDateEnd);
                }).collect(Collectors.toList());
            } else if (awardEndingDateSearchString.startsWith(">=")) {
                Date awardEndingDateStart = this.parseDate(awardEndingDateSearchString.substring(2), AWARD_ENDING_DATE_FROM_KEY, awardEndingDateLabel + " From");
                schedules = schedules.stream().filter(schedule -> {
                    java.sql.Date awardEndingDate = ((AccountsReceivableSchedule)schedule).getAward().getAwardEndingDate();
                    return awardEndingDate.after(awardEndingDateStart) || awardEndingDate.equals(awardEndingDateStart);
                }).collect(Collectors.toList());
            } else if (awardEndingDateSearchString.contains("..")) {
                String[] awardEndingDates = awardEndingDateSearchString.split("\\.\\.");
                Date awardEndingDateStart = this.parseDate(awardEndingDates[0], AWARD_ENDING_DATE_FROM_KEY, awardEndingDateLabel + " From");
                Date awardEndingDateEnd = this.parseDate(awardEndingDates[1], AWARD_ENDING_DATE_KEY, awardEndingDateLabel + " To");
                schedules = schedules.stream().filter(schedule -> {
                    java.sql.Date awardEndingDate = ((AccountsReceivableSchedule)schedule).getAward().getAwardEndingDate();
                    return !(!awardEndingDate.after(awardEndingDateStart) && !awardEndingDate.equals(awardEndingDateStart) || !awardEndingDate.before(awardEndingDateEnd) && !awardEndingDate.equals(awardEndingDateEnd));
                }).collect(Collectors.toList());
            }
        }
        return schedules;
    }

    private Date parseDate(String awardEndingDate, String propertyName, String awardEndingDateLabel) {
        Date awardEndingDateStart;
        try {
            awardEndingDateStart = this.dateTimeService.convertToDate(awardEndingDate);
        }
        catch (ParseException e) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.invalidDateTime", new String[]{awardEndingDateLabel});
            throw new ValidationException("errors in search criteria");
        }
        return awardEndingDateStart;
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        String awardEndingDateFromString = fieldValues.get(AWARD_ENDING_DATE_FROM_KEY);
        String awardEndingDateToString = fieldValues.get(AWARD_ENDING_DATE_KEY);
        String awardEndingDateLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), AWARD_ENDING_DATE_KEY);
        this.validateDateField(awardEndingDateFromString, AWARD_ENDING_DATE_FROM_KEY, awardEndingDateLabel + " From");
        this.validateDateField(awardEndingDateToString, AWARD_ENDING_DATE_KEY, awardEndingDateLabel + " To");
        super.validateSearchParameters(fieldValues);
    }

    private void validateDateField(String dateFieldValue, String dateFieldPropertyName, String fieldLabel) {
        if (StringUtils.isNotBlank((CharSequence)dateFieldValue)) {
            try {
                this.dateTimeService.convertToDate(dateFieldValue);
            }
            catch (ParseException pe) {
                GlobalVariables.getMessageMap().putError(dateFieldPropertyName, "error.invalidDateTime", new String[]{fieldLabel});
            }
        }
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

