/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.List;
import java.util.Map;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.maintenance.MaintenanceLock;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerInvoiceItemCodeMaintainableImplUtil;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;

public class OrganizationOptionsMaintainableImpl
extends FinancialSystemMaintainable {
    private OrganizationOptions newOptions;
    private OrganizationOptions oldOptions;

    public List<MaintenanceLock> generateMaintenanceLocks() {
        List maintenanceLocks = super.generateMaintenanceLocks();
        maintenanceLocks.addAll(CustomerInvoiceItemCodeMaintainableImplUtil.generateCustomerInvoiceItemCodeMaintenanceLocks(this.getBusinessObject(), this.getDocumentNumber()));
        return maintenanceLocks;
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterNew(document, parameters);
        this.initializeAttributes(document);
        Person finSysUser = GlobalVariables.getUserSession().getPerson();
        String chartAccountsCode = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(finSysUser, "KFS-AR").getChartOfAccountsCode();
        this.newOptions.setProcessingChartOfAccountCode(chartAccountsCode);
        String organizationCode = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(finSysUser, "KFS-AR").getOrganizationCode();
        this.newOptions.setProcessingOrganizationCode(organizationCode);
        this.updateRemitToAddress(chartAccountsCode, organizationCode);
    }

    public void setGenerateBlankRequiredValues(String docTypeName) {
    }

    private void initializeAttributes(MaintenanceDocument document) {
        if (this.newOptions == null) {
            this.newOptions = (OrganizationOptions)document.getNewMaintainableObject().getBusinessObject();
        }
        if (this.oldOptions == null) {
            this.oldOptions = (OrganizationOptions)document.getOldMaintainableObject().getBusinessObject();
        }
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        this.initializeAttributes(document);
        String chartCode = (String)fieldValues.get("document.newMaintainableObject.processingChartOfAccountCode");
        String orgCode = (String)fieldValues.get("document.newMaintainableObject.processingOrganizationCode");
        if (chartCode != null && orgCode != null) {
            this.updateRemitToAddress(chartCode, orgCode);
        }
    }

    private void updateRemitToAddress(String chartCode, String orgCode) {
        UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
        SystemInformation sysInfo = ((SystemInformationService)SpringContext.getBean(SystemInformationService.class)).getByProcessingChartOrgAndFiscalYear(chartCode, orgCode, universityDateService.getCurrentFiscalYear());
        if (sysInfo != null) {
            this.newOptions.setOrganizationRemitToAddressName(sysInfo.getOrganizationRemitToAddressName());
            this.newOptions.setOrganizationRemitToLine1StreetAddress(sysInfo.getOrganizationRemitToLine1StreetAddress());
            this.newOptions.setOrganizationRemitToLine2StreetAddress(sysInfo.getOrganizationRemitToLine2StreetAddress());
            this.newOptions.setOrganizationRemitToCityName(sysInfo.getOrganizationRemitToCityName());
            this.newOptions.setOrganizationRemitToStateCode(sysInfo.getOrganizationRemitToStateCode());
            this.newOptions.setOrganizationRemitToZipCode(sysInfo.getOrganizationRemitToZipCode());
            this.newOptions.setOrganizationRemitToCountryCode(sysInfo.getOrganizationRemitToCountryCode());
        } else {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.processingChartOfAccountCode", "error.document.organizationOptions.sysInfoDoesNotExistForProcessingChartAndOrg", new String[]{chartCode, orgCode});
        }
    }
}

