/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kew.doctype.bo.DocumentType;
import org.kuali.kfs.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.authorizer.CfDocumentTypeAuthorizer;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class ContractsGrantsInvoiceWorkflowDocumentAuthorizer
extends CfDocumentTypeAuthorizer {
    protected Map<String, String> buildDocumentRoleQualifiers(DocumentRouteHeaderValue document, String routeNodeName) {
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument;
        Map qualifiers = super.buildDocumentRoleQualifiers(document, routeNodeName);
        String documentNumber = document.getDocumentId();
        if (StringUtils.isNotBlank((CharSequence)documentNumber) && ObjectUtils.isNotNull((Object)(contractsGrantsInvoiceDocument = (ContractsGrantsInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(documentNumber)))) {
            ContractsAndGrantsBillingAward award = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward();
            qualifiers.put("proposalNumber", award.getProposalNumber());
        }
        return qualifiers;
    }

    public boolean canInitiate(String principalId, DocumentType documentType) {
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        Map permissionDetails = this.buildDocumentTypePermissionDetails(documentType, null, null, null);
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        qualificationDetails.put("principalId", principalId);
        if (this.useKimPermission("KFS-SYS", "Initiate Document", permissionDetails, true)) {
            return this.getPermissionService().isAuthorizedByTemplate(principalId, "KFS-SYS", "Initiate Document", permissionDetails, qualificationDetails);
        }
        return true;
    }
}

