/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsAgingOpenInvoicesReport;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsAgingOpenInvoicesReportService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;

public class ContractsGrantsAgingOpenInvoicesReportServiceImpl
implements ContractsGrantsAgingOpenInvoicesReportService {
    protected ContractsGrantsAgingReportService contractsGrantsAgingReportService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected DateTimeService dateTimeService;
    private static final Logger LOG = LogManager.getLogger();
    protected KualiModuleService kualiModuleService;

    public ContractsGrantsAgingReportService getContractsGrantsAgingReportService() {
        return this.contractsGrantsAgingReportService;
    }

    public void setContractsGrantsAgingReportService(ContractsGrantsAgingReportService contractsGrantsAgingReportService) {
        this.contractsGrantsAgingReportService = contractsGrantsAgingReportService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    @Override
    public List getPopulatedReportDetails(Map urlParameters) {
        ArrayList results = new ArrayList();
        String customerNumber = ((String[])urlParameters.get("customerNumber"))[0];
        String customerName = ((String[])urlParameters.get("customerName"))[0];
        String strBeginDate = ObjectUtils.isNotNull(urlParameters.get("startDate")) ? ((String[])urlParameters.get("startDate"))[0] : null;
        String strEndDate = ObjectUtils.isNotNull(urlParameters.get("endDate")) ? ((String[])urlParameters.get("endDate"))[0] : null;
        Date startDate = null;
        Date endDate = null;
        List<ContractsGrantsInvoiceDocument> selectedInvoices = new ArrayList<ContractsGrantsInvoiceDocument>();
        try {
            if (ObjectUtils.isNotNull((Object)strBeginDate) && StringUtils.isNotEmpty((CharSequence)strBeginDate)) {
                startDate = this.getDateTimeService().convertToSqlDate(strBeginDate);
            }
            if (ObjectUtils.isNotNull((Object)strEndDate) && StringUtils.isNotEmpty((CharSequence)strEndDate)) {
                endDate = this.getDateTimeService().convertToSqlDate(strEndDate);
            }
            HashMap<String, String> fieldValueMap = new HashMap<String, String>();
            for (Object key : urlParameters.keySet()) {
                String val = ((String[])urlParameters.get(key))[0];
                fieldValueMap.put(key.toString(), val);
            }
            Map<String, List<ContractsGrantsInvoiceDocument>> map = this.contractsGrantsAgingReportService.filterContractsGrantsAgingReport(fieldValueMap, startDate, endDate);
            if (ObjectUtils.isNotNull(map) && !map.isEmpty()) {
                selectedInvoices = map.get(customerNumber + "-" + customerName);
            }
            if (selectedInvoices.size() == 0) {
                return results;
            }
        }
        catch (ParseException ex) {
            LOG.error("problem during ContractsGrantsAgingOpenInvoicesReportServiceImpl.getPopulatedReportDetails", (Throwable)ex);
            throw new RuntimeException("Couldn't parse a date", ex);
        }
        this.populateReportDetails(selectedInvoices, results);
        return results;
    }

    protected void populateReportDetails(List<ContractsGrantsInvoiceDocument> invoices, List results) {
        for (ContractsGrantsInvoiceDocument invoice : invoices) {
            List details;
            ContractsAndGrantsBillingAgency cgAgency;
            ContractsGrantsAgingOpenInvoicesReport detail = new ContractsGrantsAgingOpenInvoicesReport();
            detail.setDocumentType(invoice.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            detail.setDocumentNumber(invoice.getDocumentNumber());
            String documentDescription = invoice.getDocumentHeader().getDocumentDescription();
            if (ObjectUtils.isNotNull((Object)documentDescription)) {
                detail.setDocumentDescription(documentDescription);
            } else {
                detail.setDocumentDescription("");
            }
            detail.setBillingDate(invoice.getBillingDate());
            detail.setDueApprovedDate(invoice.getInvoiceDueDate());
            detail.setDocumentPaymentAmount(invoice.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount());
            detail.setUnpaidUnappliedAmount(this.customerInvoiceDocumentService.getOpenAmountForCustomerInvoiceDocument(invoice));
            detail.setFinalInvoice(!ObjectUtils.isNull((Object)((Object)invoice.getInvoiceGeneralDetail())) && invoice.getInvoiceGeneralDetail().isFinalBillIndicator() ? "Yes" : "No");
            if (!ObjectUtils.isNull((Object)((Object)invoice.getInvoiceGeneralDetail())) && !ObjectUtils.isNull((Object)invoice.getInvoiceGeneralDetail().getProposalNumber())) {
                detail.setProposalNumber(invoice.getInvoiceGeneralDetail().getProposalNumber());
            }
            if (ObjectUtils.isNotNull((Object)(cgAgency = this.getAgencyByCustomer(invoice.getAccountsReceivableDocumentHeader().getCustomerNumber())))) {
                detail.setAgencyNumber(cgAgency.getAgencyNumber());
            }
            String accountNum = CollectionUtils.isNotEmpty((Collection)(details = invoice.getSourceAccountingLines())) && ObjectUtils.isNotNull(details.get(0)) ? ((CustomerInvoiceDetail)details.get(0)).getAccountNumber() : "";
            detail.setAccountNumber(accountNum);
            results.add(detail);
        }
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected ContractsAndGrantsBillingAgency getAgencyByCustomer(String customerNumber) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("customerNumber", customerNumber);
        return (ContractsAndGrantsBillingAgency)this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAgency.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAgency.class, args);
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }
}

