/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.event;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEventBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.document.validation.RecalculateCustomerCreditMemoDetailRule;

public class RecalculateCustomerCreditMemoDetailEvent
extends KualiDocumentEventBase {
    private static final Logger LOG = LogManager.getLogger();
    protected CustomerCreditMemoDetail customerCreditMemoDetail;

    public RecalculateCustomerCreditMemoDetailEvent(String errorPathPrefix, Document document, CustomerCreditMemoDetail customerCreditMemoDetail) {
        super("Recalculating customer credit memo detail for document " + RecalculateCustomerCreditMemoDetailEvent.getDocumentId((Document)document), errorPathPrefix, document);
        this.customerCreditMemoDetail = (CustomerCreditMemoDetail)((Object)ObjectUtils.deepCopy((Serializable)((Object)customerCreditMemoDetail)));
        this.logEvent();
    }

    public Class getRuleInterfaceClass() {
        return RecalculateCustomerCreditMemoDetailRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((RecalculateCustomerCreditMemoDetailRule)rule).processRecalculateCustomerCreditMemoDetailRules((TransactionalDocument)this.document, this.customerCreditMemoDetail);
    }

    public CustomerCreditMemoDetail getCustomerCreditMemoDetail() {
        return this.customerCreditMemoDetail;
    }

    public void validate() {
        super.validate();
        if (this.customerCreditMemoDetail == null) {
            throw new IllegalArgumentException("invalid (null) customer credit memo detail");
        }
    }

    private void logEvent() {
        if (LOG.isDebugEnabled()) {
            StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)((Object)((Object)this)).getClass().getName(), (String)"."));
            logMessage.append(" with ");
            if (this.customerCreditMemoDetail == null) {
                logMessage.append("null customerCreditMemoDetail");
            } else {
                logMessage.append(" customer credit memo detail# ");
                logMessage.append(this.customerCreditMemoDetail.getReferenceInvoiceItemNumber());
            }
            LOG.debug((CharSequence)logMessage);
        }
    }
}

