/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Timestamp;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CustomerInvoiceDueDateValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        int maxNumOfDaysAfterCurrentDateForInvoiceDueDate;
        Timestamp dueDateTimestamp = new Timestamp(this.customerInvoiceDocument.getInvoiceDueDate().getTime());
        Timestamp billingDateTimestamp = new Timestamp(this.dateTimeService.getCurrentDate().getTime());
        if (ObjectUtils.isNull((Object)this.customerInvoiceDocument.getFinancialSystemDocumentHeader().getFinancialDocumentInErrorNumber()) && (dueDateTimestamp.before(billingDateTimestamp) || dueDateTimestamp.equals(billingDateTimestamp))) {
            GlobalVariables.getMessageMap().putError("document.invoiceDueDate", "error.document.customerInvoiceDocument.invalidInvoiceDueDateBeforeOrEqualBillingDate", new String[0]);
            return false;
        }
        long diffInDays = CustomerInvoiceDueDateValidation.getDifferenceInDays(billingDateTimestamp, dueDateTimestamp);
        if (diffInDays >= (long)(maxNumOfDaysAfterCurrentDateForInvoiceDueDate = Integer.parseInt(this.parameterService.getParameterValueAsString(CustomerInvoiceDocument.class, "MAXIMUM_NUMBER_OF_DAYS_AFTER_CURRENT_DATE_FOR_INVOICE_DUE_DATE")))) {
            GlobalVariables.getMessageMap().putError("document.invoiceDueDate", "error.document.customerInvoiceDocument.invalidInvoiceDueDateMoreThanXDays", new String[]{"" + maxNumOfDaysAfterCurrentDateForInvoiceDueDate});
            return false;
        }
        return true;
    }

    public static long getDifferenceInDays(Timestamp t1, Timestamp t2) {
        int nano2;
        if (t1.compareTo(t2) < 0) {
            Timestamp tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        long diffSeconds = t1.getTime() / 1000L - t2.getTime() / 1000L;
        int nano1 = t1.getNanos();
        int diffNanos = nano1 - (nano2 = t2.getNanos());
        if (diffNanos < 0) {
            --diffSeconds;
            diffNanos += 1000000000;
        }
        Timestamp result = new Timestamp(diffSeconds * 1000L + (long)(diffNanos / 1000000));
        result.setNanos(diffNanos);
        return result.getDate();
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

