/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsPaymentHistoryReport;
import org.kuali.kfs.module.ar.report.ContractsGrantsPaymentHistoryReportDetailDataHolder;
import org.kuali.kfs.module.ar.report.ContractsGrantsReportDataHolder;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportDataBuilderService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.sys.report.ReportInfo;

public class ContractsGrantsPaymentHistoryReportBuilderServiceImpl
implements ContractsGrantsReportDataBuilderService {
    protected ReportInfo reportInfo;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    @Override
    public ContractsGrantsReportDataHolder buildReportDataHolder(List<? extends BusinessObject> displayList, String sortPropertyName) {
        boolean isFieldSubtotalRequired = ArConstants.ReportsConstants.cgPaymentHistoryReportSubtotalFieldsList.contains(sortPropertyName);
        Map<Object, Object> subTotalMap = new HashMap();
        if (isFieldSubtotalRequired) {
            subTotalMap = this.buildSubTotalMap(displayList, sortPropertyName);
        }
        ContractsGrantsReportDataHolder cgPaymentHistoryReportDataHolder = new ContractsGrantsReportDataHolder();
        List details = cgPaymentHistoryReportDataHolder.getDetails();
        for (ContractsGrantsPaymentHistoryReport contractsGrantsPaymentHistoryReport : displayList) {
            ContractsGrantsPaymentHistoryReportDetailDataHolder reportDetail = new ContractsGrantsPaymentHistoryReportDetailDataHolder();
            this.setReportDate(contractsGrantsPaymentHistoryReport, reportDetail);
            if (isFieldSubtotalRequired) {
                reportDetail.setSortedFieldValue(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsPaymentHistoryReport, sortPropertyName));
                reportDetail.setDisplaySubtotal(true);
                reportDetail.setInvoiceSubTotal(((KualiDecimal)((List)subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsPaymentHistoryReport, sortPropertyName))).get(0)).bigDecimalValue());
                reportDetail.setPaymentSubTotal(((KualiDecimal)((List)subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsPaymentHistoryReport, sortPropertyName))).get(1)).bigDecimalValue());
            } else {
                reportDetail.setDisplaySubtotal(false);
            }
            details.add(reportDetail);
        }
        cgPaymentHistoryReportDataHolder.setDetails(details);
        return cgPaymentHistoryReportDataHolder;
    }

    @Override
    public Class<? extends BusinessObject> getDetailsClass() {
        return ContractsGrantsPaymentHistoryReport.class;
    }

    protected Map<String, List<KualiDecimal>> buildSubTotalMap(List<ContractsGrantsPaymentHistoryReport> displayList, String sortPropertyName) {
        HashMap<String, List<KualiDecimal>> returnSubTotalMap = new HashMap<String, List<KualiDecimal>>();
        List<String> valuesOfsortProperty = this.getContractsGrantsReportHelperService().getListOfValuesSortedProperties(displayList, sortPropertyName);
        for (String value : valuesOfsortProperty) {
            KualiDecimal invoiceSubTotal = KualiDecimal.ZERO;
            KualiDecimal paymentSubTotal = KualiDecimal.ZERO;
            for (ContractsGrantsPaymentHistoryReport cgPaymentHistoryReportEntry : displayList) {
                if (!value.equals(this.getContractsGrantsReportHelperService().getPropertyValue((Object)cgPaymentHistoryReportEntry, sortPropertyName))) continue;
                invoiceSubTotal = (KualiDecimal)invoiceSubTotal.add((AbstractKualiDecimal)cgPaymentHistoryReportEntry.getInvoiceAmount());
                paymentSubTotal = (KualiDecimal)paymentSubTotal.add((AbstractKualiDecimal)cgPaymentHistoryReportEntry.getPaymentAmount());
            }
            ArrayList<KualiDecimal> allSubTotal = new ArrayList<KualiDecimal>();
            allSubTotal.add(0, invoiceSubTotal);
            allSubTotal.add(1, paymentSubTotal);
            returnSubTotalMap.put(value, allSubTotal);
        }
        return returnSubTotalMap;
    }

    protected void setReportDate(ContractsGrantsPaymentHistoryReport cgPaymentHistoryReportEntry, ContractsGrantsPaymentHistoryReportDetailDataHolder reportDetail) {
        reportDetail.setPaymentNumber(cgPaymentHistoryReportEntry.getPaymentNumber());
        reportDetail.setInvoiceType(cgPaymentHistoryReportEntry.getInvoiceType());
        reportDetail.setPaymentDate(cgPaymentHistoryReportEntry.getPaymentDate());
        reportDetail.setCustomerNumber(cgPaymentHistoryReportEntry.getCustomerNumber());
        reportDetail.setCustomerName(cgPaymentHistoryReportEntry.getCustomerName());
        BigDecimal paymentAmount = ObjectUtils.isNull((Object)cgPaymentHistoryReportEntry.getPaymentAmount()) ? BigDecimal.ZERO : cgPaymentHistoryReportEntry.getPaymentAmount().bigDecimalValue();
        reportDetail.setPaymentAmount(paymentAmount);
        reportDetail.setInvoiceNumber(cgPaymentHistoryReportEntry.getInvoiceNumber());
        BigDecimal invoiceAmount = ObjectUtils.isNull((Object)cgPaymentHistoryReportEntry.getInvoiceAmount()) ? BigDecimal.ZERO : cgPaymentHistoryReportEntry.getInvoiceAmount().bigDecimalValue();
        reportDetail.setInvoiceAmount(invoiceAmount);
        reportDetail.setAwardNumber(cgPaymentHistoryReportEntry.getAwardNumber());
        reportDetail.setReversedIndicator(cgPaymentHistoryReportEntry.isReversedIndicator() ? "Yes" : "No");
        reportDetail.setAppliedIndicator(cgPaymentHistoryReportEntry.isAppliedIndicator() ? "Yes" : "No");
    }

    @Override
    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }
}

