/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableMilestoneSchedule;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.ar.AccountsReceivablePredeterminedBillingSchedule;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.DunningCampaign;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;

public class AccountsReceivableModuleBillingServiceImpl
implements AccountsReceivableModuleBillingService {
    protected BusinessObjectService businessObjectService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected KualiModuleService kualiModuleService;
    protected ConfigurationService configurationService;
    protected ParameterService parameterService;

    public KualiDecimal getAwardBilledToDateAmount(ContractsAndGrantsBillingAward award) {
        return this.getContractsGrantsInvoiceDocumentService().getAwardBilledToDateAmount(award.getProposalNumber());
    }

    public KualiDecimal calculateTotalPaymentsToDateByAward(String proposalNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("proposalNumber", proposalNumber);
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)this.getKualiModuleService().getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObject(ContractsAndGrantsBillingAward.class, map);
        return this.getContractsGrantsInvoiceDocumentService().calculateTotalPaymentsToDateByAward(award);
    }

    public AccountsReceivableMilestoneSchedule getMilestoneSchedule() {
        return new MilestoneSchedule();
    }

    public AccountsReceivablePredeterminedBillingSchedule getPredeterminedBillingSchedule() {
        return new PredeterminedBillingSchedule();
    }

    public Date getLastBilledDate(ContractsAndGrantsBillingAward award) {
        return this.getContractsGrantsInvoiceDocumentService().getLastBilledDate(award);
    }

    public List<String> checkAwardContractControlAccounts(ContractsAndGrantsBillingAward award) {
        return this.getContractsGrantsInvoiceDocumentService().checkAwardContractControlAccounts(award);
    }

    public boolean hasPredeterminedBillingSchedule(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        PredeterminedBillingSchedule schedule = (PredeterminedBillingSchedule)this.getBusinessObjectService().findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys);
        return ObjectUtils.isNotNull((Object)((Object)schedule));
    }

    public boolean hasMilestoneSchedule(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        MilestoneSchedule schedule = (MilestoneSchedule)this.getBusinessObjectService().findByPrimaryKey(MilestoneSchedule.class, primaryKeys);
        return ObjectUtils.isNotNull((Object)((Object)schedule));
    }

    public boolean hasActiveUnbilledBills(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        PredeterminedBillingSchedule schedule = (PredeterminedBillingSchedule)this.getBusinessObjectService().findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys);
        if (ObjectUtils.isNotNull((Object)((Object)schedule))) {
            for (Bill bill : schedule.getBills()) {
                if (!bill.isActive() || bill.isBilled()) continue;
                return true;
            }
        }
        return false;
    }

    public KualiDecimal getMilestonesTotalAmount(String proposalNumber) {
        return this.getMilestonesTotalAmountForOtherSchedules(proposalNumber, null, null);
    }

    public KualiDecimal getMilestonesTotalAmountForOtherSchedules(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", proposalNumber);
        fieldValues.put("active", true);
        List milestones = (List)this.businessObjectService.findMatching(Milestone.class, fieldValues);
        return milestones.stream().filter(milestone -> !StringUtils.equals((CharSequence)chartOfAccountsCode, (CharSequence)milestone.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)accountNumber, (CharSequence)milestone.getAccountNumber())).filter(milestone -> ObjectUtils.isNotNull((Object)milestone.getMilestoneAmount())).reduce(KualiDecimal.ZERO, (sum, milestone) -> (KualiDecimal)milestone.getMilestoneAmount().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
    }

    public KualiDecimal getBillsTotalAmount(String proposalNumber) {
        return this.getBillsTotalAmountForOtherSchedules(proposalNumber, null, null);
    }

    public KualiDecimal getBillsTotalAmountForOtherSchedules(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("proposalNumber", proposalNumber);
        fieldValues.put("active", true);
        List bills = (List)this.businessObjectService.findMatching(Bill.class, fieldValues);
        return bills.stream().filter(bill -> !StringUtils.equals((CharSequence)chartOfAccountsCode, (CharSequence)bill.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)accountNumber, (CharSequence)bill.getAccountNumber())).filter(bill -> ObjectUtils.isNotNull((Object)bill.getEstimatedAmount())).reduce(KualiDecimal.ZERO, (sum, bill) -> (KualiDecimal)bill.getEstimatedAmount().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
    }

    public boolean hasActiveUnbilledMilestones(String proposalNumber, String chartOfAccountsCode, String accountNumber) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", proposalNumber);
        primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        primaryKeys.put("accountNumber", accountNumber);
        MilestoneSchedule schedule = (MilestoneSchedule)this.getBusinessObjectService().findByPrimaryKey(MilestoneSchedule.class, primaryKeys);
        if (ObjectUtils.isNotNull((Object)((Object)schedule))) {
            for (Milestone milestone : schedule.getMilestones()) {
                if (!milestone.isActive() || milestone.isBilled()) continue;
                return true;
            }
        }
        return false;
    }

    public String getContractsGrantsInvoiceDocumentType() {
        return "CINV";
    }

    public boolean isContractsGrantsBillingEnhancementActive() {
        return this.getConfigurationService().getPropertyValueAsBoolean("contracts.grants.billing.enabled");
    }

    public String getDefaultDunningCampaignCode() {
        return this.getParameterService().getParameterValueAsString(DunningCampaign.class, "DUNNING_CAMPAIGN", "");
    }

    public String getDefaultBillingFrequency() {
        return this.getParameterService().getParameterValueAsString(ContractsGrantsInvoiceDocument.class, "DEFAULT_BILLING_FREQUENCY", "");
    }

    public String getDefaultInvoicingOption() {
        return this.getParameterService().getParameterValueAsString(ContractsGrantsInvoiceDocument.class, "DEFAULT_INVOICING_OPTION", "");
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

