/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.module.ar.service.AccountsReceivablePdfHelperService;

public class AccountsReceivablePdfHelperServiceImpl
implements AccountsReceivablePdfHelperService {
    @Override
    public ByteArrayOutputStream buildPdfOutputStream(byte[] content) throws IOException, DocumentException, BadPdfFormatException {
        ArrayList<byte[]> contents = new ArrayList<byte[]>();
        contents.add(content);
        return this.buildPdfOutputStream(contents);
    }

    @Override
    public ByteArrayOutputStream buildPdfOutputStream(List<byte[]> contents) throws IOException, DocumentException, BadPdfFormatException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayList master = new ArrayList();
        Document document = null;
        PdfCopy writer = null;
        boolean createDocument = true;
        for (byte[] content : contents) {
            PdfReader reader = new PdfReader(content);
            reader.consolidateNamedDestinations();
            int n = reader.getNumberOfPages();
            List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
            if (bookmarks != null) {
                master.addAll(bookmarks);
            }
            if (createDocument) {
                document = new Document(reader.getPageSizeWithRotation(1));
                writer = new PdfCopy(document, (OutputStream)baos);
                document.open();
            }
            int i = 0;
            while (i < n) {
                PdfImportedPage page = writer.getImportedPage(reader, ++i);
                writer.addPage(page);
            }
            writer.freeReader(reader);
            createDocument = false;
        }
        if (!master.isEmpty()) {
            writer.setOutlines(master);
        }
        document.close();
        return baos;
    }
}

