/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.module.ar.batch.CustomerDigestersVO;
import org.kuali.kfs.module.ar.batch.service.CustomerLoadService;
import org.kuali.kfs.sys.batch.XmlBatchInputFileTypeBase;
import org.kuali.kfs.sys.exception.ParseException;

public class CustomerLoadInputFileType
extends XmlBatchInputFileTypeBase {
    private static final Logger LOG = LogManager.getLogger();
    private static final String FILE_NAME_PREFIX = "customer_load";
    private static final String FILE_NAME_DELIM = "_";
    private CustomerLoadService customerLoadService;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        return this.customerLoadService.getFileName(principalName, fileUserIdentifier, FILE_NAME_PREFIX, FILE_NAME_DELIM);
    }

    public String getFileTypeIdentifier() {
        return "customerLoadInputFileType";
    }

    public Object parse(byte[] fileByteContent) {
        Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])fileByteContent), (String)"fileByteContent must be provided", (Object[])new Object[0]);
        ByteArrayInputStream validateFileContents = new ByteArrayInputStream(fileByteContent);
        this.validateContentsAgainstSchema(this.getSchemaLocation(), validateFileContents);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileByteContent);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CustomerDigestersVO.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            CustomerDigestersVO customerDigestersVO = (CustomerDigestersVO)jaxbUnmarshaller.unmarshal((InputStream)byteArrayInputStream);
            return customerDigestersVO.getCustomerDigesterVOs();
        }
        catch (JAXBException e) {
            LOG.error("Error parsing xml contents", (Throwable)e);
            throw new ParseException("Error parsing xml contents: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean validate(Object parsedFileContents) {
        try {
            List customerVOs = (List)parsedFileContents;
            return this.customerLoadService.validate(customerVOs);
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = parsedFileContents::getClass;
            LOG.error("Could not convert the passed-in parsedFileContents of type [{}] to List<CustomerDigesterVO>.", supplierArray);
            throw new RuntimeException("Could not convert the passed-in parsedFileContents of type [" + parsedFileContents.getClass().toString() + "] to List<CustomerDigesterVO>.", e);
        }
    }

    public void process(String fileName, Object parsedFileContents) {
        super.process(fileName, parsedFileContents);
    }

    public String getTitleKey() {
        return "message.ar.customerLoad.batchUpload.xml.title";
    }

    public void setCustomerLoadService(CustomerLoadService customerLoadService) {
        this.customerLoadService = customerLoadService;
    }

    public String getAuthorPrincipalName(File file) {
        String[] fileNameParts = StringUtils.split((String)file.getName(), (String)FILE_NAME_DELIM);
        if (fileNameParts.length > 3) {
            return fileNameParts[2];
        }
        return null;
    }
}

