/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.report;

import java.util.ArrayList;
import java.util.List;

public class CustomerLoadResult {
    private String filename;
    private String customerName;
    private ResultCode result;
    private String workflowDocId;
    private List<String[]> messages;

    public CustomerLoadResult() {
        this.messages = new ArrayList<String[]>();
    }

    public CustomerLoadResult(String filename, String customerName) {
        this.filename = filename;
        this.customerName = customerName;
        this.result = ResultCode.INCOMPLETE;
        this.messages = new ArrayList<String[]>();
    }

    public static String getEntryTypeString(EntryType type) {
        String result;
        switch (type) {
            case INFO: {
                result = "INFO";
                break;
            }
            case ERROR: {
                result = "ERROR";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        return result;
    }

    public static String getResultCodeString(ResultCode resultCode) {
        String result;
        switch (resultCode) {
            case SUCCESS: {
                result = "SUCCESS";
                break;
            }
            case FAILURE: {
                result = "FAILURES";
                break;
            }
            case ERROR: {
                result = "ERROR";
                break;
            }
            case INCOMPLETE: {
                result = "INCOMPLETE";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        return result;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public ResultCode getResult() {
        return this.result;
    }

    public String getResultString() {
        return CustomerLoadResult.getResultCodeString(this.result);
    }

    private void setResult(ResultCode result) {
        this.result = result;
    }

    public void setSuccessResult() {
        this.result = ResultCode.SUCCESS;
    }

    public void setFailureResult() {
        this.result = ResultCode.FAILURE;
    }

    public void setErrorResult() {
        this.result = ResultCode.ERROR;
    }

    public String getWorkflowDocId() {
        return this.workflowDocId;
    }

    public void setWorkflowDocId(String workflowDocId) {
        this.workflowDocId = workflowDocId;
    }

    public List<String[]> getMessages() {
        return this.messages;
    }

    private void addMessage(EntryType entryType, String message) {
        this.messages.add(new String[]{CustomerLoadResult.getEntryTypeString(entryType), message});
    }

    public void addErrorMessage(String message) {
        this.addMessage(EntryType.ERROR, message);
    }

    public void addInfoMessage(String message) {
        this.addMessage(EntryType.INFO, message);
    }

    public static enum EntryType {
        INFO,
        ERROR;

    }

    public static enum ResultCode {
        SUCCESS,
        FAILURE,
        ERROR,
        INCOMPLETE;

    }
}

