/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.ar.ArConstants;

public class BillingPeriod {
    private final AccountingPeriodService accountingPeriodService;
    private final ArConstants.BillingFrequencyValues billingFrequency;
    private final java.sql.Date awardStartDate;
    private final java.sql.Date currentDate;
    protected final java.sql.Date lastBilledDate;
    private java.sql.Date startDate;
    private java.sql.Date endDate;
    private boolean billable;

    BillingPeriod(ArConstants.BillingFrequencyValues billingFrequency, java.sql.Date awardStartDate, java.sql.Date currentDate, java.sql.Date lastBilledDate, AccountingPeriodService accountingPeriodService) {
        this.awardStartDate = awardStartDate;
        this.lastBilledDate = lastBilledDate;
        this.accountingPeriodService = accountingPeriodService;
        this.billingFrequency = billingFrequency;
        this.currentDate = currentDate;
    }

    public static BillingPeriod determineBillingPeriodPriorTo(java.sql.Date awardStartDate, java.sql.Date currentDate, java.sql.Date lastBilledDate, ArConstants.BillingFrequencyValues billingFrequency, AccountingPeriodService accountingPeriodService) {
        BillingPeriod billingPeriod = new BillingPeriod(billingFrequency, awardStartDate, currentDate, lastBilledDate, accountingPeriodService);
        billingPeriod.billable = billingPeriod.canThisBeBilled();
        if (billingPeriod.billable) {
            billingPeriod.startDate = billingPeriod.determineStartDate();
            billingPeriod.endDate = billingPeriod.determineEndDateByFrequency();
        }
        return billingPeriod;
    }

    private java.sql.Date determineEndDateByFrequency() {
        AccountingPeriod accountingPeriod = this.findPreviousAccountingPeriod(this.currentDate);
        return accountingPeriod.getUniversityFiscalPeriodEndDate();
    }

    private static Integer calculatePreviousPeriodByFrequency(Integer currentAccountingPeriodCode, int periodsInBillingFrequency) {
        int subAmt = currentAccountingPeriodCode % periodsInBillingFrequency == 0 ? periodsInBillingFrequency : currentAccountingPeriodCode % periodsInBillingFrequency;
        return currentAccountingPeriodCode - subAmt;
    }

    private boolean canThisBeBilledByBillingFrequency() {
        if (this.billingFrequency == ArConstants.BillingFrequencyValues.ANNUALLY && this.accountingPeriodService.getByDate(this.lastBilledDate).getUniversityFiscalYear() >= this.accountingPeriodService.getByDate(this.currentDate).getUniversityFiscalYear()) {
            return false;
        }
        return !StringUtils.equals((CharSequence)this.findPreviousAccountingPeriod(this.currentDate).getUniversityFiscalPeriodCode(), (CharSequence)this.findPreviousAccountingPeriod(this.lastBilledDate).getUniversityFiscalPeriodCode()) || !this.accountingPeriodService.getByDate(this.lastBilledDate).getUniversityFiscalYear().equals(this.accountingPeriodService.getByDate(this.currentDate).getUniversityFiscalYear());
    }

    private java.sql.Date determineStartDate() {
        if (this.lastBilledDate == null) {
            if (this.awardStartDate.after(this.currentDate)) {
                AccountingPeriod previousAccountingPeriod = this.findPreviousAccountingPeriod(this.currentDate);
                AccountingPeriod beforePreviousAccountingPeriod = this.findPreviousAccountingPeriod(previousAccountingPeriod.getUniversityFiscalPeriodEndDate());
                return BillingPeriod.calculateNextDay(beforePreviousAccountingPeriod.getUniversityFiscalPeriodEndDate());
            }
            return this.awardStartDate;
        }
        return this.determineStartDateByFrequency();
    }

    private java.sql.Date determineStartDateByFrequency() {
        AccountingPeriod lastBilledDateAccountingPeriod = this.billingFrequency == ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT || this.billingFrequency == ArConstants.BillingFrequencyValues.MONTHLY || this.billingFrequency == ArConstants.BillingFrequencyValues.MANUAL || this.billingFrequency == ArConstants.BillingFrequencyValues.MILESTONE || this.billingFrequency == ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING ? this.findAccountingPeriodBy(this.lastBilledDate) : this.findPreviousAccountingPeriod(this.lastBilledDate);
        return BillingPeriod.calculateNextDay(lastBilledDateAccountingPeriod.getUniversityFiscalPeriodEndDate());
    }

    private AccountingPeriod findPreviousAccountingPeriod(java.sql.Date date) {
        AccountingPeriod currentAccountingPeriod = this.findAccountingPeriodBy(date);
        Integer currentAccountingPeriodCode = Integer.parseInt(currentAccountingPeriod.getUniversityFiscalPeriodCode());
        Integer previousAccountingPeriodCode = this.findPreviousAccountingPeriodCode(currentAccountingPeriodCode);
        Integer currentFiscalYear = currentAccountingPeriod.getUniversityFiscalYear();
        if (previousAccountingPeriodCode == 0) {
            previousAccountingPeriodCode = 12;
            currentFiscalYear = currentFiscalYear - 1;
        }
        Object periodCode = previousAccountingPeriodCode < 10 ? "0" + previousAccountingPeriodCode : String.valueOf(previousAccountingPeriodCode);
        return this.accountingPeriodService.getByPeriod((String)periodCode, currentFiscalYear);
    }

    private Integer findPreviousAccountingPeriodCode(Integer currentAccountingPeriodCode) {
        Integer previousAccountingPeriodCode = this.billingFrequency == ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT || this.billingFrequency == ArConstants.BillingFrequencyValues.MONTHLY || this.billingFrequency == ArConstants.BillingFrequencyValues.MANUAL || this.billingFrequency == ArConstants.BillingFrequencyValues.MILESTONE || this.billingFrequency == ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING ? BillingPeriod.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 1) : (this.billingFrequency == ArConstants.BillingFrequencyValues.QUARTERLY ? BillingPeriod.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 3) : (this.billingFrequency == ArConstants.BillingFrequencyValues.SEMI_ANNUALLY ? BillingPeriod.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 6) : BillingPeriod.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 12)));
        return previousAccountingPeriodCode;
    }

    public java.sql.Date getStartDate() {
        return this.startDate;
    }

    public java.sql.Date getEndDate() {
        return this.endDate;
    }

    private AccountingPeriod findAccountingPeriodBy(java.sql.Date date) {
        return this.accountingPeriodService.getByDate(date);
    }

    boolean canThisBeBilled() {
        if (this.lastBilledDate == null) {
            return true;
        }
        return this.canThisBeBilledByBillingFrequency();
    }

    private static java.sql.Date calculateNextDay(java.sql.Date date) {
        return new java.sql.Date(DateUtils.addDays((Date)date, (int)1).getTime());
    }

    public boolean isBillable() {
        return this.billable;
    }
}

