/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableTaxService;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AccountsReceivableTaxServiceImpl
implements AccountsReceivableTaxService {
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    protected CustomerAddressService customerAddressService;

    @Override
    public boolean isCustomerInvoiceDetailTaxable(CustomerInvoiceDocument customerInvoiceDocument, CustomerInvoiceDetail customerInvoiceDetail) {
        if (!this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.ACCOUNTS_RECEIVABLE_DOCUMENT.class, "SALES_TAX_IND").booleanValue()) {
            return false;
        }
        if (ObjectUtils.isNotNull((Object)((Object)customerInvoiceDocument.getCustomer())) && customerInvoiceDocument.getCustomer().isCustomerTaxExemptIndicator()) {
            return false;
        }
        if (!customerInvoiceDetail.isTaxableIndicator()) {
            return false;
        }
        return ObjectUtils.isNull((Object)customerInvoiceDocument.getShippingZipCode()) || !StringUtils.equals((CharSequence)customerInvoiceDocument.getShippingCountryCode(), (CharSequence)customerInvoiceDocument.getBillingCountryCode()) || StringUtils.equals((CharSequence)customerInvoiceDocument.getShippingStateCode(), (CharSequence)customerInvoiceDocument.getBillingStateCode());
    }

    @Override
    public String getPostalCodeForTaxation(CustomerInvoiceDocument document) {
        String postalCode = null;
        String customerNumber = document.getAccountsReceivableDocumentHeader().getCustomerNumber();
        Integer shipToAddressIdentifier = document.getCustomerShipToAddressIdentifier();
        if (ObjectUtils.isNotNull((Object)shipToAddressIdentifier) && StringUtils.isNotEmpty((CharSequence)customerNumber)) {
            CustomerAddress customerShipToAddress = this.customerAddressService.getByPrimaryKey(customerNumber, shipToAddressIdentifier);
            if (ObjectUtils.isNotNull((Object)customerShipToAddress)) {
                postalCode = customerShipToAddress.getCustomerZipCode();
            }
        } else {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("chartOfAccountsCode", document.getBillByChartOfAccountCode());
            criteria.put("organizationCode", document.getBilledByOrganizationCode());
            OrganizationOptions organizationOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
            if (ObjectUtils.isNotNull((Object)((Object)organizationOptions))) {
                postalCode = organizationOptions.getOrganizationPostalZipCode();
            }
        }
        return postalCode;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }
}

