/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.NonInvoiced;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.NonAppliedHoldingService;
import org.kuali.kfs.module.ar.document.service.PaymentApplicationDocumentService;
import org.kuali.kfs.module.ar.document.validation.impl.PaymentApplicationDocumentRuleUtil;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationForm;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceApply;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceDetailApply;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;

public class PaymentApplicationAction
extends FinancialSystemTransactionalDocumentActionBase {
    private static final Logger LOG = LogManager.getLogger();
    private PaymentApplicationDocumentService paymentApplicationDocumentService;
    private CustomerInvoiceDocumentService customerInvoiceDocumentService;
    private CustomerInvoiceDetailService customerInvoiceDetailService;
    private NonAppliedHoldingService nonAppliedHoldingService;

    public ActionForward adjust(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.reload(mapping, form, request, response);
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        PaymentApplicationDocument applicationDocument = (PaymentApplicationDocument)kualiDocumentFormBase.getDocument();
        PaymentApplicationAdjustmentDocument appAdjustDocument = this.getPaymentApplicationDocumentService().createPaymentApplicationAdjustment(applicationDocument);
        kualiDocumentFormBase.setDocument((Document)appAdjustDocument);
        return PaymentApplicationAction.createActionForward((KualiDocumentFormBase)form);
    }

    private static ActionForward createActionForward(KualiDocumentFormBase form) {
        String baseUrl = PaymentApplicationAction.getApplicationBaseUrl() + "/arPaymentApplicationAdjustment.do";
        String docNum = form.getDocument().getDocumentNumber();
        Map parameters = Map.ofEntries(Map.entry("methodToCall", "docHandler"), Map.entry("command", "displayDocSearchView"), Map.entry("docId", docNum));
        String url = UrlFactory.parameterizeUrl((String)baseUrl, parameters);
        return new ActionForward(url, true);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return super.execute(mapping, form, request, response);
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doApplicationOfFunds((PaymentApplicationForm)form);
        return super.route(mapping, form, request, response);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doApplicationOfFunds((PaymentApplicationForm)form);
        return super.save(mapping, form, request, response);
    }

    public ActionForward deleteNonArLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm paymentApplicationForm = (PaymentApplicationForm)form;
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        int deleteIndex = this.getLineToDelete(request);
        paymentApplicationDocument.getNonInvoiceds().remove(deleteIndex);
        int nonInvoicedItemNumber = 1;
        for (NonInvoiced n : paymentApplicationDocument.getNonInvoiceds()) {
            n.setFinancialDocumentLineNumber(nonInvoicedItemNumber++);
            n.refreshReferenceObject("chartOfAccounts");
            n.refreshReferenceObject("account");
            n.refreshReferenceObject("subAccount");
            n.refreshReferenceObject("financialObject");
            n.refreshReferenceObject("financialSubObject");
            n.refreshReferenceObject("project");
        }
        return mapping.findForward("basic");
    }

    protected InvoicePaidApplied generateAndValidateNewPaidApplied(PaymentApplicationInvoiceDetailApply detailApplication, String fieldName, PaymentApplicationDocument document) {
        InvoicePaidApplied paidApplied = detailApplication.generatePaidApplied();
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = paidApplied::getDocumentNumber;
        LOG.debug("Validating the generated paidApplied {}", supplierArray);
        PaymentApplicationDocumentRuleUtil.validateInvoicePaidApplied(paidApplied, fieldName, document);
        return paidApplied;
    }

    public ActionForward applyAllAmounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doApplicationOfFunds((PaymentApplicationForm)form);
        return mapping.findForward("basic");
    }

    public ActionForward clearUnapplied(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        PaymentApplicationDocument payAppDoc = payAppForm.getPaymentApplicationDocument();
        NonAppliedHolding nonAppliedHolding = payAppDoc.getNonAppliedHolding();
        if (ObjectUtils.isNotNull((Object)((Object)nonAppliedHolding))) {
            if (this.getBusinessObjectService().retrieve((PersistableBusinessObject)nonAppliedHolding) != null) {
                this.getBusinessObjectService().delete((PersistableBusinessObject)nonAppliedHolding);
            }
            payAppDoc.setNonAppliedHolding(null);
            payAppForm.setNonAppliedHoldingAmount(null);
            payAppForm.setNonAppliedHoldingCustomerNumber(null);
        }
        return mapping.findForward("basic");
    }

    protected void doApplicationOfFunds(PaymentApplicationForm paymentApplicationForm) {
        KualiDecimal controlTotalAmount;
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        ArrayList<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>();
        invoicePaidApplieds.addAll(this.applyToIndividualCustomerInvoiceDetails(paymentApplicationForm));
        invoicePaidApplieds.addAll(this.quickApplyToInvoices(paymentApplicationForm, invoicePaidApplieds));
        int paidAppliedItemNumber = 1;
        for (InvoicePaidApplied i : invoicePaidApplieds) {
            i.setPaidAppliedItemNumber(paidAppliedItemNumber++);
        }
        NonInvoiced nonInvoiced = this.applyNonInvoiced(paymentApplicationForm);
        NonAppliedHolding nonAppliedHolding = this.applyUnapplied(paymentApplicationForm);
        KualiDecimal sumOfInvoicePaidApplieds = KualiDecimal.ZERO;
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            KualiDecimal amount = invoicePaidApplied.getInvoiceItemAppliedAmount();
            if (null == amount) {
                amount = KualiDecimal.ZERO;
            }
            sumOfInvoicePaidApplieds = (KualiDecimal)sumOfInvoicePaidApplieds.add((AbstractKualiDecimal)amount);
        }
        KualiDecimal appliedAmount = KualiDecimal.ZERO;
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)sumOfInvoicePaidApplieds);
        if (null != nonInvoiced && null != nonInvoiced.getFinancialDocumentLineAmount()) {
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)nonInvoiced.getFinancialDocumentLineAmount());
        }
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonAppliedDistributions());
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonInvoicedDistributions());
        appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getSumOfNonInvoiceds());
        if (null != paymentApplicationDocument.getNonAppliedHoldingAmount()) {
            appliedAmount = (KualiDecimal)appliedAmount.add((AbstractKualiDecimal)paymentApplicationDocument.getNonAppliedHoldingAmount());
        }
        if (appliedAmount.isGreaterThan((AbstractKualiDecimal)(controlTotalAmount = paymentApplicationForm.getTotalFromControl()))) {
            this.addGlobalError("error.document.paymentApplication.quickAppliedExceedsCashControlTotalAmount");
        }
        paymentApplicationDocument.getInvoicePaidApplieds().clear();
        paymentApplicationDocument.getInvoicePaidApplieds().addAll(invoicePaidApplieds);
        if (null != nonInvoiced) {
            paymentApplicationDocument.getNonInvoiceds().add(nonInvoiced);
            int nonInvoicedItemNumber = 1;
            for (NonInvoiced n : paymentApplicationDocument.getNonInvoiceds()) {
                n.setFinancialDocumentLineNumber(nonInvoicedItemNumber++);
                n.refreshReferenceObject("chartOfAccounts");
                n.refreshReferenceObject("account");
                n.refreshReferenceObject("subAccount");
                n.refreshReferenceObject("financialObject");
                n.refreshReferenceObject("financialSubObject");
                n.refreshReferenceObject("project");
            }
            paymentApplicationForm.setNonInvoicedAddLine(new NonInvoiced());
        }
        paymentApplicationForm.setNonAppliedControlAllocations(null);
        if (!paymentApplicationDocument.hasCashControlDetail()) {
            paymentApplicationDocument.getDocumentHeader().setFinancialDocumentTotalAmount(appliedAmount);
        }
    }

    protected List<InvoicePaidApplied> applyToIndividualCustomerInvoiceDetails(PaymentApplicationForm paymentApplicationForm) {
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        int simpleInvoiceDetailApplicationCounter = 0;
        List<InvoicePaidApplied> invoicePaidApplieds = this.filterTempInvoicePaidApplieds(paymentApplicationForm);
        for (PaymentApplicationInvoiceApply invoiceApplication : paymentApplicationForm.getInvoiceApplications()) {
            for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                String fieldName = "selectedInvoiceDetailApplications[" + simpleInvoiceDetailApplicationCounter + "].amountApplied";
                ++simpleInvoiceDetailApplicationCounter;
                if (detailApplication.isFullApply()) {
                    detailApplication.setAmountApplied(detailApplication.getAmountOpen());
                } else if (detailApplication.isFullApplyChanged()) {
                    detailApplication.setAmountApplied(KualiDecimal.ZERO);
                }
                if (KualiDecimal.ZERO.equals((Object)detailApplication.getAmountApplied()) || this.containsIdentical(detailApplication.getInvoiceDetail(), detailApplication.getAmountApplied(), invoicePaidApplieds)) continue;
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = detailApplication::getInvoiceDocumentNumber;
                LOG.debug("Generating paid applied for detail application {}", supplierArray);
                InvoicePaidApplied invoicePaidApplied = this.generateAndValidateNewPaidApplied(detailApplication, fieldName, paymentApplicationDocument);
                GlobalVariables.getMessageMap().addToErrorPath("customerInvoiceDetail*");
                GlobalVariables.getMessageMap().removeFromErrorPath("customerInvoiceDetail*");
                invoicePaidApplieds.add(invoicePaidApplied);
            }
        }
        return invoicePaidApplieds;
    }

    protected List<InvoicePaidApplied> filterTempInvoicePaidApplieds(PaymentApplicationForm paymentApplicationForm) {
        PaymentApplicationDocument paymentApplicationDocument = paymentApplicationForm.getPaymentApplicationDocument();
        List<InvoicePaidApplied> invoicePaidApplieds = paymentApplicationDocument.getInvoicePaidApplieds();
        return new ArrayList<InvoicePaidApplied>(invoicePaidApplieds);
    }

    protected String findCustomerNumber(PaymentApplicationForm paymentApplicationForm) {
        boolean validInvoice = this.isValidInvoice(paymentApplicationForm);
        String customerNumber = paymentApplicationForm.getSelectedCustomerNumber();
        String currentInvoiceNumber = paymentApplicationForm.getEnteredInvoiceDocumentNumber();
        if (StringUtils.isBlank((CharSequence)customerNumber) && StringUtils.isNotBlank((CharSequence)currentInvoiceNumber) && validInvoice) {
            Customer customer = this.getCustomerInvoiceDocumentService().getCustomerByInvoiceDocumentNumber(currentInvoiceNumber);
            customerNumber = customer.getCustomerNumber();
        }
        return customerNumber;
    }

    protected boolean isValidInvoice(PaymentApplicationForm paymentApplicationForm) {
        boolean validInvoice = true;
        if (StringUtils.isNotBlank((CharSequence)paymentApplicationForm.getEnteredInvoiceDocumentNumber()) && !this.getCustomerInvoiceDocumentService().checkIfInvoiceNumberIsFinal(paymentApplicationForm.getEnteredInvoiceDocumentNumber())) {
            validInvoice = false;
        }
        return validInvoice;
    }

    protected boolean containsIdentical(CustomerInvoiceDetail customerInvoiceDetail, KualiDecimal amountApplied, List<InvoicePaidApplied> invoicePaidApplieds) {
        boolean identicalFlag = false;
        String custRefInvoiceDocNumber = customerInvoiceDetail.getDocumentNumber();
        Integer custInvoiceSequenceNumber = customerInvoiceDetail.getInvoiceItemNumber();
        for (InvoicePaidApplied invoicePaidApplied : invoicePaidApplieds) {
            String refInvoiceDocNumber = invoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber();
            Integer invoiceSequenceNumber = invoicePaidApplied.getInvoiceItemNumber();
            KualiDecimal appliedAmount = invoicePaidApplied.getInvoiceItemAppliedAmount();
            if (!custRefInvoiceDocNumber.equals(refInvoiceDocNumber) || !custInvoiceSequenceNumber.equals(invoiceSequenceNumber) || !amountApplied.equals((Object)appliedAmount)) continue;
            identicalFlag = true;
            break;
        }
        return identicalFlag;
    }

    protected List<InvoicePaidApplied> quickApplyToInvoices(PaymentApplicationForm paymentApplicationForm, List<InvoicePaidApplied> appliedToIndividualDetails) {
        PaymentApplicationDocument applicationDocument = (PaymentApplicationDocument)paymentApplicationForm.getDocument();
        ArrayList<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>();
        for (PaymentApplicationInvoiceApply invoiceApplication : paymentApplicationForm.getInvoiceApplications()) {
            String invoiceDocNumber = invoiceApplication.getDocumentNumber();
            if (!invoiceApplication.isQuickApply()) {
                if (!invoiceApplication.isQuickApplyChanged()) continue;
                for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                    detailApplication.setAmountApplied(KualiDecimal.ZERO);
                    detailApplication.setFullApply(false);
                    for (int i = appliedToIndividualDetails.size() - 1; i >= 0; --i) {
                        InvoicePaidApplied applied = appliedToIndividualDetails.get(i);
                        if (!applied.getFinancialDocumentReferenceInvoiceNumber().equals(invoiceApplication.getDocumentNumber())) continue;
                        appliedToIndividualDetails.remove(i);
                    }
                }
                continue;
            }
            if (invoiceApplication.getOpenAmount().isZero()) {
                this.addGlobalError("error.document.paymentApplication.cannotQuickApplyOnInvoiceWithZeroOpenAmount");
                return invoicePaidApplieds;
            }
            for (int i = appliedToIndividualDetails.size() - 1; i >= 0; --i) {
                InvoicePaidApplied applied = appliedToIndividualDetails.get(i);
                if (!applied.getFinancialDocumentReferenceInvoiceNumber().equals(invoiceApplication.getDocumentNumber())) continue;
                appliedToIndividualDetails.remove(i);
            }
            String fieldName = "invoiceApplications[" + invoiceDocNumber + "].quickApply";
            for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                detailApplication.setAmountApplied(detailApplication.getAmountOpen());
                detailApplication.setFullApply(true);
                InvoicePaidApplied paidApplied = this.generateAndValidateNewPaidApplied(detailApplication, fieldName, applicationDocument);
                if (paidApplied == null) continue;
                invoicePaidApplieds.add(paidApplied);
            }
            if (!invoiceDocNumber.equals(paymentApplicationForm.getEnteredInvoiceDocumentNumber())) continue;
            paymentApplicationForm.setSelectedInvoiceDocumentNumber(invoiceDocNumber);
        }
        return invoicePaidApplieds;
    }

    protected NonInvoiced applyNonInvoiced(PaymentApplicationForm payAppForm) {
        boolean isValid;
        PaymentApplicationDocument applicationDocument = (PaymentApplicationDocument)payAppForm.getDocument();
        NonInvoiced nonInvoiced = payAppForm.getNonInvoicedAddLine();
        if (ObjectUtils.isNull((Object)((Object)payAppForm.getNonInvoicedAddLine())) || nonInvoiced.getFinancialDocumentLineAmount() == null || nonInvoiced.getFinancialDocumentLineAmount().isZero()) {
            return null;
        }
        nonInvoiced.setFinancialDocumentPostingYear(applicationDocument.getPostingYear());
        nonInvoiced.setDocumentNumber(applicationDocument.getDocumentNumber());
        nonInvoiced.setFinancialDocumentLineNumber(payAppForm.getNextNonInvoicedLineNumber());
        if (StringUtils.isNotBlank((CharSequence)nonInvoiced.getChartOfAccountsCode())) {
            nonInvoiced.setChartOfAccountsCode(nonInvoiced.getChartOfAccountsCode().toUpperCase(Locale.US));
        }
        if (!(isValid = PaymentApplicationDocumentRuleUtil.validateNonInvoiced(nonInvoiced, applicationDocument, payAppForm.getTotalFromControl()))) {
            return null;
        }
        return nonInvoiced;
    }

    protected NonAppliedHolding applyUnapplied(PaymentApplicationForm payAppForm) {
        PaymentApplicationDocument payAppDoc = payAppForm.getPaymentApplicationDocument();
        KualiDecimal amount = payAppForm.getNonAppliedHoldingAmount();
        if (StringUtils.isNotBlank((CharSequence)payAppForm.getNonAppliedHoldingCustomerNumber())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("customerNumber", payAppForm.getNonAppliedHoldingCustomerNumber().toUpperCase(Locale.US));
            int found = this.getBusinessObjectService().countMatching(Customer.class, pkMap);
            if (found == 0) {
                this.addFieldError("document.nonAppliedHolding*", "document.nonAppliedHolding.customerNumber", "error.document.paymentApplication.enteredInvoiceCustomerNumberInvalid");
                return null;
            }
            payAppForm.setNonAppliedHoldingCustomerNumber(payAppForm.getNonAppliedHoldingCustomerNumber().toUpperCase(Locale.US));
        }
        if (payAppForm.getNonAppliedHoldingAmount() != null && payAppForm.getNonAppliedHoldingAmount().isNegative()) {
            this.addFieldError("document.nonAppliedHolding*", "document.nonAppliedHolding.financialDocumentLineAmount", "error.document.paymentApplication.unappliedAmountCannotBeNegative");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)payAppForm.getNonAppliedHoldingCustomerNumber()) || amount == null || amount.isZero()) {
            payAppDoc.setNonAppliedHolding(null);
            return null;
        }
        NonAppliedHolding nonAppliedHolding = payAppDoc.getNonAppliedHolding();
        if (ObjectUtils.isNull((Object)((Object)nonAppliedHolding))) {
            nonAppliedHolding = new NonAppliedHolding();
            nonAppliedHolding.setCustomerNumber(payAppForm.getNonAppliedHoldingCustomerNumber().toUpperCase(Locale.US));
            nonAppliedHolding.setReferenceFinancialDocumentNumber(payAppDoc.getDocumentNumber());
            payAppDoc.setNonAppliedHolding(nonAppliedHolding);
        }
        nonAppliedHolding.setFinancialDocumentLineAmount(amount);
        boolean isValid = PaymentApplicationDocumentRuleUtil.validateNonAppliedHolding(payAppDoc, payAppForm.getTotalFromControl());
        if (!isValid) {
            return null;
        }
        return nonAppliedHolding;
    }

    public ActionForward loadInvoices(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm pform = (PaymentApplicationForm)form;
        this.loadInvoices(pform, pform.getEnteredInvoiceDocumentNumber());
        return mapping.findForward("basic");
    }

    protected void loadInvoices(PaymentApplicationForm payAppForm, String selectedInvoiceNumber) {
        String customerNumber;
        boolean validInvoice;
        PaymentApplicationDocument payAppDoc = payAppForm.getPaymentApplicationDocument();
        AccountsReceivableDocumentHeader arDocHeader = payAppDoc.getAccountsReceivableDocumentHeader();
        String currentInvoiceNumber = selectedInvoiceNumber;
        if (StringUtils.isNotBlank((CharSequence)payAppForm.getSelectedCustomerNumber())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("customerNumber", payAppForm.getSelectedCustomerNumber());
            int found = this.getBusinessObjectService().countMatching(Customer.class, pkMap);
            if (found == 0) {
                this.addFieldError("customerInvoiceDetail*", "selectedCustomerNumber", "error.document.paymentApplication.enteredInvoiceCustomerNumberInvalid");
            }
        }
        if (!(validInvoice = this.isValidInvoice(payAppForm))) {
            this.addFieldError("customerInvoiceDetail*", "enteredInvoiceDocumentNumber", "error.document.customerInvoiceDocument.notFinal");
        }
        if (StringUtils.isBlank((CharSequence)payAppForm.getSelectedCustomerNumber())) {
            if (StringUtils.isBlank((CharSequence)arDocHeader.getCustomerNumber())) {
                if (payAppDoc.hasCashControlDetail()) {
                    payAppForm.setSelectedCustomerNumber(payAppDoc.getCashControlDetail().getCustomerNumber());
                    arDocHeader.setCustomerNumber(payAppDoc.getCashControlDetail().getCustomerNumber());
                }
            } else {
                payAppForm.setSelectedCustomerNumber(arDocHeader.getCustomerNumber());
            }
        } else {
            arDocHeader.setCustomerNumber(payAppForm.getSelectedCustomerNumber());
        }
        if (StringUtils.isBlank((CharSequence)(customerNumber = payAppForm.getSelectedCustomerNumber())) && StringUtils.isNotBlank((CharSequence)currentInvoiceNumber) && validInvoice) {
            Customer customer = this.getCustomerInvoiceDocumentService().getCustomerByInvoiceDocumentNumber(currentInvoiceNumber);
            customerNumber = customer.getCustomerNumber();
            payAppDoc.getAccountsReceivableDocumentHeader().setCustomerNumber(customerNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)customerNumber) && !payAppDoc.hasCashControlDocument()) {
            ArrayList<PaymentApplicationDocument> nonAppliedControlDocs = new ArrayList<PaymentApplicationDocument>();
            ArrayList<NonAppliedHolding> nonAppliedControlHoldings = new ArrayList<NonAppliedHolding>();
            if (payAppDoc.isFinal()) {
                nonAppliedControlDocs.addAll(payAppDoc.getPaymentApplicationDocumentsUsedAsControlDocuments());
                nonAppliedControlHoldings.addAll(payAppDoc.getNonAppliedHoldingsUsedAsControls());
            } else {
                nonAppliedControlHoldings.addAll(this.getNonAppliedHoldingService().getNonAppliedHoldingsForCustomer(customerNumber));
                ArrayList<String> controlDocNumbers = new ArrayList<String>();
                for (NonAppliedHolding nonAppliedHolding : nonAppliedControlHoldings) {
                    if (!nonAppliedHolding.getAvailableUnappliedAmount().isPositive() || controlDocNumbers.contains(nonAppliedHolding.getReferenceFinancialDocumentNumber())) continue;
                    controlDocNumbers.add(nonAppliedHolding.getReferenceFinancialDocumentNumber());
                }
                if (!controlDocNumbers.isEmpty()) {
                    List docs = this.getDocumentService().getDocumentsByListOfDocumentHeaderIds(PaymentApplicationDocument.class, controlDocNumbers);
                    for (Document doc : docs) {
                        nonAppliedControlDocs.add((PaymentApplicationDocument)doc);
                    }
                }
            }
            payAppForm.setNonAppliedControlDocs(nonAppliedControlDocs);
            payAppForm.setNonAppliedControlHoldings(nonAppliedControlHoldings);
            payAppDoc.setNonAppliedHoldingsForCustomer(new ArrayList<NonAppliedHolding>(nonAppliedControlHoldings));
            payAppForm.setNonAppliedControlAllocations(null);
        }
        if (StringUtils.isNotBlank((CharSequence)customerNumber)) {
            Collection<CustomerInvoiceDocument> openInvoicesForCustomer = payAppDoc.isFinal() ? payAppDoc.getInvoicesPaidAgainst() : this.getCustomerInvoiceDocumentService().getOpenInvoiceDocumentsByCustomerNumber(customerNumber);
            payAppForm.setInvoices(new ArrayList<CustomerInvoiceDocument>(openInvoicesForCustomer));
            payAppForm.setupInvoiceWrappers(payAppDoc.getDocumentNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)customerNumber) && StringUtils.isBlank((CharSequence)currentInvoiceNumber)) {
            currentInvoiceNumber = payAppForm.getInvoices() == null || payAppForm.getInvoices().isEmpty() ? null : payAppForm.getInvoices().get(0).getDocumentNumber();
        }
        if (StringUtils.isNotBlank((CharSequence)currentInvoiceNumber)) {
            payAppForm.setSelectedInvoiceDocumentNumber(currentInvoiceNumber);
            payAppForm.setEnteredInvoiceDocumentNumber(currentInvoiceNumber);
        }
        for (PaymentApplicationInvoiceApply invoiceApplication : payAppForm.getInvoiceApplications()) {
            this.updateInvoiceApplication(payAppDoc, invoiceApplication);
        }
        payAppForm.setNonInvoicedAddLine(null);
        if (payAppDoc.getNonAppliedHolding() != null) {
            payAppForm.setNonAppliedHoldingCustomerNumber(payAppDoc.getNonAppliedHolding().getCustomerNumber());
            payAppForm.setNonAppliedHoldingAmount(payAppDoc.getNonAppliedHolding().getFinancialDocumentLineAmount());
        } else {
            payAppForm.setNonAppliedHoldingCustomerNumber(null);
            payAppForm.setNonAppliedHoldingAmount(null);
        }
        payAppForm.setInvoiceApplications(this.sortInvoiceApplications(payAppForm.getInvoiceApplications()));
    }

    protected void updateInvoiceApplication(PaymentApplicationDocument payAppDoc, PaymentApplicationInvoiceApply invoiceApplication) {
        for (InvoicePaidApplied paidApplied : payAppDoc.getInvoicePaidApplieds()) {
            if (!paidApplied.getFinancialDocumentReferenceInvoiceNumber().equalsIgnoreCase(invoiceApplication.getDocumentNumber())) continue;
            for (PaymentApplicationInvoiceDetailApply detailApplication : invoiceApplication.getDetailApplications()) {
                if (!paidApplied.getInvoiceItemNumber().equals(detailApplication.getSequenceNumber()) || paidApplied.getInvoiceItemAppliedAmount().equals((Object)detailApplication.getAmountApplied())) continue;
                detailApplication.setAmountApplied(paidApplied.getInvoiceItemAppliedAmount());
                if (!paidApplied.getInvoiceItemAppliedAmount().equals((Object)detailApplication.getAmountOpen())) continue;
                detailApplication.setFullApply(true);
            }
        }
    }

    protected List<PaymentApplicationInvoiceApply> sortInvoiceApplications(List<PaymentApplicationInvoiceApply> invoiceApplications) {
        EntryHolderComparator entryHolderComparator = new EntryHolderComparator();
        ArrayList<EntryHolder> entryHoldings = new ArrayList<EntryHolder>();
        for (PaymentApplicationInvoiceApply paymentApplicationInvoiceApply : invoiceApplications) {
            entryHoldings.add(new EntryHolder(paymentApplicationInvoiceApply.getInvoice().getDocumentHeader().getWorkflowDocument().getDateCreated().toDate(), paymentApplicationInvoiceApply));
        }
        if (entryHoldings.size() > 0) {
            entryHoldings.sort(entryHolderComparator);
        }
        ArrayList<PaymentApplicationInvoiceApply> results = new ArrayList<PaymentApplicationInvoiceApply>();
        for (EntryHolder entryHolder : entryHoldings) {
            results.add((PaymentApplicationInvoiceApply)entryHolder.getHolder());
        }
        return results;
    }

    public ActionForward goToInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        this.loadInvoices(payAppForm, payAppForm.getSelectedInvoiceDocumentNumber());
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward goToNextInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        this.loadInvoices(payAppForm, payAppForm.getNextInvoiceDocumentNumber());
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward goToPreviousInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm payAppForm = (PaymentApplicationForm)form;
        this.loadInvoices(payAppForm, payAppForm.getPreviousInvoiceDocumentNumber());
        if (!payAppForm.getPaymentApplicationDocument().isFinal()) {
            this.doApplicationOfFunds(payAppForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentApplicationForm newForm = (PaymentApplicationForm)form;
        if (null == newForm.getCashControlDocument()) {
            return super.cancel(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.createDocument(kualiDocumentFormBase);
        PaymentApplicationForm form = (PaymentApplicationForm)kualiDocumentFormBase;
        PaymentApplicationDocument document = form.getPaymentApplicationDocument();
        AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService = (AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
        document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) {
        super.loadDocument(kualiDocumentFormBase);
        PaymentApplicationForm pform = (PaymentApplicationForm)kualiDocumentFormBase;
        this.loadInvoices(pform, pform.getEnteredInvoiceDocumentNumber());
    }

    protected void addFieldError(String errorPathToAdd, String propertyName, String errorKey) {
        GlobalVariables.getMessageMap().addToErrorPath(errorPathToAdd);
        GlobalVariables.getMessageMap().putError(propertyName, errorKey, new String[0]);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPathToAdd);
    }

    protected void addGlobalError(String errorKey) {
        GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", errorKey, new String[]{"document.hiddenFieldForErrors"});
    }

    NonAppliedHoldingService getNonAppliedHoldingService() {
        if (this.nonAppliedHoldingService == null) {
            this.nonAppliedHoldingService = (NonAppliedHoldingService)SpringContext.getBean(NonAppliedHoldingService.class);
        }
        return this.nonAppliedHoldingService;
    }

    CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        if (this.customerInvoiceDocumentService == null) {
            this.customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
        }
        return this.customerInvoiceDocumentService;
    }

    PaymentApplicationDocumentService getPaymentApplicationDocumentService() {
        if (this.paymentApplicationDocumentService == null) {
            this.paymentApplicationDocumentService = (PaymentApplicationDocumentService)SpringContext.getBean(PaymentApplicationDocumentService.class);
        }
        return this.paymentApplicationDocumentService;
    }

    protected static class EntryHolderComparator
    implements Comparator<EntryHolder> {
        protected EntryHolderComparator() {
        }

        @Override
        public int compare(EntryHolder rosencrantz, EntryHolder guildenstern) {
            return rosencrantz.getDate().compareTo(guildenstern.getDate());
        }
    }

    protected class EntryHolder {
        private Date date;
        private Object holder;

        public EntryHolder(Date date, Object holder) {
            this.date = date;
            this.holder = holder;
        }

        public Date getDate() {
            return this.date;
        }

        public Object getHolder() {
            return this.holder;
        }
    }
}

