/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.io.File;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.web.format.CurrencyFormatter;
import org.kuali.kfs.core.web.format.PhoneNumberFormatter;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kim.api.identity.IdentityService;
import org.kuali.kfs.kim.impl.identity.entity.Entity;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.AccountsReceivableReportService;
import org.kuali.kfs.module.ar.report.service.CustomerCreditMemoReportService;
import org.kuali.kfs.module.ar.report.service.CustomerInvoiceReportService;
import org.kuali.kfs.module.ar.report.service.OCRLineService;
import org.kuali.kfs.module.ar.report.util.CustomerCreditMemoDetailReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerCreditMemoReportDataHolder;
import org.kuali.kfs.module.ar.report.util.CustomerInvoiceReportDataHolder;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AccountsReceivableReportServiceImpl
implements AccountsReceivableReportService {
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected ParameterService parameterService;
    protected CustomerAddressService customerAddressService;
    protected PhoneNumberFormatter phoneNumberFormatter = new PhoneNumberFormatter();
    protected BusinessObjectService businessObjectService;
    protected CurrencyFormatter invoiceCurrencyFormatter = new CurrencyFormatter();
    protected UniversityDateService universityDateService;
    protected CustomerInvoiceDetailService customerInvoiceDetailService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected CustomerCreditMemoReportService customerCreditMemoReportService;
    protected OCRLineService ocrLineService;
    protected CustomerInvoiceReportService customerInvoiceReportService;
    private LocationService locationService;
    private IdentityService identityService;

    public AccountsReceivableReportServiceImpl() {
        HashMap<String, String> settings = this.invoiceCurrencyFormatter.getSettings();
        if (settings == null) {
            settings = new HashMap<String, String>();
            this.invoiceCurrencyFormatter.setSettings(settings);
        }
        settings.put("showCurrencySymbol", "true");
    }

    @Override
    public File generateCreditMemo(CustomerCreditMemoDocument creditMemo) {
        String initiatorID;
        Entity user;
        String billCityStateZip;
        CustomerCreditMemoReportDataHolder reportDataHolder = new CustomerCreditMemoReportDataHolder();
        String invoiceNumber = creditMemo.getFinancialDocumentReferenceInvoiceNumber();
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceNumber);
        String custID = invoice.getAccountsReceivableDocumentHeader().getCustomerNumber();
        HashMap<String, String> creditMemoMap = new HashMap<String, String>();
        creditMemoMap.put("docNumber", creditMemo.getDocumentNumber());
        creditMemoMap.put("refDocNumber", invoice.getDocumentNumber());
        Date date = creditMemo.getDocumentHeader().getDocumentFinalDate();
        if (ObjectUtils.isNotNull((Object)date)) {
            creditMemoMap.put("createDate", this.dateTimeService.toDateString((java.util.Date)date));
        }
        reportDataHolder.setCreditmemo(creditMemoMap);
        HashMap<String, String> customerMap = new HashMap<String, String>();
        customerMap.put("id", custID);
        customerMap.put("billToName", invoice.getBillingAddressName());
        customerMap.put("billToStreetAddressLine1", invoice.getBillingLine1StreetAddress());
        customerMap.put("billToStreetAddressLine2", invoice.getBillingLine2StreetAddress());
        if ("US".equals(invoice.getBillingCountryCode())) {
            billCityStateZip = this.generateCityStateZipLine(invoice.getBillingCityName(), invoice.getBillingStateCode(), invoice.getBillingZipCode());
        } else {
            Country country;
            billCityStateZip = this.generateCityStateZipLine(invoice.getBillingCityName(), invoice.getBillingAddressInternationalProvinceName(), invoice.getBillingInternationalMailCode());
            if (StringUtils.isNotBlank((CharSequence)invoice.getBillingCountryCode()) && ObjectUtils.isNotNull((Object)(country = this.locationService.getCountry(invoice.getBillingCountryCode())))) {
                customerMap.put("billToCountry", country.getName());
            }
        }
        customerMap.put("billToCityStateZip", billCityStateZip);
        reportDataHolder.setCustomer(customerMap);
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        if (ObjectUtils.isNotNull((Object)invoice.getCustomerPurchaseOrderNumber())) {
            invoiceMap.put("poNumber", invoice.getCustomerPurchaseOrderNumber());
        }
        if (invoice.getCustomerPurchaseOrderDate() != null) {
            invoiceMap.put("poDate", this.dateTimeService.toDateString((java.util.Date)invoice.getCustomerPurchaseOrderDate()));
        }
        if ((user = this.identityService.getEntityByPrincipalId(initiatorID = invoice.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId())) == null) {
            throw new RuntimeException("User '" + initiatorID + "' could not be retrieved.");
        }
        invoiceMap.put("invoicePreparer", user.getDefaultName().getFirstName() + " " + user.getDefaultName().getLastName());
        invoiceMap.put("headerField", ObjectUtils.isNull((Object)invoice.getInvoiceHeaderText()) ? "" : invoice.getInvoiceHeaderText());
        invoiceMap.put("billingOrgName", invoice.getBilledByOrganization().getOrganizationName());
        invoiceMap.put("pretaxAmount", invoice.getInvoiceItemPreTaxAmountTotal().toString());
        boolean salesTaxInd = this.parameterService.getParameterValueAsBoolean("KFS-AR", "Document", "SALES_TAX_IND");
        if (salesTaxInd) {
            invoiceMap.put("taxAmount", invoice.getInvoiceItemTaxAmountTotal().toString());
            KualiDecimal taxPercentage = new KualiDecimal(6.85);
            invoiceMap.put("taxPercentage", "*** " + taxPercentage.toString() + "%");
        }
        invoiceMap.put("invoiceAmountDue", invoice.getSourceTotal().toString());
        invoiceMap.put("ocrLine", "");
        reportDataHolder.setInvoice(invoiceMap);
        HashMap<String, String> sysInfoMap = new HashMap<String, String>();
        Organization billingOrg = invoice.getBilledByOrganization();
        String chart = billingOrg.getChartOfAccountsCode();
        String org = billingOrg.getOrganizationCode();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", chart);
        criteria.put("organizationCode", org);
        OrganizationOptions orgOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        String fiscalYear = this.universityDateService.getCurrentFiscalYear().toString();
        criteria = new HashMap();
        Organization processingOrg = invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization();
        criteria.put("universityFiscalYear", fiscalYear);
        criteria.put("processingChartOfAccountCode", processingOrg.getChartOfAccountsCode());
        criteria.put("processingOrganizationCode", processingOrg.getOrganizationCode());
        SystemInformation sysInfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        sysInfoMap.put("univName", StringUtils.upperCase((String)sysInfo.getOrganizationCheckPayableToName()));
        String univAddr = processingOrg.getOrganizationCityName() + ", " + processingOrg.getOrganizationStateCode() + " " + processingOrg.getOrganizationZipCode();
        sysInfoMap.put("univAddr", univAddr);
        if (sysInfo != null) {
            sysInfoMap.put("FEIN", "FED ID #" + sysInfo.getUniversityFederalEmployerIdentificationNumber());
        }
        reportDataHolder.setSysinfo(sysInfoMap);
        invoiceMap.put("billingOrgFax", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationFaxNumber())));
        invoiceMap.put("billingOrgPhone", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationPhoneNumber())));
        creditMemo.populateCustomerCreditMemoDetailsAfterLoad();
        List<CustomerCreditMemoDetail> detailsList = creditMemo.getCreditMemoDetails();
        ArrayList<CustomerCreditMemoDetailReportDataHolder> details = new ArrayList<CustomerCreditMemoDetailReportDataHolder>();
        for (CustomerCreditMemoDetail detail : detailsList) {
            if (!detail.getCreditMemoLineTotalAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            CustomerCreditMemoDetailReportDataHolder detailDataHolder = new CustomerCreditMemoDetailReportDataHolder(detail, detail.getCustomerInvoiceDetail());
            details.add(detailDataHolder);
        }
        reportDataHolder.setDetails(details);
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        return this.customerCreditMemoReportService.generateReport(reportDataHolder, runDate);
    }

    @Override
    public File generateInvoice(CustomerInvoiceDocument invoice) {
        String initiatorID;
        Entity user;
        CustomerInvoiceReportDataHolder reportDataHolder = new CustomerInvoiceReportDataHolder();
        String custID = invoice.getAccountsReceivableDocumentHeader().getCustomerNumber();
        Integer customerBillToAddressIdentifier = invoice.getCustomerBillToAddressIdentifier();
        Integer customerShipToAddressIdentifier = invoice.getCustomerShipToAddressIdentifier();
        CustomerAddress billToAddr = this.customerAddressService.getByPrimaryKey(custID, customerBillToAddressIdentifier);
        CustomerAddress shipToAddr = this.customerAddressService.getByPrimaryKey(custID, customerShipToAddressIdentifier);
        Organization billingOrg = invoice.getBilledByOrganization();
        String chart = billingOrg.getChartOfAccountsCode();
        String org = billingOrg.getOrganizationCode();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", chart);
        criteria.put("organizationCode", org);
        OrganizationOptions orgOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        HashMap<String, String> customerMap = new HashMap<String, String>();
        customerMap.put("id", custID);
        if (billToAddr != null) {
            String billCityStateZip;
            customerMap.put("billToName", billToAddr.getCustomerAddressName());
            customerMap.put("billToStreetAddressLine1", billToAddr.getCustomerLine1StreetAddress());
            customerMap.put("billToStreetAddressLine2", billToAddr.getCustomerLine2StreetAddress());
            String billToCountry = "";
            if (billToAddr.getCustomerCountry() != null && (billToCountry = billToAddr.getCustomerCountry().getName().toUpperCase(Locale.US)).length() > 32) {
                billToCountry = billToCountry.substring(0, 31);
            }
            if (billToAddr.getCustomerCountryCode().equals("US")) {
                billCityStateZip = this.generateCityStateZipLine(billToAddr.getCustomerCityName(), billToAddr.getCustomerStateCode(), billToAddr.getCustomerZipCode());
                if (StringUtils.isNotBlank((CharSequence)orgOptions.getOrganizationRemitToCountryCode()) && !"US".equals(orgOptions.getOrganizationRemitToCountryCode())) {
                    customerMap.put("billToCountry", billToCountry);
                }
            } else {
                billCityStateZip = this.generateCityStateZipLine(billToAddr.getCustomerCityName(), billToAddr.getCustomerAddressInternationalProvinceName(), billToAddr.getCustomerInternationalMailCode());
                customerMap.put("billToCountry", billToCountry);
            }
            customerMap.put("billToCityStateZip", billCityStateZip);
        }
        if (shipToAddr != null) {
            String shipCityStateZip;
            customerMap.put("shipToName", shipToAddr.getCustomerAddressName());
            customerMap.put("shipToStreetAddressLine1", shipToAddr.getCustomerLine1StreetAddress());
            customerMap.put("shipToStreetAddressLine2", shipToAddr.getCustomerLine2StreetAddress());
            if (shipToAddr.getCustomerCountryCode().equals("US")) {
                shipCityStateZip = this.generateCityStateZipLine(shipToAddr.getCustomerCityName(), shipToAddr.getCustomerStateCode(), shipToAddr.getCustomerZipCode());
            } else {
                shipCityStateZip = this.generateCityStateZipLine(shipToAddr.getCustomerCityName(), shipToAddr.getCustomerAddressInternationalProvinceName(), shipToAddr.getCustomerInternationalMailCode());
                customerMap.put("shipToCountry", shipToAddr.getCustomerCountry().getName().toUpperCase(Locale.US));
            }
            customerMap.put("shipToCityStateZip", shipCityStateZip);
        }
        reportDataHolder.setCustomer(customerMap);
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        invoiceMap.put("poNumber", invoice.getCustomerPurchaseOrderNumber());
        if (invoice.getCustomerPurchaseOrderDate() != null) {
            invoiceMap.put("poDate", this.dateTimeService.toDateString((java.util.Date)invoice.getCustomerPurchaseOrderDate()));
        }
        if ((user = this.identityService.getEntityByPrincipalId(initiatorID = invoice.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId())) == null) {
            throw new RuntimeException("User '" + initiatorID + "' could not be retrieved.");
        }
        invoiceMap.put("invoicePreparer", user.getDefaultName().getFirstName() + " " + user.getDefaultName().getLastName());
        invoiceMap.put("headerField", invoice.getInvoiceHeaderText());
        invoiceMap.put("customerOrg", invoice.getBilledByOrganizationCode());
        invoiceMap.put("docNumber", invoice.getDocumentNumber());
        invoiceMap.put("invoiceDueDate", this.dateTimeService.toDateString((java.util.Date)invoice.getInvoiceDueDate()));
        invoiceMap.put("createDate", this.dateTimeService.toDateString(invoice.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()));
        invoiceMap.put("invoiceAttentionLineText", StringUtils.upperCase((String)invoice.getInvoiceAttentionLineText()));
        invoiceMap.put("billingOrgName", invoice.getBilledByOrganization().getOrganizationName());
        invoiceMap.put("pretaxAmount", this.invoiceCurrencyFormatter.format((Object)invoice.getInvoiceItemPreTaxAmountTotal()).toString());
        boolean salesTaxInd = this.parameterService.getParameterValueAsBoolean("KFS-AR", "Document", "SALES_TAX_IND");
        if (salesTaxInd) {
            invoiceMap.put("taxAmount", this.invoiceCurrencyFormatter.format((Object)invoice.getInvoiceItemTaxAmountTotal()).toString());
            invoiceMap.put("taxPercentage", "");
        }
        invoiceMap.put("invoiceAmountDue", this.invoiceCurrencyFormatter.format((Object)invoice.getSourceTotal()).toString());
        invoiceMap.put("invoiceTermsText", invoice.getInvoiceTermsText());
        String ocrLine = this.ocrLineService.generateOCRLine(invoice.getSourceTotal(), custID, invoice.getDocumentNumber());
        invoiceMap.put("ocrLine", ocrLine);
        List detailsList = (List)this.customerInvoiceDetailService.getCustomerInvoiceDetailsForInvoice(invoice);
        CustomerInvoiceDetail firstDetail = (CustomerInvoiceDetail)detailsList.get(0);
        String firstChartCode = firstDetail.getChartOfAccountsCode();
        String firstAccount = firstDetail.getAccountNumber();
        invoiceMap.put("chartAndAccountOfFirstItem", firstChartCode + firstAccount);
        HashMap<String, String> sysinfoMap = new HashMap<String, String>();
        String fiscalYear = this.universityDateService.getCurrentFiscalYear().toString();
        criteria = new HashMap();
        Organization processingOrg = invoice.getAccountsReceivableDocumentHeader().getProcessingOrganization();
        criteria.put("universityFiscalYear", fiscalYear);
        criteria.put("processingChartOfAccountCode", processingOrg.getChartOfAccountsCode());
        criteria.put("processingOrganizationCode", processingOrg.getOrganizationCode());
        SystemInformation sysinfo = (SystemInformation)this.businessObjectService.findByPrimaryKey(SystemInformation.class, criteria);
        sysinfoMap.put("univName", StringUtils.upperCase((String)sysinfo.getOrganizationCheckPayableToName()));
        sysinfoMap.put("univAddr", this.generateCityStateZipLine(processingOrg.getOrganizationCityName(), processingOrg.getOrganizationStateCode(), processingOrg.getOrganizationZipCode()));
        if (sysinfo != null) {
            sysinfoMap.put("FEIN", "FED ID #" + sysinfo.getUniversityFederalEmployerIdentificationNumber());
        }
        sysinfoMap.put("checkPayableTo", orgOptions.getOrganizationCheckPayableToName());
        sysinfoMap.put("remitToName", orgOptions.getOrganizationRemitToAddressName());
        sysinfoMap.put("remitToAddressLine1", orgOptions.getOrganizationRemitToLine1StreetAddress());
        sysinfoMap.put("remitToAddressLine2", orgOptions.getOrganizationRemitToLine2StreetAddress());
        String remitToCityStateZip = this.generateCityStateZipLine(orgOptions.getOrganizationRemitToCityName(), orgOptions.getOrganizationRemitToStateCode(), orgOptions.getOrganizationRemitToZipCode());
        if (billToAddr != null && !"US".equals(billToAddr.getCustomerCountryCode()) && orgOptions.getOrgRemitToCountry() != null || StringUtils.isNotBlank((CharSequence)orgOptions.getOrganizationRemitToCountryCode()) && !"US".equals(orgOptions.getOrganizationRemitToCountryCode())) {
            String remitToCountry = orgOptions.getOrgRemitToCountry().getName().toUpperCase(Locale.US);
            if (remitToCountry.length() > 32) {
                remitToCountry = remitToCountry.substring(0, 31);
            }
            sysinfoMap.put("remitToCountry", remitToCountry);
        }
        sysinfoMap.put("remitToCityStateZip", remitToCityStateZip);
        invoiceMap.put("billingOrgFax", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationFaxNumber())));
        invoiceMap.put("billingOrgPhone", (String)this.phoneNumberFormatter.format(this.phoneNumberFormatter.convertFromPresentationFormat((Object)orgOptions.getOrganizationPhoneNumber())));
        invoiceMap.put("orgOptionsMessageText", orgOptions.getOrganizationMessageText());
        reportDataHolder.setSysinfo(sysinfoMap);
        reportDataHolder.setDetails(detailsList);
        reportDataHolder.setInvoice(invoiceMap);
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        File report = this.customerInvoiceReportService.generateReport(reportDataHolder, runDate);
        invoice.setPrintDate(runDate);
        this.documentService.updateDocument((Document)invoice);
        return report;
    }

    @Override
    public List<File> generateInvoicesByBillingOrg(String chartCode, String orgCode, Date date) {
        CustomerInvoiceDocumentService invoiceDocService = this.customerInvoiceDocumentService;
        List<CustomerInvoiceDocument> invoices = invoiceDocService.getPrintableCustomerInvoiceDocumentsByBillingChartAndOrg(chartCode, orgCode);
        ArrayList<File> reports = new ArrayList<File>();
        for (CustomerInvoiceDocument doc : invoices) {
            if (date == null) {
                reports.add(this.generateInvoice(doc));
                continue;
            }
            if (this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()) == null || !this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()).equals(this.dateTimeService.toDateString((java.util.Date)date))) continue;
            reports.add(this.generateInvoice(doc));
        }
        return reports;
    }

    @Override
    public List<File> generateInvoicesByProcessingOrg(String chartCode, String orgCode, Date date) {
        List<CustomerInvoiceDocument> invoices = this.customerInvoiceDocumentService.getPrintableCustomerInvoiceDocumentsByProcessingChartAndOrg(chartCode, orgCode);
        ArrayList<File> reports = new ArrayList<File>();
        for (CustomerInvoiceDocument doc : invoices) {
            if (date == null) {
                reports.add(this.generateInvoice(doc));
                continue;
            }
            if (this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()) == null || !this.dateTimeService.toDateString(doc.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()).equals(this.dateTimeService.toDateString((java.util.Date)date))) continue;
            reports.add(this.generateInvoice(doc));
        }
        return reports;
    }

    @Override
    public List<File> generateInvoicesByInitiator(String initiator, Date date) {
        ArrayList<File> reports = new ArrayList<File>();
        List<CustomerInvoiceDocument> invoices = this.customerInvoiceDocumentService.getPrintableCustomerInvoiceDocumentsByInitiatorPrincipalName(initiator);
        for (CustomerInvoiceDocument invoice : invoices) {
            if (date == null) {
                reports.add(this.generateInvoice(invoice));
                continue;
            }
            if (this.dateTimeService.toDateString(invoice.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()) == null || !this.dateTimeService.toDateString(invoice.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate()).equals(this.dateTimeService.toDateString((java.util.Date)date))) continue;
            reports.add(this.generateInvoice(invoice));
        }
        return reports;
    }

    protected String generateCityStateZipLine(String city, String state, String zipCode) {
        StringBuffer cityStateZip = new StringBuffer(city);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            cityStateZip.append(", ").append(state);
        }
        if (StringUtils.isNotBlank((CharSequence)zipCode)) {
            cityStateZip.append("  ").append(zipCode);
        }
        return cityStateZip.toString();
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public CustomerInvoiceDetailService getCustomerInvoiceDetailService() {
        return this.customerInvoiceDetailService;
    }

    public void setCustomerInvoiceDetailService(CustomerInvoiceDetailService customerInvoiceDetailService) {
        this.customerInvoiceDetailService = customerInvoiceDetailService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public CustomerCreditMemoReportService getCustomerCreditMemoReportService() {
        return this.customerCreditMemoReportService;
    }

    public void setCustomerCreditMemoReportService(CustomerCreditMemoReportService customerCreditMemoReportService) {
        this.customerCreditMemoReportService = customerCreditMemoReportService;
    }

    public OCRLineService getOcrLineService() {
        return this.ocrLineService;
    }

    public void setOcrLineService(OCRLineService ocrLineService) {
        this.ocrLineService = ocrLineService;
    }

    public CustomerInvoiceReportService getCustomerInvoiceReportService() {
        return this.customerInvoiceReportService;
    }

    public void setCustomerInvoiceReportService(CustomerInvoiceReportService customerInvoiceReportService) {
        this.customerInvoiceReportService = customerInvoiceReportService;
    }

    public void setLocationService(LocationService locationService) {
        this.locationService = locationService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

