/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutingRequest;
import org.kuali.kfs.module.ar.rest.resource.requests.DocumentRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PaymentApplicationAdjustmentRequest
extends DocumentRequest {
    private final List<InvoiceApplication> invoiceApplications;
    private final List<NonAppliedHolding> nonAppliedHoldings;
    private final List<AccountingLine> nonArAccountingLines;

    @JsonCreator
    public PaymentApplicationAdjustmentRequest(@JsonProperty(value="description") String description, @JsonProperty(value="explanation") String explanation, @JsonProperty(value="orgDocNumber") String orgDocNumber, @JsonProperty(value="adHocRouting") AdHocRoutingRequest adHocRoutingRequest, @JsonProperty(value="invoiceApplications") List<InvoiceApplication> invoiceApplications, @JsonProperty(value="nonAppliedHoldings") List<NonAppliedHolding> nonAppliedHoldings, @JsonProperty(value="accountingLines") List<AccountingLine> nonArAccountingLines) {
        super(description, explanation, orgDocNumber, adHocRoutingRequest);
        Validate.isTrue((invoiceApplications != null ? 1 : 0) != 0, (String)"invoiceApplications must be supplied", (Object[])new Object[0]);
        Validate.isTrue((nonAppliedHoldings != null ? 1 : 0) != 0, (String)"nonAppliedHoldings must be supplied", (Object[])new Object[0]);
        Validate.isTrue((nonArAccountingLines != null ? 1 : 0) != 0, (String)"accountingLines must be supplied", (Object[])new Object[0]);
        this.invoiceApplications = invoiceApplications;
        this.nonAppliedHoldings = nonAppliedHoldings;
        this.nonArAccountingLines = nonArAccountingLines;
    }

    public List<NonAppliedHolding> getNonAppliedHoldings() {
        return this.nonAppliedHoldings;
    }

    public List<InvoiceApplication> getInvoiceApplications() {
        return this.invoiceApplications;
    }

    public List<AccountingLine> getNonArAccountingLines() {
        return this.nonArAccountingLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentApplicationAdjustmentRequest that = (PaymentApplicationAdjustmentRequest)o;
        return this.invoiceApplications.equals(that.invoiceApplications) && this.nonAppliedHoldings.equals(that.nonAppliedHoldings) && this.nonArAccountingLines.equals(that.nonArAccountingLines);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceApplications, this.nonAppliedHoldings, this.nonArAccountingLines);
    }

    public String toString() {
        return new StringJoiner(", ", PaymentApplicationAdjustmentRequest.class.getSimpleName() + "[", "]").add("invoiceApplications=" + this.invoiceApplications).add("nonAppliedHoldings=" + this.nonAppliedHoldings).add("nonArAccountingLines=" + this.nonArAccountingLines).toString();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AccountingLine {
        private final Integer sequenceNumber;
        private final String chartCode;
        private final String accountNumber;
        private final String subAccountNumber;
        private final String object;
        private final String subObject;
        private final String projectCode;
        private final String orgRefId;
        private final String description;
        private final KualiDecimal amount;

        @JsonCreator
        public AccountingLine(@JsonProperty(value="sequenceNumber") Integer sequenceNumber, @JsonProperty(value="chartOfAccountsCode") String chartCode, @JsonProperty(value="accountNumber") String accountNumber, @JsonProperty(value="subAccountNumber") String subAccountNumber, @JsonProperty(value="financialObjectCode") String object, @JsonProperty(value="financialSubObjectCode") String subObject, @JsonProperty(value="projectCode") String projectCode, @JsonProperty(value="organizationReferenceId") String orgRefId, @JsonProperty(value="description") String description, @JsonProperty(value="amount") KualiDecimal amount) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)chartCode), (String)"chartOfAccountsCode must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)accountNumber), (String)"accountNumber must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)object), (String)"financialObjectCode must be supplied", (Object[])new Object[0]);
            Validate.isTrue((amount != null ? 1 : 0) != 0, (String)"amount must be supplied", (Object[])new Object[0]);
            this.sequenceNumber = sequenceNumber;
            this.chartCode = chartCode;
            this.accountNumber = accountNumber;
            this.subAccountNumber = subAccountNumber;
            this.object = object;
            this.subObject = subObject;
            this.projectCode = projectCode;
            this.orgRefId = orgRefId;
            this.description = description;
            this.amount = amount;
        }

        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public String getChartCode() {
            return this.chartCode;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getSubAccountNumber() {
            return this.subAccountNumber;
        }

        public String getObject() {
            return this.object;
        }

        public String getSubObject() {
            return this.subObject;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public String getOrgRefId() {
            return this.orgRefId;
        }

        public String getDescription() {
            return this.description;
        }

        public KualiDecimal getAmount() {
            return this.amount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AccountingLine)) {
                return false;
            }
            AccountingLine that = (AccountingLine)o;
            return Objects.equals(this.sequenceNumber, that.sequenceNumber) && this.chartCode.equals(that.chartCode) && this.accountNumber.equals(that.accountNumber) && Objects.equals(this.subAccountNumber, that.subAccountNumber) && this.object.equals(that.object) && Objects.equals(this.subObject, that.subObject) && Objects.equals(this.projectCode, that.projectCode) && Objects.equals(this.orgRefId, that.orgRefId) && Objects.equals(this.description, that.description) && this.amount.equals((Object)that.amount);
        }

        public int hashCode() {
            return Objects.hash(this.sequenceNumber, this.chartCode, this.accountNumber, this.subAccountNumber, this.object, this.subObject, this.projectCode, this.orgRefId, this.description, this.amount);
        }

        public String toString() {
            return new StringJoiner(", ", AccountingLine.class.getSimpleName() + "[", "]").add("sequenceNumber='" + this.sequenceNumber + "'").add("accountNumber='" + this.accountNumber + "'").add("amount=" + this.amount).add("chartOfAccountsCode='" + this.chartCode + "'").add("description='" + this.description + "'").add("financialObjectCode='" + this.object + "'").add("organizationReferenceId='" + this.orgRefId + "'").add("projectCode='" + this.projectCode + "'").add("subAccountNumber='" + this.subAccountNumber + "'").add("financialSubObjectCode='" + this.subObject + "'").toString();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NonAppliedHolding {
        private final KualiDecimal amount;
        private final String customerNumber;

        @JsonCreator
        public NonAppliedHolding(@JsonProperty(value="amount") KualiDecimal amount, @JsonProperty(value="customerNumber") String customerNumber) {
            Validate.isTrue((amount != null ? 1 : 0) != 0, (String)"amount must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerNumber), (String)"customerNumber must be supplied", (Object[])new Object[0]);
            this.amount = amount;
            this.customerNumber = customerNumber;
        }

        public KualiDecimal getAmount() {
            return this.amount;
        }

        public String getCustomerNumber() {
            return this.customerNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonAppliedHolding that = (NonAppliedHolding)o;
            return this.amount.equals((Object)that.amount) && this.customerNumber.equals(that.customerNumber);
        }

        public int hashCode() {
            return Objects.hash(this.amount, this.customerNumber);
        }

        public String toString() {
            return new StringJoiner(", ", NonAppliedHolding.class.getSimpleName() + "[", "]").add("amount=" + this.amount).add("customerNumber='" + this.customerNumber + "'").toString();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InvoiceApplicationDetail {
        private final KualiDecimal amountApplied;
        private final Integer sequenceNumber;

        @JsonCreator
        public InvoiceApplicationDetail(@JsonProperty(value="amountApplied") KualiDecimal amountApplied, @JsonProperty(value="sequenceNumber") Integer sequenceNumber) {
            Validate.isTrue((amountApplied != null ? 1 : 0) != 0, (String)"amountApplied must be supplied", (Object[])new Object[0]);
            Validate.isTrue((sequenceNumber != null ? 1 : 0) != 0, (String)"sequenceNumber must be supplied", (Object[])new Object[0]);
            Validate.isTrue((sequenceNumber >= 0 ? 1 : 0) != 0, (String)"sequenceNumber must not be negative", (Object[])new Object[0]);
            this.amountApplied = amountApplied;
            this.sequenceNumber = sequenceNumber;
        }

        public KualiDecimal getAmountApplied() {
            return this.amountApplied;
        }

        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvoiceApplicationDetail that = (InvoiceApplicationDetail)o;
            return this.amountApplied.equals((Object)that.amountApplied) && this.sequenceNumber.equals(that.sequenceNumber);
        }

        public int hashCode() {
            return Objects.hash(this.amountApplied, this.sequenceNumber);
        }

        public String toString() {
            return new StringJoiner(", ", InvoiceApplicationDetail.class.getSimpleName() + "[", "]").add("amountApplied=" + this.amountApplied).add("sequenceNumber=" + this.sequenceNumber).toString();
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InvoiceApplication {
        private final String customerNumber;
        private final String documentNumber;
        private final List<InvoiceApplicationDetail> detailApplications;

        @JsonCreator
        public InvoiceApplication(@JsonProperty(value="customerNumber") String customerNumber, @JsonProperty(value="documentNumber") String documentNumber, @JsonProperty(value="detailApplications") List<InvoiceApplicationDetail> detailApplications) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)customerNumber), (String)"customerNumber must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)documentNumber), (String)"documentNumber must be supplied", (Object[])new Object[0]);
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty(detailApplications), (String)"detailApplications must be supplied", (Object[])new Object[0]);
            this.customerNumber = customerNumber;
            this.documentNumber = documentNumber;
            this.detailApplications = detailApplications;
        }

        public String getCustomerNumber() {
            return this.customerNumber;
        }

        public String getDocumentNumber() {
            return this.documentNumber;
        }

        public List<InvoiceApplicationDetail> getDetailApplications() {
            return this.detailApplications;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvoiceApplication that = (InvoiceApplication)o;
            return this.customerNumber.equals(that.customerNumber) && this.documentNumber.equals(that.documentNumber) && this.detailApplications.equals(that.detailApplications);
        }

        public int hashCode() {
            return Objects.hash(this.customerNumber, this.documentNumber, this.detailApplications);
        }

        public String toString() {
            return new StringJoiner(", ", InvoiceApplication.class.getSimpleName() + "[", "]").add("customerNumber='" + this.customerNumber + "'").add("detailApplications=" + this.detailApplications).add("documentNumber='" + this.documentNumber + "'").toString();
        }
    }
}

