/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.service.InvoiceRecurrenceService;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InvoiceRecurrenceServiceImpl
implements InvoiceRecurrenceService {
    private DocumentService documentService;
    private BusinessObjectService boService;

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @Override
    public boolean processInvoiceRecurrence() {
        Collection<InvoiceRecurrence> recurrences = this.getAllActiveInvoiceRecurrences();
        CustomerInvoiceDocument customerInvoiceDocument = new CustomerInvoiceDocument();
        for (InvoiceRecurrence invoiceRecurrence : recurrences) {
            ArrayList<AdHocRouteRecipient> adHocRouteRecipients;
            String initiator;
            LocalDate currentDate = LocalDate.now();
            LocalDate beginDate = invoiceRecurrence.getDocumentRecurrenceBeginDate().toLocalDate();
            int day = beginDate.getDayOfMonth();
            LocalDate endDate = invoiceRecurrence.getDocumentRecurrenceEndDate().toLocalDate();
            LocalDate lastCreateDate = invoiceRecurrence.getDocumentLastCreateDate() == null ? null : invoiceRecurrence.getDocumentLastCreateDate().toLocalDate();
            LocalDate currentMonthProcessDate = currentDate.withDayOfMonth(day);
            LocalDate nextProcessDate = currentDate.isAfter(currentMonthProcessDate) ? currentMonthProcessDate.plusMonths(1L) : currentMonthProcessDate;
            LocalDate lastProcessDate = nextProcessDate.minusMonths(1L);
            if (lastProcessDate.isBefore(beginDate)) {
                lastProcessDate = LocalDate.EPOCH;
            }
            if (nextProcessDate.equals(currentDate)) {
                initiator = invoiceRecurrence.getDocumentInitiatorUserPersonUserIdentifier();
                GlobalVariables.setUserSession((UserSession)new UserSession(initiator));
                customerInvoiceDocument = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceRecurrence.getInvoiceNumber());
                customerInvoiceDocument.toCopy();
                adHocRouteRecipients = new ArrayList<AdHocRouteRecipient>();
                adHocRouteRecipients.add(this.buildApprovePersonRecipient(initiator));
                this.documentService.routeDocument((Document)customerInvoiceDocument, "This is a recurred Customer Invoice", adHocRouteRecipients);
                invoiceRecurrence.setDocumentLastCreateDate(Date.valueOf(currentDate));
                this.boService.save((PersistableBusinessObject)invoiceRecurrence);
            }
            if (nextProcessDate.isAfter(currentDate) && !nextProcessDate.isAfter(endDate) && (ObjectUtils.isNotNull((Object)lastCreateDate) && lastProcessDate.isAfter(lastCreateDate) || ObjectUtils.isNull((Object)lastCreateDate) && beginDate.isBefore(currentDate))) {
                initiator = invoiceRecurrence.getDocumentInitiatorUserPersonUserIdentifier();
                GlobalVariables.setUserSession((UserSession)new UserSession(initiator));
                customerInvoiceDocument = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceRecurrence.getInvoiceNumber());
                customerInvoiceDocument.toCopy();
                adHocRouteRecipients = new ArrayList();
                adHocRouteRecipients.add(this.buildApprovePersonRecipient(initiator));
                this.documentService.routeDocument((Document)customerInvoiceDocument, "This is a recurred Customer Invoice", adHocRouteRecipients);
                invoiceRecurrence.setDocumentLastCreateDate(Date.valueOf(currentDate));
                this.boService.save((PersistableBusinessObject)invoiceRecurrence);
            }
            if (nextProcessDate.isBefore(endDate)) continue;
            initiator = invoiceRecurrence.getDocumentInitiatorUserPersonUserIdentifier();
            GlobalVariables.setUserSession((UserSession)new UserSession(initiator));
            MaintenanceDocument newMaintDoc = (MaintenanceDocument)this.documentService.getNewDocument(this.getInvoiceRecurrenceMaintenanceDocumentTypeName());
            newMaintDoc.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)invoiceRecurrence);
            InvoiceRecurrence newInvoiceRecurrence = invoiceRecurrence;
            newInvoiceRecurrence.setActive(false);
            newMaintDoc.getDocumentHeader().setDocumentDescription("Generated by Batch process");
            newMaintDoc.getDocumentHeader().setExplanation("Inactivated by the Batch process");
            newMaintDoc.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)newInvoiceRecurrence);
            newMaintDoc.getNewMaintainableObject().setMaintenanceAction("Edit");
            ArrayList<AdHocRouteRecipient> adHocRouteRecipients2 = new ArrayList<AdHocRouteRecipient>();
            adHocRouteRecipients2.add(this.buildFyiPersonRecipient(initiator));
            this.documentService.routeDocument((Document)newMaintDoc, null, adHocRouteRecipients2);
            newInvoiceRecurrence.setDocumentLastCreateDate(Date.valueOf(currentDate));
            this.boService.save((PersistableBusinessObject)newInvoiceRecurrence);
        }
        return true;
    }

    protected Collection<InvoiceRecurrence> getAllActiveInvoiceRecurrences() {
        HashMap<String, Boolean> fieldValues = new HashMap<String, Boolean>();
        fieldValues.put("active", Boolean.TRUE);
        return this.boService.findMatchingOrderBy(InvoiceRecurrence.class, fieldValues, "invoiceNumber", true);
    }

    protected String getInvoiceRecurrenceMaintenanceDocumentTypeName() {
        return "INVR";
    }

    protected AdHocRouteRecipient buildFyiPersonRecipient(String userId) {
        AdHocRoutePerson adHocRouteRecipient = new AdHocRoutePerson();
        adHocRouteRecipient.setActionRequested("F");
        adHocRouteRecipient.setId(userId);
        return adHocRouteRecipient;
    }

    protected AdHocRouteRecipient buildApprovePersonRecipient(String userId) {
        AdHocRoutePerson adHocRouteRecipient = new AdHocRoutePerson();
        adHocRouteRecipient.setActionRequested("A");
        adHocRouteRecipient.setId(userId);
        return adHocRouteRecipient;
    }

    protected AdHocRouteRecipient buildFyiWorkgroupRecipient(String workgroupId) {
        AdHocRouteWorkgroup adHocRouteRecipient = new AdHocRouteWorkgroup();
        adHocRouteRecipient.setActionRequested("F");
        adHocRouteRecipient.setId(workgroupId);
        return adHocRouteRecipient;
    }

    protected AdHocRouteRecipient buildApproveWorkgroupRecipient(String workgroupId) {
        AdHocRouteWorkgroup adHocRouteRecipient = new AdHocRouteWorkgroup();
        adHocRouteRecipient.setActionRequested("A");
        adHocRouteRecipient.setId(workgroupId);
        return adHocRouteRecipient;
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }
}

