/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ar.AccountsReceivableMilestoneSchedule;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.sys.context.SpringContext;

public class MilestoneSchedule
extends PersistableBusinessObjectBase
implements AccountsReceivableMilestoneSchedule {
    private static final String MILESTONE_SCHEDULE_INQUIRY_TITLE_PROPERTY = "message.inquiry.milestone.schedule.title";
    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private List<Milestone> milestones = new LinkedList<Milestone>();
    private Account account;
    private Chart chart;
    private ContractsAndGrantsBillingAward award;
    private ContractsAndGrantsBillingAwardAccount awardAccount;
    private transient String agencyNumber;
    private transient ContractsAndGrantsBillingAgency agency;
    private transient AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;
    private transient ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    private transient String proposalNumberForAwardAccountLookup;
    private transient String chartOfAccountsCodeForAwardAccountLookup;
    private transient String accountNumberForAwardAccountLookup;

    public MilestoneSchedule() {
    }

    private MilestoneSchedule(String proposalNumber, String chartOfAccountsCode, String accountNumber, List<Milestone> milestones) {
        this.proposalNumber = proposalNumber;
        this.chartOfAccountsCode = chartOfAccountsCode;
        this.accountNumber = accountNumber;
        this.milestones = milestones;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public KualiDecimal getTotalScheduledAccount() {
        KualiDecimal total = KualiDecimal.ZERO;
        for (Milestone milestone : this.milestones) {
            if (!ObjectUtils.isNotNull((Object)milestone.getMilestoneAmount()) || !milestone.isActive()) continue;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
        }
        return total;
    }

    public KualiDecimal getTotalScheduledAward() {
        return (KualiDecimal)this.getTotalScheduledAccount().add((AbstractKualiDecimal)this.getAccountsReceivableModuleBillingService().getMilestonesTotalAmountForOtherSchedules(this.proposalNumber, this.chartOfAccountsCode, this.accountNumber));
    }

    public KualiDecimal getTotalAmountRemaining() {
        KualiDecimal total = KualiDecimal.ZERO;
        if (ObjectUtils.isNull((Object)this.award)) {
            this.award = this.getAward();
        }
        if (ObjectUtils.isNotNull((Object)this.award) && ObjectUtils.isNotNull((Object)this.award.getAwardTotalAmount())) {
            total = (KualiDecimal)this.award.getAwardTotalAmount().subtract((AbstractKualiDecimal)this.getTotalScheduledAward());
        }
        return total;
    }

    public String getMilestoneScheduleInquiryTitle() {
        return ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(MILESTONE_SCHEDULE_INQUIRY_TITLE_PROPERTY);
    }

    public List<Milestone> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(List<Milestone> milestones) {
        this.milestones = milestones;
    }

    public void addMilestone(Milestone milestone) {
        this.milestones.add(milestone);
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public ContractsAndGrantsBillingAward getAward() {
        ContractsAndGrantsBillingAward updatedAward = this.getContractsAndGrantsModuleBillingService().updateAwardIfNecessary(this.proposalNumber, this.award);
        if (ObjectUtils.isNull((Object)updatedAward)) {
            return this.award;
        }
        return updatedAward;
    }

    public void setAward(ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    public void forceAwardUpdate() {
        this.award = null;
        this.award = this.getAward();
    }

    public ContractsAndGrantsBillingAwardAccount getAwardAccount() {
        ContractsAndGrantsBillingAwardAccount updatedAwardAccount = this.getContractsAndGrantsModuleBillingService().updateAwardAccountIfNecessary(this.proposalNumber, this.chartOfAccountsCode, this.accountNumber, this.awardAccount);
        if (ObjectUtils.isNull((Object)updatedAwardAccount)) {
            return this.awardAccount;
        }
        return updatedAwardAccount;
    }

    public void setAwardAccount(ContractsAndGrantsBillingAwardAccount awardAccount) {
        this.awardAccount = awardAccount;
    }

    public String getProposalNumberForAwardAccountLookup() {
        return StringUtils.isNotBlank((CharSequence)this.proposalNumberForAwardAccountLookup) ? this.proposalNumberForAwardAccountLookup : this.proposalNumber;
    }

    public void setProposalNumberForAwardAccountLookup(String proposalNumberForAwardAccountLookup) {
        this.proposalNumberForAwardAccountLookup = proposalNumberForAwardAccountLookup;
    }

    public String getChartOfAccountsCodeForAwardAccountLookup() {
        return StringUtils.isNotBlank((CharSequence)this.chartOfAccountsCodeForAwardAccountLookup) ? this.chartOfAccountsCodeForAwardAccountLookup : this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCodeForAwardAccountLookup(String chartOfAccountsCodeForAwardAccountLookup) {
        this.chartOfAccountsCodeForAwardAccountLookup = chartOfAccountsCodeForAwardAccountLookup;
    }

    public String getAccountNumberForAwardAccountLookup() {
        return StringUtils.isNotBlank((CharSequence)this.accountNumberForAwardAccountLookup) ? this.accountNumberForAwardAccountLookup : this.accountNumber;
    }

    public void setAccountNumberForAwardAccountLookup(String accountNumberForAwardAccountLookup) {
        this.accountNumberForAwardAccountLookup = accountNumberForAwardAccountLookup;
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public ContractsAndGrantsBillingAgency getAgency() {
        return this.agency;
    }

    public void setAgency(ContractsAndGrantsBillingAgency agency) {
        this.agency = agency;
    }

    private AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        if (this.accountsReceivableModuleBillingService == null) {
            this.accountsReceivableModuleBillingService = (AccountsReceivableModuleBillingService)SpringContext.getBean(AccountsReceivableModuleBillingService.class);
        }
        return this.accountsReceivableModuleBillingService;
    }

    protected void setAccountsReceivableModuleBillingService(AccountsReceivableModuleBillingService accountsReceivableModuleBillingService) {
        this.accountsReceivableModuleBillingService = accountsReceivableModuleBillingService;
    }

    protected ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        if (this.contractsAndGrantsModuleBillingService == null) {
            this.contractsAndGrantsModuleBillingService = (ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class);
        }
        return this.contractsAndGrantsModuleBillingService;
    }

    protected void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MilestoneSchedule)) {
            return false;
        }
        MilestoneSchedule that = (MilestoneSchedule)((Object)o);
        return Objects.equals(this.proposalNumber, that.proposalNumber) && Objects.equals(this.chartOfAccountsCode, that.chartOfAccountsCode) && Objects.equals(this.accountNumber, that.accountNumber);
    }

    public int hashCode() {
        return Objects.hash(this.proposalNumber, this.chartOfAccountsCode, this.accountNumber);
    }

    public static class MilestoneScheduleBuilder {
        private String proposalNumber;
        private String chartOfAccountsCode;
        private String accountNumber;
        private List<Milestone> milestones = new LinkedList<Milestone>();

        public MilestoneScheduleBuilder setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
            return this;
        }

        public MilestoneScheduleBuilder setChartOfAccountsCode(String chartOfAccountsCode) {
            this.chartOfAccountsCode = chartOfAccountsCode;
            return this;
        }

        public MilestoneScheduleBuilder setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public MilestoneScheduleBuilder addMilestone(Milestone milestone) {
            this.milestones.add(milestone);
            return this;
        }

        public MilestoneSchedule build() throws IllegalStateException {
            this.validate();
            return new MilestoneSchedule(this.proposalNumber, this.chartOfAccountsCode, this.accountNumber, this.milestones);
        }

        private void validate() {
            if (StringUtils.isBlank((CharSequence)this.proposalNumber)) {
                throw new IllegalStateException("Proposal Number is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.chartOfAccountsCode)) {
                throw new IllegalStateException("Chart of Accounts Code is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.accountNumber)) {
                throw new IllegalStateException("Account Number is required.");
            }
        }
    }
}

