/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsSuspendedInvoiceSummaryReport;
import org.kuali.kfs.module.ar.businessobject.InvoiceSuspensionCategory;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsSuspendedInvoiceReportLookupableHelperServiceImplBase;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;

public class ContractsGrantsSuspendedInvoiceSummaryReportLookupableHelperServiceImpl
extends ContractsGrantsSuspendedInvoiceReportLookupableHelperServiceImplBase {
    protected DocumentService documentService;

    public Collection<? extends BusinessObject> performLookup(LookupForm lookupForm, Collection<ResultRow> resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ArrayList<ContractsGrantsSuspendedInvoiceSummaryReport> displayList = new ArrayList<ContractsGrantsSuspendedInvoiceSummaryReport>();
        TreeMap documentNumbersByCategory = new TreeMap();
        HashMap<String, String> lookupFields = new HashMap<String, String>();
        HashMap<String, String> suspensionCategoryDescriptions = new HashMap<String, String>();
        String suspensionCategoryCodeFromLookup = (String)lookupFormFields.get("suspensionCategoryCode");
        if (StringUtils.isNotBlank((CharSequence)suspensionCategoryCodeFromLookup)) {
            lookupFields.put("invoiceSuspensionCategories.suspensionCategoryCode", suspensionCategoryCodeFromLookup);
        }
        String processingDocumentStatuses = this.buildProcessingDocumentStatusesForLookup();
        lookupFields.put("documentHeader.workflowDocumentStatusCode", processingDocumentStatuses);
        Collection cgInvoiceDocuments = this.getLookupService().findCollectionBySearchHelper(ContractsGrantsInvoiceDocument.class, lookupFields, true);
        for (ContractsGrantsInvoiceDocument cgInvoiceDoc : cgInvoiceDocuments) {
            if (!ObjectUtils.isNotNull(cgInvoiceDoc.getInvoiceSuspensionCategories()) || cgInvoiceDoc.getInvoiceSuspensionCategories().isEmpty()) continue;
            for (InvoiceSuspensionCategory invoiceSuspensionCategory : cgInvoiceDoc.getInvoiceSuspensionCategories()) {
                String suspensionCategoryCode = invoiceSuspensionCategory.getSuspensionCategoryCode();
                Pattern suspensionCategoryCodePattern = null;
                if (StringUtils.isNotBlank((CharSequence)suspensionCategoryCodeFromLookup)) {
                    suspensionCategoryCodePattern = Pattern.compile(suspensionCategoryCodeFromLookup.replace("*", ".*"), 2);
                }
                if (!StringUtils.isBlank((CharSequence)suspensionCategoryCodeFromLookup) && (suspensionCategoryCodePattern == null || !suspensionCategoryCodePattern.matcher(suspensionCategoryCode).matches())) continue;
                if (!suspensionCategoryDescriptions.containsKey(suspensionCategoryCode)) {
                    suspensionCategoryDescriptions.put(suspensionCategoryCode, this.configurationService.getPropertyValueAsString("invoice.document.suspension.category." + suspensionCategoryCode));
                }
                if (ObjectUtils.isNull(documentNumbersByCategory.get(suspensionCategoryCode))) {
                    ArrayList<String> documentNumbers = new ArrayList<String>();
                    documentNumbers.add(invoiceSuspensionCategory.getDocumentNumber());
                    documentNumbersByCategory.put(suspensionCategoryCode, documentNumbers);
                    continue;
                }
                ((List)documentNumbersByCategory.get(suspensionCategoryCode)).add(invoiceSuspensionCategory.getDocumentNumber());
            }
        }
        for (String suspensionCategoryCode : documentNumbersByCategory.keySet()) {
            ContractsGrantsSuspendedInvoiceSummaryReport cgSuspendedInvoiceSummaryReport = new ContractsGrantsSuspendedInvoiceSummaryReport();
            cgSuspendedInvoiceSummaryReport.setSuspensionCategoryCode(suspensionCategoryCode);
            cgSuspendedInvoiceSummaryReport.setSuspensionCategoryDescription((String)suspensionCategoryDescriptions.get(suspensionCategoryCode));
            cgSuspendedInvoiceSummaryReport.setTotalInvoicesSuspended(Long.valueOf(((List)documentNumbersByCategory.get(suspensionCategoryCode)).size()));
            displayList.add(cgSuspendedInvoiceSummaryReport);
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

